/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.IDfsOrder;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.ISleepSetStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class MinimalSleepSetReduction<L, S, R>
implements INwaOutgoingLetterAndTransitionProvider<L, R> {
    private final INwaOutgoingLetterAndTransitionProvider<L, S> mOperand;
    private final ISleepSetStateFactory<L, S, R> mStateFactory;
    private final IDfsOrder<L, R> mOrder;
    private final IIndependenceRelation<S, L> mIndependence;
    private final R mInitial;
    private final UnifyHash<ImmutableSet<L>> mSleepSetUnifier = new UnifyHash();

    public MinimalSleepSetReduction(INwaOutgoingLetterAndTransitionProvider<L, S> iNwaOutgoingLetterAndTransitionProvider, ISleepSetStateFactory<L, S, R> iSleepSetStateFactory, IIndependenceRelation<S, L> iIndependenceRelation, IDfsOrder<L, R> iDfsOrder) {
        assert (NestedWordAutomataUtils.isFiniteAutomaton(iNwaOutgoingLetterAndTransitionProvider)) : "Sleep sets support only finite automata";
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mStateFactory = iSleepSetStateFactory;
        this.mOrder = iDfsOrder;
        this.mIndependence = iIndependenceRelation;
        Optional optional = DataStructureUtils.getOnly(iNwaOutgoingLetterAndTransitionProvider.getInitialStates(), (String)"There must only be one initial state");
        this.mInitial = optional.isPresent() ? this.mStateFactory.createSleepSetState(optional.get(), this.getSleepSet(ImmutableSet.empty())) : null;
    }

    @Override
    public IStateFactory<R> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public VpAlphabet<L> getVpAlphabet() {
        return this.mOperand.getVpAlphabet();
    }

    @Override
    public R getEmptyStackState() {
        return (R)this.mStateFactory.createEmptyStackState();
    }

    @Override
    public Iterable<R> getInitialStates() {
        return this.mInitial == null ? Collections.emptySet() : Set.of(this.mInitial);
    }

    @Override
    public boolean isInitial(R r) {
        return Objects.equals(this.mInitial, r);
    }

    @Override
    public boolean isFinal(R r) {
        return this.mOperand.isFinal(this.mStateFactory.getOriginalState(r));
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public String sizeInformation() {
        return "currently " + this.size() + " states, but on-demand construction may add more states";
    }

    @Override
    public Set<L> lettersInternal(R r) {
        return DataStructureUtils.difference(this.mOperand.lettersInternal(this.mStateFactory.getOriginalState(r)), this.mStateFactory.getSleepSet(r));
    }

    @Override
    public Iterable<OutgoingInternalTransition<L, R>> internalSuccessors(R r, L l) {
        ImmutableSet immutableSet = this.mStateFactory.getSleepSet(r);
        if (immutableSet.contains(l)) {
            return Collections.emptySet();
        }
        S s = this.mStateFactory.getOriginalState(r);
        Optional optional = DataStructureUtils.getOnly(this.mOperand.internalSuccessors(s, l), (String)"Automaton must be deterministic");
        if (optional.isEmpty()) {
            return Collections.emptySet();
        }
        Comparator comparator = this.mOrder.getOrder(r);
        Stream<Object> stream = this.mOperand.lettersInternal(s).stream().filter(object2 -> comparator.compare(object2, l) < 0 && !immutableSet.contains(object2));
        ImmutableSet<L> immutableSet2 = this.getSleepSet(ImmutableSet.of(Set.of(Stream.concat(immutableSet.stream(), stream).filter(object3 -> this.mIndependence.isIndependent(s, l, object3) == IIndependenceRelation.Dependence.INDEPENDENT).toArray())));
        R r2 = this.mStateFactory.createSleepSetState(((OutgoingInternalTransition)optional.get()).getSucc(), immutableSet2);
        return Set.of(new OutgoingInternalTransition<L, R>(l, r2));
    }

    private ImmutableSet<L> getSleepSet(ImmutableSet<L> immutableSet) {
        int n = immutableSet.hashCode();
        for (ImmutableSet immutableSet2 : this.mSleepSetUnifier.iterateHashCode(n)) {
            if (!immutableSet2.equals(immutableSet)) continue;
            return immutableSet2;
        }
        this.mSleepSetUnifier.put(n, immutableSet);
        return immutableSet;
    }

    @Override
    public Iterable<OutgoingCallTransition<L, R>> callSuccessors(R r, L l) {
        return Collections.emptySet();
    }

    @Override
    public Iterable<OutgoingReturnTransition<L, R>> returnSuccessors(R r, R r2, L l) {
        return Collections.emptySet();
    }
}

