/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public enum RelationSymbol {
    EQ("="),
    DISTINCT("distinct"),
    LEQ("<="),
    GEQ(">="),
    LESS("<"),
    GREATER(">"),
    BVULE("bvule"),
    BVULT("bvult"),
    BVUGE("bvuge"),
    BVUGT("bvugt"),
    BVSLE("bvsle"),
    BVSLT("bvslt"),
    BVSGE("bvsge"),
    BVSGT("bvsgt");

    private final String mStringRepresentation;

    private RelationSymbol(String string2) {
        this.mStringRepresentation = string2;
    }

    public String toString() {
        return this.mStringRepresentation;
    }

    public static RelationSymbol convert(String string) {
        switch (string) {
            case "=": {
                return EQ;
            }
            case "distinct": {
                return DISTINCT;
            }
            case "<=": {
                return LEQ;
            }
            case ">=": {
                return GEQ;
            }
            case "<": {
                return LESS;
            }
            case ">": {
                return GREATER;
            }
            case "bvule": {
                return BVULE;
            }
            case "bvult": {
                return BVULT;
            }
            case "bvuge": {
                return BVUGE;
            }
            case "bvugt": {
                return BVUGT;
            }
            case "bvsle": {
                return BVSLE;
            }
            case "bvslt": {
                return BVSLT;
            }
            case "bvsge": {
                return BVSGE;
            }
            case "bvsgt": {
                return BVSGT;
            }
        }
        return null;
    }

    public RelationSymbol negate() {
        return switch (this) {
            case EQ -> DISTINCT;
            case DISTINCT -> EQ;
            case LEQ -> GREATER;
            case GEQ -> LESS;
            case LESS -> GEQ;
            case GREATER -> LEQ;
            case BVULE -> BVUGT;
            case BVULT -> BVUGE;
            case BVUGE -> BVULT;
            case BVUGT -> BVULE;
            case BVSLE -> BVSGT;
            case BVSLT -> BVSGE;
            case BVSGE -> BVSLT;
            case BVSGT -> BVSLE;
            default -> throw new AssertionError((Object)("unknown RelationSymbol " + String.valueOf((Object)this)));
        };
    }

    public RelationSymbol swapParameters() {
        return switch (this) {
            case EQ -> EQ;
            case DISTINCT -> DISTINCT;
            case LEQ -> GEQ;
            case GEQ -> LEQ;
            case LESS -> GREATER;
            case GREATER -> LESS;
            case BVULE -> BVUGE;
            case BVULT -> BVUGT;
            case BVUGE -> BVULE;
            case BVUGT -> BVULT;
            case BVSLE -> BVSGE;
            case BVSLT -> BVSGT;
            case BVSGE -> BVSLE;
            case BVSGT -> BVSLT;
            default -> throw new AssertionError((Object)("unknown RelationSymbol " + String.valueOf((Object)this)));
        };
    }

    public boolean isConvexInequality() {
        return switch (this) {
            case EQ, DISTINCT -> false;
            case LEQ, GEQ, LESS, GREATER, BVULE, BVULT, BVUGE, BVUGT, BVSLE, BVSLT, BVSGE, BVSGT -> true;
            default -> throw new AssertionError((Object)("unknown RelationSymbol " + String.valueOf((Object)this)));
        };
    }

    public Term constructTerm(Script script, Term term, Term term2) {
        return switch (this) {
            case EQ -> CommuhashUtils.term(script, "=", null, null, term, term2);
            case DISTINCT -> SmtUtils.not(script, CommuhashUtils.term(script, "=", null, null, term, term2));
            case LEQ -> SmtUtils.leq(script, term, term2);
            case GEQ -> SmtUtils.leq(script, term2, term);
            case LESS -> SmtUtils.less(script, term, term2);
            case GREATER -> SmtUtils.less(script, term2, term);
            case BVULE -> SmtUtils.bvule(script, term, term2);
            case BVULT -> SmtUtils.bvult(script, term, term2);
            case BVUGE -> SmtUtils.bvule(script, term2, term);
            case BVUGT -> SmtUtils.bvult(script, term2, term);
            case BVSLE -> SmtUtils.bvsle(script, term, term2);
            case BVSLT -> SmtUtils.bvslt(script, term, term2);
            case BVSGE -> SmtUtils.bvsle(script, term2, term);
            case BVSGT -> SmtUtils.bvslt(script, term2, term);
            default -> throw new AssertionError((Object)("unknown RelationSymbol " + String.valueOf((Object)this)));
        };
    }

    public boolean isRelationSymbolGE() {
        return this == GEQ || this == BVUGE || this == BVSGE;
    }

    public boolean isRelationSymbolLE() {
        return this == LEQ || this == BVULE || this == BVSLE;
    }

    public boolean isRelationSymbolGT() {
        return this == GREATER || this == BVUGT || this == BVSGT;
    }

    public boolean isRelationSymbolLT() {
        return this == LESS || this == BVULT || this == BVSLT;
    }

    public boolean isStrictRelation() {
        switch (this) {
            case EQ: 
            case DISTINCT: 
            case LEQ: 
            case GEQ: 
            case BVULE: 
            case BVUGE: 
            case BVSLE: 
            case BVSGE: {
                return false;
            }
            case LESS: 
            case GREATER: 
            case BVULT: 
            case BVUGT: 
            case BVSLT: 
            case BVSGT: {
                return true;
            }
        }
        throw new AssertionError((Object)("unknown RelationSymbol " + String.valueOf((Object)this)));
    }

    public RelationSymbol getCorrespondingStrictRelationSymbol() {
        switch (this) {
            case LEQ: {
                return LESS;
            }
            case GEQ: {
                return GREATER;
            }
            case BVULE: {
                return BVULT;
            }
            case BVUGE: {
                return BVUGT;
            }
            case BVSGE: {
                return BVSGT;
            }
            case BVSLE: {
                return BVSLT;
            }
            case EQ: 
            case DISTINCT: 
            case LESS: 
            case GREATER: 
            case BVULT: 
            case BVUGT: 
            case BVSLT: 
            case BVSGT: {
                return this;
            }
        }
        throw new AssertionError((Object)("unknown RelationSymbol " + String.valueOf((Object)this)));
    }

    public Rational getOffsetForNonstrictToStrictTransformation() {
        switch (this) {
            case LEQ: {
                return Rational.MONE;
            }
            case GEQ: {
                return Rational.ONE;
            }
            case EQ: 
            case DISTINCT: 
            case LESS: 
            case GREATER: {
                return Rational.ZERO;
            }
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                throw new AssertionError((Object)"Non-strict to strict transformation not available for bitvectors");
            }
        }
        throw new AssertionError((Object)("unknown RelationSymbol " + String.valueOf((Object)this)));
    }

    public RelationSymbol getCorrespondingNonStrictRelationSymbol() {
        switch (this) {
            case LESS: {
                return LEQ;
            }
            case GREATER: {
                return GEQ;
            }
            case BVULT: {
                return BVULE;
            }
            case BVUGT: {
                return BVUGE;
            }
            case BVSLT: {
                return BVSLE;
            }
            case BVSGT: {
                return BVSGE;
            }
            case EQ: 
            case DISTINCT: 
            case LEQ: 
            case GEQ: 
            case BVULE: 
            case BVUGE: 
            case BVSLE: 
            case BVSGE: {
                return this;
            }
        }
        throw new AssertionError((Object)("unknown RelationSymbol " + String.valueOf((Object)this)));
    }

    public Rational getOffsetForStrictToNonstrictTransformation() {
        switch (this) {
            case LESS: {
                return Rational.ONE;
            }
            case GREATER: {
                return Rational.MONE;
            }
            case EQ: 
            case DISTINCT: 
            case LEQ: 
            case GEQ: {
                return Rational.ZERO;
            }
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                throw new AssertionError((Object)"Strict to non-strict transformation not available for bitvectors");
            }
        }
        throw new AssertionError((Object)("unknown RelationSymbol " + String.valueOf((Object)this)));
    }

    public static RelationSymbol getLessRelationSymbol(boolean bl, Sort sort, BvSignedness bvSignedness) {
        RelationSymbol relationSymbol;
        block10: {
            block8: {
                block9: {
                    if (!SmtSortUtils.isBitvecSort(sort)) break block8;
                    if (!bl) break block9;
                    switch (bvSignedness) {
                        case SIGNED: {
                            relationSymbol = BVSLT;
                            break block10;
                        }
                        case UNSIGNED: {
                            relationSymbol = BVULT;
                            break block10;
                        }
                        default: {
                            throw new AssertionError((Object)("unknown value " + String.valueOf((Object)bvSignedness)));
                        }
                    }
                }
                switch (bvSignedness) {
                    case SIGNED: {
                        relationSymbol = BVSLE;
                        break block10;
                    }
                    case UNSIGNED: {
                        relationSymbol = BVULE;
                        break block10;
                    }
                    default: {
                        throw new AssertionError((Object)("unknown value " + String.valueOf((Object)bvSignedness)));
                    }
                }
            }
            relationSymbol = bl ? LESS : LEQ;
        }
        return relationSymbol;
    }

    public static RelationSymbol getGreaterRelationSymbol(boolean bl, Sort sort, BvSignedness bvSignedness) {
        RelationSymbol relationSymbol;
        block10: {
            block8: {
                block9: {
                    if (!SmtSortUtils.isBitvecSort(sort)) break block8;
                    if (!bl) break block9;
                    switch (bvSignedness) {
                        case SIGNED: {
                            relationSymbol = BVSGT;
                            break block10;
                        }
                        case UNSIGNED: {
                            relationSymbol = BVUGT;
                            break block10;
                        }
                        default: {
                            throw new AssertionError((Object)("unknown value " + String.valueOf((Object)bvSignedness)));
                        }
                    }
                }
                switch (bvSignedness) {
                    case SIGNED: {
                        relationSymbol = BVSGE;
                        break block10;
                    }
                    case UNSIGNED: {
                        relationSymbol = BVUGE;
                        break block10;
                    }
                    default: {
                        throw new AssertionError((Object)("unknown value " + String.valueOf((Object)bvSignedness)));
                    }
                }
            }
            relationSymbol = bl ? GREATER : GEQ;
        }
        return relationSymbol;
    }

    public boolean isSignedBvRelation() {
        switch (this) {
            case EQ: 
            case DISTINCT: 
            case LEQ: 
            case GEQ: 
            case LESS: 
            case GREATER: 
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: {
                return false;
            }
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                return true;
            }
        }
        throw new AssertionError((Object)("unknown RelationSymbol " + String.valueOf((Object)this)));
    }

    public boolean isUnSignedBvRelation() {
        switch (this) {
            case EQ: 
            case DISTINCT: 
            case LEQ: 
            case GEQ: 
            case LESS: 
            case GREATER: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                return false;
            }
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: {
                return true;
            }
        }
        throw new AssertionError((Object)("unknown RelationSymbol " + String.valueOf((Object)this)));
    }

    public BvSignedness getSignedness() {
        switch (this) {
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                return BvSignedness.SIGNED;
            }
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: {
                return BvSignedness.UNSIGNED;
            }
        }
        throw new AssertionError((Object)("not a bitvector inequality " + String.valueOf((Object)this)));
    }

    public static enum BvSignedness {
        SIGNED,
        UNSIGNED;

    }
}

