/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.IVertex;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.ModelVertex;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.PredicateVertex;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.RestructureHelperObject;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.HashDeque;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PredicateTrie<T extends IPredicate> {
    private final IUltimateServiceProvider mServices;
    private final BasicPredicateFactory mFactory;
    private final T mTruePredicate;
    private final T mFalsePredicate;
    private final IIcfgSymbolTable mSymbolTable;
    private final ManagedScript mMgdScript;
    private final ILogger mLogger;
    private final Set<T> mPredicates = new HashSet<T>();
    private IVertex mRoot;

    protected PredicateTrie(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, T t, T t2, BasicPredicateFactory basicPredicateFactory, IIcfgSymbolTable iIcfgSymbolTable) {
        this.mServices = iUltimateServiceProvider;
        this.mFactory = basicPredicateFactory;
        this.mLogger = iLogger;
        this.mMgdScript = managedScript;
        this.mSymbolTable = iIcfgSymbolTable;
        this.mTruePredicate = t;
        this.mFalsePredicate = t2;
        this.mRoot = null;
    }

    private Deque<Map<Term, Term>> findRPath(T t) {
        HashDeque hashDeque = new HashDeque();
        IVertex iVertex = this.mRoot;
        ModelVertex modelVertex = null;
        while (iVertex instanceof ModelVertex) {
            modelVertex = (ModelVertex)iVertex;
            boolean bl = this.fulfillsPredicate(t, modelVertex.getWitness());
            iVertex = modelVertex.getChild(bl);
            hashDeque.add(modelVertex.getWitness());
        }
        this.mLogger.info((Object)("predicate at end of path: " + String.valueOf(iVertex)));
        return hashDeque;
    }

    private Deque<Map<Term, Term>> findRealPath(T t) {
        ArrayDeque<Object> arrayDeque = new ArrayDeque<ModelVertex>();
        arrayDeque.addFirst((ModelVertex)this.mRoot);
        ArrayDeque<ModelVertex> arrayDeque2 = this.findPathHelper(t, true, (ArrayDeque<ModelVertex>)arrayDeque.clone());
        ArrayDeque<ModelVertex> arrayDeque3 = this.findPathHelper(t, false, (ArrayDeque<ModelVertex>)arrayDeque.clone());
        arrayDeque = arrayDeque2.size() > arrayDeque3.size() ? arrayDeque2 : arrayDeque3;
        this.mLogger.info((Object)("predicate at end of path true: " + String.valueOf(((ModelVertex)arrayDeque.getLast()).getChild(true))));
        this.mLogger.info((Object)("predicate at end of path false: " + String.valueOf(((ModelVertex)arrayDeque.getLast()).getChild(false))));
        ArrayDeque<Map<Term, Term>> arrayDeque4 = new ArrayDeque<Map<Term, Term>>();
        while (!arrayDeque.isEmpty()) {
            arrayDeque4.addLast(((ModelVertex)arrayDeque.removeFirst()).getWitness());
        }
        return arrayDeque4;
    }

    private ArrayDeque<ModelVertex> findPathHelper(T t, boolean bl, ArrayDeque<ModelVertex> arrayDeque) {
        IVertex iVertex = arrayDeque.getLast().getChild(bl);
        if (iVertex instanceof PredicateVertex) {
            if (((PredicateVertex)iVertex).mPredicate.equals(t)) {
                return arrayDeque;
            }
            return new ArrayDeque<ModelVertex>();
        }
        arrayDeque.addLast((ModelVertex)iVertex);
        ArrayDeque<ModelVertex> arrayDeque2 = this.findPathHelper(t, true, (ArrayDeque<ModelVertex>)arrayDeque.clone());
        ArrayDeque<ModelVertex> arrayDeque3 = this.findPathHelper(t, false, (ArrayDeque<ModelVertex>)arrayDeque.clone());
        if (arrayDeque2.size() > arrayDeque3.size()) {
            return arrayDeque2;
        }
        return arrayDeque3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.stringHelper(this.mRoot, stringBuilder);
        return stringBuilder.toString();
    }

    private void stringHelper(IVertex iVertex, StringBuilder stringBuilder) {
        if (iVertex instanceof ModelVertex) {
            stringBuilder.append(iVertex.print() + "\n");
            this.stringHelper(((ModelVertex)iVertex).getChild(true), stringBuilder);
            this.stringHelper(((ModelVertex)iVertex).getChild(false), stringBuilder);
        }
    }

    protected T unifyPredicate(T t) {
        Object object2;
        if (this.mRoot == null) {
            this.mRoot = new PredicateVertex<T>(t);
            this.mPredicates.add(t);
            return t;
        }
        IVertex iVertex = this.mRoot;
        ModelVertex modelVertex = null;
        while (iVertex instanceof ModelVertex) {
            modelVertex = (ModelVertex)iVertex;
            boolean bl = this.fulfillsPredicate(t, modelVertex.getWitness());
            iVertex = modelVertex.getChild(bl);
        }
        Object t2 = ((PredicateVertex)iVertex).mPredicate;
        Map<Term, Term> map = this.compare(t, t2);
        if (map.isEmpty()) {
            return t2;
        }
        for (Object object2 : this.mPredicates) {
            Term term = object2.getClosedFormula();
            Term term2 = t.getClosedFormula();
            if (this.mMgdScript.isLocked()) {
                this.mMgdScript.requestLockRelease();
            }
            this.mMgdScript.lock((Object)this);
            this.mMgdScript.push((Object)this, 1);
            Term term3 = this.mMgdScript.term((Object)this, "distinct", new Term[]{term, term2});
            try {
                this.mMgdScript.assertTerm((Object)this, term3);
                Script.LBool lBool = this.mMgdScript.checkSat((Object)this);
                if (lBool != Script.LBool.UNSAT) continue;
                this.mLogger.info((Object)("new: " + String.valueOf(t)));
                this.mLogger.info((Object)("newPath: " + String.valueOf(this.findRPath(t))));
                this.mLogger.info((Object)("old: " + String.valueOf(object2)));
                this.mLogger.info((Object)("newPath: " + String.valueOf(this.findRealPath(object2))));
                throw new UnsupportedOperationException("EQUALITY NOT FOUND" + this.mPredicates.size());
            }
            finally {
                this.mMgdScript.pop((Object)this, 1);
                this.mMgdScript.unlock((Object)this);
            }
        }
        Object object3 = object2 = this.fulfillsPredicate(t, map) ? new ModelVertex(new PredicateVertex<T>(t), iVertex, map) : new ModelVertex(iVertex, new PredicateVertex<T>(t), map);
        if (modelVertex != null) {
            modelVertex.swapChild(iVertex, (IVertex)object2);
        } else {
            this.mRoot = object2;
        }
        this.mPredicates.add(t);
        return t;
    }

    protected boolean fulfillsPredicate(T t, Map<Term, Term> map) {
        Term term = Substitution.apply((ManagedScript)this.mMgdScript, map, (Term)t.getClosedFormula());
        if (this.mTruePredicate.getFormula().equals(term)) {
            return true;
        }
        assert (this.checkFalseCase(t, map, term)) : "unexpected false case";
        return false;
    }

    private boolean checkFalseCase(T t, Map<Term, Term> map, Term term) {
        if (this.mFalsePredicate.getFormula().equals(term)) {
            return true;
        }
        Term term2 = this.mTruePredicate.getClosedFormula();
        Term term3 = this.mMgdScript.getScript().term("distinct", new Term[]{term2, term});
        Script.LBool lBool = SmtUtils.checkSatTerm((Script)this.mMgdScript.getScript(), (Term)term3);
        if (lBool == Script.LBool.UNSAT) {
            this.mLogger.fatal((Object)"Simplification failed: it is actually equal to true");
            this.mLogger.fatal((Object)term3.toStringDirect());
            this.mLogger.fatal((Object)("original predicate: " + t.toString()));
            this.mLogger.fatal((Object)("witness           : " + map.toString()));
            return false;
        }
        return true;
    }

    private Map<Term, Term> compare(T t, T t2) {
        T t3 = t2;
        Term term = t3.getClosedFormula();
        Term term2 = t.getClosedFormula();
        if (this.mMgdScript.isLocked()) {
            this.mMgdScript.requestLockRelease();
        }
        this.mMgdScript.lock((Object)this);
        this.mMgdScript.push((Object)this, 1);
        Term term3 = this.mMgdScript.term((Object)this, "distinct", new Term[]{term, term2});
        try {
            this.mMgdScript.assertTerm((Object)this, term3);
            Script.LBool lBool = this.mMgdScript.checkSat((Object)this);
            if (lBool == Script.LBool.UNSAT) {
                Map<Term, Term> map = Collections.emptyMap();
                return map;
            }
            if (lBool == Script.LBool.SAT) {
                Set<ApplicationTerm> set = this.mSymbolTable.computeAllDefaultConstants();
                Map map = this.mMgdScript.getScript().getValue(set.toArray(new Term[set.size()]));
                return map;
            }
            throw new UnsupportedOperationException("Cannot handle case were solver cannot decide equality of predicates");
        }
        finally {
            this.mMgdScript.pop((Object)this, 1);
            this.mMgdScript.unlock((Object)this);
        }
    }

    protected Map<Term, Term> getWitness(Term term) {
        TermVarsFuns termVarsFuns = TermVarsFuns.computeTermVarsFuns(term, this.mMgdScript, this.mSymbolTable);
        if (this.mMgdScript.isLocked()) {
            this.mMgdScript.requestLockRelease();
        }
        this.mMgdScript.lock((Object)this);
        this.mMgdScript.push((Object)this, 1);
        try {
            this.mMgdScript.assertTerm((Object)this, termVarsFuns.getClosedFormula());
            Script.LBool lBool = this.mMgdScript.checkSat((Object)this);
            if (lBool == Script.LBool.SAT) {
                Set<IProgramVar> set = termVarsFuns.getVars();
                Set<Term> set2 = set.stream().map(IProgramVar::getDefaultConstant).collect(Collectors.toSet());
                Map map = this.mMgdScript.getScript().getValue(set2.toArray(new Term[set2.size()]));
                return map;
            }
            throw new UnsupportedOperationException("Solver cannot find a model for the term " + String.valueOf(term));
        }
        finally {
            this.mMgdScript.pop((Object)this, 1);
            this.mMgdScript.unlock((Object)this);
        }
    }

    protected int getDepth() {
        if (this.mRoot == null) {
            return 0;
        }
        return this.getDepthHelper(this.mRoot, 0);
    }

    private int getDepthHelper(IVertex iVertex, int n) {
        if (iVertex instanceof PredicateVertex) {
            return n + 1;
        }
        int n2 = this.getDepthHelper(((ModelVertex)iVertex).getChild(false), n + 1);
        int n3 = this.getDepthHelper(((ModelVertex)iVertex).getChild(true), n + 1);
        return Math.max(n2, n3);
    }

    public PredicateTrie<T> fillTrie(RestructureHelperObject restructureHelperObject, Map<RestructureHelperObject, Pair<RestructureHelperObject, RestructureHelperObject>> map) {
        if (this.mRoot != null) {
            throw new UnsupportedOperationException("trie must be empty");
        }
        HashMap<RestructureHelperObject, ModelVertex> hashMap = new HashMap<RestructureHelperObject, ModelVertex>();
        for (RestructureHelperObject object : map.keySet()) {
            hashMap.put(object, new ModelVertex(null, null, object.getWitness()));
        }
        for (Map.Entry entry : map.entrySet()) {
            PredicateVertex<IPredicate> predicateVertex;
            Pair pair = (Pair)entry.getValue();
            if (((RestructureHelperObject)pair.getFirst()).getSerialNumber() == -1) {
                predicateVertex = new PredicateVertex<IPredicate>(((RestructureHelperObject)pair.getFirst()).getPredicate());
                ((ModelVertex)hashMap.get(entry.getKey())).setTrueChild(predicateVertex);
            } else {
                ((ModelVertex)hashMap.get(entry.getKey())).setTrueChild((IVertex)hashMap.get(pair.getFirst()));
            }
            if (((RestructureHelperObject)pair.getSecond()).getSerialNumber() == -1) {
                predicateVertex = new PredicateVertex<IPredicate>(((RestructureHelperObject)pair.getSecond()).getPredicate());
                ((ModelVertex)hashMap.get(entry.getKey())).setFalseChild(predicateVertex);
                continue;
            }
            ((ModelVertex)hashMap.get(entry.getKey())).setFalseChild((IVertex)hashMap.get(pair.getSecond()));
        }
        this.mRoot = (IVertex)hashMap.get(restructureHelperObject);
        return this;
    }
}

