/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.IRunningTaskStackProvider;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IRelevanceInformation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.AbstractCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryForInterpolantAutomata;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryResultChecking;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.RelevanceInformation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.DangerAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.ErrorAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.ErrorAutomatonStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.ErrorTraceContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.IErrorAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.SimpleErrorAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorlocalization.ErrorLocalizationStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorlocalization.FlowSensitiveFaultLocalizer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ErrorGeneralizationEngine<L extends IIcfgTransition<?>>
implements IErrorAutomatonBuilder<L> {
    private static final boolean LOG_EXTENDED_SIZE_INFO = false;
    protected final IUltimateServiceProvider mServices;
    protected final ILogger mLogger;
    private final ErrorTraceContainer<L> mErrorTraces;
    private final List<Collection<L>> mRelevantStatements;
    private final List<ErrorLocalizationStatisticsGenerator> mFaultLocalizerStatistics;
    private final ErrorAutomatonStatisticsGenerator mErrorAutomatonStatisticsGenerator;
    private IErrorAutomatonBuilder<L> mErrorAutomatonBuilder;
    private int mLastIteration = -1;
    private final IErrorAutomatonBuilder.ErrorAutomatonType mType;

    public ErrorGeneralizationEngine(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mErrorAutomatonStatisticsGenerator = new ErrorAutomatonStatisticsGenerator();
        this.mErrorTraces = new ErrorTraceContainer();
        this.mRelevantStatements = new ArrayList<Collection<L>>();
        this.mFaultLocalizerStatistics = new ArrayList<ErrorLocalizationStatisticsGenerator>();
        this.mType = (IErrorAutomatonBuilder.ErrorAutomatonType)this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getEnum("Error locations removal mode", IErrorAutomatonBuilder.ErrorAutomatonType.class);
    }

    @Override
    public NestedWordAutomaton<L, IPredicate> getResultBeforeEnhancement() {
        return this.mErrorAutomatonBuilder.getResultBeforeEnhancement();
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<L, IPredicate> getResultAfterEnhancement() {
        return this.mErrorAutomatonBuilder.getResultAfterEnhancement();
    }

    @Override
    public IErrorAutomatonBuilder.ErrorAutomatonType getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IPredicate getErrorPrecondition() {
        return this.mErrorAutomatonBuilder.getErrorPrecondition();
    }

    @Override
    public TAPreferences.InterpolantAutomatonEnhancement getEnhancementMode() {
        return this.mErrorAutomatonBuilder.getEnhancementMode();
    }

    public boolean hasAutomatonInIteration(int n) {
        return this.mLastIteration == n;
    }

    public void constructErrorAutomaton(IRun<L, ?> iRun, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, CfgSmtToolkit cfgSmtToolkit, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable, PredicateFactoryForInterpolantAutomata predicateFactoryForInterpolantAutomata, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, int n) {
        this.constructErrorAutomaton(iRun, predicateFactory, iPredicateUnifier, cfgSmtToolkit, simplificationTechnique, iIcfgSymbolTable, predicateFactoryForInterpolantAutomata, iNestedWordAutomaton, n, this.mType);
    }

    public void constructErrorAutomaton(IRun<L, ?> iRun, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, CfgSmtToolkit cfgSmtToolkit, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable, PredicateFactoryForInterpolantAutomata predicateFactoryForInterpolantAutomata, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, int n, IErrorAutomatonBuilder.ErrorAutomatonType errorAutomatonType) {
        this.mErrorTraces.addTrace(iRun);
        this.mLastIteration = n;
        NestedWord nestedWord = (NestedWord)iRun.getWord();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info("Constructing %s automaton for trace of length %s", new Object[]{errorAutomatonType, nestedWord.length()});
        }
        this.mErrorAutomatonStatisticsGenerator.reportTrace(nestedWord);
        this.mErrorAutomatonStatisticsGenerator.startErrorAutomatonConstructionTime();
        try {
            switch (errorAutomatonType) {
                case SIMPLE_ERROR_AUTOMATON: {
                    this.mErrorAutomatonBuilder = new SimpleErrorAutomatonBuilder<L>(this.mServices, predicateFactory, iPredicateUnifier, cfgSmtToolkit, predicateFactoryForInterpolantAutomata, iNestedWordAutomaton, nestedWord);
                    break;
                }
                case ERROR_AUTOMATON: {
                    this.mErrorAutomatonBuilder = new ErrorAutomatonBuilder<L>(this.mServices, predicateFactory, iPredicateUnifier, cfgSmtToolkit, simplificationTechnique, iIcfgSymbolTable, predicateFactoryForInterpolantAutomata, iNestedWordAutomaton, nestedWord);
                    break;
                }
                case DANGER_AUTOMATON: {
                    this.mErrorAutomatonBuilder = new DangerAutomatonBuilder<L>(this.mServices, predicateFactory, iPredicateUnifier, cfgSmtToolkit, simplificationTechnique, iIcfgSymbolTable, predicateFactoryForInterpolantAutomata, iNestedWordAutomaton, nestedWord);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown automaton type: " + String.valueOf((Object)errorAutomatonType));
                }
            }
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            this.mErrorAutomatonStatisticsGenerator.stopErrorAutomatonConstructionTime();
            this.mErrorAutomatonStatisticsGenerator.finishAutomatonInstance();
            RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), "constructing error automaton for trace of length " + nestedWord.length() + " (spent " + this.mErrorAutomatonStatisticsGenerator.getLastConstructionTime() + " nanoseconds)");
            throw new ToolchainCanceledException((IRunningTaskStackProvider)toolchainCanceledException, runningTaskInfo);
        }
        this.mErrorAutomatonStatisticsGenerator.stopErrorAutomatonConstructionTime();
        this.mErrorTraces.addPrecondition(this.mErrorAutomatonBuilder.getErrorPrecondition());
    }

    public void startDifference() {
        this.mErrorAutomatonStatisticsGenerator.startErrorAutomatonDifferenceTime();
    }

    public void stopDifference(INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, PredicateFactoryForInterpolantAutomata predicateFactoryForInterpolantAutomata, PredicateFactoryResultChecking predicateFactoryResultChecking, IRun<L, ?> iRun, boolean bl) throws AutomataLibraryException {
        this.mErrorAutomatonStatisticsGenerator.stopErrorAutomatonDifferenceTime();
        if (!bl) {
            this.mErrorTraces.addEnhancementType(this.mErrorAutomatonStatisticsGenerator.getEnhancement());
        }
        this.mErrorAutomatonStatisticsGenerator.finishAutomatonInstance();
    }

    public void reportErrorGeneralizationBenchmarks() {
        StatisticsData statisticsData = new StatisticsData();
        this.mErrorAutomatonStatisticsGenerator.reportRelevantStatements(this.mRelevantStatements);
        this.mErrorAutomatonStatisticsGenerator.reportFaultLocalizationStatistics(this.mFaultLocalizerStatistics);
        statisticsData.aggregateBenchmarkData((IStatisticsDataProvider)this.mErrorAutomatonStatisticsGenerator);
        StatisticsResult statisticsResult = new StatisticsResult("TraceAbstraction", "ErrorAutomatonStatistics", (ICsvProviderProvider)statisticsData);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)statisticsResult);
    }

    public boolean isResultUnsafe(AbstractCegarLoop.Result result, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable) {
        if (this.mErrorTraces.isEmpty()) {
            return false;
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Found " + this.mErrorTraces.size() + (this.mErrorTraces.size() == 1 ? " error trace:" : " different error traces in total:")));
            int n = 0;
            for (ErrorTraceContainer.ErrorTrace<L> errorTrace : this.mErrorTraces) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(++n).append(": Error trace of length ").append(errorTrace.getTrace().getWord().length());
                switch (errorTrace.getEnhancement()) {
                    case NONE: {
                        stringBuilder.append(" (no additional traces)");
                        break;
                    }
                    case FINITE: {
                        stringBuilder.append(" (finite language)");
                        break;
                    }
                    case INFINITE: {
                        stringBuilder.append(" (infinite language)");
                        break;
                    }
                    case UNKNOWN: {
                        stringBuilder.append(" (unknown trace enhancement)");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown enhancement type: " + String.valueOf((Object)errorTrace.getEnhancement()));
                    }
                }
                IPredicate iPredicate = errorTrace.getPrecondition();
                if (iPredicate == null) {
                    stringBuilder.append(" (precondition not computed).");
                } else {
                    stringBuilder.append(" has precondition ").append(iPredicate.getFormula()).append('.');
                }
                this.mLogger.warn((Object)stringBuilder.toString());
            }
        }
        this.aggregateFaultLocalization(iNestedWordAutomaton, cfgSmtToolkit, predicateFactory, iPredicateUnifier, simplificationTechnique, iIcfgSymbolTable);
        return true;
    }

    private void aggregateFaultLocalization(INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable) {
        HashMap hashMap = new HashMap();
        ArrayList<ErrorLocalizationStatisticsGenerator> arrayList = new ArrayList<ErrorLocalizationStatisticsGenerator>();
        Iterator<Collection<L>> iterator = this.mRelevantStatements.iterator();
        for (ErrorTraceContainer.ErrorTrace<L> errorTrace : this.mErrorTraces) {
            NestedRun nestedRun = (NestedRun)errorTrace.getTrace();
            if (!iterator.hasNext()) break;
            Collection<L> collection = iterator.next();
            ErrorGeneralizationEngine.aggregate(collection, hashMap, nestedRun.getStateSequence());
        }
        this.presentResult(hashMap, iNestedWordAutomaton, arrayList);
    }

    public void faultLocalizationWithStorage(INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable, List<ErrorLocalizationStatisticsGenerator> list, NestedRun<L, IPredicate> nestedRun, IIcfg<IcfgLocation> iIcfg) {
        List<ErrorLocalizationStatisticsGenerator> list2 = list == null ? this.mFaultLocalizerStatistics : list;
        this.mRelevantStatements.add(this.faultLocalization(iNestedWordAutomaton, cfgSmtToolkit, predicateFactory, iPredicateUnifier, simplificationTechnique, iIcfgSymbolTable, list2, nestedRun, iIcfg));
    }

    private Collection<L> faultLocalization(INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable, List<ErrorLocalizationStatisticsGenerator> list, NestedRun<L, IPredicate> nestedRun, IIcfg<IcfgLocation> iIcfg) {
        FlowSensitiveFaultLocalizer<L> flowSensitiveFaultLocalizer = new FlowSensitiveFaultLocalizer<L>(nestedRun, iNestedWordAutomaton, this.mServices, cfgSmtToolkit, predicateFactory, cfgSmtToolkit.getModifiableGlobalsTable(), iPredicateUnifier, TraceAbstractionPreferenceInitializer.RelevanceAnalysisMode.SINGLE_TRACE, simplificationTechnique, iIcfgSymbolTable, iIcfg);
        List<IRelevanceInformation> list2 = flowSensitiveFaultLocalizer.getRelevanceInformation();
        if (list != null) {
            list.add(flowSensitiveFaultLocalizer.getStatistics());
        }
        return this.findResponsibleStatements(list2, nestedRun.getWord());
    }

    private Collection<L> findResponsibleStatements(List<IRelevanceInformation> list, NestedWord<L> nestedWord) {
        assert (nestedWord.length() == list.size());
        Iterator<IRelevanceInformation> iterator = list.iterator();
        ArrayList<IIcfgTransition> arrayList = new ArrayList<IIcfgTransition>();
        for (IIcfgTransition iIcfgTransition : nestedWord) {
            RelevanceInformation relevanceInformation = (RelevanceInformation)iterator.next();
            if (relevanceInformation == null || !relevanceInformation.getCriterion1GF() && !relevanceInformation.getCriterion1UC()) continue;
            arrayList.add(iIcfgTransition);
        }
        return arrayList;
    }

    private static <LETTER> void aggregate(Collection<LETTER> collection, Map<IcfgLocation, Set<LETTER>> map, List<IPredicate> list) {
        IcfgLocation icfgLocation = ((ISLPredicate)list.get(list.size() - 1)).getProgramPoint();
        Set<LETTER> set = map.get(icfgLocation);
        if (set == null) {
            set = new HashSet<LETTER>(collection);
            map.put(icfgLocation, set);
        } else {
            set.retainAll(collection);
        }
    }

    private void presentResult(Map<IcfgLocation, Set<L>> map, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, List<ErrorLocalizationStatisticsGenerator> list) {
        if (this.mLogger.isWarnEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            VpAlphabet vpAlphabet = iNestedWordAutomaton.getVpAlphabet();
            int n = vpAlphabet.getInternalAlphabet().size() + vpAlphabet.getCallAlphabet().size() + vpAlphabet.getReturnAlphabet().size();
            for (Map.Entry<IcfgLocation, Set<L>> entry : map.entrySet()) {
                stringBuilder.append("Error location '").append(entry.getKey());
                Set<L> object = entry.getValue();
                if (object.isEmpty()) {
                    stringBuilder.append("' has no responsible statements (out of ").append(n).append(").");
                } else {
                    stringBuilder.append("' has the following ").append(object.size()).append(" responsible statements (out of ").append(n).append("):\n");
                    for (IIcfgTransition iIcfgTransition : object) {
                        stringBuilder.append(iIcfgTransition).append(", ");
                    }
                }
                stringBuilder.append('\n');
            }
            long l = 0L;
            for (ErrorLocalizationStatisticsGenerator errorLocalizationStatisticsGenerator : list) {
                l += errorLocalizationStatisticsGenerator.getErrorLocalizationTime();
            }
            stringBuilder.append("Fault localization was applied ").append(list.size()).append(" times and altogether took ").append(StatisticsType.prettyprintNanoseconds((long)l)).append(" seconds.");
            this.mLogger.warn((Object)stringBuilder);
        }
    }
}

