/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SymbolicMemory {
    private final ManagedScript mManagedScript;
    private final ILogger mLogger;
    private final Map<IProgramVar, List<Term>> mSymbolicMemory;
    private final Map<IProgramVar, Term> mIteratedSymbolicMemory;
    private final Map<IProgramVar, UpdateType> mUpdateTypeMap;
    private final List<TermVariable> mKappas;
    private final Map<TermVariable, TermVariable> mKappa2Tau;
    private final List<Term> mRangeTerms;
    private final List<Term> mRangeExTerms;
    private final Map<Integer, Set<IProgramVar>> mAssignedVars;
    private final Map<TermVariable, Set<Integer>> mAssigningPaths;
    private final Map<IProgramVar, TermVariable> mInVars;
    private final Map<Term, Term> mReplaceInV;
    private final Map<IProgramVar, TermVariable> mOutVars;
    private int mCurrentPath;

    public SymbolicMemory(ManagedScript managedScript, ILogger iLogger) {
        this.mManagedScript = managedScript;
        this.mLogger = iLogger;
        this.mSymbolicMemory = new HashMap<IProgramVar, List<Term>>();
        this.mIteratedSymbolicMemory = new HashMap<IProgramVar, Term>();
        this.mUpdateTypeMap = new HashMap<IProgramVar, UpdateType>();
        this.mKappas = new ArrayList<TermVariable>();
        this.mKappa2Tau = new HashMap<TermVariable, TermVariable>();
        this.mRangeTerms = new ArrayList<Term>();
        this.mRangeExTerms = new ArrayList<Term>();
        this.mAssignedVars = new HashMap<Integer, Set<IProgramVar>>();
        this.mAssigningPaths = new HashMap<TermVariable, Set<Integer>>();
        this.mInVars = new HashMap<IProgramVar, TermVariable>();
        this.mOutVars = new HashMap<IProgramVar, TermVariable>();
        this.mReplaceInV = new HashMap<Term, Term>();
        this.mCurrentPath = -1;
    }

    public void newPath() {
        ++this.mCurrentPath;
        this.mAssignedVars.put(this.mCurrentPath, new HashSet());
        TermVariable termVariable = this.mManagedScript.variable("kappa" + this.mCurrentPath, this.mManagedScript.getScript().sort("Int", new Sort[0]));
        this.mKappas.add(termVariable);
        TermVariable termVariable2 = this.mManagedScript.variable("tau" + this.mCurrentPath, this.mManagedScript.getScript().sort("Int", new Sort[0]));
        this.mKappa2Tau.put(termVariable, termVariable2);
        Term term = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{this.mManagedScript.getScript().term("<=", new Term[]{Rational.ZERO.toTerm(this.mManagedScript.getScript().sort("Int", new Sort[0])), termVariable2}), this.mManagedScript.getScript().term("<", new Term[]{termVariable2, termVariable})});
        this.mRangeTerms.add(term);
        Term term2 = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{this.mManagedScript.getScript().term("<=", new Term[]{Rational.ZERO.toTerm(this.mManagedScript.getScript().sort("Int", new Sort[0])), termVariable2}), this.mManagedScript.getScript().term("<=", new Term[]{termVariable2, termVariable})});
        this.mRangeExTerms.add(term2);
    }

    public void updateInc(IProgramVar iProgramVar, Term term, IIcfgSymbolTable iIcfgSymbolTable) {
        if (((ApplicationTerm)term).getParameters().length <= 1) {
            if (((ApplicationTerm)term).getFunction().toString().equals("-")) {
                this.updateConst(iProgramVar, term, iIcfgSymbolTable);
                return;
            }
            return;
        }
        this.updateInOutVars(iProgramVar, iIcfgSymbolTable, term.getFreeVars());
        Term term2 = Substitution.apply((ManagedScript)this.mManagedScript, this.mReplaceInV, (Term)term);
        this.mAssignedVars.get(this.mCurrentPath).add(iProgramVar);
        UpdateType updateType = this.mUpdateTypeMap.get(iProgramVar);
        if (updateType != null) {
            switch (updateType) {
                case INCREMENTATION: {
                    this.mSymbolicMemory.get(iProgramVar).add(this.insertPathCounter((ApplicationTerm)term2, this.mKappa2Tau.get(this.mKappas.get(this.mCurrentPath)), iProgramVar.getTermVariable()));
                    break;
                }
                case CONSTANT: {
                    this.updateUndefined(iProgramVar, iIcfgSymbolTable);
                    break;
                }
                case CONSTANT_WITH_SINGLE_PATHCOUNTER: {
                    this.updateUndefined(iProgramVar, iIcfgSymbolTable);
                    break;
                }
            }
        } else {
            this.mSymbolicMemory.put(iProgramVar, new ArrayList());
            this.mSymbolicMemory.get(iProgramVar).add(this.insertPathCounter((ApplicationTerm)term2, this.mKappa2Tau.get(this.mKappas.get(this.mCurrentPath)), iProgramVar.getTermVariable()));
            this.mUpdateTypeMap.put(iProgramVar, UpdateType.INCREMENTATION);
        }
    }

    public void updateConst(IProgramVar iProgramVar, Term term, IIcfgSymbolTable iIcfgSymbolTable) {
        block8: {
            Term term2;
            block7: {
                this.updateInOutVars(iProgramVar, iIcfgSymbolTable, term.getFreeVars());
                term2 = Substitution.apply((ManagedScript)this.mManagedScript, this.mReplaceInV, (Term)term);
                this.mAssignedVars.get(this.mCurrentPath).add(iProgramVar);
                UpdateType updateType = this.mUpdateTypeMap.get(iProgramVar);
                if (updateType == null) break block7;
                switch (updateType) {
                    case INCREMENTATION: {
                        this.updateUndefined(iProgramVar, iIcfgSymbolTable);
                        break;
                    }
                    case CONSTANT: {
                        if (!term2.equals(this.mSymbolicMemory.get(iProgramVar).get(0))) {
                            this.updateUndefined(iProgramVar, iIcfgSymbolTable);
                            break;
                        }
                        break block8;
                    }
                    case CONSTANT_WITH_SINGLE_PATHCOUNTER: {
                        if (!term2.equals(this.mSymbolicMemory.get(iProgramVar).get(0))) {
                            this.updateUndefined(iProgramVar, iIcfgSymbolTable);
                            break;
                        }
                        this.mUpdateTypeMap.put(iProgramVar, UpdateType.CONSTANT);
                        break;
                    }
                }
                break block8;
            }
            this.mSymbolicMemory.put(iProgramVar, new ArrayList());
            this.mSymbolicMemory.get(iProgramVar).add(term2);
            this.mUpdateTypeMap.put(iProgramVar, UpdateType.CONSTANT_WITH_SINGLE_PATHCOUNTER);
        }
    }

    public void updateUndefined(IProgramVar iProgramVar, IIcfgSymbolTable iIcfgSymbolTable) {
        this.mInVars.remove(iProgramVar.getTermVariable());
        this.updateInOutVars(iProgramVar, iIcfgSymbolTable, new TermVariable[0]);
        this.mAssignedVars.get(this.mCurrentPath).add(iProgramVar);
        this.mSymbolicMemory.put(iProgramVar, null);
        this.mUpdateTypeMap.put(iProgramVar, UpdateType.UNDEFINED);
    }

    public Term getFormula(int n, TransFormula transFormula) {
        TermVariable[] termVariableArray;
        TermVariable termVariable;
        Object object22;
        if (this.mIteratedSymbolicMemory.isEmpty()) {
            this.generateTerms();
        }
        for (Object object22 : transFormula.getInVars().keySet()) {
            if (this.mReplaceInV.containsKey(object22.getTermVariable())) continue;
            termVariable = this.mManagedScript.constructFreshCopy(object22.getTermVariable());
            this.mInVars.put((IProgramVar)object22, termVariable);
            this.mReplaceInV.put((Term)object22.getTermVariable(), (Term)termVariable);
        }
        for (Object object22 : transFormula.getOutVars().keySet()) {
            if (this.mOutVars.containsKey(object22)) continue;
            this.mOutVars.put((IProgramVar)object22, this.mManagedScript.constructFreshCopy(object22.getTermVariable()));
        }
        object22 = TransFormulaUtils.constructReverseMapping((Map)transFormula.getInVars());
        HashMap hashMap = new HashMap();
        Object object3 = transFormula.getFormula().getFreeVars();
        int n2 = ((TermVariable[])object3).length;
        int n3 = 0;
        while (n3 < n2) {
            termVariable = object3[n3];
            termVariableArray = (TermVariable[])object22.get(termVariable);
            if (this.mUpdateTypeMap.get(termVariableArray) != UpdateType.UNDEFINED && this.mUpdateTypeMap.get(termVariableArray) != null) {
                hashMap.put(termVariable, this.mIteratedSymbolicMemory.get(termVariableArray));
            } else if (this.mUpdateTypeMap.get(termVariableArray) != UpdateType.UNDEFINED) {
                this.mOutVars.put((IProgramVar)termVariableArray, this.mInVars.get(termVariableArray));
            }
            ++n3;
        }
        termVariable = hashMap.size() > 0 ? Substitution.apply((ManagedScript)this.mManagedScript, (Map)hashMap, (Term)transFormula.getFormula()) : transFormula.getFormula();
        HashMap<Term, Term> hashMap2 = new HashMap<Term, Term>();
        for (Map.Entry entry : object22.entrySet()) {
            hashMap2.put((Term)entry.getKey(), this.mReplaceInV.get(((IProgramVar)entry.getValue()).getTermVariable()));
        }
        Term term = Substitution.apply((ManagedScript)this.mManagedScript, hashMap2, (Term)termVariable);
        object3 = new ArrayList();
        termVariableArray = new TermVariable[this.mKappas.size() - 1];
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.mKappas.size()) {
            if (n5 != n) {
                object3.add(this.mRangeExTerms.get(n5));
                termVariableArray[n4] = this.mKappa2Tau.get(this.mKappas.get(n5));
                ++n4;
            }
            ++n5;
        }
        object3.add(term);
        Term term2 = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])object3.toArray(new Term[object3.size()]));
        Term term3 = this.mCurrentPath > 0 ? this.mManagedScript.getScript().quantifier(0, termVariableArray, term2, (Term[][])new Term[0][]) : term2;
        TermVariable[] termVariableArray2 = new TermVariable[]{this.mKappa2Tau.get(this.mKappas.get(n))};
        Term term4 = this.mManagedScript.getScript().quantifier(1, termVariableArray2, Util.implies((Script)this.mManagedScript.getScript(), (Term[])new Term[]{this.mRangeTerms.get(n), term3}), (Term[][])new Term[0][]);
        this.mLogger.debug((Object)term4.toStringDirect());
        return term4;
    }

    public Term getVarUpdateTerm() {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Map.Entry<IProgramVar, Term> object2 : this.mIteratedSymbolicMemory.entrySet()) {
            arrayList.add(this.mManagedScript.getScript().term("=", new Term[]{(Term)this.mOutVars.get(object2.getKey()), object2.getValue()}));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        HashMap hashMap = new HashMap();
        this.mKappa2Tau.forEach((termVariable, termVariable2) -> {
            TermVariable termVariable3 = hashMap.put(termVariable2, termVariable);
        });
        Term term = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])arrayList.toArray(new Term[arrayList.size()]));
        return Substitution.apply((ManagedScript)this.mManagedScript, hashMap, (Term)term);
    }

    public Boolean containsUndefined() {
        for (UpdateType updateType : this.mUpdateTypeMap.values()) {
            if (updateType != UpdateType.UNDEFINED) continue;
            return true;
        }
        return false;
    }

    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mInVars;
    }

    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mOutVars;
    }

    public Set<TermVariable> getKappas() {
        return new HashSet<TermVariable>(this.mKappas);
    }

    public Set<TermVariable> getTaus() {
        return new HashSet<TermVariable>(this.mKappa2Tau.values());
    }

    public Term getKappaMin() {
        Term term = this.mKappas.size() > 1 ? this.mManagedScript.getScript().term("+", this.mKappas.toArray(new Term[this.mKappas.size()])) : (Term)this.mKappas.get(0);
        return this.mManagedScript.getScript().term("<=", new Term[]{Rational.ZERO.toTerm(this.mManagedScript.getScript().sort("Int", new Sort[0])), term});
    }

    private void updateInOutVars(IProgramVar iProgramVar, IIcfgSymbolTable iIcfgSymbolTable, TermVariable[] termVariableArray) {
        TermVariable[] termVariableArray2 = termVariableArray;
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray2[n2];
            if (!this.mReplaceInV.containsKey(termVariable)) {
                TermVariable termVariable2 = this.mManagedScript.constructFreshCopy(termVariable);
                this.mReplaceInV.put((Term)termVariable, (Term)termVariable2);
                this.mInVars.put(iIcfgSymbolTable.getProgramVar(termVariable), termVariable2);
            }
            ++n2;
        }
        if (!this.mOutVars.containsKey(iProgramVar)) {
            this.mOutVars.put(iProgramVar, this.mManagedScript.constructFreshCopy(iProgramVar.getTermVariable()));
            this.mAssigningPaths.put(iProgramVar.getTermVariable(), new HashSet());
        }
        this.mAssigningPaths.get(iProgramVar.getTermVariable()).add(this.mCurrentPath);
    }

    private void generateTerms() {
        for (Map.Entry<IProgramVar, List<Term>> entry : this.mSymbolicMemory.entrySet()) {
            IProgramVar iProgramVar = entry.getKey();
            switch (this.mUpdateTypeMap.get(iProgramVar)) {
                case INCREMENTATION: {
                    List<Term> list = entry.getValue();
                    list.add(this.mReplaceInV.get(iProgramVar.getTermVariable()));
                    this.mIteratedSymbolicMemory.put(iProgramVar, this.mManagedScript.getScript().term("+", list.toArray(new Term[list.size()])));
                    break;
                }
                case CONSTANT: {
                    this.mIteratedSymbolicMemory.put(iProgramVar, this.generateConstantAssignment(UpdateType.CONSTANT, iProgramVar, entry.getValue()));
                    break;
                }
                case CONSTANT_WITH_SINGLE_PATHCOUNTER: {
                    Term term = entry.getValue().iterator().next();
                    int n = this.mAssigningPaths.get(entry.getKey().getTermVariable()).iterator().next();
                    boolean bl = term.getFreeVars().length > 0;
                    boolean bl2 = false;
                    TermVariable[] termVariableArray = term.getFreeVars();
                    int n2 = termVariableArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        TermVariable termVariable = termVariableArray[n3];
                        if (this.mAssigningPaths.containsKey(termVariable)) {
                            if (this.mAssigningPaths.get(termVariable).size() > 1 || !this.mAssigningPaths.get(termVariable).contains(n)) {
                                bl = false;
                            }
                            bl2 = true;
                        }
                        ++n3;
                    }
                    if (bl && bl2) {
                        this.mIteratedSymbolicMemory.put(iProgramVar, this.generateConstantAssignment(UpdateType.CONSTANT_WITH_SINGLE_PATHCOUNTER, iProgramVar, entry.getValue()));
                        break;
                    }
                    this.mUpdateTypeMap.put(iProgramVar, UpdateType.CONSTANT);
                    this.mIteratedSymbolicMemory.put(iProgramVar, this.generateConstantAssignment(UpdateType.CONSTANT, iProgramVar, entry.getValue()));
                    break;
                }
            }
        }
    }

    private Term generateConstantAssignment(UpdateType updateType, IProgramVar iProgramVar, List<Term> list) {
        Term term;
        Object object;
        if (!this.mInVars.containsKey(iProgramVar)) {
            object = this.mManagedScript.constructFreshCopy(iProgramVar.getTermVariable());
            this.mInVars.put(iProgramVar, (TermVariable)object);
            this.mReplaceInV.put((Term)iProgramVar.getTermVariable(), (Term)object);
        }
        if (updateType == UpdateType.CONSTANT) {
            object = new ArrayList();
            int n = 0;
            while (n < this.mKappas.size()) {
                if (this.mAssignedVars.get(n).contains(iProgramVar)) {
                    object.add(this.mKappa2Tau.get(this.mKappas.get(n)));
                }
                ++n;
            }
            Term term2 = object.size() > 1 ? this.mManagedScript.getScript().term("+", object.toArray(new Term[object.size()])) : (Term)object.iterator().next();
            Term term3 = this.mManagedScript.getScript().term("<", new Term[]{Rational.ZERO.toTerm(this.mManagedScript.getScript().sort("Int", new Sort[0])), term2});
            term = Util.ite((Script)this.mManagedScript.getScript(), (Term)term3, (Term)list.get(0), (Term)((Term)this.mInVars.get(iProgramVar)));
        } else if (updateType == UpdateType.CONSTANT_WITH_SINGLE_PATHCOUNTER) {
            int n = -1;
            int n2 = 0;
            while (n2 <= this.mCurrentPath) {
                if (this.mAssignedVars.get(n2).contains(iProgramVar)) {
                    n = n2;
                }
                ++n2;
            }
            Term term4 = this.mManagedScript.getScript().term(">", new Term[]{(Term)this.mKappa2Tau.get(this.mKappas.get(n)), Rational.ZERO.toTerm(this.mManagedScript.getScript().sort("Int", new Sort[0]))});
            term = Util.ite((Script)this.mManagedScript.getScript(), (Term)term4, (Term)this.mSymbolicMemory.get(iProgramVar).get(0), (Term)((Term)this.mInVars.get(iProgramVar)));
        } else {
            term = null;
        }
        return term;
    }

    private Term insertPathCounter(ApplicationTerm applicationTerm, TermVariable termVariable, TermVariable termVariable2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(termVariable);
        Term[] termArray = applicationTerm.getParameters();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            if (!term.equals(this.mReplaceInV.get(termVariable2))) {
                arrayList.add(term);
            }
            ++n2;
        }
        return this.mManagedScript.getScript().term("*", arrayList.toArray(new Term[arrayList.size()]));
    }

    private static enum UpdateType {
        UNDEFINED,
        INCREMENTATION,
        CONSTANT,
        CONSTANT_WITH_SINGLE_PATHCOUNTER;

    }
}

