/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessprinter.graphml;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.witnessprinter.graphml.GeneratedWitnessEdge;
import de.uni_freiburg.informatik.ultimate.witnessprinter.graphml.GeneratedWitnessNode;
import de.uni_freiburg.informatik.ultimate.witnessprinter.graphml.GeneratedWitnessNodeEdgeFactory;
import de.uni_freiburg.informatik.ultimate.witnessprinter.graphml.GraphMLBaseWitnessGenerator;
import de.uni_freiburg.informatik.ultimate.witnessprinter.graphml.OrderedDirectedSparseGraph;
import de.uni_freiburg.informatik.ultimate.witnessprinter.graphml.UltimateGraphMLWriter;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Hypergraph;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringEscapeUtils;

public class GraphMLViolationWitnessGenerator<TE, E>
extends GraphMLBaseWitnessGenerator<TE, E> {
    private final IProgramExecution<TE, E> mStem;
    private final IProgramExecution<TE, E> mLoop;
    private final IBacktranslationValueProvider<TE, E> mStringProvider;
    private final ILogger mLogger;
    private final String mFilename;

    public GraphMLViolationWitnessGenerator(IProgramExecution<TE, E> iProgramExecution, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        this(iProgramExecution, null, iLogger, iUltimateServiceProvider);
    }

    public GraphMLViolationWitnessGenerator(IProgramExecution<TE, E> iProgramExecution, IProgramExecution<TE, E> iProgramExecution2, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        super(iUltimateServiceProvider);
        assert (iProgramExecution != null);
        assert (iProgramExecution2 == null && iProgramExecution.getLength() > 0 || iProgramExecution2 != null && iProgramExecution2.getLength() > 0) : "Stem or loop is empty";
        this.mLogger = iLogger;
        this.mStem = iProgramExecution;
        this.mLoop = iProgramExecution2;
        this.mStringProvider = iProgramExecution.getBacktranslationValueProvider();
        this.mFilename = iProgramExecution.getLength() > 0 ? this.mStringProvider.getFileNameFromStep(this.mStem.getTraceElement(0).getStep()) : this.mStringProvider.getFileNameFromStep(this.mLoop.getTraceElement(0).getStep());
    }

    @Override
    public String makeGraphMLString() {
        UltimateGraphMLWriter ultimateGraphMLWriter = new UltimateGraphMLWriter();
        String string = StringEscapeUtils.escapeXml10((String)this.mFilename);
        ultimateGraphMLWriter.setEdgeIDs(GeneratedWitnessEdge::getName);
        ultimateGraphMLWriter.setVertexIDs(GeneratedWitnessNode::getName);
        this.addCanonicalWitnessGraphData(ultimateGraphMLWriter, "violation_witness", string);
        this.addEdgeData(ultimateGraphMLWriter, "sourcecode", null, generatedWitnessEdge -> StringEscapeUtils.escapeXml10((String)generatedWitnessEdge.getSourceCode()));
        this.addEdgeData(ultimateGraphMLWriter, "assumption", null, generatedWitnessEdge -> StringEscapeUtils.escapeXml10((String)generatedWitnessEdge.getAssumption()));
        this.addEdgeData(ultimateGraphMLWriter, "tokens", null, generatedWitnessEdge -> null);
        this.addEdgeData(ultimateGraphMLWriter, "control", null, GeneratedWitnessEdge::getControl);
        this.addEdgeData(ultimateGraphMLWriter, "startline", null, GeneratedWitnessEdge::getStartLineNumber);
        this.addEdgeData(ultimateGraphMLWriter, "endline", null, GeneratedWitnessEdge::getEndLineNumber);
        this.addEdgeData(ultimateGraphMLWriter, "originfile", string, GeneratedWitnessEdge::getOriginFileName);
        this.addEdgeData(ultimateGraphMLWriter, "enterFunction", null, GeneratedWitnessEdge::getEnterFunction);
        this.addEdgeData(ultimateGraphMLWriter, "returnFrom", null, GeneratedWitnessEdge::getReturnFunction);
        this.addEdgeData(ultimateGraphMLWriter, "enterLoopHead", "false", generatedWitnessEdge -> generatedWitnessEdge.isEnteringLoopHead());
        this.addEdgeData(ultimateGraphMLWriter, "threadId", null, generatedWitnessEdge -> generatedWitnessEdge.getThreadId());
        this.addEdgeData(ultimateGraphMLWriter, "createThread", null, generatedWitnessEdge -> generatedWitnessEdge.getCreatedThreadId());
        this.addVertexData(ultimateGraphMLWriter, "nodetype", "path", generatedWitnessNode -> null);
        this.addVertexData(ultimateGraphMLWriter, "entry", "false", generatedWitnessNode -> generatedWitnessNode.isEntry() ? "true" : null);
        this.addVertexData(ultimateGraphMLWriter, "violation", "false", generatedWitnessNode -> generatedWitnessNode.isError() ? "true" : null);
        this.addVertexData(ultimateGraphMLWriter, "cyclehead", "false", generatedWitnessNode -> generatedWitnessNode.isHonda() ? "true" : null);
        this.addVertexData(ultimateGraphMLWriter, "invariant", "true", generatedWitnessNode -> null);
        Hypergraph<GeneratedWitnessNode, GeneratedWitnessEdge<TE, E>> hypergraph = this.getGraph();
        StringWriter stringWriter = new StringWriter();
        try {
            ultimateGraphMLWriter.save(hypergraph, stringWriter);
        }
        catch (IOException iOException) {
            this.mLogger.error((Object)("Could not save witness graph: " + iOException.getMessage()));
        }
        try {
            stringWriter.flush();
            String string2 = stringWriter.toString();
            return string2;
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (IOException iOException) {
                this.mLogger.error((Object)("Could not close witness writer: " + iOException.getMessage()));
            }
        }
    }

    private Hypergraph<GeneratedWitnessNode, GeneratedWitnessEdge<TE, E>> getGraph() {
        IProgramExecution<TE, E> iProgramExecution;
        OrderedDirectedSparseGraph orderedDirectedSparseGraph = new OrderedDirectedSparseGraph();
        GeneratedWitnessNodeEdgeFactory generatedWitnessNodeEdgeFactory = new GeneratedWitnessNodeEdgeFactory(this.mStringProvider);
        IProgramExecution<TE, E> iProgramExecution2 = this.reduceProgramExecution(this.mStem);
        IProgramExecution<TE, E> iProgramExecution3 = iProgramExecution = this.mLoop == null ? null : this.reduceProgramExecution(this.mLoop);
        if (iProgramExecution == null) {
            GeneratedWitnessNode generatedWitnessNode = generatedWitnessNodeEdgeFactory.createInitialWitnessNode();
            orderedDirectedSparseGraph.addVertex(generatedWitnessNode);
            Supplier<GeneratedWitnessNode> supplier = () -> generatedWitnessNodeEdgeFactory.createErrorWitnessNode();
            this.addProgramExecution(orderedDirectedSparseGraph, generatedWitnessNodeEdgeFactory, generatedWitnessNode, iProgramExecution2, supplier);
        } else if (iProgramExecution2.getLength() > 0) {
            GeneratedWitnessNode generatedWitnessNode = generatedWitnessNodeEdgeFactory.createHondaWitnessNode();
            Supplier<GeneratedWitnessNode> supplier = () -> generatedWitnessNode;
            GeneratedWitnessNode generatedWitnessNode2 = generatedWitnessNodeEdgeFactory.createInitialWitnessNode();
            orderedDirectedSparseGraph.addVertex(generatedWitnessNode2);
            this.addProgramExecution(orderedDirectedSparseGraph, generatedWitnessNodeEdgeFactory, generatedWitnessNode2, iProgramExecution2, supplier);
            this.addProgramExecution(orderedDirectedSparseGraph, generatedWitnessNodeEdgeFactory, generatedWitnessNode, iProgramExecution, supplier);
        } else {
            GeneratedWitnessNode generatedWitnessNode = generatedWitnessNodeEdgeFactory.createWitnessNode(true, false, false, true);
            orderedDirectedSparseGraph.addVertex(generatedWitnessNode);
            Supplier<GeneratedWitnessNode> supplier = () -> generatedWitnessNode;
            this.addProgramExecution(orderedDirectedSparseGraph, generatedWitnessNodeEdgeFactory, generatedWitnessNode, iProgramExecution, supplier);
        }
        return orderedDirectedSparseGraph;
    }

    private void addProgramExecution(DirectedSparseGraph<GeneratedWitnessNode, GeneratedWitnessEdge<TE, E>> directedSparseGraph, GeneratedWitnessNodeEdgeFactory<TE, E> generatedWitnessNodeEdgeFactory, GeneratedWitnessNode generatedWitnessNode, IProgramExecution<TE, E> iProgramExecution, Supplier<GeneratedWitnessNode> supplier) {
        int n = iProgramExecution.getLength();
        int n2 = 0;
        while (n2 < n) {
            AtomicTraceElement atomicTraceElement = iProgramExecution.getTraceElement(n2);
            IProgramExecution.ProgramState programState = iProgramExecution.getProgramState(n2);
            GeneratedWitnessNode generatedWitnessNode2 = n2 == n - 1 ? supplier.get() : generatedWitnessNodeEdgeFactory.createWitnessNode();
            directedSparseGraph.addVertex((Object)generatedWitnessNode2);
            directedSparseGraph.addEdge(generatedWitnessNodeEdgeFactory.createWitnessEdge(atomicTraceElement, programState, generatedWitnessNode2.isHonda()), (Object)generatedWitnessNode, (Object)generatedWitnessNode2);
            generatedWitnessNode = generatedWitnessNode2;
            ++n2;
        }
    }

    private IProgramExecution<TE, E> reduceProgramExecution(IProgramExecution<TE, E> iProgramExecution) {
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        hashMap.put(-1, iProgramExecution.getInitialProgramState());
        int n = iProgramExecution.getLength();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3;
            AtomicTraceElement atomicTraceElement = iProgramExecution.getTraceElement(n3);
            AtomicTraceElement.AtomicTraceElementBuilder atomicTraceElementBuilder = AtomicTraceElement.AtomicTraceElementBuilder.from((AtomicTraceElement)atomicTraceElement);
            int n5 = n3 + 1;
            while (n5 < n) {
                AtomicTraceElement atomicTraceElement2 = iProgramExecution.getTraceElement(n5);
                if (this.mStringProvider.getStartLineNumberFromStep(atomicTraceElement.getTraceElement()) != this.mStringProvider.getStartLineNumberFromStep(atomicTraceElement2.getTraceElement())) {
                    n3 = n5;
                    break;
                }
                this.update(atomicTraceElementBuilder, atomicTraceElement, atomicTraceElement2);
                ++n5;
            }
            hashMap.put(n2, iProgramExecution.getProgramState(n3));
            ++n2;
            arrayList.add(atomicTraceElementBuilder.build());
            if (n4 == n3) break;
        }
        return new ReducedProgramExecution<TE, E>(iProgramExecution, arrayList, hashMap);
    }

    private void update(AtomicTraceElement.AtomicTraceElementBuilder<TE> atomicTraceElementBuilder, AtomicTraceElement<TE> atomicTraceElement, AtomicTraceElement<TE> atomicTraceElement2) {
        atomicTraceElementBuilder.setElement(atomicTraceElement2.getTraceElement());
        atomicTraceElementBuilder.setStep(atomicTraceElement2.getStep());
        for (AtomicTraceElement.StepInfo stepInfo : atomicTraceElement2.getStepInfo()) {
            if (stepInfo == AtomicTraceElement.StepInfo.NONE) continue;
            atomicTraceElementBuilder.addStepInfo(new AtomicTraceElement.StepInfo[]{stepInfo});
        }
        atomicTraceElementBuilder.setRelevanceInformation(atomicTraceElement2.getRelevanceInformation());
        atomicTraceElementBuilder.setProcedures(atomicTraceElement.getPrecedingProcedure(), atomicTraceElement2.getSucceedingProcedure());
        if (atomicTraceElement2.hasThreadId()) {
            atomicTraceElementBuilder.setThreadId(atomicTraceElement2.getThreadId());
        }
        if (atomicTraceElement2.hasStepInfo(AtomicTraceElement.StepInfo.FORK)) {
            atomicTraceElementBuilder.setForkedThreadId(atomicTraceElement2.getForkedThreadId());
        }
        if (atomicTraceElement2.hasAnyStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.JOIN})) {
            atomicTraceElementBuilder.setJoinedThreadId(atomicTraceElement2.getJoinedThreadId());
        }
    }

    private static final class ReducedProgramExecution<TE, E>
    implements IProgramExecution<TE, E> {
        private final List<AtomicTraceElement<TE>> mTrace;
        private final Map<Integer, IProgramExecution.ProgramState<E>> mPartialProgramStateMapping;
        private final IProgramExecution<TE, E> mOriginalProgramExecution;

        public ReducedProgramExecution(IProgramExecution<TE, E> iProgramExecution, List<AtomicTraceElement<TE>> list, Map<Integer, IProgramExecution.ProgramState<E>> map) {
            this.mOriginalProgramExecution = iProgramExecution;
            this.mTrace = list;
            this.mPartialProgramStateMapping = map;
        }

        public int getLength() {
            return this.mTrace.size();
        }

        public AtomicTraceElement<TE> getTraceElement(int n) {
            return this.mTrace.get(n);
        }

        public IProgramExecution.ProgramState<E> getProgramState(int n) {
            if (n < 0 || n >= this.mTrace.size()) {
                throw new IllegalArgumentException("out of range");
            }
            return this.mPartialProgramStateMapping.get(n);
        }

        public IProgramExecution.ProgramState<E> getInitialProgramState() {
            return this.mPartialProgramStateMapping.get(-1);
        }

        public Class<E> getExpressionClass() {
            return this.mOriginalProgramExecution.getExpressionClass();
        }

        public Class<? extends TE> getTraceElementClass() {
            return this.mOriginalProgramExecution.getTraceElementClass();
        }

        public IBacktranslationValueProvider<TE, E> getBacktranslationValueProvider() {
            return this.mOriginalProgramExecution.getBacktranslationValueProvider();
        }

        public boolean isConcurrent() {
            return this.mOriginalProgramExecution.isConcurrent();
        }
    }
}

