/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class FastUPRDetection<INLOC extends IcfgLocation> {
    private final ILogger mLogger;
    private final List<INLOC> mLoopHeads;

    public FastUPRDetection(ILogger iLogger, IIcfg<INLOC> iIcfg) {
        IIcfg<INLOC> iIcfg2 = Objects.requireNonNull(iIcfg);
        this.mLogger = Objects.requireNonNull(iLogger);
        this.mLoopHeads = this.getLoopHeads(iIcfg2);
    }

    public List<Deque<IcfgEdge>> getLoopEdgePaths() {
        ArrayList<Deque<IcfgEdge>> arrayList = new ArrayList<Deque<IcfgEdge>>();
        for (IcfgLocation icfgLocation : this.mLoopHeads) {
            arrayList.add(this.getPathEdges(icfgLocation));
        }
        return arrayList;
    }

    public Map<INLOC, Deque<IcfgEdge>> getLoopEdgePathsWithLoopHead() {
        HashMap<IcfgLocation, Deque<IcfgEdge>> hashMap = new HashMap<IcfgLocation, Deque<IcfgEdge>>();
        for (IcfgLocation icfgLocation : this.mLoopHeads) {
            hashMap.put(icfgLocation, this.getPathEdges(icfgLocation));
        }
        return hashMap;
    }

    List<Deque<INLOC>> getLoopPaths() {
        ArrayList<Deque<INLOC>> arrayList = new ArrayList<Deque<INLOC>>();
        for (IcfgLocation icfgLocation : this.mLoopHeads) {
            arrayList.add(this.getPathLocs(icfgLocation));
        }
        return arrayList;
    }

    private List<INLOC> getLoopHeads(IIcfg<INLOC> iIcfg) {
        ArrayList<IcfgLocation> arrayList = new ArrayList<IcfgLocation>();
        Set set = iIcfg.getInitialNodes();
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        HashSet<IcfgEdge> hashSet2 = new HashSet<IcfgEdge>();
        ArrayDeque<IcfgLocation> arrayDeque = new ArrayDeque<IcfgLocation>(set);
        while (!arrayDeque.isEmpty()) {
            IcfgLocation icfgLocation = (IcfgLocation)arrayDeque.removeFirst();
            hashSet.add(icfgLocation);
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                if (!hashSet2.add(icfgEdge)) continue;
                IcfgLocation icfgLocation2 = (IcfgLocation)icfgEdge.getTarget();
                this.mLogger.debug((Object)("Current target:" + icfgLocation2.toString()));
                if (hashSet.contains(icfgLocation2)) {
                    arrayList.add(icfgLocation2);
                    this.mLogger.debug((Object)("Loop head:" + icfgLocation2.toString()));
                    continue;
                }
                arrayDeque.addLast(icfgLocation2);
            }
        }
        return arrayList;
    }

    private Deque<INLOC> getPathLocs(INLOC INLOC) {
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        ArrayDeque<Integer> arrayDeque2 = new ArrayDeque<Integer>();
        arrayDeque.addLast(INLOC);
        arrayDeque2.addLast(0);
        while (!arrayDeque.isEmpty()) {
            if (((IcfgLocation)arrayDeque.getLast()).getOutgoingEdges().size() > (Integer)arrayDeque2.getLast()) {
                IcfgLocation icfgLocation = (IcfgLocation)((IcfgEdge)((IcfgLocation)arrayDeque.getLast()).getOutgoingEdges().get((Integer)arrayDeque2.getLast())).getTarget();
                int n = (Integer)arrayDeque2.removeLast();
                arrayDeque2.addLast(n + 1);
                arrayDeque2.addLast(0);
                arrayDeque.addLast(icfgLocation);
                if (!icfgLocation.equals(INLOC)) continue;
                this.mLogger.debug((Object)"Found Loop Head again!");
                return arrayDeque;
            }
            arrayDeque2.removeLast();
            arrayDeque.removeLast();
        }
        return new ArrayDeque();
    }

    private Deque<IcfgEdge> getPathEdges(INLOC INLOC) {
        HashMap<IcfgEdge, IcfgEdge> hashMap = new HashMap<IcfgEdge, IcfgEdge>();
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        ArrayDeque<IcfgEdge> arrayDeque = new ArrayDeque<IcfgEdge>(INLOC.getOutgoingEdges());
        while (!arrayDeque.isEmpty()) {
            IcfgEdge icfgEdge = (IcfgEdge)arrayDeque.pop();
            if (((IcfgLocation)icfgEdge.getTarget()).equals(INLOC)) {
                return FastUPRDetection.calculatePathEdges(icfgEdge, hashMap);
            }
            if (!hashSet.add(icfgEdge)) continue;
            for (IcfgEdge icfgEdge2 : ((IcfgLocation)icfgEdge.getTarget()).getOutgoingEdges()) {
                if (icfgEdge.equals(icfgEdge2)) continue;
                hashMap.put(icfgEdge2, icfgEdge);
                arrayDeque.add(icfgEdge2);
            }
        }
        return new ArrayDeque<IcfgEdge>();
    }

    private static Deque<IcfgEdge> calculatePathEdges(IcfgEdge icfgEdge, Map<IcfgEdge, IcfgEdge> map) {
        ArrayDeque<IcfgEdge> arrayDeque = new ArrayDeque<IcfgEdge>();
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        IcfgEdge icfgEdge2 = icfgEdge;
        hashSet.add(icfgEdge2);
        arrayDeque.add(icfgEdge2);
        while (map.containsKey(icfgEdge2)) {
            if (!hashSet.contains(icfgEdge2 = map.get(icfgEdge2))) {
                arrayDeque.addFirst(icfgEdge2);
                hashSet.add(icfgEdge2);
                continue;
            }
            return arrayDeque;
        }
        return arrayDeque;
    }

    public List<INLOC> getLoopHeads() {
        return this.mLoopHeads;
    }
}

