/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.boogie.BoogieProgramExecution;
import de.uni_freiburg.informatik.ultimate.boogie.BoogieTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.ACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.FlatSymbolTable;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.IMemoryPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryPointer1D;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryPointer2D;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.core.lib.models.Multigraph;
import de.uni_freiburg.informatik.ultimate.core.lib.models.MultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ConditionAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.results.GenericResult;
import de.uni_freiburg.informatik.ultimate.core.lib.translation.DefaultTranslator;
import de.uni_freiburg.informatik.ultimate.core.lib.translation.ProgramExecutionFormatter;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.ProcedureContract;
import de.uni_freiburg.informatik.ultimate.core.model.results.IRelevanceInformation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.BacktranslatedACSLValue;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.BacktranslationPointer1D;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.BacktranslationPointer2D;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.Boogie2ACSL;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.CACSL2BoogieBacktranslatorMapping;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.CACSLBacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.CACSLBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.CACSLProgramExecution;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.FakeExpression;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTDoStatement;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTForStatement;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTFunctionCallExpression;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTIfStatement;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTWhileStatement;

public class CACSL2BoogieBacktranslator
extends DefaultTranslator<BoogieASTNode, CACSLLocation, Expression, BacktranslatedACSLValue, String, String, ILocation> {
    private static final boolean DEBUG_ERROR_FOR_UNFINISHED_BACKTRANSLATION = false;
    private static final String UNFINISHED_BACKTRANSLATION = "Unfinished Backtranslation";
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final LocationFactory mLocationFactory;
    private final CACSL2BoogieBacktranslatorMapping mMapping;
    private boolean mGenerateBacktranslationWarnings;
    private boolean mBacktranslationWarned;
    private final Boogie2ACSL mBoogie2ACSL;
    private final IBacktranslationPointer mBacktranslationPointer;

    public CACSL2BoogieBacktranslator(IUltimateServiceProvider iUltimateServiceProvider, TypeSizes typeSizes, CACSL2BoogieBacktranslatorMapping cACSL2BoogieBacktranslatorMapping, LocationFactory locationFactory, FlatSymbolTable flatSymbolTable, IMemoryPointer iMemoryPointer) {
        super(BoogieASTNode.class, CACSLLocation.class, Expression.class, BacktranslatedACSLValue.class);
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mMapping = cACSL2BoogieBacktranslatorMapping;
        this.mGenerateBacktranslationWarnings = true;
        this.mBacktranslationWarned = false;
        this.mLocationFactory = locationFactory;
        if (iMemoryPointer instanceof MemoryPointer1D) {
            this.mBacktranslationPointer = new BacktranslationPointer1D(this);
        } else if (iMemoryPointer instanceof MemoryPointer2D) {
            this.mBacktranslationPointer = new BacktranslationPointer2D(this);
        } else {
            throw new UnsupportedOperationException("Unknown pointer type: " + String.valueOf(iMemoryPointer.getClass()));
        }
        this.mBoogie2ACSL = new Boogie2ACSL(typeSizes, cACSL2BoogieBacktranslatorMapping, flatSymbolTable, this::reportUnfinishedBacktranslation);
    }

    public List<CACSLLocation> translateTrace(List<BoogieASTNode> list) {
        List list2 = list.stream().map(boogieASTNode -> new AtomicTraceElement.AtomicTraceElementBuilder().setToStringFunc(BoogiePrettyPrinter.getBoogieToStringProvider()).setStepAndElement(boogieASTNode).build()).collect(Collectors.toList());
        BoogieProgramExecution boogieProgramExecution = new BoogieProgramExecution(Collections.emptyMap(), list2, false);
        IProgramExecution<CACSLLocation, BacktranslatedACSLValue> iProgramExecution = this.translateProgramExecution((IProgramExecution<BoogieASTNode, Expression>)boogieProgramExecution);
        ArrayList<CACSLLocation> arrayList = new ArrayList<CACSLLocation>();
        int n = 0;
        while (n < iProgramExecution.getLength()) {
            AtomicTraceElement atomicTraceElement = iProgramExecution.getTraceElement(n);
            arrayList.add((CACSLLocation)((Object)atomicTraceElement.getStep()));
            ++n;
        }
        return arrayList;
    }

    public IProgramExecution<CACSLLocation, BacktranslatedACSLValue> translateProgramExecution(IProgramExecution<BoogieASTNode, Expression> iProgramExecution) {
        assert (this.checkCallStackSourceProgramExecution(this.mLogger, iProgramExecution)) : "callstack of initial program execution already broken";
        CACSLProgramExecution cACSLProgramExecution = this.translateProgramExecutionInternal(iProgramExecution);
        assert (this.checkCallStackTargetProgramExecution(this.mLogger, cACSLProgramExecution)) : "callstack broken after subtree inclusion reduction";
        return cACSLProgramExecution;
    }

    public IBacktranslationService.Lasso<IProgramExecution<CACSLLocation, BacktranslatedACSLValue>> translateLassoProgramExecution(IBacktranslationService.Lasso<IProgramExecution<BoogieASTNode, Expression>> lasso) {
        assert (this.checkCallStackSourceLassoProgramExecution(this.mLogger, lasso)) : "callstack of initial program execution already broken";
        IBacktranslationService.Lasso lasso2 = new IBacktranslationService.Lasso(this.translateProgramExecution((IProgramExecution<BoogieASTNode, Expression>)lasso.stem()), this.translateProgramExecution((IProgramExecution<BoogieASTNode, Expression>)lasso.loop()));
        assert (this.checkCallStackTargetLassoProgramExecution(this.mLogger, lasso2)) : "callstack broken after subtree inclusion reduction";
        return lasso2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private CACSLProgramExecution translateProgramExecutionInternal(IProgramExecution<BoogieASTNode, Expression> var1_1) {
        var2_2 = this.translateProgramState((IProgramExecution.ProgramState<Expression>)var1_1.getInitialProgramState());
        var3_3 = new ArrayList<AtomicTraceElement<CACSLLocation>>();
        var4_4 = new ArrayList<IProgramExecution.ProgramState<BacktranslatedACSLValue>>();
        var5_5 = 0;
        while (var5_5 < var1_1.getLength()) {
            block15: {
                block14: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                var6_7 = var1_1.getTraceElement(var5_5);
                                                var7_8 /* !! */  = ((BoogieASTNode)var6_7.getTraceElement()).getLocation();
                                                if (!(var7_8 /* !! */  instanceof CLocation)) break block14;
                                                var9_10 = (CLocation)var7_8 /* !! */ ;
                                                if (var9_10.ignoreDuringBacktranslation()) break block15;
                                                var10_11 = var9_10.getNode();
                                                if (var10_11 != null) break block16;
                                                this.reportUnfinishedBacktranslation("Skipping invalid CLocation because IASTNode is null");
                                                break block15;
                                            }
                                            if (!(var10_11 instanceof CASTTranslationUnit)) break block17;
                                            var5_5 = CACSL2BoogieBacktranslator.findMergeSequence(var1_1, var5_5, var7_8 /* !! */ );
                                            if (var10_11 instanceof CASTTranslationUnit) {
                                                if (!var3_3.isEmpty()) {
                                                    var4_4.remove(var4_4.size() - 1);
                                                    var4_4.add(this.translateProgramState((IProgramExecution.ProgramState<Expression>)var1_1.getProgramState(var5_5)));
                                                } else {
                                                    var2_2 = this.translateProgramState((IProgramExecution.ProgramState<Expression>)var1_1.getProgramState(var5_5));
                                                }
                                            }
                                            break block15;
                                        }
                                        if (!(var10_11 instanceof CASTIfStatement)) break block18;
                                        var11_12 = (CASTIfStatement)var10_11;
                                        var8_9 = AtomicTraceElement.AtomicTraceElementBuilder.fromReplaceElementAndStep((AtomicTraceElement)var6_7, (Object)var9_10).setStep((Object)this.mLocationFactory.createCLocation((IASTNode)var11_12.getConditionExpression())).build();
                                        ** GOTO lbl60
                                    }
                                    if (!(var10_11 instanceof CASTWhileStatement)) break block19;
                                    var8_9 = this.handleLoopConditional((AtomicTraceElement<BoogieASTNode>)var6_7, var9_10, ((CASTWhileStatement)var10_11).getCondition());
                                    ** GOTO lbl60
                                }
                                if (!(var10_11 instanceof CASTDoStatement)) break block20;
                                var8_9 = this.handleLoopConditional((AtomicTraceElement<BoogieASTNode>)var6_7, var9_10, ((CASTDoStatement)var10_11).getCondition());
                                ** GOTO lbl60
                            }
                            if (!(var10_11 instanceof CASTForStatement)) break block21;
                            var8_9 = this.handleLoopConditional((AtomicTraceElement<BoogieASTNode>)var6_7, var9_10, ((CASTForStatement)var10_11).getConditionExpression());
                            ** GOTO lbl60
                        }
                        if (!(var10_11 instanceof CASTFunctionCallExpression)) break block22;
                        var5_5 = this.handleCASTFunctionCallExpression(var1_1, var5_5, (CASTFunctionCallExpression)var10_11, var9_10, var3_3, var4_4);
                        if (!CACSL2BoogieBacktranslator.$assertionsDisabled && var3_3.size() != var4_4.size()) {
                            throw new AssertionError();
                        }
                        break block15;
                    }
                    var5_5 = CACSL2BoogieBacktranslator.findMergeSequence(var1_1, var5_5, var7_8 /* !! */ );
                    if (var6_7.getTraceElement() instanceof HavocStatement && this.checkTempHavoc((AtomicTraceElement<BoogieASTNode>)var6_7)) break block15;
                    var8_9 = AtomicTraceElement.AtomicTraceElementBuilder.fromReplaceElementAndStep((AtomicTraceElement)var6_7, (Object)var9_10).setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.NONE}).build();
                    ** GOTO lbl60
                }
                if (!(var7_8 /* !! */  instanceof ACSLLocation)) {
                    this.reportUnfinishedBacktranslation("Invalid location (Location is no CACSLLocation)");
                } else {
                    var8_9 = AtomicTraceElement.AtomicTraceElementBuilder.fromReplaceElementAndStep((AtomicTraceElement)var6_7, (Object)((CACSLLocation)var7_8 /* !! */ )).build();
lbl60:
                    // 6 sources

                    if (var8_9 != null) {
                        if (!CACSL2BoogieBacktranslator.$assertionsDisabled && !this.checkProcedureNames((AtomicTraceElement)var6_7, var8_9)) {
                            throw new AssertionError((Object)"callstack is broken");
                        }
                        var3_3.add((AtomicTraceElement<CACSLLocation>)var8_9);
                        var4_4.add(this.translateProgramState((IProgramExecution.ProgramState<Expression>)var1_1.getProgramState(var5_5)));
                    }
                    if (!CACSL2BoogieBacktranslator.$assertionsDisabled && var3_3.size() != var4_4.size()) {
                        throw new AssertionError();
                    }
                }
            }
            ++var5_5;
        }
        if (!CACSL2BoogieBacktranslator.$assertionsDisabled && !this.checkCallStackTarget(this.mLogger, var3_3)) {
            throw new AssertionError((Object)"callstack broken after initial translation");
        }
        var5_6 = var3_3.iterator();
        var6_7 = var4_4.iterator();
        while (var5_6.hasNext()) {
            var7_8 /* !! */  = (CACSLLocation)((AtomicTraceElement)var5_6.next()).getStep();
            var8_9 = (IProgramExecution.ProgramState)var6_7.next();
            if (!(var7_8 /* !! */  instanceof CLocation) || (var9_10 = ((CLocation)var7_8 /* !! */ ).getNode()) != null) continue;
            this.mLogger.warn((Object)("Removing null node from list of ATEs: ATE " + String.valueOf(var7_8 /* !! */ ) + " program state " + String.valueOf(var8_9)));
            var5_6.remove();
            var6_7.remove();
            if (!CACSL2BoogieBacktranslator.$assertionsDisabled && !this.checkCallStackTarget(this.mLogger, var3_3)) {
                throw new AssertionError((Object)("callstack broken after removal of " + String.valueOf((Object)var9_10)));
            }
        }
        var7_8 /* !! */  = CACSL2BoogieBacktranslator.checkForSubtreeInclusion(var3_3);
        if (this.mBacktranslationWarned) {
            this.reportUnfinishedBacktranslation("The program execution was not completely translated back.");
        }
        return new CACSLProgramExecution(var2_2, (Collection<AtomicTraceElement<CACSLLocation>>)var7_8 /* !! */ , var4_4, var1_1.isConcurrent());
    }

    private boolean checkTempHavoc(AtomicTraceElement<BoogieASTNode> atomicTraceElement) {
        HavocStatement havocStatement = (HavocStatement)atomicTraceElement.getTraceElement();
        CheckForTempVars checkForTempVars = new CheckForTempVars();
        checkForTempVars.processStatement((Statement)havocStatement);
        return checkForTempVars.areAllTemp();
    }

    private AtomicTraceElement<CACSLLocation> handleLoopConditional(AtomicTraceElement<BoogieASTNode> atomicTraceElement, CACSLLocation cACSLLocation, IASTExpression iASTExpression) {
        if (!atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE) && !atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE)) {
            this.reportUnfinishedBacktranslation("Expected StepInfo for loop construct to contain Condition, but it did not");
            return null;
        }
        CACSLLocation cACSLLocation2 = this.mLocationFactory.createCLocation((IASTNode)iASTExpression);
        AtomicTraceElement.AtomicTraceElementBuilder atomicTraceElementBuilder = new AtomicTraceElement.AtomicTraceElementBuilder();
        if (atomicTraceElement.hasThreadId()) {
            atomicTraceElementBuilder.setThreadId(atomicTraceElement.getThreadId());
        }
        atomicTraceElementBuilder.setRelevanceInformation(atomicTraceElement.getRelevanceInformation()).setElement((Object)cACSLLocation).setStep((Object)cACSLLocation2).setStepInfo(atomicTraceElement.getStepInfo()).setProcedures(atomicTraceElement.getPrecedingProcedure(), atomicTraceElement.getSucceedingProcedure());
        return atomicTraceElementBuilder.build();
    }

    private int handleCASTFunctionCallExpression(IProgramExecution<BoogieASTNode, Expression> iProgramExecution, int n, CASTFunctionCallExpression cASTFunctionCallExpression, CLocation cLocation, List<AtomicTraceElement<CACSLLocation>> list, List<IProgramExecution.ProgramState<BacktranslatedACSLValue>> list2) {
        AtomicTraceElement atomicTraceElement;
        int n2;
        AtomicTraceElement atomicTraceElement2 = iProgramExecution.getTraceElement(n);
        BoogieASTNode boogieASTNode = (BoogieASTNode)atomicTraceElement2.getTraceElement();
        if (!(boogieASTNode instanceof CallStatement)) {
            return this.handleNonCallDuringCASTFunctionCallExpression(iProgramExecution, n, cLocation, list, list2, (AtomicTraceElement<BoogieASTNode>)atomicTraceElement2, boogieASTNode);
        }
        if (atomicTraceElement2.hasStepInfo(AtomicTraceElement.StepInfo.NONE)) {
            return n;
        }
        if (atomicTraceElement2.hasStepInfo(AtomicTraceElement.StepInfo.FUNC_CALL)) {
            return n;
        }
        if (atomicTraceElement2.hasStepInfo(AtomicTraceElement.StepInfo.PROC_CALL) && (n2 = CACSL2BoogieBacktranslator.getNextValidIndex(iProgramExecution, n + 1)) != -1 && (atomicTraceElement = iProgramExecution.getTraceElement(n2)).hasStepInfo(AtomicTraceElement.StepInfo.PROC_RETURN) && CACSL2BoogieBacktranslator.haveSameThreadId(atomicTraceElement2, atomicTraceElement)) {
            assert (!atomicTraceElement2.hasStepInfo(AtomicTraceElement.StepInfo.FORK) && !atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.FORK));
            AtomicTraceElement.AtomicTraceElementBuilder atomicTraceElementBuilder = new AtomicTraceElement.AtomicTraceElementBuilder();
            atomicTraceElementBuilder.addStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.FUNC_CALL});
            atomicTraceElementBuilder.setRelevanceInformation(CACSL2BoogieBacktranslator.getCombinedRelevanceInfo((AtomicTraceElement<BoogieASTNode>)atomicTraceElement2, (AtomicTraceElement<BoogieASTNode>)atomicTraceElement));
            atomicTraceElementBuilder.setStepAndElement((Object)cLocation);
            atomicTraceElementBuilder.setProcedures(atomicTraceElement2.getPrecedingProcedure(), atomicTraceElement.getSucceedingProcedure());
            if (atomicTraceElement2.hasThreadId()) {
                atomicTraceElementBuilder.setThreadId(atomicTraceElement2.getThreadId());
            }
            list.add((AtomicTraceElement<CACSLLocation>)atomicTraceElementBuilder.build());
            list2.add(this.translateProgramState((IProgramExecution.ProgramState<Expression>)iProgramExecution.getProgramState(n2)));
            assert (this.checkCallStackTarget(this.mLogger, list)) : "callstack broken during handleCASTFunctionCallExpression";
            return n2;
        }
        list.add((AtomicTraceElement<CACSLLocation>)AtomicTraceElement.AtomicTraceElementBuilder.fromReplaceElementAndStep((AtomicTraceElement)atomicTraceElement2, (Object)((Object)cLocation)).build());
        list2.add(this.translateProgramState((IProgramExecution.ProgramState<Expression>)iProgramExecution.getProgramState(n)));
        assert (this.checkCallStackTarget(this.mLogger, list)) : "callstack broken during handleCASTFunctionCallExpression";
        return n;
    }

    private int handleNonCallDuringCASTFunctionCallExpression(IProgramExecution<BoogieASTNode, Expression> iProgramExecution, int n, CLocation cLocation, List<AtomicTraceElement<CACSLLocation>> list, List<IProgramExecution.ProgramState<BacktranslatedACSLValue>> list2, AtomicTraceElement<BoogieASTNode> atomicTraceElement, BoogieASTNode boogieASTNode) {
        EnumSet<AtomicTraceElement.StepInfo> enumSet;
        if (boogieASTNode instanceof AssertStatement) {
            enumSet = atomicTraceElement.getStepInfo();
        } else if (boogieASTNode instanceof HavocStatement) {
            if (this.checkTempHavoc(atomicTraceElement)) {
                return n;
            }
            enumSet = atomicTraceElement.getStepInfo();
        } else if (boogieASTNode instanceof ForkStatement) {
            enumSet = EnumSet.copyOf(atomicTraceElement.getStepInfo());
            enumSet.add(AtomicTraceElement.StepInfo.FORK);
            enumSet.add(AtomicTraceElement.StepInfo.FUNC_CALL);
        } else if (boogieASTNode instanceof JoinStatement) {
            enumSet = EnumSet.copyOf(atomicTraceElement.getStepInfo());
            enumSet.add(AtomicTraceElement.StepInfo.JOIN);
            enumSet.add(AtomicTraceElement.StepInfo.FUNC_CALL);
        } else {
            return n;
        }
        list.add((AtomicTraceElement<CACSLLocation>)AtomicTraceElement.AtomicTraceElementBuilder.fromReplaceElementAndStep(atomicTraceElement, (Object)((Object)cLocation), (Object)((Object)cLocation)).setStepInfo(enumSet).build());
        list2.add(this.translateProgramState((IProgramExecution.ProgramState<Expression>)iProgramExecution.getProgramState(n)));
        assert (this.checkCallStackTarget(this.mLogger, list)) : "callstack broken during handleCASTFunctionCallExpression";
        return n;
    }

    private static boolean haveSameThreadId(AtomicTraceElement<?> ... atomicTraceElementArray) {
        if (atomicTraceElementArray == null || atomicTraceElementArray.length < 2) {
            return true;
        }
        int n = 0;
        AtomicTraceElement<?>[] atomicTraceElementArray2 = atomicTraceElementArray;
        int n2 = atomicTraceElementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            AtomicTraceElement<?> atomicTraceElement = atomicTraceElementArray2[n3];
            if (atomicTraceElement.hasThreadId()) {
                ++n;
            }
            ++n3;
        }
        if (n == 0) {
            return true;
        }
        if (n != atomicTraceElementArray.length) {
            throw new AssertionError((Object)"Mixed AtomicTraceElements");
        }
        int n4 = atomicTraceElementArray[0].getThreadId();
        AtomicTraceElement<?>[] atomicTraceElementArray3 = atomicTraceElementArray;
        int n5 = atomicTraceElementArray.length;
        n2 = 0;
        while (n2 < n5) {
            AtomicTraceElement<?> atomicTraceElement = atomicTraceElementArray3[n2];
            if (n4 != atomicTraceElement.getThreadId()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static int getNextValidIndex(IProgramExecution<BoogieASTNode, Expression> iProgramExecution, int n) {
        int n2 = n;
        while (n2 < iProgramExecution.getLength()) {
            AtomicTraceElement atomicTraceElement = iProgramExecution.getTraceElement(n2);
            ILocation iLocation = ((BoogieASTNode)atomicTraceElement.getTraceElement()).getLocation();
            if (!(iLocation instanceof CLocation)) {
                return n2;
            }
            CLocation cLocation = (CLocation)iLocation;
            if (!cLocation.ignoreDuringBacktranslation() && !(cLocation.getNode() instanceof CASTTranslationUnit)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private static IRelevanceInformation getCombinedRelevanceInfo(AtomicTraceElement<BoogieASTNode> atomicTraceElement, AtomicTraceElement<BoogieASTNode> atomicTraceElement2) {
        IRelevanceInformation iRelevanceInformation = atomicTraceElement.getRelevanceInformation();
        IRelevanceInformation iRelevanceInformation2 = atomicTraceElement2.getRelevanceInformation();
        if (iRelevanceInformation == null) {
            return iRelevanceInformation2;
        }
        if (iRelevanceInformation2 == null) {
            return iRelevanceInformation;
        }
        return iRelevanceInformation.merge(new IRelevanceInformation[]{iRelevanceInformation2});
    }

    private static int findMergeSequence(IProgramExecution<BoogieASTNode, Expression> iProgramExecution, int n, ILocation iLocation) {
        if (n >= iProgramExecution.getLength() || n < 0) {
            throw new IllegalArgumentException("i has an invalid value");
        }
        int n2 = n;
        while (n2 < iProgramExecution.getLength()) {
            AtomicTraceElement atomicTraceElement = iProgramExecution.getTraceElement(n2);
            if (!iLocation.equals(((BoogieASTNode)atomicTraceElement.getTraceElement()).getLocation())) {
                --n2;
                break;
            }
            ++n2;
        }
        if (n2 < iProgramExecution.getLength()) {
            return n2;
        }
        return iProgramExecution.getLength() - 1;
    }

    public IProgramExecution.ProgramState<BacktranslatedACSLValue> translateProgramState(IProgramExecution.ProgramState<Expression> programState) {
        if (programState == null) {
            return null;
        }
        Map<Expression, Collection<IExpressionOrPointer>> map = this.compressProgramState(programState);
        boolean bl = this.mGenerateBacktranslationWarnings;
        boolean bl2 = this.mBacktranslationWarned;
        this.mGenerateBacktranslationWarnings = false;
        HashMap<BacktranslatedACSLValue, Collection<BacktranslatedACSLValue>> hashMap = new HashMap<BacktranslatedACSLValue, Collection<BacktranslatedACSLValue>>();
        for (Map.Entry<Expression, Collection<IExpressionOrPointer>> entry : map.entrySet()) {
            this.translateProgramStateEntry(entry, hashMap);
        }
        this.mGenerateBacktranslationWarnings = bl;
        this.mBacktranslationWarned = bl2;
        return new IProgramExecution.ProgramState(hashMap, BacktranslatedACSLValue.class);
    }

    private void translateProgramStateEntry(Map.Entry<Expression, Collection<IExpressionOrPointer>> entry, Map<BacktranslatedACSLValue, Collection<BacktranslatedACSLValue>> map) {
        Collection collection;
        BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression = this.translateExpression(entry.getKey());
        if (backtranslatedExpression == null) {
            return;
        }
        ArrayList<BacktranslatedACSLValue> arrayList = new ArrayList<BacktranslatedACSLValue>();
        for (IExpressionOrPointer object2 : entry.getValue()) {
            BacktranslatedACSLValue backtranslatedACSLValue = this.translateExpressionForProgramState(object2);
            if (backtranslatedACSLValue == null) continue;
            arrayList.add(backtranslatedACSLValue);
        }
        if (!arrayList.isEmpty() && (collection = (Collection)map.put(backtranslatedExpression, arrayList)) != null) {
            arrayList.addAll(collection);
        }
    }

    private Map<Expression, Collection<IExpressionOrPointer>> compressProgramState(IProgramExecution.ProgramState<Expression> programState) {
        Object object;
        Pair pair;
        Object object22;
        ArrayList<Pair<Expression, Collection<Expression>>> arrayList = new ArrayList<Pair<Expression, Collection<Expression>>>();
        for (Object object22 : programState.getVariables()) {
            pair = new Pair(object22, (Object)programState.getValues(object22));
            arrayList.add((Pair<Expression, Collection<Expression>>)pair);
        }
        object22 = this.mBacktranslationPointer.collectAllPointers(arrayList);
        for (Pair pair2 : arrayList) {
            object = ((Collection)pair2.getValue()).stream().map(expression -> new WrappedExpression((Expression)expression)).toList();
            object22.add(new Pair((Object)((Expression)pair2.getFirst()), object));
        }
        HashMap<Expression, Collection<IExpressionOrPointer>> hashMap = new HashMap<Expression, Collection<IExpressionOrPointer>>();
        object = object22.iterator();
        while (object.hasNext()) {
            pair = (Pair)object.next();
            Collection collection = (Collection)pair.getSecond();
            Collection<IExpressionOrPointer> collection2 = hashMap.put((Expression)pair.getFirst(), (Collection)pair.getSecond());
            if (collection2 == null) continue;
            collection.addAll(collection2);
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BacktranslatedACSLValue translateExpressionForProgramState(IExpressionOrPointer iExpressionOrPointer) {
        IExpressionOrPointer iExpressionOrPointer2 = iExpressionOrPointer;
        Objects.requireNonNull(iExpressionOrPointer2);
        IExpressionOrPointer iExpressionOrPointer3 = iExpressionOrPointer2;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IPointerValue.class, WrappedExpression.class}, (Object)iExpressionOrPointer3, 0)) {
            case 0: {
                IPointerValue iPointerValue = (IPointerValue)iExpressionOrPointer3;
                BacktranslatedACSLValue backtranslatedACSLValue = this.mBacktranslationPointer.translatePointer(iPointerValue);
                return backtranslatedACSLValue;
            }
            case 1: {
                BacktranslatedACSLValue backtranslatedACSLValue;
                try {
                    Expression expression = ((WrappedExpression)iExpressionOrPointer3).expr();
                    backtranslatedACSLValue = this.translateExpression(expression);
                    return backtranslatedACSLValue;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + String.valueOf(iExpressionOrPointer));
    }

    public IBacktranslatedCFG<String, CACSLLocation> translateCFG(IBacktranslatedCFG<String, BoogieASTNode> iBacktranslatedCFG) {
        boolean bl = this.mGenerateBacktranslationWarnings;
        this.mGenerateBacktranslationWarnings = false;
        IBacktranslatedCFG<String, CACSLLocation> iBacktranslatedCFG2 = this.translateCFG(iBacktranslatedCFG, this::translateCFGEdge, (string, list, clazz) -> new CACSLBacktranslatedCFG((String)string, (List<? extends IExplicitEdgesMultigraph<?, ?, String, CACSLLocation, ?>>)list, (Class<? extends CACSLLocation>)clazz));
        iBacktranslatedCFG2 = this.reduceCFGs(iBacktranslatedCFG2);
        this.mGenerateBacktranslationWarnings = bl;
        return iBacktranslatedCFG2;
    }

    private <TVL, SVL> Multigraph<TVL, CACSLLocation> translateCFGEdge(Map<IExplicitEdgesMultigraph<?, ?, SVL, ? extends BoogieASTNode, ?>, Multigraph<TVL, CACSLLocation>> map, IMultigraphEdge<?, ?, ?, BoogieASTNode, ?> iMultigraphEdge, Multigraph<TVL, CACSLLocation> multigraph) {
        BoogieASTNode boogieASTNode;
        IExplicitEdgesMultigraph iExplicitEdgesMultigraph = iMultigraphEdge.getTarget();
        Multigraph<TVL, CACSLLocation> multigraph2 = multigraph;
        Multigraph multigraph3 = map.get(iExplicitEdgesMultigraph);
        if (multigraph3 == null) {
            multigraph3 = this.createLabeledWitnessNode(iExplicitEdgesMultigraph);
            map.put(iExplicitEdgesMultigraph, multigraph3);
        }
        if ((boogieASTNode = (BoogieASTNode)iMultigraphEdge.getLabel()) == null) {
            new MultigraphEdge(multigraph2, null, multigraph3);
            return multigraph3;
        }
        ILocation iLocation = boogieASTNode.getLocation();
        ConditionAnnotation conditionAnnotation = ConditionAnnotation.getAnnotation(iMultigraphEdge);
        this.createCFGMultigraphEdge(multigraph2, iLocation, multigraph3, conditionAnnotation != null && conditionAnnotation.isNegated());
        return multigraph3;
    }

    public ProcedureContract<BacktranslatedACSLValue, BacktranslatedACSLValue> translateProcedureContract(ProcedureContract<Expression, ? extends Expression> procedureContract, ILocation iLocation) {
        CACSLLocation cACSLLocation;
        if (iLocation instanceof CACSLLocation && (cACSLLocation = (CACSLLocation)iLocation).ignoreDuringBacktranslation()) {
            return null;
        }
        BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression = procedureContract.getRequires() == null ? null : this.translateExpressionWithContext((Expression)procedureContract.getRequires(), iLocation);
        BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression2 = this.mBoogie2ACSL.translateEnsuresExpression((Expression)procedureContract.getEnsures(), iLocation, procedureContract.getModifies());
        return new ProcedureContract(procedureContract.getProcedure(), (Object)backtranslatedExpression, (Object)backtranslatedExpression2);
    }

    private <TVL> void createCFGMultigraphEdge(Multigraph<TVL, CACSLLocation> multigraph, ILocation iLocation, Multigraph<TVL, CACSLLocation> multigraph2, boolean bl) {
        if (iLocation instanceof CLocation) {
            CLocation cLocation = (CLocation)iLocation;
            if (cLocation.ignoreDuringBacktranslation()) {
                MultigraphEdge multigraphEdge = new MultigraphEdge(multigraph, null, multigraph2);
            } else {
                IASTNode iASTNode = cLocation.getNode();
                if (iASTNode == null) {
                    this.reportUnfinishedBacktranslation("Skipping invalid CLocation because IASTNode is null");
                    MultigraphEdge multigraphEdge = new MultigraphEdge(multigraph, null, multigraph2);
                } else if (iASTNode instanceof CASTTranslationUnit) {
                    MultigraphEdge multigraphEdge = new MultigraphEdge(multigraph, null, multigraph2);
                } else if (iASTNode instanceof CASTIfStatement) {
                    CASTIfStatement cASTIfStatement = (CASTIfStatement)iASTNode;
                    MultigraphEdge multigraphEdge = new MultigraphEdge(multigraph, (Object)this.mLocationFactory.createCLocation((IASTNode)cASTIfStatement.getConditionExpression()), multigraph2);
                    new ConditionAnnotation(bl).annotate((IElement)multigraphEdge);
                } else if (iASTNode instanceof CASTWhileStatement) {
                    CASTWhileStatement cASTWhileStatement = (CASTWhileStatement)iASTNode;
                    MultigraphEdge multigraphEdge = new MultigraphEdge(multigraph, (Object)this.mLocationFactory.createCLocation((IASTNode)cASTWhileStatement.getCondition()), multigraph2);
                    new ConditionAnnotation(bl).annotate((IElement)multigraphEdge);
                } else if (iASTNode instanceof CASTDoStatement) {
                    CASTDoStatement cASTDoStatement = (CASTDoStatement)iASTNode;
                    MultigraphEdge multigraphEdge = new MultigraphEdge(multigraph, (Object)this.mLocationFactory.createCLocation((IASTNode)cASTDoStatement.getCondition()), multigraph2);
                    new ConditionAnnotation(bl).annotate((IElement)multigraphEdge);
                } else if (iASTNode instanceof CASTForStatement) {
                    CASTForStatement cASTForStatement = (CASTForStatement)iASTNode;
                    IASTExpression iASTExpression = cASTForStatement.getConditionExpression();
                    if (iASTExpression == null) {
                        iASTExpression = new FakeExpression((IASTNode)cASTForStatement, "1");
                    }
                    MultigraphEdge multigraphEdge = new MultigraphEdge(multigraph, (Object)this.mLocationFactory.createCLocation((IASTNode)iASTExpression), multigraph2);
                    new ConditionAnnotation(bl).annotate((IElement)multigraphEdge);
                } else if (iASTNode instanceof CASTFunctionCallExpression) {
                    MultigraphEdge multigraphEdge = new MultigraphEdge(multigraph, (Object)cLocation, multigraph2);
                } else if (iASTNode instanceof CASTFunctionDefinition) {
                    MultigraphEdge multigraphEdge = new MultigraphEdge(multigraph, null, multigraph2);
                } else {
                    MultigraphEdge multigraphEdge = new MultigraphEdge(multigraph, (Object)cLocation, multigraph2);
                }
            }
        } else if (iLocation instanceof ACSLLocation) {
            ACSLLocation aCSLLocation = (ACSLLocation)iLocation;
            MultigraphEdge multigraphEdge = new MultigraphEdge(multigraph, (Object)aCSLLocation, multigraph2);
        } else {
            this.reportUnfinishedBacktranslation("Invalid location (Location is no CACSLLocation)");
            MultigraphEdge multigraphEdge = new MultigraphEdge(multigraph, null, multigraph2);
        }
    }

    private IBacktranslatedCFG<String, CACSLLocation> reduceCFGs(IBacktranslatedCFG<String, CACSLLocation> iBacktranslatedCFG) {
        for (IExplicitEdgesMultigraph iExplicitEdgesMultigraph : iBacktranslatedCFG.getCFGs()) {
            this.reduceCFG(iExplicitEdgesMultigraph);
        }
        return iBacktranslatedCFG;
    }

    private void reduceCFG(IExplicitEdgesMultigraph<?, ?, String, CACSLLocation, ?> iExplicitEdgesMultigraph) {
        ArrayDeque<Multigraph> arrayDeque = new ArrayDeque<Multigraph>();
        HashSet<Multigraph> hashSet = new HashSet<Multigraph>();
        int n = 0;
        arrayDeque.add((Multigraph)iExplicitEdgesMultigraph);
        while (!arrayDeque.isEmpty()) {
            Multigraph multigraph = (Multigraph)arrayDeque.remove();
            if (!hashSet.add(multigraph)) continue;
            for (MultigraphEdge multigraphEdge : new ArrayList(multigraph.getOutgoingEdges())) {
                Multigraph multigraph2 = (Multigraph)multigraphEdge.getTarget();
                List list = multigraph2.getOutgoingEdges();
                if (multigraph2.getLabel() == null && multigraph2.getIncomingEdges().size() == 1 && (multigraphEdge.getLabel() == null || list.size() == 1 && ((Object)((Object)((CACSLLocation)((Object)multigraphEdge.getLabel())))).equals(((MultigraphEdge)list.get(0)).getLabel()))) {
                    ++n;
                    multigraphEdge.disconnectSource();
                    multigraphEdge.disconnectTarget();
                    for (MultigraphEdge multigraphEdge2 : new ArrayList(list)) {
                        multigraphEdge2.redirectSource((IModifiableExplicitEdgesMultigraph)multigraph);
                    }
                }
                if (multigraphEdge.getLabel() != null || multigraph2.getIncomingEdges().size() <= 1 || multigraph.getOutgoingEdges().size() <= 1) continue;
                multigraphEdge.disconnectSource();
                multigraphEdge.disconnectTarget();
            }
            for (MultigraphEdge multigraphEdge : multigraph.getOutgoingEdges()) {
                arrayDeque.add((Multigraph)multigraphEdge.getTarget());
            }
        }
        if (n > 0) {
            this.mLogger.info((Object)("Reduced CFG by removing " + n + " nodes and edges"));
            this.reduceCFG(iExplicitEdgesMultigraph);
        }
    }

    public BacktranslatedACSLValue.BacktranslatedExpression translateExpressionWithContext(Expression expression, ILocation iLocation) {
        CACSLLocation cACSLLocation;
        if (iLocation instanceof CACSLLocation && (cACSLLocation = (CACSLLocation)iLocation).ignoreDuringBacktranslation()) {
            return null;
        }
        return this.mBoogie2ACSL.translateExpression(expression, iLocation);
    }

    public BacktranslatedACSLValue.BacktranslatedExpression translateExpression(Expression expression) {
        return this.translateExpressionWithContext(expression, null);
    }

    public void reportUnfinishedBacktranslation(String string) {
        this.mBacktranslationWarned = true;
        if (!this.mGenerateBacktranslationWarnings) {
            return;
        }
        String string2 = "Unfinished Backtranslation: " + string;
        this.mLogger.warn((Object)string2);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new GenericResult(Activator.PLUGIN_ID, UNFINISHED_BACKTRANSLATION, string2, IResultWithSeverity.Severity.WARNING));
    }

    private static IRelevanceInformation mergeRelevaneInformation(IRelevanceInformation ... iRelevanceInformationArray) {
        if (iRelevanceInformationArray == null || iRelevanceInformationArray.length == 0) {
            return null;
        }
        if (iRelevanceInformationArray.length == 1) {
            return iRelevanceInformationArray[0];
        }
        return Arrays.stream(iRelevanceInformationArray).filter(iRelevanceInformation -> iRelevanceInformation != null).reduce(null, (iRelevanceInformation, iRelevanceInformation2) -> iRelevanceInformation == null ? iRelevanceInformation2 : iRelevanceInformation.merge(new IRelevanceInformation[]{iRelevanceInformation2}));
    }

    protected static List<AtomicTraceElement<CACSLLocation>> checkForSubtreeInclusion(List<AtomicTraceElement<CACSLLocation>> list) {
        HashSet<IASTNode> hashSet;
        AtomicTraceElement<CACSLLocation> atomicTraceElement;
        HashMap<AtomicTraceElement<CACSLLocation>, Set<IASTNode>> hashMap = new HashMap<AtomicTraceElement<CACSLLocation>, Set<IASTNode>>();
        for (AtomicTraceElement<CACSLLocation> arrayList2 : list) {
            if (!(arrayList2.getStep() instanceof CLocation)) continue;
            atomicTraceElement = ((CLocation)((Object)arrayList2.getStep())).getNode();
            hashSet = new HashSet<IASTNode>();
            IASTNode iASTNode = atomicTraceElement.getParent();
            while (iASTNode != null) {
                hashSet.add(iASTNode);
                iASTNode = iASTNode.getParent();
            }
            hashMap.put(arrayList2, hashSet);
        }
        ArrayList<AtomicTraceElement<CACSLLocation>> arrayList = new ArrayList<AtomicTraceElement<CACSLLocation>>();
        int n = 0;
        while (n < list.size()) {
            atomicTraceElement = list.get(n);
            hashSet = CACSL2BoogieBacktranslator.checkForSubtreeInclusion(atomicTraceElement, list, n + 1, AtomicTraceElement.StepInfo.EXPR_EVAL, hashMap);
            arrayList.add((AtomicTraceElement<CACSLLocation>)hashSet);
            ++n;
        }
        return arrayList;
    }

    private static AtomicTraceElement<CACSLLocation> checkForSubtreeInclusion(AtomicTraceElement<CACSLLocation> atomicTraceElement, List<AtomicTraceElement<CACSLLocation>> list, int n, AtomicTraceElement.StepInfo stepInfo, Map<AtomicTraceElement<CACSLLocation>, Set<IASTNode>> map) {
        Set<IASTNode> set = map.get(atomicTraceElement);
        if (set == null) {
            return atomicTraceElement;
        }
        IASTNode iASTNode = ((CLocation)((Object)atomicTraceElement.getStep())).getNode();
        if (!(iASTNode instanceof IASTExpression)) {
            return atomicTraceElement;
        }
        int n2 = n;
        while (n2 < list.size()) {
            IASTNode iASTNode2;
            AtomicTraceElement<CACSLLocation> atomicTraceElement2 = list.get(n2);
            if (atomicTraceElement2.getStep() instanceof CLocation && set.contains(iASTNode2 = ((CLocation)((Object)atomicTraceElement2.getStep())).getNode())) {
                EnumSet<AtomicTraceElement.StepInfo> enumSet;
                if (atomicTraceElement2.hasThreadId() || atomicTraceElement.hasThreadId()) {
                    if (!atomicTraceElement2.hasThreadId() || !atomicTraceElement.hasThreadId()) {
                        throw new AssertionError((Object)"Mixing concurrent and sequential program executions is not allowed");
                    }
                    if (atomicTraceElement2.getThreadId() != atomicTraceElement.getThreadId()) {
                        return atomicTraceElement;
                    }
                }
                if ((enumSet = atomicTraceElement.getStepInfo()).isEmpty() || enumSet.contains(AtomicTraceElement.StepInfo.NONE)) {
                    enumSet = EnumSet.of(stepInfo);
                } else {
                    enumSet.add(stepInfo);
                }
                return AtomicTraceElement.AtomicTraceElementBuilder.from(atomicTraceElement).setElement((Object)((CACSLLocation)((Object)atomicTraceElement2.getStep()))).setStep((Object)((CACSLLocation)((Object)atomicTraceElement.getStep()))).setStepInfo(enumSet).setRelevanceInformation(CACSL2BoogieBacktranslator.mergeRelevaneInformation(atomicTraceElement.getRelevanceInformation(), atomicTraceElement2.getRelevanceInformation())).build();
            }
            ++n2;
        }
        return atomicTraceElement;
    }

    protected void printBrokenCallStackSource(List<AtomicTraceElement<BoogieASTNode>> list, int n) {
        this.mLogger.fatal((Object)new ProgramExecutionFormatter((IBacktranslationValueProvider)new BoogieBacktranslationValueProvider()).formatProgramExecution((IProgramExecution)new BoogieProgramExecution(list.subList(0, n), false)));
    }

    protected void printBrokenCallStackTarget(List<AtomicTraceElement<CACSLLocation>> list, int n) {
        this.mLogger.fatal((Object)new ProgramExecutionFormatter((IBacktranslationValueProvider)new CACSLBacktranslationValueProvider()).formatProgramExecution((IProgramExecution)new CACSLProgramExecution(list.subList(0, n), false)));
    }

    private class CheckForTempVars
    extends BoogieTransformer {
        private boolean mAllAreTemp = true;

        private CheckForTempVars() {
        }

        protected boolean areAllTemp() {
            return this.mAllAreTemp;
        }

        protected Statement processStatement(Statement statement) {
            return super.processStatement(statement);
        }

        protected LeftHandSide processLeftHandSide(LeftHandSide leftHandSide) {
            if (leftHandSide instanceof VariableLHS) {
                this.mAllAreTemp = this.mAllAreTemp && this.isTempVar(((VariableLHS)leftHandSide).getIdentifier());
            }
            return super.processLeftHandSide(leftHandSide);
        }

        private boolean isTempVar(String string) {
            return CACSL2BoogieBacktranslator.this.mMapping.isTempVar(string);
        }

        protected Expression processExpression(Expression expression) {
            if (expression instanceof IdentifierExpression) {
                this.mAllAreTemp = this.mAllAreTemp && this.isTempVar(((IdentifierExpression)expression).getIdentifier());
            }
            return super.processExpression(expression);
        }
    }

    public static interface IBacktranslationPointer {
        public List<Pair<Expression, Collection<IExpressionOrPointer>>> collectAllPointers(List<Pair<Expression, Collection<Expression>>> var1);

        public BacktranslatedACSLValue translatePointer(IPointerValue var1);
    }

    public static interface IExpressionOrPointer {
    }

    public static interface IPointerValue
    extends IExpressionOrPointer {
    }

    private record WrappedExpression(Expression expr) implements IExpressionOrPointer
    {
    }
}

