/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprHelpers;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.DawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.MappedDawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.ProductDawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.ProjectDawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.ReorderDawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetterFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgStateFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.BinaryMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.BiFunction;
import java.util.function.Function;

public class DawgFactory<LETTER, COLNAMES> {
    private final DawgLetterFactory<LETTER> mDawgLetterFactory;
    private final DawgStateFactory<LETTER> mDawgStateFactory;
    private final Map<Object, Set<LETTER>> mConstants = new HashMap<Object, Set<LETTER>>();

    public DawgFactory(EprTheory eprTheory) {
        this.mDawgLetterFactory = new DawgLetterFactory(this);
        this.mDawgStateFactory = new DawgStateFactory();
    }

    public void addConstant(Object object, LETTER LETTER) {
        Set<LETTER> set = this.mConstants.get(object);
        if (set == null) {
            set = new HashSet<LETTER>();
            this.mConstants.put(object, set);
        }
        set.add(LETTER);
    }

    public Set<LETTER> getAllConstants(Object object) {
        if (this.mConstants.containsKey(object)) {
            return this.mConstants.get(object);
        }
        return Collections.emptySet();
    }

    public <VALUE> DawgState<LETTER, VALUE> createConstantDawg(SortedSet<COLNAMES> sortedSet, VALUE VALUE) {
        DawgState<LETTER, VALUE> dawgState = this.mDawgStateFactory.createFinalState(VALUE);
        Object[] objectArray = sortedSet.toArray(new Object[sortedSet.size()]);
        int n = objectArray.length - 1;
        while (n >= 0) {
            Object object = objectArray[n];
            Object object2 = EprHelpers.extractSortFromColname(object);
            DawgLetter<LETTER> dawgLetter = this.mDawgLetterFactory.getUniversalDawgLetter(object2);
            dawgState = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(dawgState, dawgLetter));
            --n;
        }
        return dawgState;
    }

    public DawgState<LETTER, Boolean> createSingletonSet(SortedSet<COLNAMES> sortedSet, List<LETTER> list) {
        DawgState<LETTER, Boolean> dawgState = this.mDawgStateFactory.createFinalState(Boolean.TRUE);
        DawgState<LETTER, Boolean> dawgState2 = this.mDawgStateFactory.createFinalState(Boolean.FALSE);
        Object[] objectArray = sortedSet.toArray(new Object[sortedSet.size()]);
        int n = objectArray.length - 1;
        while (n >= 0) {
            Object object = objectArray[n];
            Object object2 = EprHelpers.extractSortFromColname(object);
            DawgLetter<LETTER> dawgLetter = this.mDawgLetterFactory.getSingletonSetDawgLetter(list.get(n), object2);
            DawgLetter<LETTER> dawgLetter2 = dawgLetter.complement();
            DawgLetter<LETTER> dawgLetter3 = this.mDawgLetterFactory.getUniversalDawgLetter(object2);
            dawgState = this.mDawgStateFactory.createIntermediateState(new BinaryMap(dawgState, dawgLetter, dawgState2, dawgLetter2));
            dawgState2 = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(dawgState2, dawgLetter3));
            --n;
        }
        return dawgState;
    }

    public DawgState<LETTER, Boolean> createSingletonPattern(SortedSet<COLNAMES> sortedSet, List<DawgLetter<LETTER>> list) {
        DawgState<LETTER, Boolean> dawgState = this.mDawgStateFactory.createFinalState(Boolean.TRUE);
        DawgState<LETTER, Boolean> dawgState2 = this.mDawgStateFactory.createFinalState(Boolean.FALSE);
        Object[] objectArray = sortedSet.toArray(new Object[sortedSet.size()]);
        int n = objectArray.length - 1;
        while (n >= 0) {
            Object object = objectArray[n];
            Object object2 = EprHelpers.extractSortFromColname(object);
            DawgLetter<LETTER> dawgLetter = list.get(n);
            DawgLetter<LETTER> dawgLetter2 = dawgLetter.complement();
            DawgLetter<LETTER> dawgLetter3 = this.mDawgLetterFactory.getUniversalDawgLetter(object2);
            dawgState = this.mDawgStateFactory.createIntermediateState(new BinaryMap(dawgState, dawgLetter, dawgState2, dawgLetter2));
            dawgState2 = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(dawgState2, dawgLetter3));
            --n;
        }
        return dawgState;
    }

    public DawgState<LETTER, Boolean> createPatternMatchSet(SortedSet<COLNAMES> sortedSet, List<LETTER> list) {
        DawgState<LETTER, Boolean> dawgState = this.mDawgStateFactory.createFinalState(Boolean.TRUE);
        DawgState<LETTER, Boolean> dawgState2 = this.mDawgStateFactory.createFinalState(Boolean.FALSE);
        Object[] objectArray = sortedSet.toArray(new Object[sortedSet.size()]);
        int n = objectArray.length - 1;
        while (n >= 0) {
            Object object = objectArray[n];
            Object object2 = EprHelpers.extractSortFromColname(object);
            DawgLetter<LETTER> dawgLetter = this.mDawgLetterFactory.getUniversalDawgLetter(object2);
            if (list.get(n) == null) {
                dawgState = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(dawgState, dawgLetter));
            } else {
                DawgLetter<LETTER> dawgLetter2 = this.mDawgLetterFactory.getSingletonSetDawgLetter(list.get(n), object2);
                DawgLetter<LETTER> dawgLetter3 = dawgLetter2.complement();
                dawgState = this.mDawgStateFactory.createIntermediateState(new BinaryMap(dawgState, dawgLetter2, dawgState2, dawgLetter3));
            }
            dawgState2 = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(dawgState2, dawgLetter));
            --n;
        }
        return dawgState;
    }

    public DawgState<LETTER, Boolean> createFromSelectMap(SortedSet<COLNAMES> sortedSet, Map<COLNAMES, LETTER> map) {
        DawgState<LETTER, Boolean> dawgState = this.mDawgStateFactory.createFinalState(Boolean.TRUE);
        DawgState<LETTER, Boolean> dawgState2 = this.mDawgStateFactory.createFinalState(Boolean.FALSE);
        Object[] objectArray = sortedSet.toArray(new Object[sortedSet.size()]);
        int n = objectArray.length - 1;
        while (n >= 0) {
            Object object = objectArray[n];
            Object object2 = EprHelpers.extractSortFromColname(object);
            DawgLetter<LETTER> dawgLetter = this.mDawgLetterFactory.getUniversalDawgLetter(object2);
            if (map.containsKey(objectArray[n])) {
                DawgLetter<LETTER> dawgLetter2 = this.mDawgLetterFactory.getSingletonSetDawgLetter(map.get(objectArray[n]), object2);
                DawgLetter<LETTER> dawgLetter3 = dawgLetter2.complement();
                dawgState = this.mDawgStateFactory.createIntermediateState(new BinaryMap(dawgState, dawgLetter2, dawgState2, dawgLetter3));
            } else {
                dawgState = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(dawgState, dawgLetter));
            }
            dawgState2 = this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(dawgState2, dawgLetter));
            --n;
        }
        return dawgState;
    }

    public <V1, V2> DawgState<LETTER, V2> createMapped(DawgState<LETTER, V1> dawgState, Function<V1, V2> function) {
        MappedDawgBuilder mappedDawgBuilder = new MappedDawgBuilder(this, function);
        return mappedDawgBuilder.map(dawgState);
    }

    public <V1, V2, V3> DawgState<LETTER, V3> createProduct(DawgState<LETTER, V1> dawgState, DawgState<LETTER, V2> dawgState2, BiFunction<V1, V2, V3> biFunction) {
        ProductDawgBuilder productDawgBuilder = new ProductDawgBuilder(this, biFunction);
        return productDawgBuilder.product(dawgState, dawgState2);
    }

    public DawgState<LETTER, Boolean> createDifference(DawgState<LETTER, Boolean> dawgState, DawgState<LETTER, Boolean> dawgState2) {
        return this.createProduct(dawgState, dawgState2, (bl, bl2) -> bl != false && bl2 == false);
    }

    public DawgState<LETTER, Boolean> createUnion(DawgState<LETTER, Boolean> dawgState, DawgState<LETTER, Boolean> dawgState2) {
        return this.createProduct(dawgState, dawgState2, (bl, bl2) -> bl != false || bl2 != false);
    }

    public DawgState<LETTER, Boolean> createIntersection(DawgState<LETTER, Boolean> dawgState, DawgState<LETTER, Boolean> dawgState2) {
        return this.createProduct(dawgState, dawgState2, (bl, bl2) -> bl != false && bl2 != false);
    }

    private <VALUE> DawgState<LETTER, VALUE> projectWithMapInternal(DawgState<LETTER, VALUE> dawgState, LETTER[] LETTERArray, int n) {
        if (dawgState.isFinal()) {
            return dawgState;
        }
        if (LETTERArray[n] != null) {
            LETTER LETTER = LETTERArray[n];
            for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> entry : dawgState.getTransitions().entrySet()) {
                if (!entry.getValue().matches(LETTER)) continue;
                return this.projectWithMapInternal(entry.getKey(), LETTERArray, n + 1);
            }
            throw new AssertionError();
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> entry : dawgState.getTransitions().entrySet()) {
            DawgState<LETTER, VALUE> dawgState2 = this.projectWithMapInternal(entry.getKey(), LETTERArray, n + 1);
            DawgBuilder.addLetterToMap(hashMap, dawgState2, entry.getValue());
        }
        return this.mDawgStateFactory.createIntermediateState(hashMap);
    }

    public <VALUE> DawgState<LETTER, VALUE> projectWithMap(DawgState<LETTER, VALUE> dawgState, LETTER[] LETTERArray) {
        return this.projectWithMapInternal(dawgState, LETTERArray, 0);
    }

    public static <LETTER, VALUE> boolean isConstantValue(DawgState<LETTER, VALUE> dawgState, VALUE VALUE) {
        if (dawgState.isFinal()) {
            return dawgState.getFinalValue() == VALUE;
        }
        return dawgState.getTransitions().size() == 1 && DawgFactory.isConstantValue(dawgState.getTransitions().keySet().iterator().next(), VALUE);
    }

    public static <LETTER> boolean isUniversal(DawgState<LETTER, Boolean> dawgState) {
        return DawgFactory.isConstantValue(dawgState, Boolean.TRUE);
    }

    public static <LETTER> boolean isEmpty(DawgState<LETTER, Boolean> dawgState) {
        return DawgFactory.isConstantValue(dawgState, Boolean.FALSE);
    }

    public static <LETTER> Iterable<List<LETTER>> getSet(final DawgState<LETTER, Boolean> dawgState) {
        if (dawgState.isFinal()) {
            return dawgState.getFinalValue() != false ? Collections.singleton(Collections.emptyList()) : Collections.emptySet();
        }
        return new Iterable<List<LETTER>>(){

            @Override
            public Iterator<List<LETTER>> iterator() {
                return new Iterator<List<LETTER>>(){
                    Iterator<DawgState<LETTER, Boolean>> transIterator;
                    DawgState<LETTER, Boolean> currentSubState;
                    Iterator<LETTER> letterIterator;
                    LETTER currentLetter;
                    Iterator<List<LETTER>> subIterator;
                    {
                        this.transIterator = dawgState2.getTransitions().keySet().iterator();
                        this.currentSubState = this.transIterator.next();
                        this.letterIterator = dawgState2.getTransitions().get(this.currentSubState).getLetters().iterator();
                        this.subIterator = null;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Override
                    public boolean hasNext() {
                        ** GOTO lbl10
                        {
                            if (!this.transIterator.hasNext()) {
                                return false;
                            }
                            this.currentSubState = this.transIterator.next();
                            this.letterIterator = dawgState.getTransitions().get(this.currentSubState).getLetters().iterator();
                            do {
                                if (!this.letterIterator.hasNext()) continue block0;
                                this.currentLetter = this.letterIterator.next();
                                this.subIterator = DawgFactory.getSet(this.currentSubState).iterator();
lbl10:
                                // 2 sources

                            } while (this.subIterator == null || !this.subIterator.hasNext());
                        }
                        return true;
                    }

                    @Override
                    public List<LETTER> next() {
                        List list = this.subIterator.next();
                        ArrayList arrayList = new ArrayList(list.size() + 1);
                        arrayList.add(this.currentLetter);
                        arrayList.addAll(list);
                        return arrayList;
                    }
                };
            }
        };
    }

    public DawgLetterFactory<LETTER> getDawgLetterFactory() {
        return this.mDawgLetterFactory;
    }

    public DawgStateFactory<LETTER> getDawgStateFactory() {
        return this.mDawgStateFactory;
    }

    public DawgState<LETTER, Boolean> computeSymmetricTransitiveClosure(DawgState<LETTER, Boolean> dawgState) {
        Object object;
        DawgLetter<LETTER> dawgLetter;
        Map.Entry<DawgState<LETTER, Boolean>, DawgLetter<LETTER>> entry3;
        Map.Entry<DawgState<LETTER, Boolean>, DawgLetter<LETTER>> entry22;
        Object object2 = dawgState.getTransitions().values().iterator().next().getSortId();
        HashSet hashSet = new HashSet();
        for (Map.Entry<DawgState<LETTER, Boolean>, DawgLetter<LETTER>> entry22 : dawgState.getTransitions().entrySet()) {
            if (DawgFactory.isEmpty(entry22.getKey())) continue;
            hashSet.add(entry22.getValue());
        }
        for (Map.Entry<DawgState<LETTER, Boolean>, DawgLetter<LETTER>> entry22 : dawgState.getTransitions().entrySet()) {
            for (Map.Entry<DawgState<LETTER, Boolean>, DawgLetter<LETTER>> entry3 : entry22.getKey().getTransitions().entrySet()) {
                if (((DawgState)entry3.getKey()).getFinalValue() != Boolean.TRUE || (dawgLetter = ((DawgLetter)entry3.getValue()).difference(entry22.getValue())).isEmpty()) continue;
                DawgLetter<LETTER> dawgLetter2 = entry22.getValue().union((DawgLetter)entry3.getValue());
                DawgLetter dawgLetter3 = (DawgLetter)entry3.getValue();
                object = hashSet.iterator();
                while (object.hasNext()) {
                    DawgLetter dawgLetter4 = (DawgLetter)object.next();
                    if (dawgLetter4.isDisjoint(dawgLetter2)) continue;
                    dawgLetter3 = dawgLetter3.union(dawgLetter4);
                    object.remove();
                }
                hashSet.add(dawgLetter3);
            }
        }
        entry22 = new HashMap();
        DawgLetter<LETTER> dawgLetter5 = this.mDawgLetterFactory.getUniversalDawgLetter(object2);
        entry3 = this.mDawgStateFactory.createFinalState(Boolean.FALSE);
        DawgState<LETTER, Boolean> dawgState2 = this.mDawgStateFactory.createFinalState(Boolean.TRUE);
        dawgLetter = dawgLetter5;
        for (DawgLetter<LETTER> dawgLetter2 : hashSet) {
            assert (!dawgLetter2.isEmpty());
            dawgLetter = dawgLetter.difference(dawgLetter2);
            object = this.mDawgStateFactory.createIntermediateState(new BinaryMap<Object, DawgLetter<LETTER>>(dawgState2, dawgLetter2, entry3, dawgLetter2.complement()));
            entry22.put((DawgState<LETTER, Boolean>)object, dawgLetter2);
        }
        entry22.put(this.mDawgStateFactory.createIntermediateState(Collections.singletonMap(entry3, dawgLetter5)), dawgLetter);
        return this.mDawgStateFactory.createIntermediateState(entry22);
    }

    public static <LETTER> boolean isSingleton(DawgState<LETTER, Boolean> dawgState) {
        if (dawgState.isFinal()) {
            return dawgState.getFinalValue();
        }
        boolean bl = false;
        for (Map.Entry<DawgState<LETTER, Boolean>, DawgLetter<LETTER>> entry : dawgState.getTransitions().entrySet()) {
            if (DawgFactory.isEmpty(entry.getKey())) continue;
            if (bl || !entry.getValue().isSingleton() || !DawgFactory.isSingleton(entry.getKey())) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public <VALUE> DawgState<LETTER, VALUE> remap(DawgState<LETTER, VALUE> dawgState, int[] nArray, SortedSet<COLNAMES> sortedSet) {
        Object object2;
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] >= 0) {
                ++n;
            }
            ++n2;
        }
        ArrayList arrayList = new ArrayList(sortedSet.size());
        for (Object object2 : sortedSet) {
            Object object3 = EprHelpers.extractSortFromColname(object2);
            arrayList.add(this.mDawgLetterFactory.getUniversalDawgLetter(object3));
        }
        object2 = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            if (nArray[n4] >= 0) {
                object2[n3++] = nArray[n4];
                arrayList.set(nArray[n4], null);
            }
            ++n4;
        }
        dawgState = new ReorderDawgBuilder(this).reorder(dawgState, arrayList, (int[])object2);
        return dawgState;
    }

    public DawgState<LETTER, Boolean> translateClauseSigToPredSig(DawgState<LETTER, Boolean> dawgState, int[] nArray, LETTER[] LETTERArray, SortedSet<COLNAMES> sortedSet) {
        Object object;
        ArrayList arrayList = new ArrayList(LETTERArray.length);
        int n = 0;
        for (Object e : sortedSet) {
            object = EprHelpers.extractSortFromColname(e);
            if (LETTERArray[n] == null) {
                arrayList.add(null);
            } else {
                arrayList.add(this.mDawgLetterFactory.getUniversalDawgLetter(object));
            }
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] >= 0) {
                ++n2;
            }
            ++n3;
        }
        int[] nArray2 = new int[n2];
        object = new BitSet();
        int n4 = 0;
        int n5 = 0;
        while (n5 < nArray.length) {
            if (nArray[n5] >= 0) {
                nArray2[n4] = nArray[n5];
                assert (arrayList.get(nArray2[n4]) == null);
                ((BitSet)object).set(n5);
                ++n4;
            }
            ++n5;
        }
        dawgState = new ProjectDawgBuilder(this, nArray.length, (BitSet)object).project(dawgState);
        dawgState = new ReorderDawgBuilder(this).reorder(dawgState, arrayList, nArray2);
        dawgState = this.createIntersection(dawgState, this.createPatternMatchSet(sortedSet, Arrays.asList(LETTERArray)));
        return dawgState;
    }

    public static <LETTER> List<DawgLetter<LETTER>> getOneWord(DawgState<LETTER, Boolean> dawgState) {
        assert (!DawgFactory.isEmpty(dawgState));
        ArrayList<DawgLetter<LETTER>> arrayList = new ArrayList<DawgLetter<LETTER>>();
        while (!dawgState.isFinal()) {
            for (Map.Entry<DawgState<LETTER, Boolean>, DawgLetter<LETTER>> entry : dawgState.getTransitions().entrySet()) {
                if (DawgFactory.isEmpty(entry.getKey())) continue;
                arrayList.add(entry.getValue());
                dawgState = entry.getKey();
                break;
            }
            assert (!DawgFactory.isEmpty(dawgState));
        }
        return arrayList;
    }
}

