/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.HeapDataArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModelDeclarationInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModelDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModelDeclarationsHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.RequiredMemoryModelFeatures;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.List;

public class MemoryModelExpressionHelper {
    public static void requireMemoryModelFeature(MemoryModelDeclarations memoryModelDeclarations, RequiredMemoryModelFeatures requiredMemoryModelFeatures, MemoryModelDeclarationsHandler memoryModelDeclarationsHandler) {
        requiredMemoryModelFeatures.require(memoryModelDeclarations);
        memoryModelDeclarationsHandler.createMemoryModelDeclarationInfo(memoryModelDeclarations);
    }

    public static VariableLHS getMemoryModelFeatureLhs(ILocation iLocation, MemoryModelDeclarations memoryModelDeclarations, RequiredMemoryModelFeatures requiredMemoryModelFeatures, MemoryModelDeclarationsHandler memoryModelDeclarationsHandler) {
        MemoryModelExpressionHelper.requireMemoryModelFeature(memoryModelDeclarations, requiredMemoryModelFeatures, memoryModelDeclarationsHandler);
        MemoryModelDeclarationInfo memoryModelDeclarationInfo = memoryModelDeclarationsHandler.memoryModelDeclarationInfo(memoryModelDeclarations);
        return memoryModelDeclarationInfo.constructVariableLHS(iLocation);
    }

    public static Expression getMemoryModelFeatureExpression(ILocation iLocation, MemoryModelDeclarations memoryModelDeclarations, RequiredMemoryModelFeatures requiredMemoryModelFeatures, MemoryModelDeclarationsHandler memoryModelDeclarationsHandler) {
        MemoryModelExpressionHelper.requireMemoryModelFeature(memoryModelDeclarations, requiredMemoryModelFeatures, memoryModelDeclarationsHandler);
        MemoryModelDeclarationInfo memoryModelDeclarationInfo = memoryModelDeclarationsHandler.memoryModelDeclarationInfo(memoryModelDeclarations);
        return memoryModelDeclarationInfo.constructIdentifierExpression(iLocation);
    }

    public static Expression constructOneDimensionalArrayAccess(ILocation iLocation, Expression expression, Expression expression2) {
        Expression[] expressionArray = new Expression[]{expression2};
        return ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)expression, (Expression[])expressionArray);
    }

    private static Expression constructOneDimensionalArrayStore(ILocation iLocation, Expression expression, Expression expression2, Expression expression3) {
        Expression[] expressionArray = new Expression[]{expression2};
        return ExpressionFactory.constructArrayStoreExpression((ILocation)iLocation, (Expression)expression, (Expression[])expressionArray, (Expression)expression3);
    }

    private static Expression constructNestedOneDimensionalArrayStore(ILocation iLocation, Expression expression, List<Expression> list, List<Expression> list2) {
        assert (list.size() == list2.size());
        Expression expression2 = expression;
        int n = 0;
        while (n < list.size()) {
            Expression[] expressionArray = new Expression[]{list.get(n)};
            expression2 = ExpressionFactory.constructArrayStoreExpression((ILocation)iLocation, (Expression)expression2, (Expression[])expressionArray, (Expression)list2.get(n));
            ++n;
        }
        return expression2;
    }

    public static Expression constructHeapArrayUpdateForWriteEnsures(ILocation iLocation, List<Expression> list, List<Expression> list2, HeapDataArray heapDataArray, boolean bl) {
        IdentifierExpression identifierExpression = heapDataArray.getIdentifierExpression();
        if (bl) {
            return MemoryModelExpressionHelper.ensuresArrayHasValues(iLocation, list, list2, (Expression)identifierExpression);
        }
        return MemoryModelExpressionHelper.ensuresArrayNestedUpdate(iLocation, list, list2, (Expression)identifierExpression);
    }

    public static Expression constructHeapArrayHardlyModifiedForWriteEnsures(ILocation iLocation, List<Expression> list, HeapDataArray heapDataArray) {
        IdentifierExpression identifierExpression = heapDataArray.getIdentifierExpression();
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        int n = 0;
        while (n < list.size()) {
            arrayList.add(MemoryModelExpressionHelper.constructOneDimensionalArrayAccess(iLocation, (Expression)identifierExpression, list.get(n)));
            ++n;
        }
        return MemoryModelExpressionHelper.ensuresArrayNestedUpdate(iLocation, arrayList, list, (Expression)identifierExpression);
    }

    public static Expression ensuresArrayUpdate(ILocation iLocation, Expression expression, Expression expression2, Expression expression3) {
        Expression expression4 = ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.OLD, (Expression)expression3);
        Expression expression5 = MemoryModelExpressionHelper.constructOneDimensionalArrayStore(iLocation, expression4, expression2, expression);
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression3, (Expression)expression5);
    }

    private static Expression ensuresArrayNestedUpdate(ILocation iLocation, List<Expression> list, List<Expression> list2, Expression expression) {
        Expression expression2 = ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.OLD, (Expression)expression);
        Expression expression3 = MemoryModelExpressionHelper.constructNestedOneDimensionalArrayStore(iLocation, expression2, list2, list);
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression, (Expression)expression3);
    }

    public static Expression ensuresArrayHasValue(ILocation iLocation, Expression expression, Expression expression2, Expression expression3) {
        ArrayAccessExpression arrayAccessExpression = ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)expression3, (Expression[])new Expression[]{expression2});
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)arrayAccessExpression, (Expression)expression);
    }

    private static Expression ensuresArrayHasValues(ILocation iLocation, List<Expression> list, List<Expression> list2, Expression expression) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        int n = 0;
        while (n < list.size()) {
            arrayList.add(MemoryModelExpressionHelper.ensuresArrayHasValue(iLocation, list.get(n), list2.get(n), expression));
            ++n;
        }
        return ExpressionFactory.and((ILocation)iLocation, arrayList);
    }
}

