/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtLibUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class NnfTransformer {
    private static final String FRESH_VARIABLE_PREFIX = "nnf";
    private static final boolean DEBUG_CHECK_SOUNDNESS = false;
    protected final Script mScript;
    private final ManagedScript mMgdScript;
    protected final ILogger mLogger;
    private final NnfTransformerHelper mNnfTransformerHelper;
    private List<List<TermVariable>> mQuantifiedVariables;
    protected final QuantifierHandling mQuantifierHandling;
    protected Function<Integer, Boolean> mFunAbortIfExponential;

    public NnfTransformer(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, QuantifierHandling quantifierHandling) {
        this(managedScript, iUltimateServiceProvider, quantifierHandling, n -> false);
    }

    public NnfTransformer(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, QuantifierHandling quantifierHandling, Function<Integer, Boolean> function) {
        this.mFunAbortIfExponential = Objects.requireNonNull(function);
        this.mQuantifierHandling = quantifierHandling;
        this.mScript = managedScript.getScript();
        this.mMgdScript = managedScript;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(SmtLibUtils.PLUGIN_ID);
        this.mNnfTransformerHelper = this.getNnfTransformerHelper(iUltimateServiceProvider);
    }

    protected NnfTransformerHelper getNnfTransformerHelper(IUltimateServiceProvider iUltimateServiceProvider) {
        return new NnfTransformerHelper(iUltimateServiceProvider);
    }

    public Term transform(Term term) {
        Object object;
        assert (this.mQuantifiedVariables == null);
        if (this.mQuantifierHandling == QuantifierHandling.PULL) {
            this.mQuantifiedVariables = new ArrayList<List<TermVariable>>();
            object = new ArrayList();
            this.mQuantifiedVariables.add((List<TermVariable>)object);
        }
        object = this.mNnfTransformerHelper.transform(term);
        if (this.mQuantifierHandling == QuantifierHandling.PULL) {
            int n = 0;
            while (n < this.mQuantifiedVariables.size()) {
                TermVariable[] termVariableArray = this.mQuantifiedVariables.get(n).toArray(new TermVariable[this.mQuantifiedVariables.get(n).size()]);
                if (termVariableArray.length > 0) {
                    int n2 = n % 2;
                    object = this.mScript.quantifier(n2, termVariableArray, object, (Term[][])new Term[0][]);
                }
                ++n;
            }
            this.mQuantifiedVariables = null;
        }
        return object;
    }

    private static Term[] negateTerms(Script script, Term[] termArray) {
        Term[] termArray2 = new Term[termArray.length];
        int n = 0;
        while (n < termArray.length) {
            termArray2[n] = SmtUtils.not(script, termArray[n]);
            ++n;
        }
        return termArray2;
    }

    private static Term[] negateLast(Script script, Term[] termArray) {
        Term[] termArray2 = new Term[termArray.length];
        System.arraycopy(termArray, 0, termArray2, 0, termArray.length - 1);
        termArray2[termArray.length - 1] = SmtUtils.not(script, termArray[termArray.length - 1]);
        return termArray2;
    }

    private static Term[] negateAllButLast(Script script, Term[] termArray) {
        Term[] termArray2 = new Term[termArray.length];
        int n = 0;
        while (n < termArray.length - 1) {
            termArray2[n] = SmtUtils.not(script, termArray[n]);
            ++n;
        }
        termArray2[termArray.length - 1] = termArray[termArray.length - 1];
        return termArray2;
    }

    private static Term convertIte(Script script, Term term, Term term2, Term term3) {
        Term term4 = SmtUtils.or(script, SmtUtils.not(script, term), term2);
        Term term5 = SmtUtils.or(script, term, term3);
        Term term6 = SmtUtils.and(script, term4, term5);
        return term6;
    }

    private static boolean isXor(ApplicationTerm applicationTerm, String string) {
        return string.equals("xor") || string.equals("distinct") && SmtUtils.firstParamIsBool(applicationTerm);
    }

    public static Term pushNot1StepInside(Script script, Term term, QuantifierHandling quantifierHandling) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            String string = applicationTerm.getFunction().getName();
            Term[] termArray = applicationTerm.getParameters();
            if (string.equals("and")) {
                return SmtUtils.or(script, NnfTransformer.negateTerms(script, termArray));
            }
            if (string.equals("or")) {
                return SmtUtils.and(script, NnfTransformer.negateTerms(script, termArray));
            }
            if (string.equals("not")) {
                assert (applicationTerm.getParameters().length == 1);
                Term term2 = applicationTerm.getParameters()[0];
                return term2;
            }
            if (string.equals("=>")) {
                return SmtUtils.and(script, NnfTransformer.negateLast(script, termArray));
            }
            if (string.equals("=") && SmtUtils.firstParamIsBool(applicationTerm)) {
                Term[] termArray2 = applicationTerm.getParameters();
                if (termArray2.length > 2) {
                    Term term3 = SmtUtils.binarize(script, applicationTerm);
                    return SmtUtils.not(script, term3);
                }
                assert (termArray2.length == 2);
                return SmtUtils.binaryBooleanNotEquals(script, termArray2[0], termArray2[1]);
            }
            if (NnfTransformer.isXor(applicationTerm, string)) {
                Term[] termArray3 = applicationTerm.getParameters();
                if (termArray3.length > 2) {
                    Term term4 = SmtUtils.binarize(script, applicationTerm);
                    return SmtUtils.not(script, term4);
                }
                assert (termArray3.length == 2);
                return SmtUtils.binaryBooleanEquality(script, termArray3[0], termArray3[1]);
            }
            if (string.equals("ite") && SmtUtils.allParamsAreBool(applicationTerm)) {
                Term[] termArray4 = applicationTerm.getParameters();
                assert (termArray.length == 3);
                Term term5 = termArray4[0];
                Term term6 = termArray4[1];
                Term term7 = termArray4[2];
                Term term8 = NnfTransformer.convertIte(script, term5, term6, term7);
                return SmtUtils.not(script, term8);
            }
            return null;
        }
        if (term instanceof QuantifiedFormula) {
            switch (quantifierHandling) {
                case CRASH: {
                    throw new UnsupportedOperationException("quantifier handling set to " + String.valueOf((Object)quantifierHandling));
                }
                case IS_ATOM: {
                    return null;
                }
                case KEEP: {
                    QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
                    Term term9 = quantifiedFormula.getSubformula();
                    Term term10 = SmtUtils.not(script, term9);
                    int n = QuantifierUtils.getDualQuantifier(quantifiedFormula.getQuantifier());
                    Term term11 = SmtUtils.quantifier(script, n, new HashSet<TermVariable>(Arrays.asList(quantifiedFormula.getVariables())), term10);
                    return term11;
                }
                case PULL: {
                    throw new UnsupportedOperationException("20180601 Matthias: I am not sure if we should still support PULL");
                }
            }
            throw new AssertionError();
        }
        return null;
    }

    public static Term apply(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, QuantifierHandling quantifierHandling, Term term) {
        return new NnfTransformer(managedScript, iUltimateServiceProvider, quantifierHandling).transform(term);
    }

    protected class NnfTransformerHelper
    extends TermTransformer {
        protected IUltimateServiceProvider mServices;

        protected NnfTransformerHelper(IUltimateServiceProvider iUltimateServiceProvider) {
            this.mServices = iUltimateServiceProvider;
        }

        protected void convert(Term term) {
            assert (SmtSortUtils.isBoolSort(term.getSort())) : "Input is not Bool";
            if (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                String string = applicationTerm.getFunction().getName();
                if (string.equals("and")) {
                    Term term2 = SmtUtils.and(NnfTransformer.this.mScript, applicationTerm.getParameters());
                    if (SmtUtils.isFunctionApplication(term2, "and")) {
                        super.convert(term2);
                    } else {
                        this.convert(term2);
                    }
                } else if (string.equals("or")) {
                    Term term3 = SmtUtils.or(NnfTransformer.this.mScript, applicationTerm.getParameters());
                    if (SmtUtils.isFunctionApplication(term3, "or")) {
                        super.convert(term3);
                    } else {
                        this.convert(term3);
                    }
                } else if (string.equals("not")) {
                    assert (applicationTerm.getParameters().length == 1);
                    Term term4 = applicationTerm.getParameters()[0];
                    this.convertNot(term4, term);
                } else if (string.equals("=>")) {
                    Term[] termArray = applicationTerm.getParameters();
                    this.convert(SmtUtils.or(NnfTransformer.this.mScript, NnfTransformer.negateAllButLast(NnfTransformer.this.mScript, termArray)));
                } else if (string.equals("=") && SmtUtils.firstParamIsBool(applicationTerm)) {
                    Term[] termArray = applicationTerm.getParameters();
                    if (termArray.length > 2) {
                        Term term5 = SmtUtils.binarize(NnfTransformer.this.mScript, applicationTerm);
                        this.convert(term5);
                    } else {
                        assert (termArray.length == 2);
                        this.convert(SmtUtils.binaryBooleanEquality(NnfTransformer.this.mScript, termArray[0], termArray[1]));
                    }
                } else if (NnfTransformer.isXor(applicationTerm, string)) {
                    Term[] termArray = applicationTerm.getParameters();
                    if (termArray.length > 2) {
                        Term term6 = SmtUtils.binarize(NnfTransformer.this.mScript, applicationTerm);
                        this.convert(term6);
                    } else {
                        assert (termArray.length == 2);
                        this.convert(SmtUtils.binaryBooleanNotEquals(NnfTransformer.this.mScript, termArray[0], termArray[1]));
                    }
                } else if (string.equals("ite") && SmtUtils.allParamsAreBool(applicationTerm)) {
                    Term[] termArray = applicationTerm.getParameters();
                    assert (termArray.length == 3);
                    Term term7 = termArray[0];
                    Term term8 = termArray[1];
                    Term term9 = termArray[2];
                    Term term10 = NnfTransformer.convertIte(NnfTransformer.this.mScript, term7, term8, term9);
                    this.convert(term10);
                } else {
                    this.setResult(term);
                }
            } else if (term instanceof TermVariable) {
                this.setResult(term);
            } else if (term instanceof ConstantTerm) {
                this.setResult(term);
            } else {
                if (term instanceof QuantifiedFormula) {
                    switch (NnfTransformer.this.mQuantifierHandling) {
                        case CRASH: {
                            throw new UnsupportedOperationException("quantifier handling set to " + String.valueOf((Object)NnfTransformer.this.mQuantifierHandling));
                        }
                        case IS_ATOM: {
                            this.setResult(term);
                            return;
                        }
                        case KEEP: {
                            super.convert(term);
                            return;
                        }
                        case PULL: {
                            TermVariable termVariable;
                            List<Object> list;
                            QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
                            if (NnfTransformer.this.mQuantifiedVariables.size() - 1 == quantifiedFormula.getQuantifier()) {
                                list = NnfTransformer.this.mQuantifiedVariables.get(NnfTransformer.this.mQuantifiedVariables.size() - 1);
                            } else {
                                list = new ArrayList();
                                NnfTransformer.this.mQuantifiedVariables.add(list);
                            }
                            HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
                            TermVariable[] termVariableArray = quantifiedFormula.getVariables();
                            int n = termVariableArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                termVariable = termVariableArray[n2];
                                TermVariable termVariable2 = NnfTransformer.this.mMgdScript.constructFreshTermVariable(NnfTransformer.FRESH_VARIABLE_PREFIX, termVariable.getSort());
                                hashMap.put(termVariable, termVariable2);
                                list.add(termVariable2);
                                ++n2;
                            }
                            termVariable = Substitution.apply(NnfTransformer.this.mMgdScript, hashMap, quantifiedFormula.getSubformula());
                            this.convert((Term)termVariable);
                            return;
                        }
                    }
                    throw new AssertionError((Object)"unknown case");
                }
                if (term instanceof AnnotatedTerm) {
                    NnfTransformer.this.mLogger.warn((Object)("thrown away annotations " + Arrays.toString(((AnnotatedTerm)term).getAnnotations())));
                    this.convert(((AnnotatedTerm)term).getSubterm());
                }
            }
        }

        private void convertNot(Term term, Term term2) {
            assert (SmtSortUtils.isBoolSort(term.getSort())) : "Input is not Bool";
            Term term3 = NnfTransformer.pushNot1StepInside(NnfTransformer.this.mScript, term, NnfTransformer.this.mQuantifierHandling);
            if (term3 == null) {
                this.setResult(term2);
            } else {
                this.convert(term3);
            }
        }

        public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
            Term term = SmtUtils.unfTerm(NnfTransformer.this.mScript, applicationTerm.getFunction(), termArray);
            this.setResult(term);
        }
    }

    public static enum QuantifierHandling {
        CRASH,
        KEEP,
        IS_ATOM,
        PULL;

    }
}

