/*
 * Decompiled with CFR 0.152.
 */
package ap.parser;

import ap.parser.IBoolLit;
import ap.parser.IExpression;
import ap.parser.IExpression$;
import ap.parser.IFormula;
import ap.parser.ITerm;
import ap.parser.ITermITE;
import ap.parser.Parser2InputAbsy;
import ap.parser.SMTLineariser$;
import ap.parser.SMTTypes;
import ap.parser.SMTTypes$SMTBool$;
import ap.parser.smtlib.Absyn.CastIdentifierRef;
import ap.parser.smtlib.Absyn.CompositeSort;
import ap.parser.smtlib.Absyn.HexIndex;
import ap.parser.smtlib.Absyn.IdentSort;
import ap.parser.smtlib.Absyn.Identifier;
import ap.parser.smtlib.Absyn.IdentifierRef;
import ap.parser.smtlib.Absyn.IndexC;
import ap.parser.smtlib.Absyn.IndexIdent;
import ap.parser.smtlib.Absyn.NormalSymbol;
import ap.parser.smtlib.Absyn.NumIndex;
import ap.parser.smtlib.Absyn.QuotedSymbol;
import ap.parser.smtlib.Absyn.Sort;
import ap.parser.smtlib.Absyn.SymIndex;
import ap.parser.smtlib.Absyn.Symbol;
import ap.parser.smtlib.Absyn.SymbolIdent;
import ap.parser.smtlib.Absyn.SymbolRef;
import ap.parser.smtlib.Yylex;
import ap.parser.smtlib.parser;
import java.io.Reader;
import java.io.Serializable;
import java.util.List;
import java_cup.runtime.Scanner;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.util.matching.Regex;

public final class SMTParsingUtils$ {
    public static SMTParsingUtils$ MODULE$;
    private final Regex DecLiteral;
    private final Regex HexLiteral;
    private final Regex BVDecLiteral;
    private final Regex FFDecLiteral;

    static {
        new SMTParsingUtils$();
    }

    public <T> T parseWithEntry(Reader input, Function1<parser, T> entry) {
        Object object;
        Yylex l = new Yylex((Reader)new Parser2InputAbsy.CRRemover2(input));
        parser p = new parser((Scanner)l);
        try {
            object = entry.apply((Object)p);
        }
        catch (Exception e) {
            try {
                String msg = new StringBuilder(24).append("At line ").append(String.valueOf(l.line_num())).append(", near \"").append(l.buff()).append("\" :").append("     ").append(e.getMessage()).toString();
                throw new Parser2InputAbsy.ParseException(msg);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new Parser2InputAbsy.ParseException("Runaway block, probably due to mismatched parentheses");
            }
        }
        return (T)object;
    }

    public String asString(SymbolRef s) {
        SymbolRef symbolRef = s;
        if (symbolRef instanceof IdentifierRef) {
            IdentifierRef identifierRef = (IdentifierRef)symbolRef;
            return this.asString(identifierRef.identifier_);
        }
        if (symbolRef instanceof CastIdentifierRef) {
            CastIdentifierRef castIdentifierRef = (CastIdentifierRef)symbolRef;
            return this.asString(castIdentifierRef.identifier_);
        }
        throw new MatchError((Object)symbolRef);
    }

    public String asString(IndexC id) {
        IndexC indexC = id;
        if (indexC instanceof NumIndex) {
            NumIndex numIndex = (NumIndex)indexC;
            return numIndex.numeral_;
        }
        if (indexC instanceof HexIndex) {
            HexIndex hexIndex = (HexIndex)indexC;
            return hexIndex.hexadecimal_;
        }
        if (indexC instanceof SymIndex) {
            SymIndex symIndex = (SymIndex)indexC;
            return this.asString(symIndex.symbol_);
        }
        throw new MatchError((Object)indexC);
    }

    public String asString(Identifier id2) {
        Identifier identifier = id2;
        if (identifier instanceof SymbolIdent) {
            SymbolIdent symbolIdent = (SymbolIdent)identifier;
            return this.asString(symbolIdent.symbol_);
        }
        if (identifier instanceof IndexIdent) {
            IndexIdent indexIdent = (IndexIdent)identifier;
            return new StringBuilder(1).append(this.asString(indexIdent.symbol_)).append("_").append(((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer((List)indexIdent.listindexc_).map((Function1 & Serializable & scala.Serializable)id -> MODULE$.asString((IndexC)id), Buffer$.MODULE$.canBuildFrom())).mkString("_")).toString();
        }
        throw new MatchError((Object)identifier);
    }

    public String asString(Symbol s) {
        Symbol symbol = s;
        if (symbol instanceof NormalSymbol) {
            NormalSymbol normalSymbol = (NormalSymbol)symbol;
            return normalSymbol.normalsymbolt_;
        }
        if (symbol instanceof QuotedSymbol) {
            QuotedSymbol quotedSymbol = (QuotedSymbol)symbol;
            return quotedSymbol.quotedsymbolt_.substring(1, quotedSymbol.quotedsymbolt_.length() - 1);
        }
        throw new MatchError((Object)symbol);
    }

    public String asString(Sort s) {
        Sort sort = s;
        if (sort instanceof IdentSort) {
            IdentSort identSort = (IdentSort)sort;
            return this.asString(identSort.identifier_);
        }
        if (sort instanceof CompositeSort) {
            CompositeSort compositeSort = (CompositeSort)sort;
            return new StringBuilder(1).append(this.asString(compositeSort.identifier_)).append("_").append(((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer((List)compositeSort.listsort_).map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.asString((Sort)x$1), Buffer$.MODULE$.canBuildFrom())).mkString("_")).toString();
        }
        throw new MatchError((Object)sort);
    }

    public Regex DecLiteral() {
        return this.DecLiteral;
    }

    public Regex HexLiteral() {
        return this.HexLiteral;
    }

    public Regex BVDecLiteral() {
        return this.BVDecLiteral;
    }

    public Regex FFDecLiteral() {
        return this.FFDecLiteral;
    }

    public ITerm asTerm(Tuple2<IExpression, SMTTypes.SMTType> expr) {
        IBoolLit iBoolLit;
        boolean bl;
        IExpression iExpression;
        IBoolLit iBoolLit2;
        boolean bl2;
        IExpression iExpression2;
        IExpression expr2;
        Tuple2<IExpression, SMTTypes.SMTType> tuple2 = expr;
        if (tuple2 != null && (expr2 = (IExpression)tuple2._1()) instanceof ITerm) {
            ITerm iTerm = (ITerm)expr2;
            return iTerm;
        }
        if (tuple2 != null && (iExpression2 = (IExpression)tuple2._1()) instanceof IBoolLit && (bl2 = (iBoolLit2 = (IBoolLit)iExpression2).value())) {
            return IExpression$.MODULE$.i(0);
        }
        if (tuple2 != null && (iExpression = (IExpression)tuple2._1()) instanceof IBoolLit && !(bl = (iBoolLit = (IBoolLit)iExpression).value())) {
            return IExpression$.MODULE$.i(1);
        }
        if (tuple2 != null) {
            IExpression expr3 = (IExpression)tuple2._1();
            SMTTypes.SMTType sMTType = (SMTTypes.SMTType)tuple2._2();
            if (expr3 instanceof IFormula) {
                IFormula iFormula = (IFormula)expr3;
                if (SMTTypes$SMTBool$.MODULE$.equals(sMTType)) {
                    return new ITermITE(iFormula, IExpression$.MODULE$.i(0), IExpression$.MODULE$.i(1));
                }
            }
        }
        if (tuple2 != null) {
            IExpression expr4 = (IExpression)tuple2._1();
            throw new Parser2InputAbsy.TranslationException(new StringBuilder(21).append("Expected a term, not ").append(expr4).toString());
        }
        throw new MatchError(tuple2);
    }

    public ITerm asTerm(Tuple2<IExpression, SMTTypes.SMTType> expr, SMTTypes.SMTType expectedSort) {
        Tuple2<IExpression, SMTTypes.SMTType> tuple2 = expr;
        if (tuple2 != null) {
            IExpression expr2 = (IExpression)tuple2._1();
            SMTTypes.SMTType sMTType = (SMTTypes.SMTType)tuple2._2();
            if (expr2 instanceof ITerm) {
                ITerm iTerm = (ITerm)expr2;
                SMTTypes.SMTType sMTType2 = expectedSort;
                SMTTypes.SMTType sMTType3 = sMTType;
                if (!(sMTType2 != null ? !sMTType2.equals(sMTType3) : sMTType3 != null)) {
                    return iTerm;
                }
            }
        }
        if (tuple2 != null) {
            IExpression expr3 = (IExpression)tuple2._1();
            throw new Parser2InputAbsy.TranslationException(new StringBuilder(30).append("Expected a term of type ").append(SMTLineariser$.MODULE$.smtTypeAsString(expectedSort)).append(", not ").append(expr3).toString());
        }
        throw new MatchError(tuple2);
    }

    private SMTParsingUtils$() {
        MODULE$ = this;
        this.DecLiteral = new StringOps(Predef$.MODULE$.augmentString("([0-9]+)")).r();
        this.HexLiteral = new StringOps(Predef$.MODULE$.augmentString("#x([0-9a-fA-F]+)")).r();
        this.BVDecLiteral = new StringOps(Predef$.MODULE$.augmentString("bv([0-9]+)")).r();
        this.FFDecLiteral = new StringOps(Predef$.MODULE$.augmentString("ff([0-9]+)")).r();
    }
}

