/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph;

import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphEdgeLabel;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphNode;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphNodeLabel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NodeLabeler {
    private final Collection<String> mEntryProcedures;
    private Map<String, CallGraphNode> mCallGraph;
    private Set<CallGraphEdgeLabel> mVisitedEdges;
    private Set<String> mEntryAndReEntryProcedures;

    public NodeLabeler(Collection<String> collection) {
        this.mEntryProcedures = collection;
    }

    public Set<String> label(Map<String, CallGraphNode> map) {
        this.reset();
        this.mCallGraph = map;
        for (String string : this.mEntryProcedures) {
            CallGraphNode callGraphNode = map.get(string);
            if (callGraphNode == null) continue;
            callGraphNode.setLabel(CallGraphNodeLabel.ENTRY);
            this.mEntryAndReEntryProcedures.add(string);
            this.visitChildren(callGraphNode);
        }
        this.labelNonLabeledNodesAsDead();
        return this.mEntryAndReEntryProcedures;
    }

    private void reset() {
        this.mCallGraph = null;
        this.mVisitedEdges = new HashSet<CallGraphEdgeLabel>();
        this.mEntryAndReEntryProcedures = new HashSet<String>();
    }

    private void visitChildren(CallGraphNode callGraphNode) {
        Iterator iterator = callGraphNode.getOutgoingEdgeLabels().iterator();
        Iterator iterator2 = callGraphNode.getOutgoingNodes().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            boolean bl;
            CallGraphNode callGraphNode2 = (CallGraphNode)((Object)iterator2.next());
            CallGraphEdgeLabel callGraphEdgeLabel = (CallGraphEdgeLabel)iterator.next();
            boolean bl2 = !this.mVisitedEdges.add(callGraphEdgeLabel);
            boolean bl3 = bl = callGraphNode2.getLabel() != null;
            if (bl2 || bl) continue;
            if (!callGraphEdgeLabel.getInlineFlag()) {
                callGraphNode2.setLabel(CallGraphNodeLabel.RE_ENTRY);
                this.mEntryAndReEntryProcedures.add(callGraphNode2.getId());
            }
            this.visitChildren(callGraphNode2);
        }
    }

    private void labelNonLabeledNodesAsDead() {
        for (CallGraphNode callGraphNode : this.mCallGraph.values()) {
            if (callGraphNode.getLabel() != null) continue;
            callGraphNode.setLabel(CallGraphNodeLabel.DEAD);
        }
    }
}

