/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.backtranslation;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.VarMapKey;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.VarMapValue;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ExpressionBacktranslation
extends BoogieTransformer {
    private final Map<VarMapValue, VarMapKey> mReverseVarMap = new HashMap<VarMapValue, VarMapKey>();
    private Set<String> mActiveProcedures = Collections.emptySet();
    private boolean mProcessedExprWasActive = false;

    public void reverseAndAddMapping(Map<VarMapKey, VarMapValue> map) {
        for (Map.Entry<VarMapKey, VarMapValue> entry : map.entrySet()) {
            VarMapKey varMapKey;
            VarMapValue varMapValue = entry.getValue();
            VarMapKey varMapKey2 = this.mReverseVarMap.put(varMapValue, varMapKey = entry.getKey());
            if (varMapKey2 == null || varMapKey2.equals(varMapKey)) continue;
            VarMapKey varMapKey3 = ExpressionBacktranslation.combineDeclaration(varMapKey2, varMapKey);
            this.mReverseVarMap.put(varMapValue, varMapKey3);
        }
    }

    private static VarMapKey combineDeclaration(VarMapKey varMapKey, VarMapKey varMapKey2) {
        String string;
        String string2 = varMapKey.getDeclInfo().getProcedure();
        if (!Objects.equals(string2, string = varMapKey2.getDeclInfo().getProcedure())) {
            throw new AssertionError((Object)("Ambiguous translation mapping. Different procedure in DeclarationInformation: " + String.valueOf(varMapKey) + ", " + String.valueOf(varMapKey2)));
        }
        DeclarationInformation.StorageClass storageClass = varMapKey.getDeclInfo().getStorageClass();
        DeclarationInformation.StorageClass storageClass2 = varMapKey2.getDeclInfo().getStorageClass();
        if (storageClass == DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM && storageClass2 == DeclarationInformation.StorageClass.PROC_FUNC_INPARAM) {
            return varMapKey;
        }
        if (storageClass == DeclarationInformation.StorageClass.PROC_FUNC_INPARAM && storageClass2 == DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM) {
            return varMapKey2;
        }
        if (storageClass == DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM && storageClass2 == DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM) {
            return varMapKey;
        }
        if (storageClass == DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM && storageClass2 == DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM) {
            return varMapKey2;
        }
        throw new AssertionError((Object)("Ambiguous translation mapping. DeclarationInformations cannot be merged: " + String.valueOf(varMapKey) + ", " + String.valueOf(varMapKey2)));
    }

    public void setInlinedActiveProcedures(Set<String> set) {
        this.mActiveProcedures = set;
        this.mProcessedExprWasActive = false;
    }

    public Expression processExpression(Expression expression) {
        if (expression == null) {
            return null;
        }
        if (ExpressionBacktranslation.isDisguisedStruct(expression)) {
            return this.processDisguisedStruct((IdentifierExpression)expression);
        }
        if (expression instanceof IdentifierExpression) {
            IdentifierExpression identifierExpression = (IdentifierExpression)expression;
            ILocation iLocation = identifierExpression.getLocation();
            IBoogieType iBoogieType = identifierExpression.getType();
            VarMapKey varMapKey = this.mReverseVarMap.get(new VarMapValue(identifierExpression.getIdentifier(), identifierExpression.getDeclarationInformation()));
            if (varMapKey == null) {
                this.mProcessedExprWasActive = true;
                return expression;
            }
            DeclarationInformation declarationInformation = varMapKey.getDeclInfo();
            String string = varMapKey.getVarId();
            IdentifierExpression identifierExpression2 = new IdentifierExpression(iLocation, iBoogieType, string, declarationInformation);
            ModelUtils.copyAnnotations((IElement)expression, (IElement)identifierExpression2);
            if (varMapKey.getGlobalInOldExprOfProc() != null) {
                identifierExpression2 = new UnaryExpression(iLocation, iBoogieType, UnaryExpression.Operator.OLD, (Expression)identifierExpression2);
            }
            if (declarationInformation.getStorageClass() == DeclarationInformation.StorageClass.GLOBAL || declarationInformation.getStorageClass() == DeclarationInformation.StorageClass.QUANTIFIED || this.mActiveProcedures.contains(declarationInformation.getProcedure())) {
                this.mProcessedExprWasActive = true;
            }
            return identifierExpression2;
        }
        return super.processExpression(expression);
    }

    private static boolean isDisguisedStruct(Expression expression) {
        if (expression instanceof IdentifierExpression) {
            IdentifierExpression identifierExpression = (IdentifierExpression)expression;
            return identifierExpression.getIdentifier().contains("!");
        }
        return false;
    }

    private IdentifierExpression processDisguisedStruct(IdentifierExpression identifierExpression) {
        String[] stringArray = identifierExpression.getIdentifier().split("!", 2);
        assert (stringArray.length == 2) : "IdentifierExpression was no disguised struct: " + String.valueOf(identifierExpression);
        IdentifierExpression identifierExpression2 = new IdentifierExpression(identifierExpression.getLocation(), null, stringArray[0], identifierExpression.getDeclarationInformation());
        IdentifierExpression identifierExpression3 = (IdentifierExpression)this.processExpression((Expression)identifierExpression2);
        return new IdentifierExpression(identifierExpression3.getLocation(), identifierExpression.getType(), identifierExpression3.getIdentifier() + "!" + stringArray[1], identifierExpression3.getDeclarationInformation());
    }

    public boolean processedExprWasActive() {
        return this.mProcessedExprWasActive;
    }
}

