/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeature;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeatureExtractionTermClassifier;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class SMTFeatureExtractor {
    private final ILogger mLogger;
    private final List<SMTFeature> mFeatures;
    private final Path mDumpPath;
    private final Path mFilename;
    private final boolean mDumpFeatures;

    public SMTFeatureExtractor(ILogger iLogger, String string, boolean bl) {
        this.mLogger = iLogger;
        this.mFeatures = new ArrayList<SMTFeature>();
        this.mDumpFeatures = bl;
        if (bl) {
            this.mDumpPath = new File(string).toPath();
            String string2 = ZonedDateTime.now().format(DateTimeFormatter.ofPattern("uuuu-MM-dd"));
            this.mFilename = this.mDumpPath.resolve(string2 + "-smtfeatures.csv");
            this.createDumpFile();
        } else {
            this.mDumpPath = null;
            this.mFilename = null;
        }
    }

    public SMTFeature extractFeatureRaw(Term term) {
        SMTFeatureExtractionTermClassifier sMTFeatureExtractionTermClassifier = new SMTFeatureExtractionTermClassifier();
        sMTFeatureExtractionTermClassifier.checkTerm(term);
        SMTFeature sMTFeature = new SMTFeature();
        sMTFeature.containsArrays = sMTFeatureExtractionTermClassifier.hasArrays();
        sMTFeature.occuringFunctions = sMTFeatureExtractionTermClassifier.getOccuringFunctionNames();
        sMTFeature.occuringQuantifiers = sMTFeatureExtractionTermClassifier.getOccuringQuantifiers();
        sMTFeature.occuringSorts = sMTFeatureExtractionTermClassifier.getOccuringSortNames();
        sMTFeature.numberOfFunctions = sMTFeatureExtractionTermClassifier.getNumberOfFunctions();
        sMTFeature.numberOfQuantifiers = sMTFeatureExtractionTermClassifier.getNumberOfQuantifiers();
        sMTFeature.numberOfVariables = sMTFeatureExtractionTermClassifier.getNumberOfVariables();
        sMTFeature.numberOfArrays = sMTFeatureExtractionTermClassifier.getNumberOfArrays();
        sMTFeature.numberOfSelectFunctions = sMTFeatureExtractionTermClassifier.getOccuringFunctionNames().getOrDefault("select", 0);
        sMTFeature.numberOfStoreFunctions = sMTFeatureExtractionTermClassifier.getOccuringFunctionNames().getOrDefault("store", 0);
        sMTFeature.dagsize = sMTFeatureExtractionTermClassifier.getDAGSize();
        sMTFeature.dependencyScore = sMTFeatureExtractionTermClassifier.getDependencyScore();
        sMTFeature.variableEquivalenceClassSizes = sMTFeatureExtractionTermClassifier.getVariableEquivalenceClassSizes();
        sMTFeature.biggestEquivalenceClass = sMTFeatureExtractionTermClassifier.getBiggestEquivalenceClass();
        return sMTFeature;
    }

    public void extractFeature(List<Term> list, double d, String string, String string2) throws IllegalAccessException, IOException {
        SMTFeatureExtractionTermClassifier sMTFeatureExtractionTermClassifier = new SMTFeatureExtractionTermClassifier();
        for (Term sMTFeature2 : list) {
            sMTFeatureExtractionTermClassifier.checkTerm(sMTFeature2);
        }
        SMTFeature sMTFeature = new SMTFeature();
        sMTFeature.assertionStackHashCode = sMTFeatureExtractionTermClassifier.getAssertionStack().hashCode();
        sMTFeature.containsArrays = sMTFeatureExtractionTermClassifier.hasArrays();
        sMTFeature.occuringFunctions = sMTFeatureExtractionTermClassifier.getOccuringFunctionNames();
        sMTFeature.occuringQuantifiers = sMTFeatureExtractionTermClassifier.getOccuringQuantifiers();
        sMTFeature.occuringSorts = sMTFeatureExtractionTermClassifier.getOccuringSortNames();
        sMTFeature.numberOfFunctions = sMTFeatureExtractionTermClassifier.getNumberOfFunctions();
        sMTFeature.numberOfQuantifiers = sMTFeatureExtractionTermClassifier.getNumberOfQuantifiers();
        sMTFeature.numberOfVariables = sMTFeatureExtractionTermClassifier.getNumberOfVariables();
        sMTFeature.numberOfArrays = sMTFeatureExtractionTermClassifier.getNumberOfArrays();
        sMTFeature.dagsize = sMTFeatureExtractionTermClassifier.getDAGSize();
        sMTFeature.treesize = sMTFeatureExtractionTermClassifier.getTreeSize();
        sMTFeature.dependencyScore = sMTFeatureExtractionTermClassifier.getDependencyScore();
        sMTFeature.variableEquivalenceClassSizes = sMTFeatureExtractionTermClassifier.getVariableEquivalenceClassSizes();
        sMTFeature.biggestEquivalenceClass = sMTFeatureExtractionTermClassifier.getBiggestEquivalenceClass();
        sMTFeature.solverresult = string;
        sMTFeature.solvertime = d;
        sMTFeature.solvername = string2;
        this.mFeatures.add(sMTFeature);
        if (this.mDumpFeatures) {
            this.dumpFeature(sMTFeature);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dumpFeature(SMTFeature sMTFeature) throws IllegalAccessException, IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileWriter fileWriter = new FileWriter(this.mFilename.toString(), true);
                try {
                    block21: {
                        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                        try {
                            try (PrintWriter printWriter = new PrintWriter(bufferedWriter);){
                                if (this.mLogger.isDebugEnabled()) {
                                    this.mLogger.debug((Object)"################## SMT DUMP #####################");
                                    this.mLogger.debug((Object)("Writing to file:" + String.valueOf(this.mFilename)));
                                    this.mLogger.debug((Object)SMTFeature.getCsvHeader(";"));
                                    this.mLogger.debug((Object)("FEATURE: " + String.valueOf(sMTFeature)));
                                    this.mLogger.debug((Object)"#################################################");
                                }
                                printWriter.println(sMTFeature.toCsv(";"));
                            }
                            if (bufferedWriter == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (bufferedWriter == null) throw throwable;
                            bufferedWriter.close();
                            throw throwable;
                        }
                        bufferedWriter.close();
                    }
                    if (fileWriter == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fileWriter == null) throw throwable;
                    fileWriter.close();
                    throw throwable;
                }
                fileWriter.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createDumpFile() {
        File file = new File(this.mFilename.toString());
        if (file.exists()) return;
        try {
            file.createNewFile();
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try {
                    FileWriter fileWriter = new FileWriter(this.mFilename.toString(), true);
                    try {
                        block22: {
                            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                            try {
                                try (PrintWriter printWriter = new PrintWriter(bufferedWriter);){
                                    String string = SMTFeature.getCsvHeader(";");
                                    printWriter.println(string);
                                }
                                if (bufferedWriter == null) break block22;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (bufferedWriter == null) throw throwable;
                                bufferedWriter.close();
                                throw throwable;
                            }
                            bufferedWriter.close();
                        }
                        if (fileWriter == null) return;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (fileWriter == null) throw throwable;
                        fileWriter.close();
                        throw throwable;
                    }
                    fileWriter.close();
                    return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            catch (IOException | IllegalAccessException exception) {
                this.mLogger.error((Object)exception);
                return;
            }
        }
        catch (IOException iOException) {
            this.mLogger.error((Object)iOException);
        }
    }
}

