/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.rabin;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.rabin.Accepts;
import de.uni_freiburg.informatik.ultimate.automata.rabin.IRabinAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.rabin.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.rabin.RabinIntersectionWorstCaseOptimal;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiIntersectStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;

public class Intersection<LETTER, STATE, CRSF extends IBuchiIntersectStateFactory<STATE>>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final IRabinAutomaton<LETTER, STATE> mResult;
    private final IRabinAutomaton<LETTER, STATE> mFirst;
    private final IRabinAutomaton<LETTER, STATE> mSecond;

    public Intersection(AutomataLibraryServices automataLibraryServices, CRSF CRSF, IRabinAutomaton<LETTER, STATE> iRabinAutomaton, IRabinAutomaton<LETTER, STATE> iRabinAutomaton2) {
        super(automataLibraryServices);
        this.mResult = new RabinIntersectionWorstCaseOptimal<LETTER, STATE>(iRabinAutomaton, iRabinAutomaton2, CRSF);
        this.mFirst = iRabinAutomaton;
        this.mSecond = iRabinAutomaton2;
    }

    @Override
    public IRabinAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataOperationCanceledException {
        boolean bl = true;
        IsEmpty isEmpty = new IsEmpty(this.mServices, this.mResult);
        if (Boolean.FALSE.equals(isEmpty.getResult())) {
            bl = bl && new Accepts(this.mServices, this.mFirst, isEmpty.getCounterexample()).getResult() != false;
            bl = bl && new Accepts(this.mServices, this.mSecond, isEmpty.getCounterexample()).getResult() != false;
        }
        return bl;
    }
}

