/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.rabin;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.rabin.IRabinAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiIntersectStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class RabinIntersectionWorstCaseOptimal<LETTER, STATE>
implements IRabinAutomaton<LETTER, STATE> {
    private final IRabinAutomaton<LETTER, STATE> mFirstAutomaton;
    private final IRabinAutomaton<LETTER, STATE> mSecondAutomaton;
    private final IBuchiIntersectStateFactory<STATE> mFactory;
    private Set<STATE> mInitialStates;
    private final HashMap<STATE, Triple<STATE, STATE, Boolean>> mAutomatonMap = new HashMap();

    public RabinIntersectionWorstCaseOptimal(IRabinAutomaton<LETTER, STATE> iRabinAutomaton, IRabinAutomaton<LETTER, STATE> iRabinAutomaton2, IBuchiIntersectStateFactory<STATE> iBuchiIntersectStateFactory) {
        this.mFirstAutomaton = iRabinAutomaton;
        this.mSecondAutomaton = iRabinAutomaton2;
        this.mFactory = iBuchiIntersectStateFactory;
    }

    @Override
    public Set<LETTER> getAlphabet() {
        assert (this.mFirstAutomaton.getAlphabet().equals(this.mSecondAutomaton.getAlphabet()));
        return this.mFirstAutomaton.getAlphabet();
    }

    @Override
    public int size() {
        return this.mFirstAutomaton.size() * this.mSecondAutomaton.size() * 2;
    }

    @Override
    public String sizeInformation() {
        return "Number of states: " + this.size() + "\nThe number of lazyly constructed reachable states may be smaller";
    }

    private Set<STATE> constructInitialStates() {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (STATE STATE : this.mFirstAutomaton.getInitialStates()) {
            for (STATE STATE2 : this.mSecondAutomaton.getInitialStates()) {
                hashSet.add(this.getProducedState(STATE, STATE2, false));
            }
        }
        return hashSet;
    }

    @Override
    public Set<STATE> getInitialStates() {
        if (this.mInitialStates == null) {
            this.mInitialStates = this.constructInitialStates();
        }
        return this.mInitialStates;
    }

    @Override
    public boolean isAccepting(STATE STATE) {
        Triple<STATE, STATE, Boolean> triple = this.mAutomatonMap.get(STATE);
        return (Boolean)triple.getThird() == false && this.mFirstAutomaton.isAccepting(triple.getFirst());
    }

    @Override
    public boolean isFinite(STATE STATE) {
        Triple<STATE, STATE, Boolean> triple = this.mAutomatonMap.get(STATE);
        return this.mFirstAutomaton.isFinite(triple.getFirst()) || this.mSecondAutomaton.isFinite(triple.getSecond());
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> getSuccessors(STATE STATE) {
        Triple<STATE, STATE, Boolean> triple = this.mAutomatonMap.get(STATE);
        return this.getComponentalSuccessors(this.mFirstAutomaton.getSuccessors(triple.getFirst()), triple);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> getSuccessors(STATE STATE, LETTER LETTER) {
        Triple<STATE, STATE, Boolean> triple = this.mAutomatonMap.get(STATE);
        return this.getComponentalSuccessors(this.mFirstAutomaton.getSuccessors(triple.getFirst(), LETTER), triple);
    }

    private STATE getProducedState(STATE STATE, STATE STATE2, boolean bl) {
        STATE STATE3 = this.mFactory.intersectBuchi(STATE, STATE2, bl ? 1 : 2);
        this.mAutomatonMap.computeIfAbsent(STATE3, object3 -> new Triple(STATE, STATE2, (Object)bl));
        return STATE3;
    }

    private ArrayList<OutgoingInternalTransition<LETTER, STATE>> getRelatedSuccessors(Iterable<OutgoingInternalTransition<LETTER, STATE>> iterable, STATE STATE, boolean bl) {
        ArrayList<OutgoingInternalTransition<LETTER, STATE>> arrayList = new ArrayList<OutgoingInternalTransition<LETTER, STATE>>();
        for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iterable) {
            LETTER LETTER = outgoingInternalTransition.getLetter();
            for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition2 : this.mSecondAutomaton.getSuccessors(STATE, LETTER)) {
                arrayList.add(new OutgoingInternalTransition<LETTER, STATE>(LETTER, this.getProducedState(outgoingInternalTransition.getSucc(), outgoingInternalTransition2.getSucc(), bl)));
            }
        }
        return arrayList;
    }

    private ArrayList<OutgoingInternalTransition<LETTER, STATE>> getComponentalSuccessors(Iterable<OutgoingInternalTransition<LETTER, STATE>> iterable, Triple<STATE, STATE, Boolean> triple) {
        boolean bl = (Boolean)triple.getThird();
        if (bl) {
            if (this.mSecondAutomaton.isAccepting(triple.getSecond())) {
                bl = false;
            }
        } else if (this.mFirstAutomaton.isAccepting(triple.getFirst()) && !this.mSecondAutomaton.isAccepting(triple.getSecond())) {
            bl = true;
        }
        return this.getRelatedSuccessors(iterable, triple.getSecond(), bl);
    }
}

