/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class StrongVacuous {
    private final Set<Set<CDD>> mPossiblyVacuous = new HashSet<Set<CDD>>();
    private Set<CDD> mPossVacuous;
    private final Set<CDD> mPossibleVacuousMaker = new HashSet<CDD>();
    private final Set<Set<CDD>> mVacuous = new HashSet<Set<CDD>>();

    public void getVacuousAssignments(PhaseEventAutomata phaseEventAutomata) {
        List<Phase> list = phaseEventAutomata.getInit();
        int n = phaseEventAutomata.getPhases().size();
        if (n < 0) {
            System.out.println("ERROR: The pea is empty");
        }
        if (n == 1) {
            CDD cDD = phaseEventAutomata.getPhases().get(0).getStateInvariant();
            Iterator<CDD> iterator = this.getPossibleVacuousMakerIterator();
            while (iterator.hasNext()) {
                CDD cDD2 = iterator.next();
                if (cDD.implies(cDD2)) {
                    this.addToVacuous(cDD);
                    continue;
                }
                if (!cDD2.implies(cDD)) continue;
                this.addToVacuous(cDD2);
            }
            this.addToPossVacuousMaker(cDD);
        } else {
            int n2 = list.size();
            HashSet<CDD> hashSet = new HashSet<CDD>(n2);
            CDD cDD = CDD.TRUE;
            int n3 = 0;
            while (n3 < n2) {
                Phase phase = list.get(n3);
                if (phase.getClockInvariant() == CDD.TRUE) {
                    CDD cDD3 = phase.getStateInvariant();
                    hashSet.add(cDD3);
                    cDD = cDD.or(cDD3);
                }
                ++n3;
            }
            this.addToPossVacuous(cDD);
            this.addToPossiblyVacuous(hashSet);
        }
    }

    private void checkPossiblyVacuous(PhaseEventAutomata phaseEventAutomata) {
        List<Phase> list = phaseEventAutomata.getPhases();
        Set<Set<CDD>> set = this.getPossiblyVacuous();
        for (Set<CDD> set2 : set) {
            Iterator<CDD> iterator = set2.iterator();
            boolean bl = true;
            int n = 0;
            while (n < list.size() && bl) {
                boolean bl2 = false;
                Phase phase = list.get(n);
                CDD cDD = phase.getStateInvariant();
                while (iterator.hasNext() && !bl2) {
                    CDD cDD2 = iterator.next();
                    if (cDD.and(cDD2) == CDD.FALSE) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    bl = false;
                }
                ++n;
            }
            if (!bl) continue;
            this.addToVacuous(set2);
        }
    }

    private void checkPossibleVacuousMaker(PhaseEventAutomata phaseEventAutomata) {
        Set<CDD> set = this.getPossibleVacuousMaker();
        Set<Set<CDD>> set2 = this.getPossiblyVacuous();
        if (set.isEmpty() || set2.isEmpty()) {
            System.out.println("no possible vacuous formulas known OR no possible vacuous maker known");
        } else {
            boolean bl = false;
            Iterator<CDD> iterator = this.getPossibleVacuousMakerIterator();
            while (iterator.hasNext() && !bl) {
                CDD cDD = iterator.next();
                for (Set<CDD> set3 : set2) {
                    for (CDD cDD2 : set3) {
                        if (!cDD.implies(cDD2)) continue;
                        bl = true;
                        this.addToVacuous(cDD2);
                        this.addToVacuous(cDD);
                    }
                }
            }
        }
    }

    public void checkVacuousSatisfiability(PhaseEventAutomata phaseEventAutomata) {
        Set<Set<CDD>> set = this.getPossiblyVacuous();
        if (set.isEmpty()) {
            System.out.println("Before checking for vacuous satisfaction, you need to built-up the vacuous-vector");
        } else {
            this.checkPossiblyVacuous(phaseEventAutomata);
            this.checkPossibleVacuousMaker(phaseEventAutomata);
        }
    }

    public Set<Set<CDD>> getPossiblyVacuous() {
        return this.mPossiblyVacuous;
    }

    private void addToPossVacuousMaker(CDD cDD) {
        this.mPossibleVacuousMaker.add(cDD);
    }

    private void addToVacuous(Set<CDD> set) {
        this.mVacuous.add(set);
    }

    private void addToVacuous(CDD cDD) {
        HashSet<CDD> hashSet = new HashSet<CDD>(1);
        hashSet.add(cDD);
        this.mVacuous.add(hashSet);
    }

    private void addToPossiblyVacuous(Set<CDD> set) {
        this.mPossiblyVacuous.add(set);
    }

    public Set<CDD> getPossibleVacuousMaker() {
        return this.mPossibleVacuousMaker;
    }

    private Iterator<CDD> getPossibleVacuousMakerIterator() {
        return this.mPossibleVacuousMaker.iterator();
    }

    public Set<Set<CDD>> getVacuous() {
        return this.mVacuous;
    }

    private void addToPossVacuous(CDD cDD) {
        this.mPossVacuous.add(cDD);
    }
}

