/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermEquivalence;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FormulaLet
extends NonRecursive {
    private final ArrayList<Map<Term, TermInfo>> mVisited = new ArrayList();
    private final ArrayList<Set<TermVariable>> mScopes = new ArrayList();
    private final ArrayDeque<Term> mResultStack = new ArrayDeque();
    private int mCseNum;
    private final LetFilter mFilter;

    public FormulaLet() {
        this(null);
    }

    public FormulaLet(LetFilter letFilter) {
        this.mFilter = letFilter;
    }

    private int findScope(Term term) {
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = this.mScopes.size() - 1;
        while (n >= 0) {
            if (this.mScopes.get(n) == null) {
                return n;
            }
            TermVariable[] termVariableArray2 = termVariableArray;
            int n2 = termVariableArray.length;
            int n3 = 0;
            while (n3 < n2) {
                TermVariable termVariable = termVariableArray2[n3];
                if (this.mScopes.get(n).contains(termVariable)) {
                    return n;
                }
                ++n3;
            }
            --n;
        }
        throw new AssertionError((Object)"no scope");
    }

    public Term let(Term term) {
        term = new FormulaUnLet().unlet(term);
        this.mCseNum = 0;
        this.enqueueLetter(term);
        this.run();
        Term term2 = this.mResultStack.removeLast();
        assert (this.mResultStack.size() == 0 && this.mVisited.size() == 0);
        assert (new TermEquivalence().equal(new FormulaUnLet().unlet(term2), term));
        return term2;
    }

    public void enqueueLetter(Term term) {
        if (term instanceof TermVariable || term instanceof ConstantTerm) {
            this.mResultStack.addLast(term);
            return;
        }
        HashMap hashMap = new HashMap();
        this.mScopes.add(null);
        this.mVisited.add(hashMap);
        TermInfo termInfo = new TermInfo(term);
        this.enqueueWalker(new ScopeRemover());
        this.enqueueWalker(new Transformer(termInfo));
        this.enqueueWalker(new MarkLet(termInfo));
        this.enqueueWalker(new CollectInfo(term, termInfo));
    }

    private static boolean isNamed(AnnotatedTerm annotatedTerm) {
        return annotatedTerm.getAnnotations().length == 1 && annotatedTerm.getAnnotations()[0].getKey().equals(":named");
    }

    private static boolean isPattern(Term term) {
        if (term instanceof AnnotatedTerm) {
            AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
            Annotation[] annotationArray = annotatedTerm.getAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (!annotation.getKey().equals(":pattern")) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static boolean bindsVariable(Term term, Term term2) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(term.getFreeVars()));
        TermVariable[] termVariableArray = term2.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            if (!hashSet.contains(termVariable)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addTransformScope(TermVariable[] termVariableArray, Map<Term, TermInfo> map) {
        this.enqueueWalker(new ScopeRemover());
        this.mScopes.add(new HashSet<TermVariable>(Arrays.asList(termVariableArray)));
        this.mVisited.add(map);
    }

    public void visitChild(Term term) {
        if (term instanceof TermVariable || term instanceof ConstantTerm) {
            return;
        }
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getParameters().length == 0) {
            return;
        }
        Map<Term, TermInfo> map = this.mVisited.get(this.findScope(term));
        TermInfo termInfo = map.get(term);
        if (termInfo == null) {
            termInfo = new TermInfo(term);
            map.put(term, termInfo);
            this.enqueueWalker(new CollectInfo(term, termInfo));
        } else {
            ++termInfo.mCount;
        }
    }

    public Map<Term, TermInfo> newScope(TermVariable[] termVariableArray) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(termVariableArray));
        HashMap<Term, TermInfo> hashMap = new HashMap<Term, TermInfo>();
        this.mScopes.add(hashSet);
        this.mVisited.add(hashMap);
        this.enqueueWalker(new ScopeRemover());
        return hashMap;
    }

    static class AddParent
    implements NonRecursive.Walker {
        TermInfo mParent;
        Term mTerm;

        public AddParent(TermInfo termInfo, Term term) {
            this.mParent = termInfo;
            this.mTerm = term;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            Object object;
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            Term term = this.mTerm;
            Map<Term, TermInfo> map = formulaLet.mVisited.get(formulaLet.findScope(term));
            TermInfo termInfo = map.get(term);
            if (termInfo == null) {
                return;
            }
            if (termInfo.mParent == null) {
                termInfo.mParent = this.mParent;
                termInfo.mPDepth = this.mParent.mPDepth + 1;
                if (termInfo.mSubst == null && !(term instanceof LambdaTerm) && (formulaLet.mFilter == null || formulaLet.mFilter.isLettable(term)) && termInfo.shouldBuildLet()) {
                    object = termInfo.mTerm;
                    termInfo.mSubst = ((Term)object).getTheory().createTermVariable(".cse" + formulaLet.mCseNum++, ((Term)object).getSort());
                }
            }
            ++termInfo.mSeen;
            if (termInfo.mSeen == termInfo.mCount) {
                termInfo.mergeParent(this.mParent);
                if (termInfo.mSubst == null) {
                    formulaLet.enqueueWalker(new MarkLet(termInfo));
                } else {
                    object = termInfo.mParent;
                    TermInfo termInfo2 = object;
                    while (object != null && ((TermInfo)object).mSubst == null) {
                        if (((TermInfo)object).mParent != null && FormulaLet.bindsVariable(((TermInfo)object).mParent.mTerm, term)) break;
                        if (((TermInfo)object).mCount > 1) {
                            termInfo2 = ((TermInfo)object).mParent;
                        }
                        object = ((TermInfo)object).mParent;
                    }
                    termInfo2.mLettedTerms.getFirst().add(termInfo);
                }
            }
        }
    }

    public static class AddParentMatchCase
    implements NonRecursive.Walker {
        MatchTerm mTerm;
        TermInfo mInfo;
        int mCaseNr;

        public AddParentMatchCase(MatchTerm matchTerm, TermInfo termInfo, int n) {
            this.mTerm = matchTerm;
            this.mInfo = termInfo;
            this.mCaseNr = n;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            formulaLet.addTransformScope(this.mTerm.getVariables()[this.mCaseNr], this.mInfo.mScopes[this.mCaseNr]);
            formulaLet.enqueueWalker(new AddParent(this.mInfo, this.mTerm.getCases()[this.mCaseNr]));
        }
    }

    static class BuildAnnotatedTerm
    implements NonRecursive.Walker {
        final AnnotatedTerm mOldTerm;

        public BuildAnnotatedTerm(AnnotatedTerm annotatedTerm) {
            this.mOldTerm = annotatedTerm;
        }

        private Object retrieveValue(FormulaLet formulaLet, Object object) {
            if (object instanceof Term) {
                return formulaLet.mResultStack.removeLast();
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n = objectArray.length - 1;
                while (n >= 0) {
                    Object object2 = objectArray[n];
                    Object object3 = this.retrieveValue(formulaLet, object2);
                    if (object2 != object3) {
                        if (objectArray == object) {
                            objectArray = (Object[])objectArray.clone();
                        }
                        objectArray[n] = object3;
                    }
                    --n;
                }
                return objectArray;
            }
            return object;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            Annotation[] annotationArray;
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            Term term = this.mOldTerm;
            Term term2 = formulaLet.mResultStack.removeLast();
            Annotation[] annotationArray2 = annotationArray = this.mOldTerm.getAnnotations();
            int n = annotationArray.length - 1;
            while (n >= 0) {
                Object object = annotationArray[n].getValue();
                Object object2 = this.retrieveValue(formulaLet, object);
                if (object2 != object) {
                    if (annotationArray2 == annotationArray) {
                        annotationArray2 = (Annotation[])annotationArray.clone();
                    }
                    annotationArray2[n] = new Annotation(annotationArray[n].getKey(), object2);
                }
                --n;
            }
            if (term2 != this.mOldTerm.getSubterm() || annotationArray2 != annotationArray) {
                Theory theory = this.mOldTerm.getTheory();
                term = theory.annotatedTerm(annotationArray2, term2);
            }
            formulaLet.mResultStack.addLast(term);
        }
    }

    static class BuildApplicationTerm
    implements NonRecursive.Walker {
        final ApplicationTerm mOldTerm;

        public BuildApplicationTerm(ApplicationTerm applicationTerm) {
            this.mOldTerm = applicationTerm;
        }

        public Term[] getTerms(FormulaLet formulaLet, Term[] termArray) {
            Term[] termArray2 = termArray;
            int n = termArray.length - 1;
            while (n >= 0) {
                Term term = formulaLet.mResultStack.removeLast();
                if (term != termArray[n]) {
                    if (termArray2 == termArray) {
                        termArray2 = (Term[])termArray.clone();
                    }
                    termArray2[n] = term;
                }
                --n;
            }
            return termArray2;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            Term[] termArray = this.getTerms(formulaLet, this.mOldTerm.getParameters());
            Term term = this.mOldTerm;
            if (termArray != this.mOldTerm.getParameters()) {
                Theory theory = this.mOldTerm.getTheory();
                term = theory.term(this.mOldTerm.getFunction(), termArray);
            }
            formulaLet.mResultStack.addLast(term);
        }
    }

    static class BuildLambda
    implements NonRecursive.Walker {
        final LambdaTerm mOldTerm;

        public BuildLambda(LambdaTerm lambdaTerm) {
            this.mOldTerm = lambdaTerm;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            Term term = formulaLet.mResultStack.removeLast();
            Term term2 = this.mOldTerm;
            if (term != this.mOldTerm.getSubterm()) {
                Theory theory = this.mOldTerm.getTheory();
                term2 = theory.lambda(this.mOldTerm.getVariables(), term);
            }
            formulaLet.mResultStack.addLast(term2);
        }
    }

    static class BuildLetTerm
    implements NonRecursive.Walker {
        final TermVariable[] mVars;

        public BuildLetTerm(TermVariable[] termVariableArray) {
            this.mVars = termVariableArray;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            Term[] termArray = new Term[this.mVars.length];
            int n = 0;
            while (n < termArray.length) {
                termArray[n] = formulaLet.mResultStack.removeLast();
                ++n;
            }
            Term term = formulaLet.mResultStack.removeLast();
            Theory theory = term.getTheory();
            Term term2 = theory.let(this.mVars, termArray, term);
            formulaLet.mResultStack.addLast(term2);
        }
    }

    static class BuildMatchTerm
    implements NonRecursive.Walker {
        final MatchTerm mOldTerm;

        public BuildMatchTerm(MatchTerm matchTerm) {
            this.mOldTerm = matchTerm;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            Term term;
            Term[] termArray;
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            Term[] termArray2 = termArray = this.mOldTerm.getCases();
            int n = termArray.length - 1;
            while (n >= 0) {
                term = formulaLet.mResultStack.removeLast();
                if (term != termArray[n]) {
                    if (termArray2 == termArray) {
                        termArray2 = (Term[])termArray.clone();
                    }
                    termArray2[n] = term;
                }
                --n;
            }
            Term term2 = formulaLet.mResultStack.removeLast();
            term = this.mOldTerm;
            if (term2 != this.mOldTerm.getDataTerm() || termArray2 != termArray) {
                Theory theory = this.mOldTerm.getTheory();
                term = theory.match(term2, this.mOldTerm.getVariables(), termArray2, this.mOldTerm.getConstructors());
            }
            formulaLet.mResultStack.addLast(term);
        }
    }

    static class BuildQuantifier
    implements NonRecursive.Walker {
        final QuantifiedFormula mOldTerm;

        public BuildQuantifier(QuantifiedFormula quantifiedFormula) {
            this.mOldTerm = quantifiedFormula;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            Term term = formulaLet.mResultStack.removeLast();
            Term term2 = this.mOldTerm;
            if (term != this.mOldTerm.getSubformula()) {
                Theory theory = this.mOldTerm.getTheory();
                term2 = this.mOldTerm.getQuantifier() == 0 ? theory.exists(this.mOldTerm.getVariables(), term) : theory.forall(this.mOldTerm.getVariables(), term);
            }
            formulaLet.mResultStack.addLast(term2);
        }
    }

    public static class CollectInfo
    implements NonRecursive.Walker {
        Term mTerm;
        TermInfo mInfo;

        public CollectInfo(Term term, TermInfo termInfo) {
            this.mTerm = term;
            this.mInfo = termInfo;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            if (this.mTerm instanceof AnnotatedTerm) {
                AnnotatedTerm annotatedTerm = (AnnotatedTerm)this.mTerm;
                if (!FormulaLet.isNamed(annotatedTerm)) {
                    Annotation annotation;
                    formulaLet.visitChild(annotatedTerm.getSubterm());
                    ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
                    Annotation[] annotationArray = annotatedTerm.getAnnotations();
                    int n = annotationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        annotation = annotationArray[n2];
                        if (annotation.getValue() != null) {
                            arrayDeque.add(annotation.getValue());
                        }
                        ++n2;
                    }
                    while (!arrayDeque.isEmpty()) {
                        annotation = arrayDeque.removeLast();
                        if (annotation instanceof Term) {
                            formulaLet.visitChild((Term)((Object)annotation));
                            continue;
                        }
                        if (!(annotation instanceof Object[])) continue;
                        Object[] objectArray = (Object[])annotation;
                        int n3 = objectArray.length;
                        n = 0;
                        while (n < n3) {
                            Object object = objectArray[n];
                            arrayDeque.add(object);
                            ++n;
                        }
                    }
                }
            } else if (this.mTerm instanceof ApplicationTerm) {
                Term[] termArray;
                ApplicationTerm applicationTerm = (ApplicationTerm)this.mTerm;
                Term[] termArray2 = termArray = applicationTerm.getParameters();
                int n = termArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Term term = termArray2[n4];
                    formulaLet.visitChild(term);
                    ++n4;
                }
            } else if (this.mTerm instanceof LambdaTerm) {
                LambdaTerm lambdaTerm = (LambdaTerm)this.mTerm;
                this.mInfo.mScopes = new Map[]{formulaLet.newScope(lambdaTerm.getVariables())};
                formulaLet.visitChild(lambdaTerm.getSubterm());
            } else if (this.mTerm instanceof QuantifiedFormula) {
                QuantifiedFormula quantifiedFormula = (QuantifiedFormula)this.mTerm;
                this.mInfo.mScopes = new Map[]{formulaLet.newScope(quantifiedFormula.getVariables())};
                if (FormulaLet.isPattern(quantifiedFormula.getSubformula())) {
                    formulaLet.visitChild(((AnnotatedTerm)quantifiedFormula.getSubformula()).getSubterm());
                } else {
                    formulaLet.visitChild(quantifiedFormula.getSubformula());
                }
            } else if (this.mTerm instanceof MatchTerm) {
                MatchTerm matchTerm = (MatchTerm)this.mTerm;
                int n = matchTerm.getCases().length;
                this.mInfo.mScopes = new Map[n];
                int n5 = n - 1;
                while (n5 >= 0) {
                    formulaLet.enqueueWalker(new CollectMatchCase(matchTerm, this.mInfo, n5));
                    --n5;
                }
                formulaLet.visitChild(matchTerm.getDataTerm());
            } else {
                throw new AssertionError();
            }
        }
    }

    static class CollectLets
    implements NonRecursive.Walker {
        final TermInfo mTermInfo;

        public CollectLets(TermInfo termInfo) {
            this.mTermInfo = termInfo;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            List list = this.mTermInfo.mLettedTerms.getFirst();
            if (list.isEmpty()) {
                this.mTermInfo.mLettedTerms.removeFirst();
                return;
            }
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            formulaLet.enqueueWalker(this);
            this.mTermInfo.mLettedTerms.addFirst(new ArrayList());
            for (TermInfo termInfo : list) {
                formulaLet.enqueueWalker(new MarkLet(termInfo));
            }
        }
    }

    public static class CollectMatchCase
    implements NonRecursive.Walker {
        MatchTerm mTerm;
        TermInfo mInfo;
        int mCaseNr;

        public CollectMatchCase(MatchTerm matchTerm, TermInfo termInfo, int n) {
            this.mTerm = matchTerm;
            this.mInfo = termInfo;
            this.mCaseNr = n;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            this.mInfo.mScopes[this.mCaseNr] = formulaLet.newScope(this.mTerm.getVariables()[this.mCaseNr]);
            formulaLet.visitChild(this.mTerm.getCases()[this.mCaseNr]);
        }
    }

    static class Converter
    implements NonRecursive.Walker {
        Term mTerm;

        public Converter(Term term) {
            this.mTerm = term;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            Term term = this.mTerm;
            Map<Term, TermInfo> map = formulaLet.mVisited.get(formulaLet.findScope(term));
            TermInfo termInfo = map.get(term);
            if (termInfo == null) {
                formulaLet.mResultStack.addLast(term);
            } else if (termInfo.mSubst != null) {
                formulaLet.mResultStack.addLast(termInfo.mSubst);
            } else {
                formulaLet.enqueueWalker(new Transformer(termInfo));
            }
        }
    }

    public static interface LetFilter {
        public boolean isLettable(Term var1);
    }

    static class MarkLet
    implements NonRecursive.Walker {
        TermInfo mTermInfo;

        public MarkLet(TermInfo termInfo) {
            this.mTermInfo = termInfo;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            Term term = this.mTermInfo.mTerm;
            this.mTermInfo.mLettedTerms = new ArrayDeque();
            this.mTermInfo.mLettedTerms.addFirst(new ArrayList());
            formulaLet.enqueueWalker(new CollectLets(this.mTermInfo));
            if (term instanceof LambdaTerm) {
                LambdaTerm lambdaTerm = (LambdaTerm)term;
                formulaLet.addTransformScope(lambdaTerm.getVariables(), this.mTermInfo.mScopes[0]);
                formulaLet.enqueueWalker(new AddParent(this.mTermInfo, lambdaTerm.getSubterm()));
            } else if (term instanceof QuantifiedFormula) {
                QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
                if (FormulaLet.isPattern(quantifiedFormula.getSubformula())) {
                    AnnotatedTerm annotatedTerm = (AnnotatedTerm)quantifiedFormula.getSubformula();
                    formulaLet.addTransformScope(quantifiedFormula.getVariables(), this.mTermInfo.mScopes[0]);
                    formulaLet.enqueueWalker(new AddParent(this.mTermInfo, annotatedTerm.getSubterm()));
                } else {
                    formulaLet.addTransformScope(quantifiedFormula.getVariables(), this.mTermInfo.mScopes[0]);
                    formulaLet.enqueueWalker(new AddParent(this.mTermInfo, quantifiedFormula.getSubformula()));
                }
            } else if (term instanceof AnnotatedTerm) {
                AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
                if (!FormulaLet.isNamed(annotatedTerm)) {
                    Annotation annotation;
                    formulaLet.enqueueWalker(new AddParent(this.mTermInfo, annotatedTerm.getSubterm()));
                    ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
                    Annotation[] annotationArray = annotatedTerm.getAnnotations();
                    int n = annotationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        annotation = annotationArray[n2];
                        if (annotation.getValue() != null) {
                            arrayDeque.add(annotation.getValue());
                        }
                        ++n2;
                    }
                    while (!arrayDeque.isEmpty()) {
                        annotation = arrayDeque.removeLast();
                        if (annotation instanceof Term) {
                            formulaLet.enqueueWalker(new AddParent(this.mTermInfo, (Term)((Object)annotation)));
                            continue;
                        }
                        if (!(annotation instanceof Object[])) continue;
                        Object[] objectArray = (Object[])annotation;
                        int n3 = objectArray.length;
                        n = 0;
                        while (n < n3) {
                            Object object = objectArray[n];
                            arrayDeque.add(object);
                            ++n;
                        }
                    }
                }
            } else if (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                Term[] termArray = applicationTerm.getParameters();
                int n = termArray.length - 1;
                while (n >= 0) {
                    formulaLet.enqueueWalker(new AddParent(this.mTermInfo, termArray[n]));
                    --n;
                }
            } else if (term instanceof MatchTerm) {
                MatchTerm matchTerm = (MatchTerm)term;
                Term[] termArray = matchTerm.getCases();
                int n = termArray.length - 1;
                while (n >= 0) {
                    formulaLet.enqueueWalker(new AddParentMatchCase(matchTerm, this.mTermInfo, n));
                    --n;
                }
                formulaLet.enqueueWalker(new AddParent(this.mTermInfo, matchTerm.getDataTerm()));
            } else {
                formulaLet.mResultStack.addLast(term);
            }
        }
    }

    public static final class ScopeRemover
    implements NonRecursive.Walker {
        @Override
        public void walk(NonRecursive nonRecursive) {
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            int n = formulaLet.mScopes.size() - 1;
            formulaLet.mScopes.remove(n);
            formulaLet.mVisited.remove(n);
        }
    }

    private static final class TermInfo {
        final Term mTerm;
        int mCount;
        int mSeen;
        ArrayDeque<ArrayList<TermInfo>> mLettedTerms;
        TermVariable mSubst;
        TermInfo mParent;
        int mPDepth;
        Map<Term, TermInfo>[] mScopes;

        public TermInfo(Term term) {
            this.mTerm = term;
            this.mCount = 1;
        }

        public boolean shouldBuildLet() {
            TermInfo termInfo = this;
            while (termInfo.mCount == 1) {
                termInfo = termInfo.mParent;
                if (termInfo == null) {
                    return false;
                }
                if (FormulaLet.bindsVariable(termInfo.mTerm, this.mTerm)) {
                    return false;
                }
                if (termInfo.mSubst == null) continue;
                return false;
            }
            return true;
        }

        /*
         * Unable to fully structure code
         */
        public void mergeParent(TermInfo var1_1) {
            if (this.mParent != null) ** GOTO lbl13
            this.mParent = var1_1;
            this.mPDepth = var1_1.mPDepth + 1;
            return;
lbl-1000:
            // 1 sources

            {
                if (var1_1.mPDepth == this.mParent.mPDepth) {
                    var1_1 = var1_1.mParent;
                    this.mParent = this.mParent.mParent;
                    continue;
                }
                if (var1_1.mPDepth > this.mParent.mPDepth) {
                    var1_1 = var1_1.mParent;
                    continue;
                }
                this.mParent = this.mParent.mParent;
lbl13:
                // 4 sources

                ** while (this.mParent != var1_1)
            }
lbl14:
            // 1 sources

            this.mPDepth = this.mParent.mPDepth + 1;
        }
    }

    public static class TransformMatchCase
    implements NonRecursive.Walker {
        MatchTerm mTerm;
        TermInfo mInfo;
        int mCaseNr;

        public TransformMatchCase(MatchTerm matchTerm, TermInfo termInfo, int n) {
            this.mTerm = matchTerm;
            this.mInfo = termInfo;
            this.mCaseNr = n;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            formulaLet.addTransformScope(this.mTerm.getVariables()[this.mCaseNr], this.mInfo.mScopes[this.mCaseNr]);
            formulaLet.enqueueWalker(new Converter(this.mTerm.getCases()[this.mCaseNr]));
        }
    }

    static class Transformer
    implements NonRecursive.Walker {
        TermInfo mTermInfo;

        public Transformer(TermInfo termInfo) {
            this.mTermInfo = termInfo;
        }

        public void enqueueBuildLetTerms(FormulaLet formulaLet) {
            for (ArrayList<TermInfo> arrayList : this.mTermInfo.mLettedTerms) {
                assert (!arrayList.isEmpty());
                TermVariable[] termVariableArray = new TermVariable[arrayList.size()];
                formulaLet.enqueueWalker(new BuildLetTerm(termVariableArray));
                int n = 0;
                for (TermInfo termInfo : arrayList) {
                    assert (termInfo.mSubst != null);
                    termVariableArray[n++] = termInfo.mSubst;
                    formulaLet.enqueueWalker(new Transformer(termInfo));
                }
            }
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            FormulaLet formulaLet = (FormulaLet)nonRecursive;
            Term term = this.mTermInfo.mTerm;
            this.enqueueBuildLetTerms(formulaLet);
            if (term instanceof LambdaTerm) {
                LambdaTerm lambdaTerm = (LambdaTerm)term;
                formulaLet.enqueueWalker(new BuildLambda(lambdaTerm));
                formulaLet.addTransformScope(lambdaTerm.getVariables(), this.mTermInfo.mScopes[0]);
                formulaLet.enqueueWalker(new Converter(lambdaTerm.getSubterm()));
            } else if (term instanceof QuantifiedFormula) {
                QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
                formulaLet.enqueueWalker(new BuildQuantifier(quantifiedFormula));
                if (FormulaLet.isPattern(quantifiedFormula.getSubformula())) {
                    Annotation annotation;
                    AnnotatedTerm annotatedTerm = (AnnotatedTerm)quantifiedFormula.getSubformula();
                    formulaLet.enqueueWalker(new BuildAnnotatedTerm(annotatedTerm));
                    formulaLet.addTransformScope(quantifiedFormula.getVariables(), this.mTermInfo.mScopes[0]);
                    formulaLet.enqueueWalker(new Converter(annotatedTerm.getSubterm()));
                    ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
                    Annotation[] annotationArray = annotatedTerm.getAnnotations();
                    int n = annotationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        annotation = annotationArray[n2];
                        if (annotation.getValue() != null) {
                            arrayDeque.add(annotation.getValue());
                        }
                        ++n2;
                    }
                    while (!arrayDeque.isEmpty()) {
                        annotation = arrayDeque.removeFirst();
                        if (annotation instanceof Term) {
                            formulaLet.mResultStack.addLast((Term)((Object)annotation));
                            continue;
                        }
                        if (!(annotation instanceof Object[])) continue;
                        Object[] objectArray = (Object[])annotation;
                        int n3 = objectArray.length;
                        n = 0;
                        while (n < n3) {
                            Object object = objectArray[n];
                            arrayDeque.add(object);
                            ++n;
                        }
                    }
                } else {
                    formulaLet.addTransformScope(quantifiedFormula.getVariables(), this.mTermInfo.mScopes[0]);
                    formulaLet.enqueueWalker(new Converter(quantifiedFormula.getSubformula()));
                }
            } else if (term instanceof AnnotatedTerm) {
                AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
                formulaLet.enqueueWalker(new BuildAnnotatedTerm(annotatedTerm));
                if (FormulaLet.isNamed(annotatedTerm)) {
                    formulaLet.enqueueLetter(annotatedTerm.getSubterm());
                } else {
                    Annotation annotation;
                    formulaLet.enqueueWalker(new Converter(annotatedTerm.getSubterm()));
                    ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
                    Annotation[] annotationArray = annotatedTerm.getAnnotations();
                    int n = annotationArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        annotation = annotationArray[n4];
                        if (annotation.getValue() != null) {
                            arrayDeque.add(annotation.getValue());
                        }
                        ++n4;
                    }
                    while (!arrayDeque.isEmpty()) {
                        annotation = arrayDeque.removeLast();
                        if (annotation instanceof Term) {
                            formulaLet.enqueueWalker(new Converter((Term)((Object)annotation)));
                            continue;
                        }
                        if (!(annotation instanceof Object[])) continue;
                        Object[] objectArray = (Object[])annotation;
                        int n5 = objectArray.length;
                        n = 0;
                        while (n < n5) {
                            Object object = objectArray[n];
                            arrayDeque.add(object);
                            ++n;
                        }
                    }
                }
            } else if (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                formulaLet.enqueueWalker(new BuildApplicationTerm(applicationTerm));
                Term[] termArray = applicationTerm.getParameters();
                int n = termArray.length - 1;
                while (n >= 0) {
                    formulaLet.enqueueWalker(new Converter(termArray[n]));
                    --n;
                }
            } else if (term instanceof MatchTerm) {
                MatchTerm matchTerm = (MatchTerm)term;
                formulaLet.enqueueWalker(new BuildMatchTerm(matchTerm));
                Term[] termArray = matchTerm.getCases();
                int n = termArray.length - 1;
                while (n >= 0) {
                    formulaLet.enqueueWalker(new TransformMatchCase(matchTerm, this.mTermInfo, n));
                    --n;
                }
                formulaLet.enqueueWalker(new Converter(matchTerm.getDataTerm()));
            } else {
                formulaLet.mResultStack.addLast(term);
            }
        }
    }
}

