/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.List;
import java.util.function.Predicate;

public final class SizeOfExpression
extends Expression {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(SizeOfExpression.class);
    Expression expression;
    ACSLType logicType;

    public SizeOfExpression() {
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid SizeOfExpression: " + String.valueOf(this);
    }

    public SizeOfExpression(ACSLType aCSLType, Expression expression, ACSLType aCSLType2) {
        super(aCSLType);
        this.expression = expression;
        this.logicType = aCSLType2;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid SizeOfExpression: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SizeOfExpression").append('[');
        stringBuffer.append(this.expression);
        stringBuffer.append(',').append(this.logicType);
        return stringBuffer.append(']').toString();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public ACSLType getLogicType() {
        return this.logicType;
    }

    public void setLogicType(ACSLType aCSLType) {
        this.logicType = aCSLType;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.expression);
        list.add(this.logicType);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((Expression)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            if (this.expression != null) {
                this.expression.accept(aCSLVisitor);
            }
            if (this.logicType != null) {
                this.logicType.accept(aCSLVisitor);
            }
            if (this.type != null) {
                this.type.accept(aCSLVisitor);
            }
        }
    }

    @Override
    public Expression accept(ACSLTransformer aCSLTransformer) {
        Expression expression = aCSLTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        Expression expression2 = null;
        if (this.expression != null) {
            expression2 = this.expression.accept(aCSLTransformer);
        }
        ACSLType aCSLType = null;
        if (this.logicType != null) {
            aCSLType = this.logicType.accept(aCSLTransformer);
        }
        ACSLType aCSLType2 = null;
        if (this.type != null) {
            aCSLType2 = this.type.accept(aCSLTransformer);
        }
        if (this.expression != expression2 || this.logicType != aCSLType || this.type != aCSLType2) {
            return new SizeOfExpression(aCSLType2, expression2, aCSLType);
        }
        return this;
    }
}

