/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryNumericRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.ExplicitLhsPolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SolveForSubjectUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class XnfTir
extends XjunctPartialQuantifierElimination {
    public XnfTir(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        super(managedScript, iUltimateServiceProvider);
    }

    @Override
    public String getName() {
        return "transitive inequality resolution";
    }

    @Override
    public String getAcronym() {
        return "TIR";
    }

    @Override
    public boolean resultIsXjunction() {
        return false;
    }

    @Override
    public Term[] tryToEliminate(int n, Term[] termArray, Set<TermVariable> set) {
        TermVariable termVariable;
        Object object;
        Term term = QuantifierUtils.applyDualFiniteConnective(this.mScript, n, Arrays.asList(termArray));
        Object object2 = new ArrayList<Term>(Arrays.asList(term));
        Iterator<TermVariable> iterator = set.iterator();
        while (iterator.hasNext()) {
            object = new ArrayList();
            termVariable = iterator.next();
            if (!termVariable.getSort().isNumericSort()) {
                object = object2;
                continue;
            }
            boolean bl = false;
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                Term term2 = (Term)iterator2.next();
                List<Term> list = this.tryToEliminateSingleDisjuct(n, term2, termVariable, set);
                if (list == null) {
                    bl = true;
                    object.add(term2);
                    continue;
                }
                object.addAll(list);
            }
            if (!bl) {
                iterator.remove();
            }
            object2 = object;
        }
        object = object2.toArray(new Term[object2.size()]);
        termVariable = QuantifierUtils.applyCorrespondingFiniteConnective(this.mScript, n, (Term[])object);
        return new Term[]{termVariable};
    }

    private List<Term> tryToEliminateSingleDisjuct(int n, Term term, TermVariable termVariable, Set<TermVariable> set) {
        Term term2;
        Term term3 = XnfTir.tryToEliminateConjuncts(this.mServices, this.mScript, n, term, termVariable, set);
        if (term3 == null) {
            return null;
        }
        if (n == 0) {
            term2 = SmtUtils.toDnf(this.mServices, this.mMgdScript, term3);
        } else if (n == 1) {
            term2 = SmtUtils.toCnf(this.mServices, this.mMgdScript, term3);
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        assert (!Arrays.asList(term2.getFreeVars()).contains(termVariable)) : "not eliminated";
        SmtUtils.ExtendedSimplificationResult extendedSimplificationResult = SmtUtils.simplifyWithStatistics(this.mMgdScript, term3, this.mServices, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        term2 = extendedSimplificationResult.getSimplifiedTerm();
        List<Term> list = Arrays.asList(QuantifierUtils.getCorrespondingFiniteJuncts(n, term2));
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public static Term tryToEliminateConjuncts(IUltimateServiceProvider iUltimateServiceProvider, Script script, int n, Term term, TermVariable termVariable, Set<TermVariable> set) {
        Object object;
        Term[] termArray = QuantifierUtils.getDualFiniteJuncts(n, term);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Bound> arrayList2 = new ArrayList<Bound>();
        ArrayList<Bound> arrayList3 = new ArrayList<Bound>();
        ArrayList<Pair<Term, Term>> arrayList4 = new ArrayList<Pair<Term, Term>>();
        Term[] termArray2 = termArray;
        int n2 = termArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = termArray2[n3];
            if (!Arrays.asList(object.getFreeVars()).contains(termVariable)) {
                arrayList.add(object);
            } else {
                boolean bl;
                Pair<ExplicitLhsPolynomialRelation, Term> pair;
                ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation;
                void object2;
                if (n == 0) {
                    PolynomialRelation.TransformInequality transformInequality = PolynomialRelation.TransformInequality.STRICT2NONSTRICT;
                } else if (n == 1) {
                    PolynomialRelation.TransformInequality transformInequality = PolynomialRelation.TransformInequality.NONSTRICT2STRICT;
                } else {
                    throw new AssertionError((Object)"unknown quantifier");
                }
                PolynomialRelation polynomialRelation = PolynomialRelation.of(script, (Term)object, (PolynomialRelation.TransformInequality)object2);
                if (polynomialRelation == null) {
                    return null;
                }
                if (!polynomialRelation.isVariable((Term)termVariable)) {
                    return null;
                }
                SolvedBinaryRelation solvedBinaryRelation = polynomialRelation.solveForSubject(script, (Term)termVariable);
                if (solvedBinaryRelation == null) {
                    explicitLhsPolynomialRelation = ExplicitLhsPolynomialRelation.moveMonomialToLhs(script, (Term)termVariable, polynomialRelation);
                    if (explicitLhsPolynomialRelation == null) {
                        return null;
                    }
                    if (!SmtSortUtils.isIntSort(termVariable.getSort())) {
                        return null;
                    }
                    pair = explicitLhsPolynomialRelation.divideByIntegerCoefficient(script, set);
                    if (pair == null) {
                        return null;
                    }
                    ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation2 = (ExplicitLhsPolynomialRelation)pair.getFirst();
                    if (!explicitLhsPolynomialRelation2.getLhsMonomial().isLinear()) {
                        return null;
                    }
                    solvedBinaryRelation = new SolvedBinaryRelation(explicitLhsPolynomialRelation2.getLhsMonomial().getSingleVariable(), explicitLhsPolynomialRelation2.getRhs().toTerm(script), explicitLhsPolynomialRelation2.getRelationSymbol(), MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT);
                    bl = true;
                } else {
                    bl = false;
                }
                if (SolveForSubjectUtils.isVariableDivCaptured(solvedBinaryRelation, set)) {
                    throw new AssertionError((Object)"should not be possible to divCapture here");
                }
                explicitLhsPolynomialRelation = solvedBinaryRelation.toTerm(script);
                pair = BinaryNumericRelation.convert((Term)explicitLhsPolynomialRelation);
                switch (pair.getRelationSymbol()) {
                    case DISTINCT: {
                        if (n == 0) {
                            if (bl) {
                                arrayList4.add(XnfTir.antiDerWithAssumption(script, 0, (Term)object, (Term)termVariable));
                                break;
                            }
                            arrayList4.add((Pair<Term, Term>)new Pair((Object)pair.getRhs(), (Object)pair.getRhs()));
                            break;
                        }
                        assert (XnfTir.occursInsideSelectTerm(script, (Term)object, termVariable)) : "should have been removed by DER";
                        throw new AssertionError((Object)"should have been removed by DER");
                    }
                    case EQ: {
                        if (n == 1) {
                            if (bl) {
                                arrayList4.add(XnfTir.antiDerWithAssumption(script, 1, (Term)object, (Term)termVariable));
                                break;
                            }
                            arrayList4.add((Pair<Term, Term>)new Pair((Object)pair.getRhs(), (Object)pair.getRhs()));
                            break;
                        }
                        assert (XnfTir.occursInsideSelectTerm(script, (Term)object, termVariable)) : "should have been removed by DER";
                        throw new AssertionError((Object)"should have been removed by DER");
                    }
                    case GEQ: {
                        arrayList3.add(new Bound(false, pair.getRhs()));
                        break;
                    }
                    case GREATER: {
                        arrayList3.add(new Bound(true, pair.getRhs()));
                        break;
                    }
                    case LEQ: {
                        arrayList2.add(new Bound(false, pair.getRhs()));
                        break;
                    }
                    case LESS: {
                        arrayList2.add(new Bound(true, pair.getRhs()));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            ++n3;
        }
        object = new AntiDerBuildingInstructions(iUltimateServiceProvider, script, n, arrayList2, arrayList3, arrayList4);
        ArrayList<Term> arrayList5 = new ArrayList<Term>();
        for (Bound bound : arrayList3) {
            for (Bound bound2 : arrayList2) {
                arrayList5.add(XnfTir.buildInequality(script, n, bound, bound2));
                if (iUltimateServiceProvider.getProgressMonitorService().continueProcessing()) continue;
                throw new ToolchainCanceledException(XnfTir.class, "building " + arrayList3.size() * arrayList2.size() + " inequalities");
            }
        }
        arrayList5.addAll(arrayList);
        if (!arrayList4.isEmpty()) {
            arrayList5.add(((AntiDerBuildingInstructions)object).buildCorrespondingFiniteJunction());
        }
        Term term2 = QuantifierUtils.applyDualFiniteConnective(script, n, arrayList5);
        assert (!Arrays.asList(term2.getFreeVars()).contains(termVariable)) : "not eliminated";
        return term2;
    }

    private static Pair<Term, Term> antiDerWithAssumption(Script script, int n, Term term, Term term2) {
        RelationSymbol relationSymbol;
        Object object = PolynomialRelation.of(script, term);
        Object object2 = ExplicitLhsPolynomialRelation.moveMonomialToLhs(script, term2, object);
        Rational rational = object2.getLhsCoefficient();
        object = PolynomialRelation.TransformInequality.NO_TRANFORMATION;
        if (n == 0) {
            if (rational.isNegative()) {
                object2 = RelationSymbol.LESS;
                relationSymbol = RelationSymbol.GREATER;
            } else {
                object2 = RelationSymbol.GREATER;
                relationSymbol = RelationSymbol.LESS;
            }
        } else if (rational.isNegative()) {
            object2 = RelationSymbol.LEQ;
            relationSymbol = RelationSymbol.GEQ;
        } else {
            object2 = RelationSymbol.GEQ;
            relationSymbol = RelationSymbol.LEQ;
        }
        BinaryNumericRelation binaryNumericRelation = BinaryNumericRelation.convert(term);
        BinaryNumericRelation binaryNumericRelation2 = binaryNumericRelation.changeRelationSymbol((RelationSymbol)((Object)object2));
        PolynomialRelation polynomialRelation = PolynomialRelation.of(script, binaryNumericRelation2.toTerm(script), (PolynomialRelation.TransformInequality)((Object)object));
        ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation = ExplicitLhsPolynomialRelation.moveMonomialToLhs(script, term2, polynomialRelation);
        assert (rational.equals((Object)explicitLhsPolynomialRelation.getLhsCoefficient()));
        SolvedBinaryRelation solvedBinaryRelation = explicitLhsPolynomialRelation.divideByIntegerCoefficientForInequalities(script, Collections.emptySet());
        BinaryNumericRelation binaryNumericRelation3 = binaryNumericRelation.changeRelationSymbol(relationSymbol);
        PolynomialRelation polynomialRelation2 = PolynomialRelation.of(script, binaryNumericRelation3.toTerm(script), (PolynomialRelation.TransformInequality)((Object)object));
        ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation2 = ExplicitLhsPolynomialRelation.moveMonomialToLhs(script, term2, polynomialRelation2);
        assert (rational.equals((Object)explicitLhsPolynomialRelation2.getLhsCoefficient()));
        SolvedBinaryRelation solvedBinaryRelation2 = explicitLhsPolynomialRelation2.divideByIntegerCoefficientForInequalities(script, Collections.emptySet());
        if (solvedBinaryRelation == null || solvedBinaryRelation2 == null) {
            throw new AssertionError((Object)"suddenly unsolvable");
        }
        Term term3 = solvedBinaryRelation.getRightHandSide();
        Term term4 = solvedBinaryRelation2.getRightHandSide();
        return new Pair((Object)term3, (Object)term4);
    }

    private static boolean occursInsideSelectTerm(Script script, Term term, TermVariable termVariable) {
        List<MultiDimensionalSelect> list = MultiDimensionalSelect.extractSelectShallow(term);
        for (MultiDimensionalSelect multiDimensionalSelect : list) {
            for (Term term2 : multiDimensionalSelect.getIndex()) {
                if (!Arrays.asList(term2.getFreeVars()).contains(termVariable)) continue;
                return true;
            }
            if (Arrays.asList(multiDimensionalSelect.toTerm(script).getFreeVars()).contains(termVariable)) {
                return true;
            }
            if (!Arrays.asList(multiDimensionalSelect.getArray().getFreeVars()).contains(termVariable)) continue;
            return true;
        }
        return false;
    }

    private static Term buildInequality(Script script, int n, Bound bound, Bound bound2) {
        String string;
        Term term;
        PolynomialRelation polynomialRelation;
        boolean bl;
        boolean bl2 = SmtSortUtils.isIntSort(bound.getTerm().getSort());
        if (n == 0) {
            boolean bl3 = bl = bound.isIsStrict() || bound2.isIsStrict();
            assert (!(bound.isIsStrict() && bound2.isIsStrict() && bl2)) : "unsound if int and both are strict";
        } else if (n == 1) {
            boolean bl4 = bl = bound.isIsStrict() && bound2.isIsStrict();
            assert (bound.isIsStrict() || bound2.isIsStrict() || !bl2) : "unsound if int and both are non-strict";
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        if ((polynomialRelation = PolynomialRelation.of(script, term = script.term(string = bl ? "<" : "<=", new Term[]{bound.getTerm(), bound2.getTerm()}))) == null) {
            throw new AssertionError((Object)"should be affine");
        }
        return polynomialRelation.toTerm(script);
    }

    private static class AntiDerBuildingInstructions {
        private final IUltimateServiceProvider mServices;
        private final Script mScript;
        private final int mQuantifier;
        private final List<Bound> mUpperBounds;
        private final List<Bound> mLowerBounds;
        private final List<Pair<Term, Term>> mAntiDer;

        public AntiDerBuildingInstructions(IUltimateServiceProvider iUltimateServiceProvider, Script script, int n, List<Bound> list, List<Bound> list2, List<Pair<Term, Term>> list3) {
            this.mServices = iUltimateServiceProvider;
            this.mScript = script;
            this.mQuantifier = n;
            this.mUpperBounds = list;
            this.mLowerBounds = list2;
            this.mAntiDer = list3;
        }

        /*
         * Could not resolve type clashes
         */
        Term buildCorrespondingFiniteJunction() {
            ArrayList<Term> arrayList = new ArrayList<Term>();
            int n = 0;
            while ((double)n < Math.pow(2.0, this.mAntiDer.size())) {
                ArrayList<Term> arrayList2 = new ArrayList<Term>();
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                ArrayList<Object> arrayList4 = new ArrayList<Object>();
                int n2 = 0;
                while (n2 < this.mAntiDer.size()) {
                    if (BigInteger.valueOf(n).testBit(n2)) {
                        var7_9 = this.computeBound((Term)this.mAntiDer.get(n2).getSecond(), this.mQuantifier, BoundType.UPPER);
                        arrayList4.add(var7_9);
                    } else {
                        var7_9 = this.computeBound((Term)this.mAntiDer.get(n2).getFirst(), this.mQuantifier, BoundType.LOWER);
                        arrayList3.add(var7_9);
                    }
                    ++n2;
                }
                for (Bound bound : arrayList3) {
                    for (Bound bound2 : arrayList4) {
                        arrayList2.add(XnfTir.buildInequality(this.mScript, this.mQuantifier, bound, bound2));
                    }
                    for (Bound bound2 : this.mUpperBounds) {
                        arrayList2.add(XnfTir.buildInequality(this.mScript, this.mQuantifier, bound, bound2));
                    }
                }
                for (Bound bound : arrayList4) {
                    for (Bound bound2 : this.mLowerBounds) {
                        arrayList2.add(XnfTir.buildInequality(this.mScript, this.mQuantifier, bound2, bound));
                    }
                }
                arrayList.add(QuantifierUtils.applyDualFiniteConnective(this.mScript, this.mQuantifier, arrayList2));
                if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(this.getClass(), "building " + Math.pow(2.0, this.mAntiDer.size()) + " xjuncts");
                }
                ++n;
            }
            return QuantifierUtils.applyCorrespondingFiniteConnective(this.mScript, this.mQuantifier, arrayList);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Bound computeBound(Term term, int n, BoundType boundType) {
            if (SmtSortUtils.isRealSort(term.getSort())) {
                if (n == 0) {
                    return new Bound(true, term);
                }
                if (n != 1) throw new AssertionError((Object)"unknown quantifier");
                return new Bound(false, term);
            }
            if (!SmtSortUtils.isIntSort(term.getSort())) throw new AssertionError((Object)("unknown sort " + String.valueOf(term.getSort())));
            Term term2 = SmtUtils.constructIntValue(this.mScript, BigInteger.ONE);
            if (n == 0) {
                if (boundType == BoundType.LOWER) {
                    return new Bound(false, this.mScript.term("+", new Term[]{term, term2}));
                }
                if (boundType != BoundType.UPPER) throw new AssertionError((Object)("unknown BoundType" + String.valueOf((Object)boundType)));
                return new Bound(false, this.mScript.term("-", new Term[]{term, term2}));
            }
            if (n != 1) throw new AssertionError((Object)"unknown quantifier");
            if (boundType == BoundType.LOWER) {
                return new Bound(true, this.mScript.term("-", new Term[]{term, term2}));
            }
            if (boundType != BoundType.UPPER) throw new AssertionError((Object)("unknown BoundType" + String.valueOf((Object)boundType)));
            return new Bound(true, this.mScript.term("+", new Term[]{term, term2}));
        }
    }

    private static class Bound {
        private final boolean mIsStrict;
        private final Term mTerm;

        public Bound(boolean bl, Term term) {
            this.mIsStrict = bl;
            this.mTerm = term;
        }

        public boolean isIsStrict() {
            return this.mIsStrict;
        }

        public Term getTerm() {
            return this.mTerm;
        }

        public String toString() {
            return "Bound [mIsStrict=" + this.mIsStrict + ", mTerm=" + String.valueOf(this.mTerm) + "]";
        }
    }

    public static enum BoundType {
        UPPER,
        LOWER;

    }
}

