/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AllSpecificationsHoldResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AnnotationCheckResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AutomataScriptInterpreterOverallResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.CounterExampleResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.DataRaceFoundResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ExceptionOrErrorResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.GenericResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.NonterminatingLassoResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.PositiveResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.SyntaxErrorResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TerminationAnalysisResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TerminationArgumentResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovableResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.ITimeoutResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.IResultService;
import java.util.List;
import java.util.Map;

public final class ResultSummarizer {
    private ToolchainResult mSummary;
    private String mDescription;

    public ResultSummarizer(IResultService iResultService) {
        this.processResults(iResultService.getResults());
    }

    public ResultSummarizer(Map<String, List<IResult>> map) {
        this.processResults(map);
    }

    private void processResults(Map<String, List<IResult>> map) {
        ToolchainResult toolchainResult = ToolchainResult.NORESULT;
        Object object = "Toolchain returned no result.";
        for (List<IResult> list : map.values()) {
            block5: for (IResult iResult : list) {
                Object object2;
                if (iResult instanceof SyntaxErrorResult) {
                    toolchainResult = ToolchainResult.SYNTAXERROR;
                    object = iResult.getShortDescription();
                    continue;
                }
                if (iResult instanceof UnprovableResult) {
                    if (!toolchainResult.isLess(ToolchainResult.UNPROVABLE)) continue;
                    toolchainResult = ToolchainResult.UNPROVABLE;
                    object = "unable to determine feasibility of some traces";
                    continue;
                }
                if (iResult instanceof CounterExampleResult) {
                    toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.INCORRECT);
                    continue;
                }
                if (iResult instanceof DataRaceFoundResult) {
                    toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.INCORRECT);
                    continue;
                }
                if (iResult instanceof PositiveResult) {
                    toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.CORRECT);
                    continue;
                }
                if (iResult instanceof ITimeoutResult) {
                    if (!toolchainResult.isLess(ToolchainResult.TIMEOUT)) continue;
                    toolchainResult = ToolchainResult.TIMEOUT;
                    object = "Timeout";
                    continue;
                }
                if (iResult instanceof GenericResultAtElement) {
                    if (!toolchainResult.isLessOrEqual(ToolchainResult.GENERICRESULT)) continue;
                    toolchainResult = ToolchainResult.GENERICRESULT;
                    object = iResult.getShortDescription() + "  " + iResult.getLongDescription();
                    continue;
                }
                if (iResult instanceof AutomataScriptInterpreterOverallResult) {
                    object2 = (AutomataScriptInterpreterOverallResult)iResult;
                    toolchainResult = ResultSummarizer.translateAutomataScriptInterpreterOverallResult(((AutomataScriptInterpreterOverallResult)object2).getOverallResult());
                    object = iResult.getLongDescription();
                    continue;
                }
                if (iResult instanceof NonterminatingLassoResult) {
                    toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.INCORRECT);
                    continue;
                }
                if (iResult instanceof AllSpecificationsHoldResult) {
                    toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.CORRECT);
                    continue;
                }
                if (iResult instanceof TerminationArgumentResult) {
                    toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.CORRECT);
                    continue;
                }
                if (iResult instanceof AnnotationCheckResult) {
                    object2 = ResultSummarizer.translateRefereeResult((AnnotationCheckResult)iResult);
                    toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, (ToolchainResult)((Object)object2));
                    continue;
                }
                if (iResult instanceof ExceptionOrErrorResult) {
                    toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.ERROR);
                    continue;
                }
                if (!(iResult instanceof TerminationAnalysisResult)) continue;
                object2 = (TerminationAnalysisResult)iResult;
                switch (((TerminationAnalysisResult)object2).getTermination()) {
                    case NONTERMINATING: {
                        toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.INCORRECT);
                        break;
                    }
                    case TERMINATING: {
                        toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.CORRECT);
                        break;
                    }
                    default: {
                        if (!toolchainResult.isLess(ToolchainResult.UNPROVABLE)) continue block5;
                        toolchainResult = ToolchainResult.UNPROVABLE;
                        object = "unable to determine termination";
                    }
                }
            }
        }
        this.mSummary = toolchainResult;
        this.mDescription = object;
    }

    private static ToolchainResult translateRefereeResult(AnnotationCheckResult<?, ?> annotationCheckResult) {
        return switch (annotationCheckResult.getAnnotationState()) {
            case AnnotationCheckResult.AnnotationState.INVALID -> ToolchainResult.UNPROVABLE;
            case AnnotationCheckResult.AnnotationState.UNKNOWN -> ToolchainResult.UNPROVABLE;
            case AnnotationCheckResult.AnnotationState.VALID -> ToolchainResult.CORRECT;
            default -> throw new MatchException(null, null);
        };
    }

    private static ToolchainResult updateIfLess(ToolchainResult toolchainResult, ToolchainResult toolchainResult2) {
        if (toolchainResult.isLess(toolchainResult2)) {
            return toolchainResult2;
        }
        return toolchainResult;
    }

    private static ToolchainResult translateAutomataScriptInterpreterOverallResult(AutomataScriptInterpreterOverallResult.OverallResult overallResult) {
        return switch (overallResult) {
            case AutomataScriptInterpreterOverallResult.OverallResult.ALL_ASSERTIONS_HOLD -> ToolchainResult.CORRECT;
            case AutomataScriptInterpreterOverallResult.OverallResult.SOME_ASSERTION_FAILED -> ToolchainResult.INCORRECT;
            case AutomataScriptInterpreterOverallResult.OverallResult.TIMEOUT -> ToolchainResult.TIMEOUT;
            case AutomataScriptInterpreterOverallResult.OverallResult.NO_ASSERTION, AutomataScriptInterpreterOverallResult.OverallResult.EXCEPTION_OR_ERROR, AutomataScriptInterpreterOverallResult.OverallResult.OUT_OF_MEMORY -> ToolchainResult.NORESULT;
            default -> throw new MatchException(null, null);
        };
    }

    public ToolchainResult getResultSummary() {
        return this.mSummary;
    }

    public String getResultDescription() {
        return this.mDescription;
    }

    public String getOldResultMessage() {
        return switch (this.getResultSummary()) {
            case ToolchainResult.NORESULT, ToolchainResult.UNPROVABLE, ToolchainResult.TIMEOUT, ToolchainResult.SYNTAXERROR -> ResultSummarizer.programUnknown(this.getResultDescription());
            case ToolchainResult.INCORRECT -> ResultSummarizer.programIncorrect();
            case ToolchainResult.CORRECT -> ResultSummarizer.programCorrect();
            case ToolchainResult.GENERICRESULT -> this.getResultDescription();
            case ToolchainResult.ERROR -> throw new UnsupportedOperationException("unknown result " + String.valueOf((Object)this.getResultSummary()));
            default -> throw new MatchException(null, null);
        };
    }

    private static String programCorrect() {
        return "RESULT: Ultimate proved your program to be correct!";
    }

    private static String programIncorrect() {
        return "RESULT: Ultimate proved your program to be incorrect!";
    }

    private static String programUnknown(String string) {
        return "RESULT: Ultimate could not prove your program: " + string;
    }

    public static enum ToolchainResult {
        NORESULT(-1),
        GENERICRESULT(0),
        CORRECT(1),
        UNPROVABLE(2),
        TIMEOUT(3),
        INCORRECT(4),
        SYNTAXERROR(5),
        ERROR(5);

        private final int mValue;

        private ToolchainResult(int n2) {
            this.mValue = n2;
        }

        boolean isLess(ToolchainResult toolchainResult) {
            return this.mValue < toolchainResult.mValue;
        }

        boolean isLessOrEqual(ToolchainResult toolchainResult) {
            return this.mValue <= toolchainResult.mValue;
        }
    }
}

