/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.IBuchiNwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.incrementalinclusion.IIncrementalInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IFinitePrefix2PetriNetStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.DebugPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IMLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryForInterpolantAutomata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PredicateFactoryRefinement
extends PredicateFactoryForInterpolantAutomata
implements INwaInclusionStateFactory<IPredicate>,
IIncrementalInclusionStateFactory<IPredicate>,
IBuchiNwaInclusionStateFactory<IPredicate>,
IFinitePrefix2PetriNetStateFactory<IPredicate> {
    private static final boolean DEBUG_COMPUTE_HISTORY = false;
    private static final boolean DEBUG_CHECK_VARIABLES_PERMISSIBLE = false;
    protected final IUltimateServiceProvider mServices;
    protected int mIteration;
    private final Set<? extends IcfgLocation> mHoareAnnotationProgramPoints;

    public PredicateFactoryRefinement(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, PredicateFactory predicateFactory, boolean bl, Set<? extends IcfgLocation> set) {
        super(managedScript, predicateFactory, bl);
        this.mServices = iUltimateServiceProvider;
        this.mHoareAnnotationProgramPoints = set;
    }

    public IPredicate intersection(IPredicate iPredicate, IPredicate iPredicate2) {
        if (iPredicate instanceof IMLPredicate) {
            IcfgLocation[] icfgLocationArray = ((IMLPredicate)iPredicate).getProgramPoints();
            if (Arrays.stream(icfgLocationArray).anyMatch(this.mHoareAnnotationProgramPoints::contains)) {
                Term term = this.mPredicateFactory.and(new IPredicate[]{iPredicate, iPredicate2}).getFormula();
                term = new CommuhashNormalForm(this.mServices, this.mMgdScript.getScript()).transform(term);
                return this.mPredicateFactory.newMLPredicate(icfgLocationArray, term);
            }
            return this.mPredicateFactory.newMLDontCarePredicate(((IMLPredicate)iPredicate).getProgramPoints());
        }
        if (iPredicate instanceof ISLPredicate) {
            IcfgLocation icfgLocation = ((ISLPredicate)iPredicate).getProgramPoint();
            if (this.mHoareAnnotationProgramPoints.contains(icfgLocation)) {
                Term term = this.mPredicateFactory.and(new IPredicate[]{iPredicate, iPredicate2}).getFormula();
                term = new CommuhashNormalForm(this.mServices, this.mMgdScript.getScript()).transform(term);
                SPredicate sPredicate = this.mPredicateFactory.newSPredicate(icfgLocation, term);
                return sPredicate;
            }
            return this.mPredicateFactory.newDontCarePredicate(icfgLocation);
        }
        throw new AssertionError((Object)"unknown predicate");
    }

    private static void checkIfVariablesArePermissible(IcfgLocation icfgLocation, IPredicate iPredicate) {
        String string = icfgLocation.getProcedure();
        Set set = iPredicate.getVars();
        PredicateFactoryRefinement.checkIfVariablesArePermissible(string, set);
    }

    private static void checkIfVariablesArePermissible(String string, Set<IProgramVar> set) {
        for (IProgramVar iProgramVar : set) {
            String string2 = iProgramVar.getProcedure();
            if (string2 != null && !string2.equals(string)) {
                throw new AssertionError((Object)String.format("Var %s of proc %s must not occur in proc %s", iProgramVar, iProgramVar.getProcedure(), string));
            }
        }
    }

    @Override
    public IPredicate determinize(Map<IPredicate, Set<IPredicate>> map) {
        throw new AssertionError((Object)"determinize is only required for construction of interpolant automaton, not for refinement");
    }

    @Override
    public IPredicate merge(Collection<IPredicate> collection) {
        assert (!collection.isEmpty()) : "minimize empty set???";
        assert (this.sameProgramPoints(collection)) : "states do not have same program points";
        IPredicate iPredicate = collection.iterator().next();
        if (iPredicate instanceof ISLPredicate) {
            IcfgLocation icfgLocation = ((ISLPredicate)iPredicate).getProgramPoint();
            if (this.mHoareAnnotationProgramPoints.contains(icfgLocation)) {
                Term term = this.mPredicateFactory.or(collection).getFormula();
                term = new CommuhashNormalForm(this.mServices, this.mMgdScript.getScript()).transform(term);
                return this.mPredicateFactory.newSPredicate(icfgLocation, term);
            }
            return this.mPredicateFactory.newDontCarePredicate(icfgLocation);
        }
        if (iPredicate instanceof IMLPredicate) {
            IcfgLocation[] icfgLocationArray = ((IMLPredicate)iPredicate).getProgramPoints();
            if (collection.isEmpty()) {
                assert (false) : "minimize empty set???";
                return this.mPredicateFactory.newMLDontCarePredicate(icfgLocationArray);
            }
            Term term = this.mPredicateFactory.or(collection).getFormula();
            return this.mPredicateFactory.newMLPredicate(icfgLocationArray, term);
        }
        throw new AssertionError((Object)"unknown predicate");
    }

    private boolean sameProgramPoints(Collection<IPredicate> collection) {
        Iterator<IPredicate> iterator = collection.iterator();
        IPredicate iPredicate = iterator.next();
        if (iPredicate instanceof ISLPredicate) {
            IcfgLocation icfgLocation = ((ISLPredicate)iPredicate).getProgramPoint();
            while (iterator.hasNext()) {
                IcfgLocation icfgLocation2 = ((ISLPredicate)iterator.next()).getProgramPoint();
                if (icfgLocation2 == icfgLocation) continue;
                return false;
            }
        } else if (iPredicate instanceof IMLPredicate) {
            Object[] objectArray = ((IMLPredicate)iPredicate).getProgramPoints();
            while (iterator.hasNext()) {
                Object[] objectArray2 = ((IMLPredicate)iterator.next()).getProgramPoints();
                if (Arrays.equals(objectArray2, objectArray)) continue;
                return false;
            }
        } else {
            throw new AssertionError((Object)"unsupported predicate");
        }
        return true;
    }

    @Override
    public IPredicate senwa(IPredicate iPredicate, IPredicate iPredicate2) {
        return this.mPredicateFactory.newDontCarePredicate(((SPredicate)iPredicate2).getProgramPoint());
    }

    public IPredicate intersectBuchi(IPredicate iPredicate, IPredicate iPredicate2, int n) {
        return this.intersection(iPredicate, iPredicate2);
    }

    public void setIteration(int n) {
        this.mIteration = n;
    }

    @Override
    public IPredicate getContentOnPetriNet2FiniteAutomaton(Marking<IPredicate> marking) {
        ArrayList<IcfgLocation> arrayList = new ArrayList<IcfgLocation>(marking.size());
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        for (IPredicate iPredicate : marking) {
            if (iPredicate instanceof ISLPredicate) {
                arrayList.add(((ISLPredicate)iPredicate).getProgramPoint());
            }
            arrayList2.add(iPredicate.getFormula());
        }
        return this.mPredicateFactory.newMLPredicate(arrayList.toArray(new IcfgLocation[arrayList.size()]), arrayList2);
    }

    public IPredicate finitePrefix2net(Condition<?, IPredicate> condition) {
        if (condition.getPlace() instanceof SPredicate) {
            SPredicate sPredicate = (SPredicate)condition.getPlace();
            return this.mPredicateFactory.newSPredicate(sPredicate.getProgramPoint(), sPredicate.getFormula());
        }
        if (condition.getPlace() instanceof BasicPredicate) {
            BasicPredicate basicPredicate = (BasicPredicate)condition.getPlace();
            return this.mPredicateFactory.newPredicate(basicPredicate.getFormula());
        }
        if (condition.getPlace() instanceof DebugPredicate) {
            DebugPredicate debugPredicate = (DebugPredicate)condition.getPlace();
            return this.mPredicateFactory.newDebugPredicate(debugPredicate.getDebugMessage());
        }
        throw new AssertionError((Object)("unexpected predicate: " + ((IPredicate)condition.getPlace()).getClass().getSimpleName()));
    }
}

