/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class VPDomainHelpers {
    public static Map<TermVariable, IProgramVar> computeProgramVarMappingFromTransFormula(TransFormula transFormula) {
        return VPDomainHelpers.computeProgramVarMappingFromInVarOutVarMappings(transFormula.getInVars(), transFormula.getOutVars());
    }

    public static Map<TermVariable, IProgramVar> computeProgramVarMappingFromInVarOutVarMappings(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        HashMap<TermVariable, IProgramVar> hashMap = new HashMap<TermVariable, IProgramVar>();
        for (Map.Entry<IProgramVar, TermVariable> entry : map.entrySet()) {
            hashMap.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : map2.entrySet()) {
            hashMap.put(entry.getValue(), entry.getKey());
        }
        return hashMap;
    }

    public static IProgramVar getProgramVar(TermVariable termVariable, Map<IProgramVar, TermVariable> map) {
        for (Map.Entry<IProgramVar, TermVariable> entry : map.entrySet()) {
            if (entry.getValue() != termVariable) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Map<IProgramVar, TermVariable> projectToTerm(Map<IProgramVar, TermVariable> map, Term term) {
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> entry : map.entrySet()) {
            if (!Arrays.asList(term.getFreeVars()).contains(entry.getValue())) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    public static Term getArrayTerm(Term term) {
        if (!(term instanceof ApplicationTerm)) {
            return term;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        if (applicationTerm.getFunction().getName().equals("select")) {
            MultiDimensionalSelect multiDimensionalSelect = MultiDimensionalSelect.of((Term)applicationTerm);
            if (multiDimensionalSelect.getArray() instanceof ApplicationTerm && (((ApplicationTerm)multiDimensionalSelect.getArray()).getFunction().getName().equals("select") || ((ApplicationTerm)multiDimensionalSelect.getArray()).getFunction().getName().equals("store"))) {
                return VPDomainHelpers.getArrayTerm(multiDimensionalSelect.getArray());
            }
            return multiDimensionalSelect.getArray();
        }
        if (applicationTerm.getFunction().getName().equals("store")) {
            MultiDimensionalStore multiDimensionalStore = MultiDimensionalStore.of((Term)applicationTerm);
            if (multiDimensionalStore.getArray() instanceof ApplicationTerm && (((ApplicationTerm)multiDimensionalStore.getArray()).getFunction().getName().equals("select") || ((ApplicationTerm)multiDimensionalStore.getArray()).getFunction().getName().equals("store"))) {
                return VPDomainHelpers.getArrayTerm(multiDimensionalStore.getArray());
            }
            return multiDimensionalStore.getArray();
        }
        assert (false);
        return null;
    }

    public static Map<IProgramVar, TermVariable> projectToVars(Map<IProgramVar, TermVariable> map, Set<IProgramVar> set) {
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> entry : map.entrySet()) {
            if (!set.contains(entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    public static InOutStatusOfStateId getInOutStatusOfPvoc(IProgramVarOrConst iProgramVarOrConst, TransFormula transFormula) {
        InOutStatusOfStateId inOutStatusOfStateId = iProgramVarOrConst instanceof IProgramVarOrConst ? VPDomainHelpers.computeInOutStatus((IProgramVar)iProgramVarOrConst, transFormula) : InOutStatusOfStateId.THROUGH;
        return inOutStatusOfStateId;
    }

    public static InOutStatusOfStateId computeInOutStatus(IProgramVar iProgramVar, TransFormula transFormula) {
        boolean bl = transFormula.getInVars().containsKey(iProgramVar);
        boolean bl2 = transFormula.getOutVars().containsKey(iProgramVar);
        if (bl && bl2) {
            if (transFormula.getInVars().get(iProgramVar) == transFormula.getOutVars().get(iProgramVar)) {
                return InOutStatusOfStateId.THROUGH;
            }
            return InOutStatusOfStateId.UPDATE;
        }
        if (bl && !bl2) {
            return InOutStatusOfStateId.IN;
        }
        if (!bl && bl2) {
            return InOutStatusOfStateId.OUT;
        }
        assert (!bl && !bl2);
        return InOutStatusOfStateId.NONE;
    }

    public static Map<IProgramVar, TermVariable> projectOut(Map<IProgramVar, TermVariable> map, IProgramVarOrConst iProgramVarOrConst) {
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>(map);
        if (iProgramVarOrConst instanceof IProgramVar) {
            hashMap.remove(iProgramVarOrConst);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static <T> Set<List<T>> computeCrossProduct(List<Set<T>> list, IUltimateServiceProvider iUltimateServiceProvider) {
        HashSet<List<Object>> hashSet = new HashSet<List<T>>();
        hashSet.add(new ArrayList());
        for (Set<T> set : list) {
            HashSet hashSet2 = new HashSet();
            if (!iUltimateServiceProvider.getProgressMonitorService().continueProcessing()) {
                return null;
            }
            for (List list2 : hashSet) {
                for (T t : set) {
                    ArrayList<T> arrayList = new ArrayList<T>(list2);
                    arrayList.add(t);
                    hashSet2.add(arrayList);
                }
            }
            hashSet = hashSet2;
        }
        return hashSet;
    }

    public static Map<IProgramVar, TermVariable> projectToTermAndVars(Map<IProgramVar, TermVariable> map, Term term, Set<IProgramVar> set) {
        return VPDomainHelpers.projectToTerm(VPDomainHelpers.projectToVars(map, set), term);
    }

    public static <T> Set<T> intersect(Set<T> set, Set<T> set2) {
        HashSet<T> hashSet = new HashSet<T>(set);
        hashSet.retainAll(set2);
        return Collections.unmodifiableSet(hashSet);
    }

    public static <K, V> boolean imageIsNeverNull(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getValue() != null) continue;
            return false;
        }
        return true;
    }

    public static <NODE extends IEqNodeIdentifier<NODE>> boolean constraintFreeOfVars(Collection<Term> collection, EqConstraint<NODE> eqConstraint, Script script) {
        if (collection.isEmpty()) {
            return true;
        }
        HashSet<Term> hashSet = new HashSet<Term>();
        for (IEqNodeIdentifier iEqNodeIdentifier : eqConstraint.getAllNodes()) {
            if (iEqNodeIdentifier.isMixFunction()) {
                if (collection.contains(iEqNodeIdentifier.getMixFunction1())) {
                    assert (false);
                    return false;
                }
                if (collection.contains(iEqNodeIdentifier.getMixFunction2())) {
                    assert (false);
                    return false;
                }
                hashSet.add(((ApplicationTerm)iEqNodeIdentifier.getTerm()).getParameters()[2]);
                continue;
            }
            Set set = DataStructureUtils.intersection(new HashSet<TermVariable>(Arrays.asList(iEqNodeIdentifier.getTerm().getFreeVars())), new HashSet<Term>(collection));
            if (set.isEmpty()) continue;
            assert (false);
            return false;
        }
        if (script != null && Arrays.asList(eqConstraint.getTerm(script).getFreeVars()).stream().anyMatch(termVariable -> collection.contains(termVariable) && !hashSet.contains(termVariable))) {
            assert (false);
            return false;
        }
        return true;
    }

    public static <T> boolean arrayContains(T[] TArray, T t) {
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t2 = TArray2[n2];
            if (t2.equals(t)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <NODE extends IEqNodeIdentifier<NODE>> boolean haveSameType(NODE NODE, NODE NODE2) {
        if (NODE.getTerm().getSort() != NODE2.getTerm().getSort()) {
            assert (false);
            return false;
        }
        return true;
    }

    public static <K, V> void transformRelationInPlace(HashRelation<K, V> hashRelation, Function<K, K> function, Function<V, V> function2) {
        for (Map.Entry entry : new HashRelation(hashRelation)) {
            hashRelation.removePair(entry.getKey(), entry.getValue());
            hashRelation.addPair(function.apply(entry.getKey()), function2.apply(entry.getValue()));
        }
    }

    public static enum InOutStatusOfStateId {
        IN,
        OUT,
        THROUGH,
        UPDATE,
        NONE;

    }
}

