/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;

public class CommuhashNormalForm {
    private static final boolean DEBUG_LOG_SIZES = false;
    private static final boolean DEBUG_CHECK_CORRECTNESS = false;
    private final IUltimateServiceProvider mServices;
    private final Script mScript;

    public CommuhashNormalForm(IUltimateServiceProvider iUltimateServiceProvider, Script script) {
        this.mServices = iUltimateServiceProvider;
        this.mScript = script;
    }

    public Term transform(Term term) {
        ILogger iLogger = this.mServices.getLoggingService().getLogger(CommuhashNormalForm.class.getSimpleName());
        Term term2 = new CommuhashNormalFormHelper().transform(term);
        return term2;
    }

    private class CommuhashNormalFormHelper
    extends TermTransformer {
        private CommuhashNormalFormHelper() {
        }

        public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
            String string = applicationTerm.getFunction().getName();
            if (CommuhashUtils.isKnownToBeCommutative(string)) {
                Sort sort = applicationTerm.getFunction().isReturnOverload() ? applicationTerm.getFunction().getReturnSort() : null;
                Term term = this.constructlocallySimplifiedTermWithSortedParams(string, null, sort, termArray);
                this.setResult(term);
            } else {
                super.convertApplicationTerm(applicationTerm, termArray);
            }
        }

        private Term constructlocallySimplifiedTermWithSortedParams(String string, BigInteger[] bigIntegerArray, Sort sort, Term[] termArray) {
            Term[] termArray2 = CommuhashUtils.sortByHashCode(termArray);
            Term term = SmtUtils.unfTerm(CommuhashNormalForm.this.mScript, string, SmtUtils.toStringArray(bigIntegerArray), sort, termArray2);
            return term;
        }

        public void postConvertQuantifier(QuantifiedFormula quantifiedFormula, Term term) {
            Term term2 = SmtUtils.quantifier(CommuhashNormalForm.this.mScript, quantifiedFormula.getQuantifier(), new HashSet<TermVariable>(Arrays.asList(quantifiedFormula.getVariables())), term);
            this.setResult(term2);
        }
    }
}

