/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizeAndOffsetComputer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CStructOrUnion;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.IncorrectSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.BitfieldInformation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.HeapLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValueFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ResultWithSideEffects;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class StructHandler {
    private final MemoryHandler mMemoryHandler;
    private final TypeSizeAndOffsetComputer mTypeSizeAndOffsetComputer;
    private final ExpressionTranslation mExpressionTranslation;
    private final ITypeHandler mTypeHandler;
    private final LocationFactory mLocationFactory;

    public StructHandler(MemoryHandler memoryHandler, TypeSizeAndOffsetComputer typeSizeAndOffsetComputer, ExpressionTranslation expressionTranslation, ITypeHandler iTypeHandler, LocationFactory locationFactory) {
        this.mMemoryHandler = memoryHandler;
        this.mTypeSizeAndOffsetComputer = typeSizeAndOffsetComputer;
        this.mExpressionTranslation = expressionTranslation;
        this.mTypeHandler = iTypeHandler;
        this.mLocationFactory = locationFactory;
    }

    public Result handleFieldReference(IDispatcher iDispatcher, ExpressionResultTransformer expressionResultTransformer, IASTFieldReference iASTFieldReference) {
        Object object;
        Object object2;
        CACSLLocation cACSLLocation = this.mLocationFactory.createCLocation((IASTNode)iASTFieldReference);
        String string = iASTFieldReference.getFieldName().toString();
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((IASTNode)iASTFieldReference.getFieldOwner());
        LRValue lRValue = null;
        ArrayList<ExpressionResult> arrayList = expressionResult.getNeighbourUnionFields() == null ? new ArrayList<ExpressionResult>() : new ArrayList<ExpressionResult>(expressionResult.getNeighbourUnionFields());
        ICType iCType = iASTFieldReference.isPointerDereference() ? ((CPointer)expressionResult.getLrValue().getUnderlyingType()).getPointsToType() : expressionResult.getLrValue().getUnderlyingType();
        CStructOrUnion cStructOrUnion = (CStructOrUnion)iCType.getUnderlyingType();
        ICType iCType2 = cStructOrUnion.getFieldType(string);
        int n = cStructOrUnion.getBitfieldWidth(string);
        if (iASTFieldReference.isPointerDereference()) {
            object2 = expressionResultTransformer.switchToRValue(expressionResult, cACSLLocation, (IASTNode)iASTFieldReference);
            object = ((ExpressionResult)object2).getLrValue().getValue();
            expressionResult = new ExpressionResult(((ResultWithSideEffects)object2).getStatements(), LRValueFactory.constructHeapLValue(this.mTypeHandler, object, ((ExpressionResult)object2).getLrValue().getCType(), null), ((ResultWithSideEffects)object2).getDeclarations(), ((ResultWithSideEffects)object2).getAuxVars(), ((ResultWithSideEffects)object2).getOverapprs());
        }
        if (expressionResult.getLrValue() instanceof HeapLValue) {
            object2 = (HeapLValue)expressionResult.getLrValue();
            object = this.mTypeSizeAndOffsetComputer.constructOffsetForField((ILocation)cACSLLocation, cStructOrUnion, string);
            Expression expression = ((HeapLValue)object2).getAddress();
            Expression expression2 = this.mMemoryHandler.constructAddressForStructField(cACSLLocation, expression, (TypeSizeAndOffsetComputer.Offset)object, this.mExpressionTranslation.getCTypeOfPointerComponents());
            BitfieldInformation bitfieldInformation = StructHandler.constructBitfieldInformation(n);
            lRValue = LRValueFactory.constructHeapLValue(this.mTypeHandler, expression2, iCType2, bitfieldInformation);
            if (cStructOrUnion.isStructOrUnion() == CStructOrUnion.StructOrUnion.UNION) {
                arrayList.addAll(this.computeNeighbourFieldsOfUnionField(cACSLLocation, string, arrayList, cStructOrUnion, (LRValue)object2));
            }
        } else if (expressionResult.getLrValue() instanceof RValue) {
            object2 = (RValue)expressionResult.getLrValue();
            object = ExpressionFactory.constructStructAccessExpression((ILocation)cACSLLocation, (Expression)((RValue)object2).getValue(), (String)string);
            lRValue = new RValue((Expression)object, iCType2);
        } else {
            object2 = (LocalLValue)expressionResult.getLrValue();
            object = ExpressionFactory.constructStructAccessLhs((ILocation)cACSLLocation, (LeftHandSide)((LocalLValue)object2).getLhs(), (String)string);
            BitfieldInformation bitfieldInformation = StructHandler.constructBitfieldInformation(n);
            lRValue = new LocalLValue((LeftHandSide)object, iCType2, bitfieldInformation);
            if (cStructOrUnion.isStructOrUnion() == CStructOrUnion.StructOrUnion.UNION) {
                arrayList.addAll(this.computeNeighbourFieldsOfUnionField(cACSLLocation, string, arrayList, cStructOrUnion, (LRValue)object2));
            }
        }
        return new ExpressionResult(expressionResult.getStatements(), lRValue, expressionResult.getDeclarations(), expressionResult.getAuxVars(), expressionResult.getOverapprs(), arrayList);
    }

    private static BitfieldInformation constructBitfieldInformation(int n) {
        if (n != -1) {
            return new BitfieldInformation(n);
        }
        return null;
    }

    private List<ExpressionResult> computeNeighbourFieldsOfUnionField(ILocation iLocation, String string, List<ExpressionResult> list, CStructOrUnion cStructOrUnion, LRValue lRValue) {
        assert (cStructOrUnion.isStructOrUnion() == CStructOrUnion.StructOrUnion.UNION);
        ArrayList<Object> arrayList = list == null ? new ArrayList() : new ArrayList<ExpressionResult>(list);
        String[] stringArray = cStructOrUnion.getFieldIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (!string2.equals(string)) {
                ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
                if (lRValue instanceof LocalLValue) {
                    var12_12 = ExpressionFactory.constructStructAccessLhs((ILocation)iLocation, (LeftHandSide)((LocalLValue)lRValue).getLhs(), (String)string2);
                    expressionResultBuilder.setLrValue(new LocalLValue((LeftHandSide)var12_12, cStructOrUnion.getFieldType(string2), null));
                } else {
                    assert (lRValue instanceof HeapLValue);
                    var12_12 = ((HeapLValue)lRValue).getAddress();
                    TypeSizeAndOffsetComputer.Offset offset = this.mTypeSizeAndOffsetComputer.constructOffsetForField(iLocation, cStructOrUnion, string2);
                    Expression expression = this.mMemoryHandler.constructAddressForStructField(iLocation, var12_12, offset, this.mExpressionTranslation.getCTypeOfPointerComponents());
                    expressionResultBuilder.setLrValue(LRValueFactory.constructHeapLValue(this.mTypeHandler, expression, cStructOrUnion.getFieldType(string2), null));
                }
                arrayList.add(expressionResultBuilder.build());
            }
            ++n2;
        }
        return arrayList;
    }

    public Result readFieldInTheStructAtAddress(ILocation iLocation, int n, Expression expression, CStructOrUnion cStructOrUnion, boolean bl) {
        Expression expression2 = this.computeStructFieldAddress(iLocation, n, expression, cStructOrUnion);
        ICType iCType = cStructOrUnion.getFieldTypes()[n];
        ExpressionResult expressionResult = bl ? this.mMemoryHandler.getReadUnchecked(expression2, iCType) : this.mMemoryHandler.getReadCall(expression2, iCType);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        expressionResultBuilder.setLrValue(new RValue(expressionResult.getLrValue().getValue(), iCType));
        return expressionResultBuilder.build();
    }

    public Expression computeStructFieldAddress(ILocation iLocation, int n, Expression expression, CStructOrUnion cStructOrUnion) {
        if (cStructOrUnion == null) {
            throw new IncorrectSyntaxException(iLocation, "Incorrect or unexpected field owner!");
        }
        TypeSizeAndOffsetComputer.Offset offset = this.mTypeSizeAndOffsetComputer.constructOffsetForField(iLocation, cStructOrUnion, n);
        return this.mMemoryHandler.constructAddressForStructField(iLocation, expression, offset, this.mTypeSizeAndOffsetComputer.getSizeT());
    }
}

