/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.petrinetlbe;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgSummaryTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.petrinetlbe.PetriNetLargeBlockEncoding;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IcfgCompositionFactory
implements PetriNetLargeBlockEncoding.IPLBECompositionFactory<IcfgEdge> {
    private static final SmtUtils.SimplificationTechnique SIMPLIFICATION_TECHNIQUE = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA;
    private final IcfgEdgeBuilder mEdgeBuilder;
    private final Map<IcfgEdge, TermVariable> mBranchEncoders;

    public IcfgCompositionFactory(IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit) {
        this.mEdgeBuilder = new IcfgEdgeBuilder(cfgSmtToolkit, iUltimateServiceProvider, SIMPLIFICATION_TECHNIQUE);
        this.mBranchEncoders = new HashMap<IcfgEdge, TermVariable>();
    }

    public boolean isComposable(IcfgEdge icfgEdge) {
        return icfgEdge instanceof IIcfgInternalTransition && !(icfgEdge instanceof IIcfgSummaryTransition);
    }

    private boolean isComposable(List<IcfgEdge> list) {
        return list.stream().allMatch(this::isComposable);
    }

    public IcfgEdge composeSequential(IcfgEdge icfgEdge, IcfgEdge icfgEdge2) {
        IcfgLocation icfgLocation = (IcfgLocation)icfgEdge.getSource();
        IcfgLocation icfgLocation2 = (IcfgLocation)icfgEdge2.getTarget();
        List<IcfgEdge> list = Arrays.asList(icfgEdge, icfgEdge2);
        assert (this.isComposable(list)) : "You cannot have calls or returns in sequential compositions";
        return this.mEdgeBuilder.constructSequentialComposition(icfgLocation, icfgLocation2, list, true, false, false);
    }

    public IcfgEdge composeParallel(List<IcfgEdge> list) {
        assert (!list.isEmpty()) : "Cannot compose 0 transitions";
        assert (this.isComposable(list)) : "You cannot have calls or returns in parallel compositions";
        IcfgLocation icfgLocation = (IcfgLocation)list.get(0).getSource();
        IcfgLocation icfgLocation2 = (IcfgLocation)list.get(0).getTarget();
        assert (list.stream().allMatch(icfgEdge -> icfgEdge.getSource() == icfgLocation && icfgEdge.getTarget() == icfgLocation2)) : "Can only compose transitions with equal sources and targets.";
        Map map = this.mEdgeBuilder.constructBranchIndicatorToEdgeMapping(list);
        this.storeBranchEncoders(map);
        return this.mEdgeBuilder.constructParallelComposition(icfgLocation, icfgLocation2, map);
    }

    private void storeBranchEncoders(Map<TermVariable, IcfgEdge> map) {
        for (Map.Entry<TermVariable, IcfgEdge> entry : map.entrySet()) {
            assert (!this.mBranchEncoders.containsKey(entry.getValue())) : "Ambiguous branch encoder for transition";
            this.mBranchEncoders.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public Map<IcfgEdge, TermVariable> getBranchEncoders() {
        return this.mBranchEncoders;
    }
}

