/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import java.util.HashSet;
import java.util.Set;

public class EquivalenceFinder {
    private final Script mScript;
    private final Set<PolynomialRelation> mRelations;

    public EquivalenceFinder(Term term, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
        this.mScript = managedScript.getScript();
        Term term2 = SmtUtils.toCnf((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)term);
        this.mRelations = this.getEquivalenceRelations(term2);
    }

    public UnionFind<Term> getEquivalences(Set<? extends Term> set) {
        UnionFind unionFind = new UnionFind();
        for (PolynomialRelation polynomialRelation : this.mRelations) {
            for (Term term : set) {
                SolvedBinaryRelation solvedBinaryRelation = polynomialRelation.solveForSubject(this.mScript, term);
                if (solvedBinaryRelation == null) continue;
                assert ("=".equals(polynomialRelation.getRelationSymbol().toString()));
                Term term2 = solvedBinaryRelation.getRightHandSide();
                unionFind.findAndConstructEquivalenceClassIfNeeded((Object)term);
                unionFind.findAndConstructEquivalenceClassIfNeeded((Object)term2);
                unionFind.union((Object)term, (Object)term2);
            }
        }
        return unionFind;
    }

    private Set<PolynomialRelation> getEquivalenceRelations(Term term) {
        HashSet<PolynomialRelation> hashSet = new HashSet<PolynomialRelation>();
        HashSet<AffineTerm> hashSet2 = new HashSet<AffineTerm>();
        Term[] termArray = SmtUtils.getConjuncts((Term)term);
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term2 = termArray[n2];
            PolynomialRelation polynomialRelation = PolynomialRelation.of((Script)this.mScript, (Term)term2, (PolynomialRelation.TransformInequality)PolynomialRelation.TransformInequality.STRICT2NONSTRICT);
            if (polynomialRelation != null) {
                RelationSymbol relationSymbol = polynomialRelation.getRelationSymbol();
                switch (relationSymbol) {
                    case EQ: {
                        hashSet.add(polynomialRelation);
                        break;
                    }
                    case LEQ: 
                    case GEQ: {
                        AffineTerm affineTerm;
                        AffineTerm affineTerm2 = EquivalenceFinder.normalize((AffineTerm)polynomialRelation.getPolynomialTerm());
                        AffineTerm affineTerm3 = EquivalenceFinder.normalize(AffineTerm.mul((IPolynomialTerm)polynomialRelation.getPolynomialTerm(), (Rational)Rational.MONE));
                        AffineTerm affineTerm4 = relationSymbol == RelationSymbol.LEQ ? affineTerm2 : affineTerm3;
                        AffineTerm affineTerm5 = affineTerm = relationSymbol == RelationSymbol.LEQ ? affineTerm3 : affineTerm2;
                        if (hashSet2.contains(affineTerm)) {
                            hashSet2.remove(affineTerm);
                            hashSet.add(PolynomialRelation.of((AbstractGeneralizedAffineTerm)affineTerm4, (RelationSymbol)RelationSymbol.EQ));
                            break;
                        }
                        hashSet2.add(affineTerm4);
                        break;
                    }
                }
            }
            ++n2;
        }
        return hashSet;
    }

    private static AffineTerm normalize(AffineTerm affineTerm) {
        Rational rational = affineTerm.getConstant();
        for (Rational rational2 : affineTerm.getVariable2Coefficient().values()) {
            rational = rational.gcd(rational2);
        }
        if (rational.equals((Object)Rational.ZERO)) {
            return affineTerm;
        }
        return AffineTerm.mul((IPolynomialTerm)affineTerm, (Rational)rational.inverse());
    }
}

