/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleListable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCBaseTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;
import java.util.HashMap;

public class CCAppTerm
extends CCTerm {
    final CCTerm mFunc;
    final CCTerm mArg;
    final Parent mLeftParInfo;
    final Parent mRightParInfo;
    Term mSmtTerm;

    public CCAppTerm(boolean bl, int n, CCTerm cCTerm, CCTerm cCTerm2, CClosure cClosure, boolean bl2) {
        super(bl, n, HashUtils.hashJenkins((int)cCTerm.hashCode(), (Object)cCTerm2), !bl2 ? 0 : Math.max(cCTerm.mAge, cCTerm2.mAge + 1));
        this.mFunc = cCTerm;
        this.mArg = cCTerm2;
        this.mLeftParInfo = new Parent();
        this.mRightParInfo = new Parent();
    }

    public CCTerm getFunc() {
        return this.mFunc;
    }

    public CCTerm getArg() {
        return this.mArg;
    }

    public void addParentInfo(CClosure cClosure) {
        CCTerm cCTerm = this.mFunc;
        CCTerm cCTerm2 = this.mArg;
        while (cCTerm.mRep != cCTerm || cCTerm2.mRep != cCTerm2) {
            if (cCTerm2.mMergeTime < cCTerm.mMergeTime) {
                cCTerm2.mCCPars.addParentInfo(cCTerm.mParentPosition, this.mRightParInfo, false, null);
                cCTerm2 = cCTerm2.mRep;
                continue;
            }
            cCTerm.mCCPars.addParentInfo(0, this.mLeftParInfo, false, null);
            cCTerm = cCTerm.mRep;
        }
        cCTerm.mCCPars.addParentInfo(0, this.mLeftParInfo, true, cClosure);
        cCTerm2.mCCPars.addParentInfo(cCTerm.mParentPosition, this.mRightParInfo, true, cClosure);
        assert (this.invariant());
        assert (cCTerm.invariant());
        assert (cCTerm2.invariant());
    }

    public void unlinkParentInfos() {
        this.mLeftParInfo.removeFromList();
        this.mRightParInfo.removeFromList();
    }

    public void markParentInfos() {
        this.mRightParInfo.mMark = true;
        this.mLeftParInfo.mMark = true;
    }

    public void unmarkParentInfos() {
        this.mRightParInfo.mMark = false;
        this.mLeftParInfo.mMark = false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<CCAppTerm, Integer> hashMap = new HashMap<CCAppTerm, Integer>();
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        arrayDeque.add(")");
        arrayDeque.add(this);
        arrayDeque.add("(");
        while (!arrayDeque.isEmpty()) {
            Object e = arrayDeque.removeLast();
            if (e instanceof String) {
                stringBuilder.append(e);
                continue;
            }
            if (e instanceof CCAppTerm) {
                CCAppTerm cCAppTerm = (CCAppTerm)e;
                Integer n = (Integer)hashMap.get(e);
                if (n != null) {
                    stringBuilder.append("@" + String.valueOf(n));
                    continue;
                }
                hashMap.put(cCAppTerm, hashMap.size());
                if (cCAppTerm.mArg instanceof CCAppTerm) {
                    arrayDeque.add(")");
                    arrayDeque.add(cCAppTerm.mArg);
                    arrayDeque.add("(");
                } else {
                    arrayDeque.add(cCAppTerm.mArg);
                }
                arrayDeque.add(" ");
                arrayDeque.add(cCAppTerm.mFunc);
                continue;
            }
            if (e instanceof CCBaseTerm) {
                stringBuilder.append(e);
                continue;
            }
            throw new AssertionError((Object)("Unknown CCTerm " + String.valueOf(e)));
        }
        return stringBuilder.toString();
    }

    class Parent
    extends SimpleListable<Parent> {
        private boolean mMark = false;

        Parent() {
        }

        CCAppTerm getData() {
            return CCAppTerm.this;
        }

        public final boolean isMarked() {
            assert (!this.mMark || CCAppTerm.this.mRepStar.mNumMembers > 1);
            return this.mMark;
        }

        public String toString() {
            return CCAppTerm.this.toString();
        }
    }
}

