/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LoopEntryAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import java.util.Set;

public class InvariantResult<ELEM extends IElement, E>
extends AbstractResultAtElement<ELEM> {
    private final E mInvariant;
    private final String mInvariantString;
    private final boolean mIsLoopLocation;
    private final Set<Check> mChecks;

    public InvariantResult(String string, ELEM ELEM, E e, String string2, Set<Check> set) {
        super(ELEM, string);
        LoopEntryAnnotation loopEntryAnnotation = LoopEntryAnnotation.getAnnotation(ELEM);
        this.mIsLoopLocation = loopEntryAnnotation != null && loopEntryAnnotation.getLoopEntryType() == LoopEntryAnnotation.LoopEntryType.WHILE;
        this.mInvariant = e;
        this.mInvariantString = string2;
        this.mChecks = set;
    }

    public E getInvariant() {
        return this.mInvariant;
    }

    public String getShortDescription() {
        return this.mIsLoopLocation ? "Loop Invariant" : "Location Invariant";
    }

    public String getLongDescription() {
        return (this.mIsLoopLocation ? "Derived loop invariant: " : "Derived location invariant: ") + this.mInvariantString;
    }

    public Set<Check> getChecks() {
        return this.mChecks;
    }
}

