/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IProblemType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;

public class ExplorativeNameVisitor
extends ASTVisitor {
    private final ILogger mLogger;

    public ExplorativeNameVisitor(ILogger iLogger) {
        super(true);
        this.shouldVisitAmbiguousNodes = true;
        this.mLogger = iLogger;
    }

    public int visit(IASTName iASTName2) {
        IScope iScope;
        this.mLogger.info((Object)"IASTName");
        this.mLogger.info((Object)("  " + iASTName2.getRawSignature()));
        IBinding iBinding = iASTName2.resolveBinding();
        IASTName[] iASTNameArray = iASTName2.getTranslationUnit().getDeclarationsInAST(iBinding);
        Arrays.stream(iASTNameArray).forEach(iASTName -> this.mLogger.info((Object)("  " + iASTName.getRawSignature() + " as " + iASTName.getRoleOfName(true))));
        ILinkage iLinkage = iBinding.getLinkage();
        try {
            iScope = iBinding.getScope();
        }
        catch (DOMException dOMException) {
            this.mLogger.fatal((Object)"  Exception during getScope: ", (Throwable)dOMException);
            return super.visit(iASTName2);
        }
        String string = iScope == null ? "NOSCOPE" : iScope.getKind().toString();
        this.mLogger.info((Object)("  Scope: " + string + " Linkage: " + iLinkage.getLinkageName()));
        if (iBinding instanceof IVariable) {
            IVariable iVariable = (IVariable)iBinding;
            this.mLogger.info((Object)("  " + this.toString(iVariable.getType())));
        } else if (iBinding instanceof ITypedef) {
            ITypedef iTypedef = (ITypedef)iBinding;
            this.mLogger.info((Object)("  " + this.toString(iTypedef.getType())));
        } else if (iBinding instanceof IFunction) {
            IFunction iFunction = (IFunction)iBinding;
            IScope iScope2 = iFunction.getFunctionScope();
            if (iScope2 == null) {
                this.mLogger.info((Object)"  NOFSCOPE");
            } else {
                this.mLogger.info((Object)("  " + String.valueOf(iScope2.getScopeName())));
                this.mLogger.info((Object)("  " + String.valueOf(iScope2.getKind())));
            }
            IFunctionType iFunctionType = iFunction.getType();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(iFunction.getName());
            stringBuilder.append("(");
            stringBuilder.append(Arrays.stream(iFunctionType.getParameterTypes()).map(this::toString).collect(Collectors.joining(",")));
            stringBuilder.append(") :");
            stringBuilder.append(this.toString(iFunctionType.getReturnType()));
            this.mLogger.info((Object)("  " + stringBuilder.toString() + " " + iFunction.getType().getClass().getSimpleName()));
        } else if (iBinding instanceof ICompositeType) {
            ICompositeType iCompositeType = (ICompositeType)iBinding;
            this.mLogger.info((Object)("  Fields: " + String.valueOf(iCompositeType.getFields())));
        } else {
            this.mLogger.info((Object)("  Unhandled binding class:" + iBinding.getClass().getSimpleName()));
        }
        return super.visit(iASTName2);
    }

    public int visit(IASTStatement iASTStatement) {
        this.mLogger.info(iASTStatement.getClass());
        return super.visit(iASTStatement);
    }

    private String toString(IType iType) {
        if (iType instanceof IProblemType) {
            IProblemType iProblemType = (IProblemType)iType;
            return "Problem: " + iProblemType.getMessage();
        }
        return String.valueOf(iType) + " (" + iType.getClass().getSimpleName() + ")";
    }
}

