/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ArrayEquality {
    private final Term mOriginalTerm;
    private final Term mLhs;
    private final Term mRhs;
    private final boolean mIsNegated;

    public ArrayEquality(Term term) throws ArrayEqualityException {
        this(term, false, false);
    }

    public ArrayEquality(Term term, boolean bl, boolean bl2) throws ArrayEqualityException {
        ApplicationTerm applicationTerm;
        boolean bl3;
        if (!(term instanceof ApplicationTerm)) {
            throw new ArrayEqualityException("no ApplicationTerm");
        }
        ApplicationTerm applicationTerm2 = (ApplicationTerm)term;
        boolean bl4 = applicationTerm2.getFunction().getName().equals("not") && applicationTerm2.getParameters()[0] instanceof ApplicationTerm && ((ApplicationTerm)applicationTerm2.getParameters()[0]).getFunction().getName().equals("=");
        this.mIsNegated = bl3 = applicationTerm2.getFunction().getName().equals("distinct") || bl4;
        if (!applicationTerm2.getFunction().getName().equals("=")) {
            if (!bl) {
                throw new ArrayEqualityException("no equality");
            }
            if (!bl3) {
                throw new ArrayEqualityException("no (dis)equality");
            }
        }
        ApplicationTerm applicationTerm3 = applicationTerm = bl4 ? (ApplicationTerm)applicationTerm2.getParameters()[0] : applicationTerm2;
        if (applicationTerm.getParameters().length != 2) {
            throw new ArrayEqualityException("no binary equality");
        }
        this.mOriginalTerm = term;
        Term term2 = applicationTerm.getParameters()[0];
        Term term3 = applicationTerm.getParameters()[1];
        if (!term2.getSort().isArraySort()) {
            throw new ArrayEqualityException("no array");
        }
        if (term2 instanceof TermVariable) {
            this.mLhs = term2;
        } else if (bl2 && ArrayEquality.isTermVarOrConst(term2)) {
            this.mLhs = term2;
        } else {
            throw new ArrayEqualityException("no TermVariable or constant");
        }
        if (term3 instanceof TermVariable) {
            this.mRhs = term3;
        } else if (bl2 && ArrayEquality.isTermVarOrConst(term3)) {
            this.mRhs = term3;
        } else {
            throw new ArrayEqualityException("no TermVariable or constant");
        }
    }

    public Term getOriginalTerm() {
        return this.mOriginalTerm;
    }

    public Term getLhs() {
        return this.mLhs;
    }

    public Term getRhs() {
        return this.mRhs;
    }

    public TermVariable getLhsTermVariable() {
        return (TermVariable)this.mLhs;
    }

    public TermVariable getRhsTermVariable() {
        return (TermVariable)this.mRhs;
    }

    public boolean isNegated() {
        return this.mIsNegated;
    }

    public static List<ArrayEquality> extractArrayEqualities(Term term) {
        Set<String> set = Set.of("=", "distinct", "not");
        ArrayList<ArrayEquality> arrayList = new ArrayList<ArrayEquality>();
        for (ApplicationTerm applicationTerm : SmtUtils.extractApplicationTerms(set, term, false)) {
            ArrayEquality arrayEquality = null;
            try {
                arrayEquality = new ArrayEquality((Term)applicationTerm, true, true);
            }
            catch (ArrayEqualityException arrayEqualityException) {
                continue;
            }
            arrayList.add(arrayEquality);
        }
        return arrayList;
    }

    private static boolean isTermVarOrConst(Term term) {
        if (term instanceof TermVariable) {
            return true;
        }
        if (term instanceof ConstantTerm) {
            return true;
        }
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getParameters().length == 0;
    }

    public String toString() {
        return this.mOriginalTerm.toString();
    }

    public static class ArrayEqualityException
    extends Exception {
        private static final long serialVersionUID = -5344050289008681972L;

        public ArrayEqualityException(String string) {
            super(string);
        }
    }

    public static class ArrayEqualityExtractor {
        private final List<ArrayEquality> mArrayEqualities = new ArrayList<ArrayEquality>();
        private final List<Term> remainingTerms = new ArrayList<Term>();

        public ArrayEqualityExtractor(Term[] termArray) {
            Term[] termArray2 = termArray;
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArrayEquality arrayEquality;
                Term term = termArray2[n2];
                try {
                    arrayEquality = new ArrayEquality(term);
                }
                catch (ArrayEqualityException arrayEqualityException) {
                    arrayEquality = null;
                }
                if (arrayEquality == null) {
                    this.remainingTerms.add(term);
                } else {
                    this.mArrayEqualities.add(arrayEquality);
                }
                ++n2;
            }
        }

        public List<ArrayEquality> getArrayEqualities() {
            return this.mArrayEqualities;
        }

        public List<Term> getRemainingTerms() {
            return this.remainingTerms;
        }
    }
}

