/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.InequalityConverter;
import java.io.File;
import java.io.Serializable;

public class LassoRankerPreferences
implements Serializable,
ILassoRankerPreferences {
    private static final long serialVersionUID = 3253589986886574198L;
    private final boolean mComputeIntegralHull;
    private final boolean mEnablePartitioneer;
    private final boolean mAnnotateTerms;
    private final boolean mExternalSolver;
    private final String mExternalSolverCommand;
    private final boolean mDumpSmtSolverScript;
    private final String mPathOfDumpedScript;
    private final String mBaseNameOfDumpedScript;
    private final boolean mOverapproximateArrayIndexConnection;
    private final InequalityConverter.NlaHandling mNlaHandling;
    private final boolean mUseOldMapElimination;
    private final boolean mMapElimAddInequalities;
    private final boolean mMapElimOnlyTrivialImplicationsIndexAssignment;
    private final boolean mMapElimOnlyTrivialImplicationsArrayWrite;
    private final boolean mMapElimOnlyIndicesInFormula;
    private final boolean mFakeNonIncrementalScript;

    public LassoRankerPreferences(ILassoRankerPreferences iLassoRankerPreferences) {
        this(iLassoRankerPreferences.isComputeIntegralHull(), iLassoRankerPreferences.isEnablePartitioneer(), iLassoRankerPreferences.isAnnotateTerms(), iLassoRankerPreferences.isExternalSolver(), iLassoRankerPreferences.getExternalSolverCommand(), iLassoRankerPreferences.isDumpSmtSolverScript(), iLassoRankerPreferences.getPathOfDumpedScript(), iLassoRankerPreferences.getBaseNameOfDumpedScript(), iLassoRankerPreferences.isOverapproximateArrayIndexConnection(), iLassoRankerPreferences.getNlaHandling(), iLassoRankerPreferences.isUseOldMapElimination(), iLassoRankerPreferences.isMapElimAddInequalities(), iLassoRankerPreferences.isMapElimOnlyTrivialImplicationsIndexAssignment(), iLassoRankerPreferences.isMapElimOnlyTrivialImplicationsArrayWrite(), iLassoRankerPreferences.isMapElimOnlyIndicesInFormula(), iLassoRankerPreferences.isFakeNonIncrementalScript());
    }

    private LassoRankerPreferences(boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, boolean bl5, String string2, String string3, boolean bl6, InequalityConverter.NlaHandling nlaHandling, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12) {
        this.mComputeIntegralHull = bl;
        this.mEnablePartitioneer = bl2;
        this.mAnnotateTerms = bl3;
        this.mExternalSolver = bl4;
        this.mExternalSolverCommand = string;
        this.mDumpSmtSolverScript = bl5;
        this.mPathOfDumpedScript = string2;
        this.mBaseNameOfDumpedScript = string3;
        this.mOverapproximateArrayIndexConnection = bl6;
        this.mNlaHandling = nlaHandling;
        this.mUseOldMapElimination = bl7;
        this.mMapElimAddInequalities = bl8;
        this.mMapElimOnlyTrivialImplicationsIndexAssignment = bl9;
        this.mMapElimOnlyTrivialImplicationsArrayWrite = bl10;
        this.mMapElimOnlyIndicesInFormula = bl11;
        this.mFakeNonIncrementalScript = bl12;
        assert (this.isSane()) : "Settings are invalid";
    }

    private boolean isSane() {
        if (this.mExternalSolverCommand != null && this.mPathOfDumpedScript != null) {
            if (this.mDumpSmtSolverScript) {
                File file = new File(this.mPathOfDumpedScript);
                return file.exists() && file.isDirectory() && this.mBaseNameOfDumpedScript != null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isComputeIntegralHull() {
        return this.mComputeIntegralHull;
    }

    @Override
    public boolean isEnablePartitioneer() {
        return this.mEnablePartitioneer;
    }

    @Override
    public boolean isAnnotateTerms() {
        return this.mAnnotateTerms;
    }

    @Override
    public boolean isExternalSolver() {
        return this.mExternalSolver;
    }

    @Override
    public String getExternalSolverCommand() {
        return this.mExternalSolverCommand;
    }

    @Override
    public boolean isDumpSmtSolverScript() {
        return this.mDumpSmtSolverScript;
    }

    @Override
    public String getPathOfDumpedScript() {
        return this.mPathOfDumpedScript;
    }

    @Override
    public String getBaseNameOfDumpedScript() {
        return this.mBaseNameOfDumpedScript;
    }

    @Override
    public boolean isOverapproximateArrayIndexConnection() {
        return this.mOverapproximateArrayIndexConnection;
    }

    @Override
    public InequalityConverter.NlaHandling getNlaHandling() {
        return this.mNlaHandling;
    }

    @Override
    public boolean isUseOldMapElimination() {
        return this.mUseOldMapElimination;
    }

    @Override
    public boolean isMapElimAddInequalities() {
        return this.mMapElimAddInequalities;
    }

    @Override
    public boolean isMapElimOnlyTrivialImplicationsIndexAssignment() {
        return this.mMapElimOnlyTrivialImplicationsIndexAssignment;
    }

    @Override
    public boolean isMapElimOnlyTrivialImplicationsArrayWrite() {
        return this.mMapElimOnlyTrivialImplicationsArrayWrite;
    }

    @Override
    public boolean isMapElimOnlyIndicesInFormula() {
        return this.mMapElimOnlyIndicesInFormula;
    }

    @Override
    public boolean isFakeNonIncrementalScript() {
        return this.mFakeNonIncrementalScript;
    }
}

