/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.TCSWriter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Vector;

public class VacuousAssignment
extends TCSWriter {
    protected BufferedWriter writer;
    protected boolean rename;
    protected PhaseEventAutomata pea2write;
    private int i = 0;
    private final Vector<CDD> possiblyVacuous;
    private Vector<CDD> possibleVacuousMaker;
    private Vector<String> vacuousReqNames;
    private Vector<CDD> vacuous;

    public VacuousAssignment(String string, PhaseEventAutomata phaseEventAutomata) {
        super(string);
        this.pea2write = phaseEventAutomata;
        this.possiblyVacuous = new Vector();
        this.setVacuous(new Vector<CDD>());
        this.setPossibleVacuousMaker(new Vector<CDD>());
        this.setVacuousReqNames(new Vector<String>());
    }

    public VacuousAssignment(String string, boolean bl, PhaseEventAutomata phaseEventAutomata) {
        this(string, phaseEventAutomata);
        this.rename = bl;
        this.setVacuous(new Vector<CDD>());
        this.setPossibleVacuousMaker(new Vector<CDD>());
        this.setVacuousReqNames(new Vector<String>());
    }

    public void getVacuousAssignments(PhaseEventAutomata phaseEventAutomata) throws IOException {
        System.out.println("*********************************************************");
        System.out.println("Queries to check for a vacuous satisfaction for PEA " + phaseEventAutomata.getName());
        List<Phase> list = phaseEventAutomata.getInit();
        int n = phaseEventAutomata.getPhases().size();
        if (n < 0) {
            System.out.println("ERROR: The pea is empty");
        }
        if (n == 1) {
            CDD cDD = phaseEventAutomata.getPhases().get(0).getStateInvariant();
            int n2 = this.getPossibleVacuousMakerLength();
            int n3 = 0;
            while (n3 < n2) {
                CDD cDD2 = this.getPossibleVacuousMaker().elementAt(n3);
                if (cDD.implies(cDD2)) {
                    this.addToVacuous(cDD);
                } else if (cDD2.implies(cDD)) {
                    this.addToVacuous(cDD2);
                }
                ++n3;
            }
            this.addToPossVacuousMaker(cDD);
            String string = cDD.toString("uppaal", true);
            System.out.println("A[](" + string + ");");
            this.writer.write("A[](" + string + ");");
            this.writer.newLine();
            this.writer.flush();
        } else {
            int n4 = list.size();
            int n5 = 0;
            while (n5 < n4) {
                Phase phase = list.get(0);
                if (phase.getClockInvariant() == CDD.TRUE) {
                    CDD cDD = phase.getStateInvariant();
                    this.addToPossiblyVacuous(cDD);
                    String string = cDD.toString("uppaal", true);
                    System.out.println("A[](" + string + ");");
                    this.writer.write("A[](" + string + ");");
                    this.writer.newLine();
                    this.writer.flush();
                }
                ++n5;
            }
            System.out.println("*********************************************************");
        }
    }

    public void getVacuousAssignments(PhaseEventAutomata phaseEventAutomata, String string) throws IOException {
        this.getVacuousAssignments(phaseEventAutomata);
    }

    public void checkVacuousSatisfiability(PhaseEventAutomata phaseEventAutomata) {
        Vector<CDD> vector = this.getPossiblyVacuous();
        if (vector.isEmpty()) {
            System.out.println("Before checking for vacuous satisfaction, you need to built-up the vacuous-vector");
        } else {
            this.checkPossiblyVacuous(phaseEventAutomata);
            this.checkPossibleVacuousMaker(phaseEventAutomata);
        }
    }

    private void checkPossiblyVacuous(PhaseEventAutomata phaseEventAutomata) {
        List<Phase> list = phaseEventAutomata.getPhases();
        Vector<CDD> vector = this.getPossiblyVacuous();
        if (list.size() > 1) {
            int n = 0;
            while (n < vector.size()) {
                boolean bl = true;
                CDD cDD = vector.elementAt(n);
                for (Phase phase : list) {
                    CDD cDD2 = phase.getStateInvariant();
                    if (cDD2.and(cDD) != CDD.FALSE) continue;
                    bl = false;
                }
                if (bl) {
                    this.addToVacuous(cDD);
                }
                ++n;
            }
        }
    }

    private void checkPossibleVacuousMaker(PhaseEventAutomata phaseEventAutomata) {
        Vector<CDD> vector = this.getPossibleVacuousMaker();
        Vector<CDD> vector2 = this.getPossiblyVacuous();
        if (vector.isEmpty() || vector2.isEmpty()) {
            System.out.println("no possible vacuous formulas known OR no possible vacuous maker known");
        } else {
            boolean bl = false;
            int n = 0;
            while (n < vector.size() && !bl) {
                CDD cDD = vector.elementAt(n);
                int n2 = 0;
                while (n2 < vector2.size()) {
                    CDD cDD2 = vector2.elementAt(n2);
                    if (cDD.implies(cDD2)) {
                        bl = true;
                        this.addToVacuous(cDD2);
                        this.addToVacuous(cDD);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public void startWriting() {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.mFileName));
            this.writer.write("Preamble:\n Queries to check for a vacuous satisfaction for PEA");
            this.writer.newLine();
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void stopWriting() throws IOException {
        this.writer.close();
        System.out.println("Successfully written to " + this.mFileName);
    }

    @Override
    public void write() {
        try {
            this.writer = new BufferedWriter(new FileWriter("fileName"));
            this.getVacuousAssignments(this.pea2write);
            this.writer.flush();
            this.writer.close();
            System.out.println("Successfully written to " + this.mFileName);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void writePEA(PhaseEventAutomata phaseEventAutomata) {
        try {
            this.writer.write("Queries to check for requirement " + this.i);
            this.writer.newLine();
            ++this.i;
            this.getVacuousAssignments(phaseEventAutomata);
            this.writer.newLine();
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    protected void writeAndDelimiter(Writer writer) throws IOException {
    }

    protected void writeDecision(Decision decision, int n, Writer writer) throws IOException {
    }

    public Vector<CDD> getPossiblyVacuous() {
        return this.possiblyVacuous;
    }

    public void setVacuous(Vector<CDD> vector) {
        this.vacuous = vector;
    }

    public Vector<CDD> getVacuous() {
        return this.vacuous;
    }

    public void addToVacuous(CDD cDD) {
        if (this.vacuous.contains(cDD)) {
            return;
        }
        this.vacuous.add(cDD);
    }

    public void addToPossiblyVacuous(CDD cDD) {
        if (this.possiblyVacuous.contains(cDD)) {
            return;
        }
        this.possiblyVacuous.add(cDD);
    }

    public void addToPossVacuousMaker(CDD cDD) {
        if (this.possibleVacuousMaker.contains(cDD)) {
            return;
        }
        this.possibleVacuousMaker.add(cDD);
    }

    public void addToVacuousReqNames(String string) {
        if (this.vacuousReqNames.contains(string)) {
            return;
        }
        this.vacuousReqNames.add(string);
    }

    public Vector<CDD> getPossibleVacuousMaker() {
        return this.possibleVacuousMaker;
    }

    private int getPossibleVacuousMakerLength() {
        return this.possibleVacuousMaker.size();
    }

    private void setPossibleVacuousMaker(Vector<CDD> vector) {
        this.possibleVacuousMaker = vector;
    }

    public Vector<String> getVacuousReqNames() {
        return this.vacuousReqNames;
    }

    private void setVacuousReqNames(Vector<String> vector) {
        this.vacuousReqNames = vector;
    }
}

