/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.BitvectorUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class IntToBvBackTranslation
extends TermTransformer {
    private final ManagedScript mMgdScript;
    private final Script mScript;
    private final LinkedHashMap<Term, Term> mVariableMap;
    private final Set<Term> mConstraintSet;
    private final FunctionSymbol mIntand;

    public IntToBvBackTranslation(ManagedScript managedScript, LinkedHashMap<Term, Term> linkedHashMap, Set<Term> set, FunctionSymbol functionSymbol) {
        this.mMgdScript = managedScript;
        this.mScript = managedScript.getScript();
        this.mVariableMap = linkedHashMap;
        this.mConstraintSet = set;
        this.mIntand = functionSymbol;
    }

    public void convert(Term term) {
        ApplicationTerm applicationTerm;
        if (this.mConstraintSet.contains(term)) {
            this.setResult(this.mScript.term("true", new Term[0]));
            return;
        }
        if (this.mVariableMap.containsKey(term)) {
            this.setResult(this.mVariableMap.get(term));
            return;
        }
        if (term instanceof ConstantTerm) {
            this.setResult(this.translateConst((ConstantTerm)term));
            return;
        }
        if (term instanceof TermVariable) {
            throw new UnsupportedOperationException("Cannot translate AuxVars back to Bitvector Sort " + String.valueOf(term));
        }
        if (term instanceof ApplicationTerm && (applicationTerm = (ApplicationTerm)term).getParameters().length == 0 && SmtUtils.isConstant((Term)applicationTerm)) {
            throw new UnsupportedOperationException("Cannot translate AuxVars back to Bitvector Sort " + String.valueOf(term));
        }
        super.convert(term);
    }

    public void postConvertQuantifier(QuantifiedFormula quantifiedFormula, Term term) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        if (term != quantifiedFormula.getSubformula()) {
            int n = 0;
            while (n < quantifiedFormula.getVariables().length) {
                if (this.mVariableMap.containsKey(quantifiedFormula.getVariables()[n])) {
                    hashSet.add((TermVariable)this.mVariableMap.get(quantifiedFormula.getVariables()[n]));
                } else {
                    hashSet.add(quantifiedFormula.getVariables()[n]);
                }
                ++n;
            }
            this.setResult(SmtUtils.quantifier(this.mScript, quantifiedFormula.getQuantifier(), hashSet, term));
        } else {
            super.postConvertQuantifier(quantifiedFormula, term);
        }
    }

    private Term bringTermToWidth(Term term, int n, boolean bl) {
        if (!SmtSortUtils.isBitvecSort(term.getSort())) {
            return term;
        }
        int n2 = Integer.valueOf(term.getSort().getIndices()[0]);
        if (n2 == n) {
            return term;
        }
        if (n2 > n) {
            BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(n - 1), BigInteger.valueOf(0L)};
            return BitvectorUtils.unfTerm(this.mScript, "extract", bigIntegerArray, term);
        }
        int n3 = n - n2;
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(n3)};
        if (!bl) {
            return BitvectorUtils.unfTerm(this.mScript, "zero_extend", bigIntegerArray, term);
        }
        return BitvectorUtils.unfTerm(this.mScript, "sign_extend", bigIntegerArray, term);
    }

    private int getTwoExponent(Rational rational) {
        BigInteger bigInteger = rational.numerator();
        int n = Integer.lowestOneBit(bigInteger.intValue());
        if (Integer.highestOneBit(bigInteger.intValue()) == n) {
            return bigInteger.bitLength() - 1;
        }
        throw new UnsupportedOperationException("Not a power of two");
    }

    /*
     * Unable to fully structure code
     */
    private boolean isPowerOfTwo(Rational var1_1) {
        var2_2 = var1_1.numerator();
        if (BigInteger.ZERO.compareTo(var2_2) != 0) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            if (var2_2.mod(BigInteger.TWO) != BigInteger.ZERO) {
                return false;
            }
            var2_2 = var2_2.divide(BigInteger.TWO);
lbl7:
            // 2 sources

            ** while (BigInteger.ONE.compareTo((BigInteger)var2_2) != 0)
        }
lbl8:
        // 1 sources

        return true;
    }

    private boolean isSigned(Term term) {
        if (this.mVariableMap.containsKey(term)) {
            return false;
        }
        if (term instanceof ConstantTerm) {
            return ((Rational)((ConstantTerm)term).getValue()).isNegative();
        }
        if (term instanceof TermVariable) {
            return false;
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            if (applicationTerm.getParameters().length == 0) {
                if (SmtUtils.isConstant((Term)applicationTerm)) {
                    return false;
                }
                throw new UnsupportedOperationException("Cannot translate AuxVars back to Bitvector Sort " + String.valueOf(term));
            }
            if (applicationTerm.getFunction().getName().equals("-")) {
                return true;
            }
            if (applicationTerm.getFunction().getName().equals("mod")) {
                return false;
            }
            boolean bl = false;
            int n = 0;
            while (n < applicationTerm.getParameters().length) {
                Term term2 = applicationTerm.getParameters()[n];
                bl = bl || this.isSigned(term2);
                ++n;
            }
            return bl;
        }
        if (term instanceof QuantifiedFormula) {
            throw new UnsupportedOperationException("Unsupported sign of quantified formula");
        }
        throw new UnsupportedOperationException("Unknown Sign");
    }

    private Term getInnerMostArray(Term term) {
        MultiDimensionalSelectOverNestedStore multiDimensionalSelectOverNestedStore;
        Term term2;
        if (term instanceof TermVariable) {
            return term;
        }
        MultiDimensionalSelect multiDimensionalSelect = MultiDimensionalSelect.of(term);
        if (multiDimensionalSelect.getIndex().size() > 0) {
            term2 = multiDimensionalSelect.getArray();
        } else {
            multiDimensionalSelectOverNestedStore = MultiDimensionalSelectOverNestedStore.of(term);
            if (multiDimensionalSelectOverNestedStore != null) {
                term2 = multiDimensionalSelectOverNestedStore.getNestedStore().toTerm(this.mScript);
            } else {
                throw new UnsupportedOperationException("unable to compute width: " + String.valueOf(term));
            }
        }
        if (term2 instanceof ApplicationTerm) {
            multiDimensionalSelectOverNestedStore = (ApplicationTerm)term2;
            if (multiDimensionalSelectOverNestedStore.getFunction().getName().equals("select")) {
                term2 = this.getInnerMostArray(multiDimensionalSelectOverNestedStore.getParameters()[0]);
            } else if (multiDimensionalSelectOverNestedStore.getFunction().getName().equals("store")) {
                term2 = this.getInnerMostArray(multiDimensionalSelectOverNestedStore.getParameters()[0]);
            }
        }
        return term2;
    }

    private Integer getWidth(Term term) {
        block38: {
            int n;
            block40: {
                ApplicationTerm applicationTerm;
                block39: {
                    n = 0;
                    if (this.mVariableMap.containsKey(term)) {
                        return Integer.valueOf(this.mVariableMap.get(term).getSort().getIndices()[0]);
                    }
                    if (term instanceof ConstantTerm) {
                        Rational rational = (Rational)((ConstantTerm)term).getValue();
                        int n2 = rational.abs().numerator().bitLength();
                        n = n2 == 0 ? 1 : n2;
                        return n;
                    }
                    if (term instanceof TermVariable) {
                        throw new UnsupportedOperationException("Unknown width of AuxVar");
                    }
                    if (!(term instanceof ApplicationTerm)) break block38;
                    applicationTerm = (ApplicationTerm)term;
                    if (applicationTerm.getParameters().length == 0) {
                        if (SmtUtils.isConstant((Term)applicationTerm)) {
                            throw new UnsupportedOperationException("Unknown width of AuxVar");
                        }
                        throw new UnsupportedOperationException("Unkexpected term: " + String.valueOf(applicationTerm));
                    }
                    if (applicationTerm.getParameters().length == 1) {
                        if (applicationTerm.getFunction().getName().equals("-")) {
                            n = this.getWidth(applicationTerm.getParameters()[0]);
                        } else {
                            throw new UnsupportedOperationException("Unkexpected term: " + String.valueOf(applicationTerm));
                        }
                    }
                    if (!applicationTerm.getFunction().getName().equals("select")) break block39;
                    Term term2 = this.getInnerMostArray((Term)applicationTerm);
                    Term term3 = this.mVariableMap.get(term2);
                    if (term3 == null) {
                        throw new UnsupportedOperationException("Unknown Array: " + String.valueOf(term2));
                    }
                    MultiDimensionalSort multiDimensionalSort = new MultiDimensionalSort(term3.getSort());
                    Sort sort = multiDimensionalSort.getArrayValueSort();
                    n = Integer.valueOf(sort.getIndices()[0]);
                    break block40;
                }
                int n3 = !SmtSortUtils.isIntSort(applicationTerm.getParameters()[0].getSort()) ? 1 : this.getWidth(applicationTerm.getParameters()[0]);
                int n4 = 1;
                while (n4 < applicationTerm.getParameters().length) {
                    Object object = applicationTerm.getParameters()[n4];
                    int n5 = this.getWidth((Term)object);
                    if (n5 > n3) {
                        n3 = n5;
                    }
                    ++n4;
                }
                n = n3;
                FunctionSymbol functionSymbol = applicationTerm.getFunction();
                if (!functionSymbol.isIntern()) break block40;
                switch (functionSymbol.getName()) {
                    case "*": {
                        if (applicationTerm.getParameters().length == 2) {
                            ConstantTerm constantTerm;
                            Rational rational;
                            if (applicationTerm.getParameters()[0] instanceof ConstantTerm) {
                                ConstantTerm constantTerm2 = (ConstantTerm)applicationTerm.getParameters()[0];
                                Rational rational2 = (Rational)constantTerm2.getValue();
                                if (this.isPowerOfTwo(rational2)) {
                                    n = this.getWidth(applicationTerm.getParameters()[1]) + this.getTwoExponent(rational2);
                                    break;
                                }
                            } else if (applicationTerm.getParameters()[1] instanceof ConstantTerm && this.isPowerOfTwo(rational = (Rational)(constantTerm = (ConstantTerm)applicationTerm.getParameters()[1]).getValue())) {
                                n = this.getWidth(applicationTerm.getParameters()[0]) + this.getTwoExponent(rational);
                                break;
                            }
                        }
                        n = n3 * 2;
                        break;
                    }
                    case "+": {
                        n = n3 + 1;
                        break;
                    }
                    case "-": {
                        if (applicationTerm.getParameters()[0] instanceof ConstantTerm && this.isPowerOfTwo((Rational)((ConstantTerm)applicationTerm.getParameters()[0]).getValue())) {
                            n = this.getWidth(applicationTerm.getParameters()[1]);
                            break;
                        }
                        n = n3 + 1;
                        break;
                    }
                    case "mod": {
                        ConstantTerm constantTerm;
                        Rational rational;
                        if (applicationTerm.getParameters()[1] instanceof ConstantTerm && this.isPowerOfTwo(rational = (Rational)(constantTerm = (ConstantTerm)applicationTerm.getParameters()[1]).getValue())) {
                            n = this.getTwoExponent(rational);
                            break;
                        }
                        n = n3;
                        break;
                    }
                    case "div": {
                        ConstantTerm constantTerm;
                        Rational rational;
                        if (applicationTerm.getParameters()[1] instanceof ConstantTerm && this.isPowerOfTwo(rational = (Rational)(constantTerm = (ConstantTerm)applicationTerm.getParameters()[1]).getValue())) {
                            n = this.getWidth(applicationTerm.getParameters()[0]) - this.getTwoExponent(rational);
                            break;
                        }
                        n = n3;
                        break;
                    }
                    default: {
                        n = n3;
                    }
                }
            }
            return n;
        }
        throw new UnsupportedOperationException("Unexpected Term " + String.valueOf(term));
    }

    public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
        Term[] termArray2;
        block81: {
            termArray2 = new Term[termArray.length];
            Term[] termArray3 = applicationTerm.getParameters();
            if (this.mConstraintSet.contains(applicationTerm)) {
                this.setResult(this.mScript.term("true", new Term[0]));
                return;
            }
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            if (functionSymbol.equals(this.mIntand) || functionSymbol.getName().equals("intand")) {
                int n = 0;
                while (n < termArray.length) {
                    termArray2[n] = this.bringTermToWidth(termArray[n], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[n]));
                    ++n;
                }
                this.setResult(BitvectorUtils.unfTerm(this.mScript, "bvand", null, termArray2));
                return;
            }
            if (!functionSymbol.isIntern()) break block81;
            switch (functionSymbol.getName()) {
                case "=": {
                    int n = 0;
                    while (n < termArray.length) {
                        termArray2[n] = SmtSortUtils.isIntSort(applicationTerm.getParameters()[0].getSort()) ? this.bringTermToWidth(termArray[n], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[n])) : termArray[n];
                        ++n;
                    }
                    this.setResult(SmtUtils.equality(this.mScript, termArray2));
                    return;
                }
                case "<": {
                    if (this.isSigned((Term)applicationTerm)) {
                        int n = 0;
                        while (n < termArray.length) {
                            termArray2[n] = this.bringTermToWidth(termArray[n], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[n]));
                            ++n;
                        }
                        this.setResult(BitvectorUtils.unfTerm(this.mScript, "bvslt", null, termArray2));
                        return;
                    }
                    int n = 0;
                    while (n < termArray.length) {
                        termArray2[n] = this.bringTermToWidth(termArray[n], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[n]));
                        ++n;
                    }
                    this.setResult(BitvectorUtils.unfTerm(this.mScript, "bvult", null, termArray2));
                    return;
                }
                case "<=": {
                    if (this.isSigned((Term)applicationTerm)) {
                        int n = 0;
                        while (n < termArray.length) {
                            termArray2[n] = this.bringTermToWidth(termArray[n], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[n]));
                            ++n;
                        }
                        this.setResult(BitvectorUtils.unfTerm(this.mScript, "bvsle", null, termArray2));
                        return;
                    }
                    int n = 0;
                    while (n < termArray.length) {
                        termArray2[n] = this.bringTermToWidth(termArray[n], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[n]));
                        ++n;
                    }
                    this.setResult(BitvectorUtils.unfTerm(this.mScript, "bvule", null, termArray2));
                    return;
                }
                case ">=": {
                    if (this.isSigned((Term)applicationTerm)) {
                        int n = 0;
                        while (n < termArray.length) {
                            termArray2[n] = this.bringTermToWidth(termArray[n], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[n]));
                            ++n;
                        }
                        this.setResult(BitvectorUtils.unfTerm(this.mScript, "bvsge", null, termArray2));
                        return;
                    }
                    int n = 0;
                    while (n < termArray.length) {
                        termArray2[n] = this.bringTermToWidth(termArray[n], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[n]));
                        ++n;
                    }
                    this.setResult(BitvectorUtils.unfTerm(this.mScript, "bvuge", null, termArray2));
                    return;
                }
                case ">": {
                    if (this.isSigned((Term)applicationTerm)) {
                        int n = 0;
                        while (n < termArray.length) {
                            termArray2[n] = this.bringTermToWidth(termArray[n], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[n]));
                            ++n;
                        }
                        this.setResult(BitvectorUtils.unfTerm(this.mScript, "bvsgt", null, termArray2));
                        return;
                    }
                    int n = 0;
                    while (n < termArray.length) {
                        termArray2[n] = this.bringTermToWidth(termArray[n], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[n]));
                        ++n;
                    }
                    this.setResult(BitvectorUtils.unfTerm(this.mScript, "bvugt", null, termArray2));
                    return;
                }
                case "+": {
                    int n = 0;
                    while (n < termArray.length) {
                        termArray2[n] = this.bringTermToWidth(termArray[n], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[n]));
                        ++n;
                    }
                    this.setResult(SmtUtils.binaryBitvectorSum(this.mScript, null, termArray2));
                    return;
                }
                case "*": {
                    ConstantTerm constantTerm;
                    Rational rational;
                    if (applicationTerm.getParameters()[1] instanceof ConstantTerm && this.isPowerOfTwo(rational = (Rational)(constantTerm = (ConstantTerm)applicationTerm.getParameters()[1]).getValue())) {
                        Term term = BitvectorUtils.constructTerm(this.mScript, new BitvectorConstant(BigInteger.ZERO, BigInteger.valueOf(this.getTwoExponent(rational))));
                        this.setResult(BitvectorUtils.unfTerm(this.mScript, "concat", null, termArray[0], term));
                        return;
                    }
                    int n = 0;
                    while (n < termArray.length) {
                        termArray2[n] = this.bringTermToWidth(termArray[n], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[n]));
                        ++n;
                    }
                    this.setResult(BitvectorUtils.unfTerm(this.mScript, "bvmul", null, termArray2));
                    return;
                }
                case "-": {
                    if (applicationTerm.getParameters().length == 1) {
                        assert (!(termArray[0] instanceof ConstantTerm));
                        this.setResult(this.mScript.term("bvneg", new Term[]{this.bringTermToWidth(termArray[0], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[0]))}));
                        return;
                    }
                    int n = 0;
                    while (n < termArray.length) {
                        termArray2[n] = this.bringTermToWidth(termArray[n], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[n]));
                        ++n;
                    }
                    this.setResult(BitvectorUtils.unfTerm(this.mScript, "bvsub", null, termArray2));
                    return;
                }
                case "mod": {
                    ConstantTerm constantTerm;
                    Rational rational;
                    if (applicationTerm.getParameters()[1] instanceof ConstantTerm && this.isPowerOfTwo(rational = (Rational)(constantTerm = (ConstantTerm)applicationTerm.getParameters()[1]).getValue())) {
                        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(this.getTwoExponent(rational) - 1), BigInteger.valueOf(0L)};
                        this.setResult(BitvectorUtils.unfTerm(this.mScript, "extract", bigIntegerArray, termArray[0]));
                        return;
                    }
                    if (this.isSigned((Term)applicationTerm)) {
                        int n = this.getWidth((Term)applicationTerm);
                        int n2 = 0;
                        while (n2 < termArray.length) {
                            termArray2[n2] = this.bringTermToWidth(termArray[n2], n, this.isSigned(termArray3[n2]));
                            ++n2;
                        }
                        Term term = BitvectorUtils.constructTerm(this.mScript, new BitvectorConstant(BigInteger.ONE, BigInteger.valueOf(1L)));
                        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(n - 1), BigInteger.valueOf(n - 1)};
                        Term term2 = BitvectorUtils.unfTerm(this.mScript, "bvsmod", null, termArray2);
                        Term term3 = SmtUtils.binaryEquality(this.mScript, BitvectorUtils.unfTerm(this.mScript, "extract", bigIntegerArray, termArray2[1]), term);
                        Term term4 = BitvectorUtils.unfTerm(this.mScript, "bvneg", null, BitvectorUtils.unfTerm(this.mScript, "bvsub", null, termArray2[1], term2));
                        this.setResult(Util.ite((Script)this.mScript, (Term)term3, (Term)term4, (Term)term2));
                        return;
                    }
                    int n = 0;
                    while (n < termArray.length) {
                        termArray2[n] = this.bringTermToWidth(termArray[n], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[n]));
                        ++n;
                    }
                    this.setResult(BitvectorUtils.unfTerm(this.mScript, "bvurem", null, termArray2));
                    return;
                }
                case "div": {
                    ConstantTerm constantTerm;
                    Rational rational;
                    if (applicationTerm.getParameters()[1] instanceof ConstantTerm && this.isPowerOfTwo(rational = (Rational)(constantTerm = (ConstantTerm)applicationTerm.getParameters()[1]).getValue())) {
                        BigInteger[] bigIntegerArray = new BigInteger[2];
                        int n = Integer.valueOf(termArray[0].getSort().getIndices()[0]);
                        int n3 = this.getTwoExponent(rational);
                        if (n3 > n - 1) {
                            Term term = BitvectorUtils.constructTerm(this.mScript, new BitvectorConstant(BigInteger.ZERO, BigInteger.valueOf(1L)));
                            this.setResult(term);
                            return;
                        }
                        bigIntegerArray[0] = BigInteger.valueOf(n - 1);
                        bigIntegerArray[1] = BigInteger.valueOf(n3);
                        this.setResult(BitvectorUtils.unfTerm(this.mScript, "extract", bigIntegerArray, termArray[0]));
                        return;
                    }
                    if (this.isSigned((Term)applicationTerm)) {
                        int n = this.getWidth((Term)applicationTerm);
                        int n4 = 0;
                        while (n4 < termArray.length) {
                            termArray2[n4] = this.bringTermToWidth(termArray[n4], n, this.isSigned(termArray3[n4]));
                            ++n4;
                        }
                        Term term = BitvectorUtils.unfTerm(this.mScript, "bvsdiv", null, termArray2);
                        Term term5 = BitvectorUtils.unfTerm(this.mScript, "bvurem", null, termArray2);
                        Term term6 = BitvectorUtils.constructTerm(this.mScript, new BitvectorConstant(BigInteger.ZERO, BigInteger.valueOf(n)));
                        Term term7 = BitvectorUtils.constructTerm(this.mScript, new BitvectorConstant(BigInteger.ONE, BigInteger.valueOf(n)));
                        Term term8 = BitvectorUtils.constructTerm(this.mScript, new BitvectorConstant(BigInteger.ZERO, BigInteger.valueOf(1L)));
                        Term term9 = BitvectorUtils.constructTerm(this.mScript, new BitvectorConstant(BigInteger.ONE, BigInteger.valueOf(1L)));
                        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(n - 1), BigInteger.valueOf(n - 1)};
                        Term term10 = BitvectorUtils.unfTerm(this.mScript, "extract", bigIntegerArray, termArray2[0]);
                        Term term11 = BitvectorUtils.unfTerm(this.mScript, "extract", bigIntegerArray, termArray2[1]);
                        Term term12 = BitvectorUtils.unfTerm(this.mScript, "bvsub", null, term, term7);
                        Term term13 = BitvectorUtils.unfTerm(this.mScript, "bvadd", null, term, term7);
                        Term term14 = SmtUtils.and(this.mScript, SmtUtils.binaryEquality(this.mScript, term10, term9), SmtUtils.binaryEquality(this.mScript, term11, term9));
                        Term term15 = Util.ite((Script)this.mScript, (Term)term14, (Term)term13, (Term)term);
                        Term term16 = SmtUtils.and(this.mScript, SmtUtils.binaryEquality(this.mScript, term10, term9), SmtUtils.binaryEquality(this.mScript, term11, term8));
                        Term term17 = Util.ite((Script)this.mScript, (Term)term16, (Term)term12, (Term)term15);
                        Term term18 = SmtUtils.not(this.mScript, SmtUtils.binaryEquality(this.mScript, term5, term6));
                        Term term19 = term17;
                        Term term20 = Util.ite((Script)this.mScript, (Term)term18, (Term)term19, (Term)term);
                        this.setResult(term20);
                        return;
                    }
                    int n = 0;
                    while (n < termArray.length) {
                        termArray2[n] = this.bringTermToWidth(termArray[n], this.getWidth((Term)applicationTerm), this.isSigned(termArray3[n]));
                        ++n;
                    }
                    this.setResult(BitvectorUtils.unfTerm(this.mScript, "bvudiv", null, termArray2));
                    return;
                }
                case "ite": {
                    this.setResult(this.mScript.term("ite", new Term[]{termArray[0], termArray[1], termArray[2]}));
                    return;
                }
                case "select": {
                    Term term = this.bringTermToWidth(termArray[1], Integer.parseInt(termArray[0].getSort().getArguments()[0].getIndices()[0]), false);
                    if (Integer.parseInt(termArray[0].getSort().getArguments()[0].getIndices()[0]) != Integer.parseInt(term.getSort().getIndices()[0])) {
                        throw new AssertionError((Object)String.format("Cannot access array with %sbit indices via %sbit term.", Integer.parseInt(termArray[0].getSort().getArguments()[0].getIndices()[0]), Integer.parseInt(term.getSort().getIndices()[0])));
                    }
                    this.setResult(this.mScript.term("select", new Term[]{termArray[0], term}));
                    return;
                }
                case "store": {
                    Sort sort = this.getArrayValueSort(termArray[0].getSort());
                    this.setResult(this.mScript.term("store", new Term[]{termArray[0], this.bringTermToWidth(termArray[1], Integer.parseInt(termArray[0].getSort().getArguments()[0].getIndices()[0]), false), this.bringTermToWidth(termArray[2], Integer.parseInt(sort.getIndices()[0]), false)}));
                    return;
                }
                case "abs": {
                    throw new UnsupportedOperationException("Unexpected function in back-translation " + functionSymbol.getName());
                }
                case "const": {
                    throw new UnsupportedOperationException("Unable to translate const array back. Don't know width of index. Look-ahead needed.");
                }
            }
            this.setResult(SmtUtils.unfTerm(this.mScript, functionSymbol, termArray));
            return;
        }
        super.convertApplicationTerm(applicationTerm, termArray2);
    }

    private Sort getArrayValueSort(Sort sort) {
        assert (SmtSortUtils.isArraySort(sort));
        Sort sort2 = sort.getArguments()[1];
        if (SmtSortUtils.isBitvecSort(sort2)) {
            return sort2;
        }
        if (SmtSortUtils.isArraySort(sort2)) {
            return this.getArrayValueSort(sort2);
        }
        throw new UnsupportedOperationException("Unexpected Array Value Sort");
    }

    private Term translateConst(ConstantTerm constantTerm) {
        assert (constantTerm.getValue() instanceof Rational);
        if (((Rational)constantTerm.getValue()).isNegative()) {
            int n = this.getWidth((Term)constantTerm);
            return SmtUtils.rational2Term(this.mScript, (Rational)constantTerm.getValue(), SmtSortUtils.getBitvectorSort(this.mScript, n + 1));
        }
        int n = this.getWidth((Term)constantTerm);
        return SmtUtils.rational2Term(this.mScript, (Rational)constantTerm.getValue(), SmtSortUtils.getBitvectorSort(this.mScript, n));
    }
}

