/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;

public final class IsDeterministic<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final IDoubleDeckerAutomaton<LETTER, STATE> mOperand;
    private final boolean mResult;
    private final boolean mNondeterministicTransitions;
    private final boolean mNondeterministicInitials;

    public IsDeterministic(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider instanceof IDoubleDeckerAutomaton ? (IDoubleDeckerAutomaton)iNwaOutgoingLetterAndTransitionProvider : new NestedWordAutomatonReachableStates<LETTER, STATE>(this.mServices, iNwaOutgoingLetterAndTransitionProvider);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mNondeterministicInitials = this.mOperand.getInitialStates().size() > 1;
        this.mNondeterministicTransitions = this.checkIfOperandhasNondeterministicTransitions();
        boolean bl = this.mResult = !this.mNondeterministicInitials && !this.mNondeterministicTransitions;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    private boolean checkIfOperandhasNondeterministicTransitions() {
        for (Object STATE : this.mOperand.getStates()) {
            for (STATE STATE2 : this.mOperand.getDownStates(STATE)) {
                boolean bl = NestedWordAutomataUtils.isNondeterministic(STATE, STATE2, this.mOperand);
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasNondeterministicTransitions() {
        return this.mNondeterministicTransitions;
    }

    public boolean hasNondeterministicInitials() {
        return this.mNondeterministicInitials;
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Operand is " + (this.mResult ? "" : "not ") + "deterministic.";
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Boolean getResult() {
        return this.mResult;
    }
}

