/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwaDd;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.AbstractMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.DimacsMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.GeneralMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.HornMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.ScopedTransitivityGenerator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.VariableStatus;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.util.ISetOfPairs;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.IPartition;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiPredicate;

public abstract class MinimizeNwaMaxSat2<LETTER, STATE, T>
extends AbstractMinimizeNwaDd<LETTER, STATE> {
    protected static final int THREE = 3;
    protected static final String GENERATING_VARIABLES = "generating variables";
    protected static final String ADDING_TRANSITION_CONSTRAINTS = "adding transition constraints";
    protected static final String ADDING_TRANSITIVITY_CONSTRAINTS = "adding transitivity constraints";
    protected static final String SOLVER_TIMEOUT = "solving";
    protected final NestedMap2<STATE, STATE, T> mStatePair2Var;
    protected final IDoubleDeckerAutomaton<LETTER, STATE> mOperand;
    protected final Settings<STATE> mSettings;
    protected final AbstractMaxSatSolver<T> mSolver;
    protected ScopedTransitivityGenerator<T, STATE> mTransitivityGenerator;
    private int mNumberClausesAcceptance;
    private int mNumberClausesTransitions;
    private int mNumberClausesTransitionsNondeterministic;
    private int mNumberClausesTransitivity;
    private long mTimer = System.currentTimeMillis();
    private long mTimeAsserting;
    private long mTimeSolving;
    private long mNumberOfResultPairs;

    protected MinimizeNwaMaxSat2(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, Settings<STATE> settings, NestedMap2<STATE, STATE, T> nestedMap2, String string) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iDoubleDeckerAutomaton;
        this.mStatePair2Var = nestedMap2;
        this.mSettings = settings;
        this.mSettings.validate(this.mOperand);
        this.mSolver = this.createSolver(string);
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    private AbstractMaxSatSolver<T> createSolver(String string) {
        switch (this.mSettings.getSolverMode()) {
            case EXTERNAL: {
                return new DimacsMaxSatSolver(this.mServices, string);
            }
            case HORN: {
                return new HornMaxSatSolver(this.mServices);
            }
            case TRANSITIVITY: {
                if (MinimizeNwaMaxSat2.hasNoReturnTransitions(this.mOperand)) {
                    return new GeneralMaxSatSolver(this.mServices);
                }
                return this.createTransitivitySolver();
            }
            case GENERAL: {
                return new GeneralMaxSatSolver(this.mServices);
            }
        }
        throw new IllegalArgumentException("Unknown solver mode: " + String.valueOf((Object)this.mSettings.getSolverMode()));
    }

    protected final void run() throws AutomataOperationCanceledException {
        this.feedSolver();
        this.mTimeAsserting = this.mTimer;
        this.mTimer = System.currentTimeMillis();
        this.mTimeAsserting = this.mTimer - this.mTimeAsserting;
        this.constructResult(this.mSettings.isAddMapOldState2newState());
        this.mTimeSolving = this.mTimer;
        this.mTimer = System.currentTimeMillis();
        this.mTimeSolving = this.mTimer - this.mTimeSolving;
    }

    private void feedSolver() throws AutomataOperationCanceledException {
        this.generateVariablesAndAcceptingConstraints();
        boolean bl = this.mTransitivityGenerator == null && !MinimizeNwaMaxSat2.hasNoReturnTransitions(this.mOperand);
        this.generateTransitionAndTransitivityConstraints(bl);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Number of clauses for: -> acceptance: " + this.mNumberClausesAcceptance + ", -> transitions: " + this.mNumberClausesTransitions + ", -> nondeterministic transitions: " + this.mNumberClausesTransitionsNondeterministic + ", -> transitivity: " + this.mNumberClausesTransitivity));
        }
    }

    private void constructResult(boolean bl) throws AutomataOperationCanceledException, AssertionError {
        boolean bl2;
        try {
            bl2 = this.mSolver.solve();
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            RunningTaskInfo runningTaskInfo = this.getRunningTaskInfo(SOLVER_TIMEOUT);
            automataOperationCanceledException.addRunningTaskInfo(runningTaskInfo);
            throw automataOperationCanceledException;
        }
        if (!bl2) {
            throw new AssertionError((Object)"Constructed constraints were unsatisfiable");
        }
        IPartition<STATE> iPartition = this.constructResultEquivalenceClasses();
        this.mNumberOfResultPairs = this.countNumberOfPairs(iPartition);
        this.constructResultFromPartition(iPartition, bl);
    }

    private long countNumberOfPairs(IPartition<STATE> iPartition) {
        long l = 0L;
        for (Set set : iPartition) {
            l += (long)set.size() * (long)set.size() - (long)set.size();
        }
        return l;
    }

    protected abstract AbstractMaxSatSolver<T> createTransitivitySolver();

    protected abstract void generateVariablesAndAcceptingConstraints() throws AutomataOperationCanceledException;

    protected abstract void generateTransitionAndTransitivityConstraints(boolean var1) throws AutomataOperationCanceledException;

    protected abstract IPartition<STATE> constructResultEquivalenceClasses() throws AssertionError;

    protected abstract boolean isInitialPair(STATE var1, STATE var2);

    protected abstract boolean isInitialPair(T var1);

    protected abstract T[] getEmptyVariableArray();

    protected abstract String createTaskDescription();

    protected final STATE[] constructStateArray(Collection<STATE> collection) {
        return collection.toArray(new Object[collection.size()]);
    }

    protected final void generateTransitionConstraintsHelper(STATE STATE, STATE STATE2, T t) {
        T t2;
        if (this.knownToBeDifferent(STATE, STATE2, t)) {
            return;
        }
        if (this.mSettings.getUseInternalCallConstraints() && !this.haveSameOutgoingInternalCallSymbols(STATE, STATE2)) {
            this.setVariableFalse(t);
            return;
        }
        STATE[] STATEArray = this.getDownStatesArray(STATE);
        T t3 = t2 = this.knownToBeSimilar(STATE, STATE2, t) ? null : (T)t;
        if (this.mSettings.getUseTransitionHornClauses()) {
            this.generateTransitionConstraintInternalHorn(STATE, STATE2, t2);
            this.generateTransitionConstraintCallHorn(STATE, STATE2, t2);
        } else {
            this.generateTransitionConstraintInternalGeneral(STATE, STATE2, t2);
            this.generateTransitionConstraintCallGeneral(STATE, STATE2, t2);
        }
        this.generateTransitionConstraintsHelperReturnMixedLinPred(STATE, STATEArray, STATE2, t2);
    }

    private void generateTransitionConstraintInternalHorn(STATE STATE, STATE STATE2, T t) {
        for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(STATE)) {
            STATE STATE3 = outgoingInternalTransition.getSucc();
            for (OutgoingInternalTransition outgoingInternalTransition2 : this.mOperand.internalSuccessors(STATE2, outgoingInternalTransition.getLetter())) {
                STATE STATE4 = outgoingInternalTransition2.getSucc();
                this.generateBinaryTransitionConstraint(t, STATE3, STATE4);
            }
        }
    }

    private void generateTransitionConstraintInternalGeneral(STATE STATE, STATE STATE2, T t) {
        for (Object LETTER : this.mOperand.lettersInternal(STATE)) {
            LinkedHashSet<STATE> linkedHashSet = new LinkedHashSet<STATE>();
            LinkedHashSet<STATE> linkedHashSet2 = new LinkedHashSet<STATE>();
            for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(STATE, LETTER)) {
                linkedHashSet.add(outgoingInternalTransition.getSucc());
            }
            for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(STATE2, LETTER)) {
                linkedHashSet2.add(outgoingInternalTransition.getSucc());
            }
            this.generateTransitionConstraintGeneralInternalCallHelper(t, linkedHashSet, linkedHashSet2);
        }
    }

    private void generateTransitionConstraintCallHorn(STATE STATE, STATE STATE2, T t) {
        for (OutgoingCallTransition outgoingCallTransition : this.mOperand.callSuccessors(STATE)) {
            STATE STATE3 = outgoingCallTransition.getSucc();
            for (OutgoingCallTransition outgoingCallTransition2 : this.mOperand.callSuccessors(STATE2, outgoingCallTransition.getLetter())) {
                STATE STATE4 = outgoingCallTransition2.getSucc();
                this.generateBinaryTransitionConstraint(t, STATE3, STATE4);
            }
        }
    }

    private void generateTransitionConstraintCallGeneral(STATE STATE, STATE STATE2, T t) {
        for (Object LETTER : this.mOperand.lettersCall(STATE)) {
            LinkedHashSet<STATE> linkedHashSet = new LinkedHashSet<STATE>();
            LinkedHashSet<STATE> linkedHashSet2 = new LinkedHashSet<STATE>();
            for (OutgoingCallTransition outgoingCallTransition : this.mOperand.callSuccessors(STATE, LETTER)) {
                linkedHashSet.add(outgoingCallTransition.getSucc());
            }
            for (OutgoingCallTransition outgoingCallTransition : this.mOperand.callSuccessors(STATE2, LETTER)) {
                linkedHashSet2.add(outgoingCallTransition.getSucc());
            }
            this.generateTransitionConstraintGeneralInternalCallHelper(t, linkedHashSet, linkedHashSet2);
        }
    }

    protected abstract void generateTransitionConstraintGeneralInternalCallHelper(T var1, Set<STATE> var2, Set<STATE> var3);

    protected final void generateTransitionConstraintGeneralInternalCallHelperOneSide(T t, Iterable<STATE> iterable, Iterable<STATE> iterable2, Collection<STATE> collection) {
        boolean bl = false;
        for (STATE STATE : iterable) {
            for (STATE STATE2 : iterable2) {
                if (!this.knownToBeSimilar(STATE, STATE2, null)) continue;
                this.addIfNotNull(collection, STATE2);
                bl = true;
                break;
            }
            if (bl) {
                bl = false;
                continue;
            }
            this.generateNaryTransitionConstraint(t, STATE, iterable2);
        }
    }

    private void generateTransitionConstraintsHelperReturnMixedLinPred(STATE STATE, STATE[] STATEArray, STATE STATE2, T t) {
        for (STATE STATE3 : this.mOperand.getDownStates(STATE2)) {
            STATE[] STATEArray2 = STATEArray;
            int n = STATEArray.length;
            int n2 = 0;
            while (n2 < n) {
                STATE STATE4 = STATEArray2[n2];
                this.generateTransitionConstraintReturn(STATE, STATE2, t, STATE4, STATE3, this.mSettings.getUseTransitionHornClauses(), true);
                ++n2;
            }
        }
    }

    protected final void generateTransitionConstraintsHelperReturnSameLinPred(STATE STATE, STATE[] STATEArray) {
        int n = 0;
        while (n < STATEArray.length) {
            int n2 = 0;
            while (n2 < n) {
                this.generateTransitionConstraintReturn(STATE, STATE, null, STATEArray[n], STATEArray[n2], this.mSettings.getUseTransitionHornClauses(), false);
                ++n2;
            }
            ++n;
        }
    }

    private void generateTransitionConstraintReturn(STATE STATE, STATE STATE2, T t, STATE STATE3, STATE STATE4, boolean bl, boolean bl2) {
        if (this.knownToBeDifferent(STATE3, STATE4, null)) {
            return;
        }
        T t2 = this.getVariableIfNotSimilar(STATE3, STATE4);
        Set<LETTER> set = this.getSameOutgoingReturnSymbols(STATE, STATE3, STATE2, STATE4);
        if (set == null) {
            this.addThreeLiteralHornClause(t, t2, null);
            return;
        }
        if (bl) {
            this.generateTransitionConstraintReturnHelperHorn(STATE, STATE2, t, STATE3, STATE4, t2);
        } else {
            this.generateTransitionConstraintReturnHelperGeneral(STATE, STATE2, t, STATE3, STATE4, t2, set, bl2);
        }
    }

    private void generateTransitionConstraintReturnHelperHorn(STATE STATE, STATE STATE2, T t, STATE STATE3, STATE STATE4, T t2) {
        block0: for (OutgoingReturnTransition outgoingReturnTransition : this.mOperand.returnSuccessorsGivenHier(STATE, STATE3)) {
            for (OutgoingReturnTransition outgoingReturnTransition2 : this.mOperand.returnSuccessors(STATE2, STATE4, outgoingReturnTransition.getLetter())) {
                if (this.knownToBeSimilar(outgoingReturnTransition.getSucc(), outgoingReturnTransition2.getSucc(), null)) continue block0;
                T t3 = this.getVariableIfNotDifferent(outgoingReturnTransition.getSucc(), outgoingReturnTransition2.getSucc());
                this.addThreeLiteralHornClause(t, t2, t3);
            }
        }
    }

    private void generateTransitionConstraintReturnHelperGeneral(STATE STATE, STATE STATE2, T t, STATE STATE3, STATE STATE4, T t2, Set<LETTER> set, boolean bl) {
        for (LETTER LETTER : set) {
            LinkedHashSet<STATE> linkedHashSet = new LinkedHashSet<STATE>();
            LinkedHashSet<STATE> linkedHashSet2 = new LinkedHashSet<STATE>();
            for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mOperand.returnSuccessors(STATE, STATE3, LETTER)) {
                linkedHashSet.add(outgoingReturnTransition.getSucc());
            }
            for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mOperand.returnSuccessors(STATE2, STATE4, LETTER)) {
                linkedHashSet2.add(outgoingReturnTransition.getSucc());
            }
            if (bl) {
                this.generateTransitionConstraintGeneralReturnHelper(t, t2, linkedHashSet, linkedHashSet2);
                continue;
            }
            this.generateTransitionConstraintGeneralReturnHelperSymmetric(t, t2, linkedHashSet, linkedHashSet2);
        }
    }

    protected abstract void generateTransitionConstraintGeneralReturnHelper(T var1, T var2, Set<STATE> var3, Set<STATE> var4);

    protected final void generateTransitionConstraintGeneralReturnHelperSymmetric(T t, T t2, Set<STATE> set, Set<STATE> set2) {
        ArrayList arrayList = new ArrayList();
        this.generateTransitionConstraintGeneralReturnHelperOneSide(t, t2, set, set2, arrayList);
        set2.removeAll(arrayList);
        this.generateTransitionConstraintGeneralReturnHelperOneSide(t, t2, set2, set, null);
    }

    protected final void generateTransitionConstraintGeneralReturnHelperOneSide(T t, T t2, Set<STATE> set, Set<STATE> set2, Collection<STATE> collection) {
        boolean bl = false;
        for (STATE STATE : set) {
            for (STATE STATE2 : set2) {
                if (!this.knownToBeSimilar(STATE, STATE2, null)) continue;
                this.addIfNotNull(collection, STATE2);
                bl = true;
                break;
            }
            if (bl) {
                bl = false;
                continue;
            }
            this.generateNaryTransitionConstraint(t, t2, STATE, set2);
        }
    }

    private void addIfNotNull(Collection<STATE> collection, STATE STATE) {
        if (collection != null) {
            collection.add(STATE);
        }
    }

    private void generateBinaryTransitionConstraint(T t, STATE STATE, STATE STATE2) {
        if (this.knownToBeSimilar(STATE, STATE2, null)) {
            return;
        }
        T t2 = this.getVariableIfNotDifferent(STATE, STATE2);
        this.addTwoLiteralHornClause(t, t2);
    }

    private void generateNaryTransitionConstraint(T t, STATE STATE, Iterable<STATE> iterable) {
        Object[] objectArray;
        Object object2;
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Object object2 : iterable) {
            if (this.knownToBeDifferent(STATE, object2, null)) continue;
            T t2 = this.getVariable(STATE, object2, false);
            arrayList.add(t2);
        }
        if (t == null) {
            objectArray = this.getEmptyVariableArray();
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = t;
        }
        object2 = objectArray;
        E[] EArray = this.consArr(arrayList);
        this.addArbitraryLiteralClause((T[])object2, (T[])EArray);
    }

    private void generateNaryTransitionConstraint(T t, T t2, STATE STATE, Iterable<STATE> iterable) {
        Object object2;
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Object object2 : iterable) {
            if (this.knownToBeDifferent(STATE, object2, null)) continue;
            T t3 = this.getVariable(STATE, object2, false);
            arrayList.add(t3);
        }
        object2 = t == null ? (t2 == null ? this.getEmptyVariableArray() : new Object[]{t2}) : (t2 == null ? new Object[]{t} : new Object[]{t, t2});
        E[] EArray = this.consArr(arrayList);
        this.addArbitraryLiteralClause((T[])object2, (T[])EArray);
    }

    protected final void addTransitivityClausesToSolver(T t, T t2, T t3) {
        this.mSolver.addHornClause(new Object[]{t, t2}, t3);
        this.mSolver.addHornClause(new Object[]{t2, t3}, t);
        this.mSolver.addHornClause(new Object[]{t3, t}, t2);
        this.mNumberClausesTransitivity += 3;
    }

    protected final boolean knownToBeSimilar(STATE STATE, STATE STATE2, T t) {
        if (STATE.equals(STATE2)) {
            return true;
        }
        if (t == null) {
            if (this.isInitialPair(STATE, STATE2)) {
                return this.resultFromSolver(STATE, STATE2) == VariableStatus.TRUE;
            }
        } else if (this.isInitialPair(t)) {
            return this.resultFromSolver(t) == VariableStatus.TRUE;
        }
        return false;
    }

    protected final boolean knownToBeDifferent(STATE STATE, STATE STATE2, T t) {
        if (STATE.equals(STATE2)) {
            return false;
        }
        if (t == null) {
            if (this.isInitialPair(STATE, STATE2)) {
                return this.resultFromSolver(STATE, STATE2) == VariableStatus.FALSE;
            }
        } else if (this.isInitialPair(t)) {
            return this.resultFromSolver(t) == VariableStatus.FALSE;
        }
        return true;
    }

    protected final STATE[] getDownStatesArray(STATE STATE) {
        return this.constructStateArray(this.mOperand.getDownStates(STATE));
    }

    protected final T[] consArr(Collection<T> collection) {
        return collection.toArray(new Object[collection.size()]);
    }

    protected final void setStatesDifferent(T t) {
        this.setVariableFalse(t);
        ++this.mNumberClausesAcceptance;
    }

    protected final void addInverseHornClause(T t, Collection<T> collection) {
        this.addArbitraryLiteralClause(new Object[]{t}, this.consArr(collection));
    }

    private void addArbitraryLiteralClause(T[] TArray, T[] TArray2) {
        assert (MinimizeNwaMaxSat2.isVoidOfNull(TArray) && MinimizeNwaMaxSat2.isVoidOfNull(TArray2)) : "Array/list must be void of null elements.";
        assert (TArray.length == 1 || TArray.length == 2) : "Always pass one or two negative atoms.";
        if (TArray2.length <= 1) {
            T t;
            T t2 = t = TArray2.length == 1 ? (T)TArray2[0] : null;
            if (TArray.length == 1) {
                this.addTwoLiteralHornClause(TArray[0], t);
            } else {
                this.addThreeLiteralHornClause(TArray[0], TArray[1], t);
            }
        } else {
            this.mSolver.addClause(TArray, TArray2);
            ++this.mNumberClausesTransitionsNondeterministic;
        }
    }

    private void addTwoLiteralHornClause(T t, T t2) {
        if (t == null) {
            if (t2 == null) {
                throw new AssertionError((Object)"clause must not be empty");
            }
            this.mSolver.addHornClause(this.getEmptyVariableArray(), t2);
        } else {
            this.mSolver.addHornClause(new Object[]{t}, t2);
        }
        ++this.mNumberClausesTransitions;
    }

    private void addThreeLiteralHornClause(T t, T t2, T t3) {
        if (t == null) {
            this.addTwoLiteralHornClause(t2, t3);
        } else if (t2 == null) {
            this.addTwoLiteralHornClause(t, t3);
        } else {
            this.mSolver.addHornClause(new Object[]{t, t2}, t3);
            ++this.mNumberClausesTransitions;
        }
    }

    private boolean haveSameOutgoingInternalCallSymbols(STATE STATE, STATE STATE2) {
        Set set;
        Set set2 = this.mOperand.lettersInternal(STATE);
        if (!this.testOutgoingSymbols(set2, set = this.mOperand.lettersInternal(STATE2))) {
            return false;
        }
        set2 = this.mOperand.lettersCall(STATE);
        set = this.mOperand.lettersCall(STATE2);
        return this.testOutgoingSymbols(set2, set);
    }

    protected abstract boolean testOutgoingSymbols(Set<LETTER> var1, Set<LETTER> var2);

    private boolean haveSameOutgoingReturnSymbols(STATE STATE, STATE STATE2, STATE STATE3, STATE STATE4) {
        return this.getSameOutgoingReturnSymbols(STATE, STATE2, STATE3, STATE4) != null;
    }

    private Set<LETTER> getSameOutgoingReturnSymbols(STATE STATE, STATE STATE2, STATE STATE3, STATE STATE4) {
        HashSet hashSet = new HashSet();
        for (OutgoingReturnTransition outgoingReturnTransition : this.mOperand.returnSuccessorsGivenHier(STATE, STATE2)) {
            hashSet.add(outgoingReturnTransition.getLetter());
        }
        HashSet hashSet2 = new HashSet();
        for (OutgoingReturnTransition outgoingReturnTransition : this.mOperand.returnSuccessorsGivenHier(STATE3, STATE4)) {
            hashSet2.add(outgoingReturnTransition.getLetter());
        }
        return hashSet.equals(hashSet2) ? hashSet : null;
    }

    private VariableStatus resultFromSolver(STATE STATE, STATE STATE2) {
        return this.resultFromSolver(this.getVariable(STATE, STATE2, false));
    }

    private VariableStatus resultFromSolver(T t) {
        return this.mSolver.getValue(t);
    }

    protected final T getVariable(STATE STATE, STATE STATE2, boolean bl) {
        return (T)(bl ? null : this.mStatePair2Var.get(STATE, STATE2));
    }

    private T getVariableIfNotDifferent(STATE STATE, STATE STATE2) {
        return this.getVariable(STATE, STATE2, this.knownToBeDifferent(STATE, STATE2, null));
    }

    private T getVariableIfNotSimilar(STATE STATE, STATE STATE2) {
        return this.getVariable(STATE, STATE2, this.knownToBeSimilar(STATE, STATE2, null));
    }

    protected void setVariableFalse(T t) {
        this.mSolver.addHornClause(new Object[]{t}, null);
    }

    private static <T> boolean isVoidOfNull(T[] TArray) {
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray2[n2];
            if (t == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static <LETTER, STATE> boolean hasNoReturnTransitions(IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) {
        return iDoubleDeckerAutomaton.getVpAlphabet().getReturnAlphabet().isEmpty();
    }

    protected final void checkTimeout(String string) throws AutomataOperationCanceledException {
        if (this.isCancellationRequested()) {
            RunningTaskInfo runningTaskInfo = this.getRunningTaskInfo(string);
            throw new AutomataOperationCanceledException(runningTaskInfo);
        }
    }

    private RunningTaskInfo getRunningTaskInfo(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.createTaskDescription();
        stringBuilder.append(string2).append(". Currently ").append(string).append(". Solver was fed with ").append(this.mSolver.getNumberOfClauses()).append(" variables and ").append(this.mSolver.getNumberOfClauses()).append(" clauses");
        if (this.mTimeAsserting != 0L) {
            stringBuilder.append(". Asserting time ").append(this.mTimeAsserting);
        }
        if (this.mTimeSolving != 0L) {
            stringBuilder.append(". Solving time ").append(this.mTimeSolving);
        }
        return new RunningTaskInfo(this.getClass(), stringBuilder.toString());
    }

    @Override
    public AutomataOperationStatistics getAutomataOperationStatistics() {
        AutomataOperationStatistics automataOperationStatistics = super.getAutomataOperationStatistics();
        this.addStatistics(automataOperationStatistics);
        return automataOperationStatistics;
    }

    public void addStatistics(AutomataOperationStatistics automataOperationStatistics) {
        automataOperationStatistics.addKeyValuePair(StatisticsType.TIME_ASSERTING, this.mTimeAsserting);
        automataOperationStatistics.addKeyValuePair(StatisticsType.TIME_SOLVING, this.mTimeSolving);
        automataOperationStatistics.addKeyValuePair(StatisticsType.NUMBER_VARIABLES, this.mSolver.getNumberOfVariables());
        automataOperationStatistics.addKeyValuePair(StatisticsType.NUMBER_CLAUSES, this.mSolver.getNumberOfClauses());
        automataOperationStatistics.addKeyValuePair(StatisticsType.NUMBER_RESULT_PAIRS, this.mNumberOfResultPairs);
    }

    @Override
    protected Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        return this.checkLanguageEquivalence(iMinimizationCheckResultStateFactory);
    }

    public static class RelationBackedBiPredicate<STATE>
    implements BiPredicate<STATE, STATE> {
        private final ISetOfPairs<STATE, ?> mRelation;

        public RelationBackedBiPredicate(ISetOfPairs<STATE, ?> iSetOfPairs) {
            this.mRelation = iSetOfPairs;
        }

        @Override
        public boolean test(STATE STATE, STATE STATE2) {
            return this.mRelation.containsPair(STATE, STATE2);
        }
    }

    public static class Settings<STATE> {
        private boolean mAddMapOldState2newState;
        private SolverMode mSolverMode = SolverMode.TRANSITIVITY;
        private BiPredicate<STATE, STATE> mFinalNonfinalConstraintPredicate = new TrueBiPredicate();
        private boolean mUseTransitionHornClauses;
        private final boolean mUsePathCompression = false;
        private boolean mUseInternalCallConstraints = true;
        private boolean mLibraryMode = true;

        public <LETTER> void validate(IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) {
            if (this.mSolverMode == null) {
                throw new IllegalArgumentException("No solver mode set.");
            }
            if (this.mSolverMode == SolverMode.HORN && !this.mUseTransitionHornClauses) {
                throw new IllegalArgumentException("For using the Horn solver you must use Horn clauses.");
            }
        }

        public boolean isAddMapOldState2newState() {
            return this.mAddMapOldState2newState;
        }

        public Settings<STATE> setAddMapOldState2NewState(boolean bl) {
            this.mAddMapOldState2newState = bl;
            return this;
        }

        public BiPredicate<STATE, STATE> getFinalNonfinalConstraintPredicate() {
            return this.mFinalNonfinalConstraintPredicate;
        }

        public Settings<STATE> setFinalNonfinalConstraintPredicate(BiPredicate<STATE, STATE> biPredicate) {
            this.mFinalNonfinalConstraintPredicate = biPredicate;
            return this;
        }

        public boolean getUseTransitionHornClauses() {
            return this.mUseTransitionHornClauses;
        }

        public SolverMode getSolverMode() {
            return this.mSolverMode;
        }

        public Settings<STATE> setSolverModeExternal() {
            this.mSolverMode = SolverMode.EXTERNAL;
            return this;
        }

        public Settings<STATE> setSolverModeTransitivity() {
            this.mSolverMode = SolverMode.TRANSITIVITY;
            return this;
        }

        public Settings<STATE> setSolverModeGeneral() {
            this.mSolverMode = SolverMode.GENERAL;
            return this;
        }

        public boolean getUseInternalCallConstraints() {
            return this.mUseInternalCallConstraints;
        }

        public Settings<STATE> setUseInternalCallConstraints(boolean bl) {
            this.mUseInternalCallConstraints = bl;
            return this;
        }

        public boolean getLibraryMode() {
            return this.mLibraryMode;
        }

        public Settings<STATE> setLibraryMode(boolean bl) {
            this.mLibraryMode = bl;
            return this;
        }

        public boolean isUsePathCompression() {
            return false;
        }

        public static enum SolverMode {
            EXTERNAL,
            HORN,
            TRANSITIVITY,
            GENERAL;

        }
    }

    public static class TrueBiPredicate<STATE>
    implements BiPredicate<STATE, STATE> {
        @Override
        public boolean test(STATE STATE, STATE STATE2) {
            return true;
        }
    }
}

