/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.RequiredMemoryModelFeatures;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.preferences.CACSLPreferenceInitializer;
import java.util.HashSet;

public enum MemoryModelDeclarations {
    ULTIMATE_ALLOC_STACK("#Ultimate.allocOnStack"),
    ULTIMATE_ALLOC_INIT("#Ultimate.allocInit"),
    ULTIMATE_ALLOC_HEAP("#Ultimate.allocOnHeap"),
    ULTIMATE_DEALLOC("ULTIMATE.dealloc"),
    ULTIMATE_MEMINIT("#Ultimate.meminit"),
    C_MEMCPY("#Ultimate.C_memcpy"),
    C_MEMMOVE("#Ultimate.C_memmove"),
    C_MEMSET("#Ultimate.C_memset"),
    C_STRCPY("#Ultimate.C_strcpy"),
    C_REALLOC("#Ultimate.C_realloc"),
    ULTIMATE_LENGTH("#length"),
    ULTIMATE_PTHREADS_FORK_COUNT("#PthreadsForkCount"),
    ULTIMATE_PTHREADS_MUTEX("#PthreadsMutex"),
    ULTIMATE_PTHREADS_MUTEX_LOCK("#PthreadsMutexLock"),
    ULTIMATE_PTHREADS_MUTEX_UNLOCK("#PthreadsMutexUnlock"),
    ULTIMATE_PTHREADS_MUTEX_TRYLOCK("#PthreadsMutexTryLock"),
    ULTIMATE_PTHREADS_RWLOCK("#PthreadsRwLock"),
    ULTIMATE_PTHREADS_RWLOCK_READLOCK("#PthreadsRwLockReadLock"),
    ULTIMATE_PTHREADS_RWLOCK_WRITELOCK("#PthreadsRwLockWriteLock"),
    ULTIMATE_PTHREADS_RWLOCK_UNLOCK("#PthreadsRwLockUnlock"),
    ULTIMATE_VALID("#valid"),
    ULTIMATE_STACK_HEAP_BARRIER("#StackHeapBarrier"),
    ULTIMATE_DATA_RACE_MEMORY("#race"),
    ULTIMATE_INITIAL_ALLOCATIONS("#InitialAllocations"),
    ULTIMATE_STACK_ALLOCATIONS("#StackAllocations"),
    ULTIMATE_HEAP_ALLOCATIONS("#HeapAllocations");

    private final String mName;

    private MemoryModelDeclarations(String string2) {
        this.mName = string2;
    }

    public String getName() {
        return this.mName;
    }

    boolean resolveDependencies(RequiredMemoryModelFeatures requiredMemoryModelFeatures, TranslationSettings translationSettings) {
        if (this == C_MEMCPY || this == C_MEMMOVE) {
            return MemoryModelDeclarations.memcpyOrMemmoveRequirements(requiredMemoryModelFeatures);
        }
        if (this == C_MEMSET) {
            return false;
        }
        if (this == ULTIMATE_MEMINIT) {
            return MemoryModelDeclarations.meminitRequirements(requiredMemoryModelFeatures, translationSettings);
        }
        if (this == C_STRCPY) {
            return MemoryModelDeclarations.strcpyRequirements(requiredMemoryModelFeatures);
        }
        if (this == C_REALLOC) {
            return MemoryModelDeclarations.reallocRequirements(requiredMemoryModelFeatures, translationSettings);
        }
        if (this == ULTIMATE_ALLOC_STACK || this == ULTIMATE_ALLOC_HEAP) {
            return MemoryModelDeclarations.allocRequirements(requiredMemoryModelFeatures);
        }
        if (this == ULTIMATE_PTHREADS_MUTEX_LOCK || this == ULTIMATE_PTHREADS_MUTEX_UNLOCK || this == ULTIMATE_PTHREADS_MUTEX_TRYLOCK) {
            return requiredMemoryModelFeatures.require(ULTIMATE_PTHREADS_MUTEX);
        }
        if (this == ULTIMATE_PTHREADS_RWLOCK_READLOCK || this == ULTIMATE_PTHREADS_RWLOCK_WRITELOCK || this == ULTIMATE_PTHREADS_RWLOCK_UNLOCK) {
            return requiredMemoryModelFeatures.require(ULTIMATE_PTHREADS_RWLOCK);
        }
        return false;
    }

    private static boolean allocRequirements(RequiredMemoryModelFeatures requiredMemoryModelFeatures) {
        boolean bl = false;
        bl |= requiredMemoryModelFeatures.requireMemoryStructureInfrastructure();
        return bl |= requiredMemoryModelFeatures.require(ULTIMATE_STACK_HEAP_BARRIER);
    }

    private static boolean reallocRequirements(RequiredMemoryModelFeatures requiredMemoryModelFeatures, TranslationSettings translationSettings) {
        boolean bl = false;
        bl |= requiredMemoryModelFeatures.requireMemoryStructureInfrastructure();
        bl |= requiredMemoryModelFeatures.require(ULTIMATE_DEALLOC);
        if (translationSettings.memoryAddressingPreference() == CACSLPreferenceInitializer.MemoryAddressing.Two_Dimensional) {
            for (CPrimitive.CPrimitives cPrimitives : requiredMemoryModelFeatures.getDataOnHeapRequiredUnchecked()) {
                bl |= requiredMemoryModelFeatures.reportDataOnHeapStoreFunctionRequired(cPrimitives);
            }
            if (requiredMemoryModelFeatures.isPointerOnHeapRequiredUnchecked()) {
                bl |= requiredMemoryModelFeatures.reportPointerOnHeapStoreFunctionRequired();
            }
        } else if (translationSettings.memoryAddressingPreference() == CACSLPreferenceInitializer.MemoryAddressing.One_Dimensional) {
            bl |= requiredMemoryModelFeatures.require(C_MEMCPY);
        }
        return bl;
    }

    private static boolean strcpyRequirements(RequiredMemoryModelFeatures requiredMemoryModelFeatures) {
        boolean bl = false;
        requiredMemoryModelFeatures.reportDataOnHeapRequired(CPrimitive.CPrimitives.CHAR);
        for (CPrimitive.CPrimitives cPrimitives : new HashSet<CPrimitive.CPrimitives>(requiredMemoryModelFeatures.getDataOnHeapRequiredUnchecked())) {
            bl |= requiredMemoryModelFeatures.reportUncheckedWriteRequired(cPrimitives);
        }
        if (requiredMemoryModelFeatures.isPointerOnHeapRequiredUnchecked()) {
            bl |= requiredMemoryModelFeatures.reportPointerUncheckedWriteRequired();
        }
        return bl;
    }

    private static boolean meminitRequirements(RequiredMemoryModelFeatures requiredMemoryModelFeatures, TranslationSettings translationSettings) {
        boolean bl = false;
        if (translationSettings.useConstantArrays()) {
            for (CPrimitive.CPrimitives cPrimitives : new HashSet<CPrimitive.CPrimitives>(requiredMemoryModelFeatures.getDataOnHeapRequiredUnchecked())) {
                bl |= requiredMemoryModelFeatures.reportDataOnHeapInitFunctionRequired(cPrimitives);
            }
            if (requiredMemoryModelFeatures.isPointerOnHeapRequiredUnchecked()) {
                bl |= requiredMemoryModelFeatures.reportPointerOnHeapInitFunctionRequired();
            }
        }
        return bl;
    }

    private static boolean memcpyOrMemmoveRequirements(RequiredMemoryModelFeatures requiredMemoryModelFeatures) {
        boolean bl = false;
        for (CPrimitive.CPrimitives cPrimitives : new HashSet<CPrimitive.CPrimitives>(requiredMemoryModelFeatures.getDataOnHeapRequiredUnchecked())) {
            bl |= requiredMemoryModelFeatures.reportUncheckedWriteRequired(cPrimitives);
        }
        if (requiredMemoryModelFeatures.isPointerOnHeapRequiredUnchecked()) {
            bl |= requiredMemoryModelFeatures.reportPointerUncheckedWriteRequired();
        }
        return bl |= requiredMemoryModelFeatures.require(ULTIMATE_DATA_RACE_MEMORY);
    }
}

