/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.TransitionConstraintIngredients;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SuccessorConstraintIngredients<IPT> {
    private final IcfgLocation mSourceLocation;
    private final Set<IProgramVar> mVariablesForSourcePattern;
    private final IPT mInvStart;
    private final Map<IcfgEdge, IPT> mEdge2Pattern;
    private final Map<IcfgEdge, IPT> mEdge2TargetInv;
    private final Map<IcfgEdge, Set<IProgramVar>> mEdge2VariablesForTargetPattern;

    public SuccessorConstraintIngredients(IcfgLocation icfgLocation, Set<IProgramVar> set, IPT IPT) {
        this.mSourceLocation = icfgLocation;
        this.mVariablesForSourcePattern = set;
        this.mInvStart = IPT;
        this.mEdge2Pattern = new HashMap<IcfgEdge, IPT>();
        this.mEdge2TargetInv = new HashMap<IcfgEdge, IPT>();
        this.mEdge2VariablesForTargetPattern = new HashMap<IcfgEdge, Set<IProgramVar>>();
    }

    public void addTransition(IcfgEdge icfgEdge, IPT IPT, Set<IProgramVar> set) {
        if (!((IcfgLocation)icfgEdge.getSource()).equals((Object)this.mSourceLocation)) {
            throw new IllegalArgumentException("incompatible source location " + String.valueOf(icfgEdge.getSource()));
        }
        IPT IPT2 = this.mEdge2TargetInv.put(icfgEdge, IPT);
        if (IPT2 != null) {
            throw new IllegalArgumentException("edge already added " + String.valueOf(icfgEdge));
        }
        Set<IProgramVar> set2 = this.mEdge2VariablesForTargetPattern.put(icfgEdge, set);
        if (set2 != null) {
            throw new IllegalArgumentException("vars already added " + String.valueOf(icfgEdge));
        }
    }

    public void addTransition(IcfgEdge icfgEdge, IPT IPT, Set<IProgramVar> set, IPT IPT2) {
        this.addTransition(icfgEdge, IPT, set);
        this.mEdge2Pattern.put(icfgEdge, IPT2);
    }

    public Set<TransitionConstraintIngredients<IPT>> buildTransitionConstraintIngredients() {
        HashSet<TransitionConstraintIngredients<IPT>> hashSet = new HashSet<TransitionConstraintIngredients<IPT>>();
        for (Map.Entry<IcfgEdge, IPT> entry : this.mEdge2TargetInv.entrySet()) {
            hashSet.add(new TransitionConstraintIngredients<IPT>(this.mInvStart, entry.getValue(), this.mSourceLocation, (IcfgLocation)entry.getKey().getTarget(), this.mVariablesForSourcePattern, this.mEdge2VariablesForTargetPattern.get(entry.getKey()), entry.getKey().getTransformula()));
        }
        return hashSet;
    }

    public IcfgLocation getSourceLocation() {
        return this.mSourceLocation;
    }

    public Set<IProgramVar> getVariablesForSourcePattern() {
        return this.mVariablesForSourcePattern;
    }

    public IPT getInvStart() {
        return this.mInvStart;
    }

    public Map<IcfgEdge, IPT> getEdge2Pattern() {
        return this.mEdge2Pattern;
    }

    public Map<IcfgEdge, IPT> getEdge2TargetInv() {
        return this.mEdge2TargetInv;
    }

    public Map<IcfgEdge, Set<IProgramVar>> getEdge2VariablesForTargetPattern() {
        return this.mEdge2VariablesForTargetPattern;
    }
}

