/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorlocalization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.IRunningTaskStackProvider;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IRelevanceInformation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.BasicInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.predicates.IterativePredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.DefaultTransFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.AcyclicSubgraphMerger;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.RelevanceInformation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorlocalization.ErrorLocalizationStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.predicates.FaultLocalizationRelevanceChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlowSensitiveFaultLocalizer<L extends IIcfgTransition<?>> {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final IRelevanceInformation[] mRelevanceOfTrace;
    private final IIcfgSymbolTable mSymbolTable;
    private final PredicateFactory mPredicateFactory;
    private final ErrorLocalizationStatisticsGenerator mErrorLocalizationStatisticsGenerator;
    private final boolean mApplyQuantifierElimination = true;

    public FlowSensitiveFaultLocalizer(NestedRun<L, IPredicate> nestedRun, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, ModifiableGlobalsTable modifiableGlobalsTable, IPredicateUnifier iPredicateUnifier, TraceAbstractionPreferenceInitializer.RelevanceAnalysisMode relevanceAnalysisMode, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable, IIcfg<IcfgLocation> iIcfg) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mSimplificationTechnique = simplificationTechnique;
        this.mSymbolTable = iIcfgSymbolTable;
        this.mPredicateFactory = predicateFactory;
        this.mRelevanceOfTrace = this.initializeRelevanceOfTrace(nestedRun);
        this.mErrorLocalizationStatisticsGenerator = new ErrorLocalizationStatisticsGenerator();
        this.mErrorLocalizationStatisticsGenerator.continueErrorLocalizationTime();
        try {
            if (relevanceAnalysisMode == TraceAbstractionPreferenceInitializer.RelevanceAnalysisMode.SINGLE_TRACE) {
                this.doNonFlowSensitiveAnalysis(nestedRun.getWord(), iPredicateUnifier.getTruePredicate(), iPredicateUnifier.getFalsePredicate(), modifiableGlobalsTable, cfgSmtToolkit);
            }
            if (relevanceAnalysisMode == TraceAbstractionPreferenceInitializer.RelevanceAnalysisMode.MULTI_TRACE) {
                this.doFlowSensitiveAnalysis(nestedRun, iPredicateUnifier.getTruePredicate(), iNestedWordAutomaton, modifiableGlobalsTable, cfgSmtToolkit, iIcfg);
            }
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            this.mErrorLocalizationStatisticsGenerator.stopErrorLocalizationTime();
            RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), "doing error localization for trace of length " + nestedRun.getLength());
            throw new ToolchainCanceledException((IRunningTaskStackProvider)toolchainCanceledException, runningTaskInfo);
        }
        this.mErrorLocalizationStatisticsGenerator.reportSuccessfullyFinished();
        this.mErrorLocalizationStatisticsGenerator.stopErrorLocalizationTime();
        StatisticsData statisticsData = new StatisticsData();
        statisticsData.aggregateBenchmarkData((IStatisticsDataProvider)this.mErrorLocalizationStatisticsGenerator);
        StatisticsResult statisticsResult = new StatisticsResult("TraceAbstraction", "ErrorLocalizationStatistics", (ICsvProviderProvider)statisticsData);
        iUltimateServiceProvider.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)statisticsResult);
    }

    private IRelevanceInformation[] initializeRelevanceOfTrace(NestedRun<L, IPredicate> nestedRun) {
        IRelevanceInformation[] iRelevanceInformationArray = new IRelevanceInformation[nestedRun.getLength() - 1];
        NestedWord nestedWord = nestedRun.getWord();
        int n = 0;
        while (n < nestedWord.length()) {
            RelevanceInformation relevanceInformation = new RelevanceInformation(Collections.singletonList((IAction)nestedWord.getSymbol(n)), false, false, false, false, false);
            iRelevanceInformationArray[n] = relevanceInformation;
            ++n;
        }
        return iRelevanceInformationArray;
    }

    private UnmodifiableTransFormula constructConglomerate(Integer n, Integer n2, Set<IcfgEdge> set, NestedRun<L, IPredicate> nestedRun, IIcfg<IcfgLocation> iIcfg) {
        Object object3;
        IcfgLocation icfgLocation = ((ISLPredicate)nestedRun.getStateAtPosition(n.intValue())).getProgramPoint();
        Object object2 = null;
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        IcfgLocation icfgLocation2 = ((ISLPredicate)nestedRun.getStateAtPosition(n2 + 1)).getProgramPoint();
        hashSet.add(icfgLocation2);
        IcfgLocation icfgLocation3 = ((ISLPredicate)nestedRun.getStateAtPosition(n - 1)).getProgramPoint();
        for (Object object3 : icfgLocation3.getOutgoingEdges()) {
            IcfgLocation icfgLocation4 = (IcfgLocation)object3.getTarget();
            if (icfgLocation4 != icfgLocation) continue;
            object2 = object3;
        }
        object3 = new AcyclicSubgraphMerger(this.mServices, iIcfg, set, icfgLocation, (IcfgEdge)object2, (Set<IcfgLocation>)hashSet);
        return ((AcyclicSubgraphMerger)object3).getTransFormula(icfgLocation2);
    }

    private Map<Integer, Set<IcfgEdge>> computeBranchOutLocation(int n, int n2, Map<Integer, Map<Integer, Set<IcfgEdge>>> map, NestedRun<L, IPredicate> nestedRun) {
        HashMap<Integer, Set<IcfgEdge>> hashMap = new HashMap<Integer, Set<IcfgEdge>>();
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>(this.computePathEdges(nestedRun, n, n2));
        Object object = n;
        int n3 = n2;
        while (n3 >= n) {
            Map<Integer, Set<IcfgEdge>> map2 = map.get(n3);
            if (map2 != null) {
                Object object2;
                ArrayList<Integer> arrayList = new ArrayList<Integer>(map2.keySet());
                Object object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    hashSet.addAll((Collection<IcfgEdge>)map2.get(object2));
                }
                arrayList.sort(Collections.reverseOrder());
                if (arrayList.get(0) < (Integer)object) {
                    object2 = this.computeBranchOutLocation(arrayList.get(0), n3, map, nestedRun);
                    Iterator iterator = object2.keySet().iterator();
                    while (iterator.hasNext()) {
                        object = object3 = (Integer)iterator.next();
                        hashSet.addAll((Collection)object2.get(object3));
                    }
                }
            }
            --n3;
        }
        hashMap.put((Integer)object, (Set<IcfgEdge>)hashSet);
        return hashMap;
    }

    private Map<Integer, Map<Integer, Set<IcfgEdge>>> postProcessInformationFromCFG(NestedRun<L, IPredicate> nestedRun, Map<Integer, Map<Integer, Set<IcfgEdge>>> map, int n, int n2) {
        HashMap<Integer, Map<Integer, Set<IcfgEdge>>> hashMap = new HashMap<Integer, Map<Integer, Set<IcfgEdge>>>();
        int n3 = n2;
        while (n3 >= n) {
            Map<Integer, Set<IcfgEdge>> map2 = map.get(n3);
            Integer n4 = null;
            Map<Object, Object> map3 = new HashMap();
            if (map2 != null) {
                hashMap.put(n3, map2);
                ArrayList<Integer> arrayList = new ArrayList<Integer>(map2.keySet());
                Collections.sort(arrayList);
                n4 = arrayList.get(0);
                map3 = this.computeBranchOutLocation(n4, n3, map, nestedRun);
                for (Integer n5 : map3.keySet()) {
                    if (((Map)hashMap.get(n3)).get(n5) != null) {
                        ((Set)((Map)hashMap.get(n3)).get(n5)).addAll((Collection)map3.get(n5));
                        continue;
                    }
                    ((Map)hashMap.get(n3)).putAll(map3);
                }
            }
            --n3;
        }
        return hashMap;
    }

    private Set<IcfgEdge> computePathEdges(NestedRun<L, IPredicate> nestedRun, Integer n, Integer n2) {
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        int n3 = n;
        while (n3 < n2) {
            IcfgLocation icfgLocation = ((ISLPredicate)nestedRun.getStateAtPosition(n3)).getProgramPoint();
            IcfgLocation icfgLocation2 = ((ISLPredicate)nestedRun.getStateAtPosition(n3 + 1)).getProgramPoint();
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                IcfgLocation icfgLocation3 = (IcfgLocation)icfgEdge.getTarget();
                if (icfgLocation3 != icfgLocation2) continue;
                hashSet.add(icfgEdge);
            }
            ++n3;
        }
        return hashSet;
    }

    private Map<Integer, Map<Integer, Set<IcfgEdge>>> computeInformationFromCFG(NestedRun<L, IPredicate> nestedRun, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, ManagedScript managedScript) {
        IcfgLocation icfgLocation;
        Object object;
        IPredicate iPredicate2;
        HashMap<Integer, Map<Integer, Set<IcfgEdge>>> hashMap = new HashMap<Integer, Map<Integer, Set<IcfgEdge>>>();
        HashMap<IcfgLocation, IPredicate> hashMap2 = new HashMap<IcfgLocation, IPredicate>();
        for (IPredicate iPredicate2 : iNestedWordAutomaton.getStates()) {
            object = (ISLPredicate)iPredicate2;
            icfgLocation = object.getProgramPoint();
            hashMap2.put(icfgLocation, iPredicate2);
        }
        iPredicate2 = new ArrayList();
        int n = 0;
        while (n < nestedRun.getLength() - 1) {
            iPredicate2.add((IIcfgTransition)nestedRun.getSymbol(n));
            ++n;
        }
        n = 0;
        while (n < nestedRun.getLength() - 1) {
            object = new HashSet();
            icfgLocation = (IPredicate)nestedRun.getStateAtPosition(n);
            IcfgLocation icfgLocation2 = ((ISLPredicate)icfgLocation).getProgramPoint();
            IPredicate iPredicate3 = (IPredicate)hashMap2.get(icfgLocation2);
            Set<IPredicate> set = this.computePossibleEndpoints(nestedRun, hashMap2, n);
            Iterable iterable = iNestedWordAutomaton.internalSuccessors((Object)iPredicate3);
            for (OutgoingInternalTransition outgoingInternalTransition : iterable) {
                Integer n22;
                IPredicate iPredicate4 = (IPredicate)outgoingInternalTransition.getSucc();
                if (iPredicate2.contains(outgoingInternalTransition.getLetter())) continue;
                NestedWord nestedWord = new NestedWord((Object)((IIcfgTransition)outgoingInternalTransition.getLetter()), -2);
                NestedRun nestedRun2 = new NestedRun(nestedWord, new ArrayList<IPredicate>(Arrays.asList(iPredicate3, (IPredicate)outgoingInternalTransition.getSucc())));
                NestedRun<L, IPredicate> nestedRun3 = this.findPathInCfg(iPredicate4, iPredicate3, set, iNestedWordAutomaton);
                if (nestedRun3 == null) continue;
                nestedRun2 = nestedRun2.concatenate(nestedRun3);
                object.addAll(this.computePathEdges(nestedRun2, 0, nestedRun2.getLength() - 1));
                Map<Integer, Map<Integer, Set<IcfgEdge>>> map = this.computeInformationFromCFG(nestedRun2, iNestedWordAutomaton, managedScript);
                for (Integer n22 : map.keySet()) {
                    for (Integer n3 : map.get(n22).keySet()) {
                        object.addAll((Collection)map.get(n22).get(n3));
                    }
                }
                n22 = (IPredicate)nestedRun2.getStateAtPosition(nestedRun2.getLength() - 1);
                List<Integer> list = this.computeEndpointOfAlternativePath(nestedRun, n, (IPredicate)n22);
                Iterator<Integer> iterator = list.iterator();
                while (iterator.hasNext()) {
                    Integer n3;
                    n3 = iterator.next();
                    object.addAll(this.computePathEdges(nestedRun, n, n3));
                    if (hashMap.get(n3 - 1) == null) {
                        HashMap<Integer, Object> hashMap3 = new HashMap<Integer, Object>();
                        hashMap3.put(n, object);
                        hashMap.put(n3 - 1, hashMap3);
                        continue;
                    }
                    ((Map)hashMap.get(n3 - 1)).put(n, object);
                }
            }
            ++n;
        }
        return hashMap;
    }

    private List<Integer> computeEndpointOfAlternativePath(NestedRun<L, IPredicate> nestedRun, int n, IPredicate iPredicate) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = nestedRun.getLength() - 1;
        while (n2 > n) {
            IPredicate iPredicate2 = (IPredicate)nestedRun.getStateAtPosition(n2);
            IcfgLocation icfgLocation = ((ISLPredicate)iPredicate2).getProgramPoint();
            IcfgLocation icfgLocation2 = ((ISLPredicate)iPredicate).getProgramPoint();
            if (icfgLocation2.equals((Object)icfgLocation)) {
                arrayList.add(n2);
            }
            --n2;
        }
        if (!arrayList.isEmpty()) {
            return arrayList;
        }
        throw new AssertionError((Object)"endpoint not in trace");
    }

    private Set<IPredicate> computePossibleEndpoints(NestedRun<L, IPredicate> nestedRun, Map<IcfgLocation, IPredicate> map, int n) {
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        int n2 = n + 1;
        while (n2 < nestedRun.getStateSequence().size() - 1) {
            hashSet.add(map.get(((ISLPredicate)nestedRun.getStateAtPosition(n2)).getProgramPoint()));
            ++n2;
        }
        return hashSet;
    }

    private static boolean[] relevanceCriterionVariables(FaultLocalizationRelevanceChecker.ERelevanceStatus eRelevanceStatus, boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4;
        if (eRelevanceStatus == FaultLocalizationRelevanceChecker.ERelevanceStatus.InUnsatCore) {
            bl4 = true;
            bl3 = false;
            bl2 = false;
        } else if (eRelevanceStatus == FaultLocalizationRelevanceChecker.ERelevanceStatus.Sat) {
            bl4 = false;
            bl3 = true;
            bl2 = !bl;
        } else {
            bl4 = false;
            bl3 = false;
            bl2 = false;
        }
        return new boolean[]{bl4, bl3, bl2};
    }

    private void doNonFlowSensitiveAnalysis(NestedWord<L> nestedWord, IPredicate iPredicate, IPredicate iPredicate2, ModifiableGlobalsTable modifiableGlobalsTable, CfgSmtToolkit cfgSmtToolkit) {
        TracePredicates tracePredicates;
        this.mLogger.info((Object)"Starting non-flow-sensitive error relevancy analysis");
        FaultLocalizationRelevanceChecker faultLocalizationRelevanceChecker = new FaultLocalizationRelevanceChecker(this.mServices, cfgSmtToolkit);
        IterativePredicateTransformer iterativePredicateTransformer = new IterativePredicateTransformer((BasicPredicateFactory)this.mPredicateFactory, cfgSmtToolkit.getManagedScript(), cfgSmtToolkit.getModifiableGlobalsTable(), this.mServices, nestedWord, null, iPredicate2, null, this.mPredicateFactory.not(iPredicate2), this.mSimplificationTechnique, this.mSymbolTable);
        IterativePredicateTransformer iterativePredicateTransformer2 = new IterativePredicateTransformer((BasicPredicateFactory)this.mPredicateFactory, cfgSmtToolkit.getManagedScript(), cfgSmtToolkit.getModifiableGlobalsTable(), this.mServices, nestedWord, iPredicate, null, null, this.mPredicateFactory.not(iPredicate2), this.mSimplificationTechnique, this.mSymbolTable);
        DefaultTransFormulas defaultTransFormulas = new DefaultTransFormulas(nestedWord, iPredicate, iPredicate2, Collections.emptySortedMap(), cfgSmtToolkit.getOldVarsAssignmentCache(), false);
        IterativePredicateTransformer.QuantifierEliminationPostprocessor quantifierEliminationPostprocessor = new IterativePredicateTransformer.QuantifierEliminationPostprocessor(this.mServices, cfgSmtToolkit.getManagedScript(), (BasicPredicateFactory)this.mPredicateFactory, this.mSimplificationTechnique);
        List<IterativePredicateTransformer.QuantifierEliminationPostprocessor> list = Collections.singletonList(quantifierEliminationPostprocessor);
        try {
            quantifierEliminationPostprocessor = iterativePredicateTransformer.computeWeakestPreconditionSequence((NestedFormulas)defaultTransFormulas, list, true, false);
            tracePredicates = iterativePredicateTransformer2.computeStrongestPostconditionSequence((NestedFormulas)defaultTransFormulas, list);
        }
        catch (IterativePredicateTransformer.TraceInterpolationException traceInterpolationException) {
            throw new RuntimeException(traceInterpolationException);
        }
        boolean bl = false;
        int n = nestedWord.length() - 1;
        while (n >= 0) {
            IAction iAction = (IAction)nestedWord.getSymbol(n);
            IPredicate iPredicate3 = quantifierEliminationPostprocessor.getPredicate(n + 1);
            IPredicate iPredicate4 = this.mPredicateFactory.not(quantifierEliminationPostprocessor.getPredicate(n));
            IPredicate iPredicate5 = tracePredicates.getPredicate(n);
            IPredicate iPredicate6 = this.mPredicateFactory.and(SmtUtils.SimplificationTechnique.SIMPLIFY_QUICK, new IPredicate[]{iPredicate4, iPredicate5});
            FaultLocalizationRelevanceChecker.ERelevanceStatus eRelevanceStatus = this.computeRelevance(n, iAction, iPredicate6, iPredicate3, null, (TracePredicates)quantifierEliminationPostprocessor, nestedWord, faultLocalizationRelevanceChecker, cfgSmtToolkit);
            boolean[] blArray = FlowSensitiveFaultLocalizer.relevanceCriterionVariables(eRelevanceStatus, bl);
            boolean bl2 = blArray[0];
            boolean bl3 = blArray[1];
            boolean bl4 = blArray[2];
            bl |= bl4;
            this.mErrorLocalizationStatisticsGenerator.reportIcfgEdge();
            if (bl2) {
                this.mErrorLocalizationStatisticsGenerator.reportErrorEnforcingIcfgEdge();
            }
            if (bl3) {
                this.mErrorLocalizationStatisticsGenerator.reportErrorAdmittingIcfgEdge();
            }
            if (!bl2 && !bl3) {
                this.mErrorLocalizationStatisticsGenerator.reportErrorIrrelevantIcfgEdge();
            }
            RelevanceInformation relevanceInformation = new RelevanceInformation(Collections.singletonList(iAction), bl2, bl3, ((RelevanceInformation)this.mRelevanceOfTrace[n]).getCriterion2UC(), ((RelevanceInformation)this.mRelevanceOfTrace[n]).getCriterion2GF(), bl4);
            this.mRelevanceOfTrace[n] = relevanceInformation;
            --n;
        }
        this.mErrorLocalizationStatisticsGenerator.addHoareTripleCheckerStatistics(faultLocalizationRelevanceChecker.getHoareTripleCheckerStatistics());
        this.mErrorLocalizationStatisticsGenerator.reportAngelicScore(this.getAngelicScore());
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"- - - - - - [Non-Flow Sensitive Analysis with statments + pre/wp information]- - - - - -");
            n = 0;
            while (n < nestedWord.length()) {
                this.mLogger.debug((Object)quantifierEliminationPostprocessor.getPredicate(n));
                this.mLogger.debug((Object)this.mRelevanceOfTrace[n]);
                ++n;
            }
            this.mLogger.debug((Object)quantifierEliminationPostprocessor.getPredicate(nestedWord.length()));
            this.mLogger.debug((Object)"------------------------------------------------------------------------------------------");
        }
    }

    private boolean checkBranchRelevance(int n, int n2, UnmodifiableTransFormula unmodifiableTransFormula, IPredicate iPredicate, IPredicate iPredicate2, NestedWord<L> nestedWord, CfgSmtToolkit cfgSmtToolkit, ModifiableGlobalsTable modifiableGlobalsTable, TracePredicates tracePredicates) {
        String string;
        String string2;
        BasicInternalAction basicInternalAction;
        IPredicate iPredicate3;
        FaultLocalizationRelevanceChecker faultLocalizationRelevanceChecker = new FaultLocalizationRelevanceChecker(this.mServices, cfgSmtToolkit);
        IPredicate iPredicate4 = this.mPredicateFactory.not(iPredicate);
        IPredicate iPredicate5 = this.mPredicateFactory.and(SmtUtils.SimplificationTechnique.SIMPLIFY_QUICK, new IPredicate[]{iPredicate4, iPredicate3 = tracePredicates.getPredicate(n)});
        FaultLocalizationRelevanceChecker.ERelevanceStatus eRelevanceStatus = faultLocalizationRelevanceChecker.relevanceInternal(iPredicate5, (IInternalAction)(basicInternalAction = new BasicInternalAction(string2 = ((IIcfgTransition)nestedWord.getSymbol(n)).getPrecedingProcedure(), string = ((IIcfgTransition)nestedWord.getSymbol(n2)).getSucceedingProcedure(), unmodifiableTransFormula)), this.mPredicateFactory.not(iPredicate2));
        return eRelevanceStatus == FaultLocalizationRelevanceChecker.ERelevanceStatus.InUnsatCore || eRelevanceStatus == FaultLocalizationRelevanceChecker.ERelevanceStatus.Sat;
    }

    private static Integer computeCorrespondingBranchOutLocation(List<Integer> list, int n) {
        assert (list != null && !list.isEmpty());
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            Integer n3 = list.get(n2);
            if (n3 > n) {
                list.remove(n2);
                return n3;
            }
            --n2;
        }
        return null;
    }

    private IPredicate computeRelevantStatements_FlowSensitive(NestedWord<L> nestedWord, int n, int n2, IPredicate iPredicate, PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer, FaultLocalizationRelevanceChecker faultLocalizationRelevanceChecker, CfgSmtToolkit cfgSmtToolkit, ModifiableGlobalsTable modifiableGlobalsTable, TracePredicates tracePredicates, Map<Integer, Map<Integer, Set<IcfgEdge>>> map, NestedRun<L, IPredicate> nestedRun, IIcfg<IcfgLocation> iIcfg) {
        IPredicate iPredicate2 = iPredicate;
        int n3 = n2;
        while (n3 >= n) {
            Object object;
            IIcfgTransition iIcfgTransition = (IIcfgTransition)nestedWord.getSymbol(n3);
            Map<Integer, Set<IcfgEdge>> map2 = map.get(n3);
            Integer n4 = null;
            Set<IcfgEdge> set = null;
            UnmodifiableTransFormula unmodifiableTransFormula = null;
            if (map2 != null && !map2.isEmpty()) {
                object = new ArrayList<Integer>(map2.keySet());
                ((ArrayList)object).sort(Collections.reverseOrder());
                n4 = FlowSensitiveFaultLocalizer.computeCorrespondingBranchOutLocation((List<Integer>)object, n);
                set = map2.get(n4);
            } else {
                n4 = null;
            }
            object = iPredicate2;
            if (n4 != null) {
                map2.remove(n4);
                int n5 = n3;
                unmodifiableTransFormula = this.constructConglomerate(n4, n3, set, nestedRun, iIcfg);
                n3 = n4;
                var22_23 = this.computeWp((IPredicate)object, unmodifiableTransFormula, cfgSmtToolkit.getManagedScript().getScript(), cfgSmtToolkit.getManagedScript(), predicateTransformer, true);
                iPredicate2 = this.mPredicateFactory.newPredicate(var22_23);
                boolean bl = this.checkBranchRelevance(n4, n5, unmodifiableTransFormula, iPredicate2, (IPredicate)object, nestedWord, cfgSmtToolkit, modifiableGlobalsTable, tracePredicates);
                if (bl) {
                    iPredicate2 = this.computeRelevantStatements_FlowSensitive(nestedWord, n4, n5, (IPredicate)object, predicateTransformer, faultLocalizationRelevanceChecker, cfgSmtToolkit, modifiableGlobalsTable, tracePredicates, map, nestedRun, iIcfg);
                } else {
                    this.mLogger.debug((Object)(" - - Irrelevant Branch - - - [BlockEncodedFormula:" + String.valueOf(unmodifiableTransFormula) + " ]"));
                }
            } else {
                UnmodifiableTransFormula unmodifiableTransFormula2 = ((IIcfgTransition)nestedWord.getSymbol(n3)).getTransformula();
                var22_23 = this.computeWp((IPredicate)object, unmodifiableTransFormula2, cfgSmtToolkit.getManagedScript().getScript(), cfgSmtToolkit.getManagedScript(), predicateTransformer, true);
                iPredicate2 = this.mPredicateFactory.newPredicate(var22_23);
                IPredicate iPredicate3 = this.mPredicateFactory.not(iPredicate2);
                IPredicate iPredicate4 = tracePredicates.getPredicate(n3);
                IPredicate iPredicate5 = this.mPredicateFactory.and(SmtUtils.SimplificationTechnique.SIMPLIFY_QUICK, new IPredicate[]{iPredicate3, iPredicate4});
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)" ");
                    this.mLogger.debug((Object)("WP -- > " + String.valueOf(object)));
                    this.mLogger.debug((Object)(" Statement -- > " + String.valueOf(iIcfgTransition)));
                    this.mLogger.debug((Object)("Pre --> " + String.valueOf(iPredicate3)));
                    this.mLogger.debug((Object)("Sp -- >" + String.valueOf(iPredicate4)));
                    this.mLogger.debug((Object)("intersection -- >" + String.valueOf(iPredicate5)));
                    this.mLogger.debug((Object)" ");
                }
                IAction iAction = (IAction)nestedWord.getSymbol(n3);
                FaultLocalizationRelevanceChecker.ERelevanceStatus eRelevanceStatus = this.computeRelevance(n3, iAction, iPredicate5, (IPredicate)object, iPredicate2, null, nestedWord, faultLocalizationRelevanceChecker, cfgSmtToolkit);
                boolean[] blArray = FlowSensitiveFaultLocalizer.relevanceCriterionVariables(eRelevanceStatus, false);
                boolean bl = blArray[0];
                boolean bl2 = blArray[1];
                this.mErrorLocalizationStatisticsGenerator.reportIcfgEdge();
                if (bl) {
                    this.mErrorLocalizationStatisticsGenerator.reportErrorEnforcingIcfgEdge();
                }
                if (bl2) {
                    this.mErrorLocalizationStatisticsGenerator.reportErrorAdmittingIcfgEdge();
                }
                if (!bl && !bl2) {
                    this.mErrorLocalizationStatisticsGenerator.reportErrorIrrelevantIcfgEdge();
                }
                RelevanceInformation relevanceInformation = new RelevanceInformation(Collections.singletonList(iAction), ((RelevanceInformation)this.mRelevanceOfTrace[n3]).getCriterion1UC(), ((RelevanceInformation)this.mRelevanceOfTrace[n3]).getCriterion1GF(), bl, bl2, false);
                this.mRelevanceOfTrace[n3] = relevanceInformation;
            }
            --n3;
        }
        this.mErrorLocalizationStatisticsGenerator.addHoareTripleCheckerStatistics(faultLocalizationRelevanceChecker.getHoareTripleCheckerStatistics());
        return iPredicate2;
    }

    private FaultLocalizationRelevanceChecker.ERelevanceStatus computeRelevance(int n, IAction iAction, IPredicate iPredicate, IPredicate iPredicate2, IPredicate iPredicate3, TracePredicates tracePredicates, NestedWord<L> nestedWord, FaultLocalizationRelevanceChecker faultLocalizationRelevanceChecker, CfgSmtToolkit cfgSmtToolkit) {
        FaultLocalizationRelevanceChecker.ERelevanceStatus eRelevanceStatus;
        if (iAction instanceof IInternalAction) {
            IInternalAction iInternalAction = (IInternalAction)nestedWord.getSymbol(n);
            eRelevanceStatus = faultLocalizationRelevanceChecker.relevanceInternal(iPredicate, iInternalAction, this.mPredicateFactory.not(iPredicate2));
        } else if (iAction instanceof ICallAction) {
            ICallAction iCallAction = (ICallAction)nestedWord.getSymbol(n);
            eRelevanceStatus = faultLocalizationRelevanceChecker.relevanceCall(iPredicate, iCallAction, this.mPredicateFactory.not(iPredicate2));
        } else if (iAction instanceof IReturnAction) {
            IPredicate iPredicate4;
            IReturnAction iReturnAction = (IReturnAction)nestedWord.getSymbol(n);
            assert (nestedWord.isReturnPosition(n));
            assert (!nestedWord.isPendingReturn(n)) : "pending returns not supported";
            if (tracePredicates != null) {
                int n2 = nestedWord.getCallPosition(n);
                iPredicate4 = tracePredicates.getPredicate(n2);
            } else {
                iPredicate4 = iPredicate3;
            }
            eRelevanceStatus = faultLocalizationRelevanceChecker.relevanceReturn(iPredicate, iPredicate4, iReturnAction, this.mPredicateFactory.not(iPredicate2));
        } else {
            throw new AssertionError((Object)("Unknown Action " + iAction.getClass().getSimpleName()));
        }
        return eRelevanceStatus;
    }

    private Term computeWp(IPredicate iPredicate, UnmodifiableTransFormula unmodifiableTransFormula, Script script, ManagedScript managedScript, PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer, boolean bl) {
        Term term = (Term)predicateTransformer.weakestPrecondition((IAbstractPredicate)iPredicate, (ITransitionRelation)unmodifiableTransFormula);
        if (bl) {
            Term term2 = term;
            term = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)managedScript, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique, (Term)term2);
        }
        return term;
    }

    private void doFlowSensitiveAnalysis(NestedRun<L, IPredicate> nestedRun, IPredicate iPredicate, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, ModifiableGlobalsTable modifiableGlobalsTable, CfgSmtToolkit cfgSmtToolkit, IIcfg<IcfgLocation> iIcfg) {
        this.mLogger.info((Object)"Starting flow-sensitive error relevancy analysis");
        Map<Integer, Map<Integer, Set<IcfgEdge>>> map = this.computeInformationFromCFG(nestedRun, iNestedWordAutomaton, cfgSmtToolkit.getManagedScript());
        Map<Integer, Map<Integer, Set<IcfgEdge>>> map2 = this.postProcessInformationFromCFG(nestedRun, map, 0, nestedRun.getLength() - 1);
        int n = 0;
        Collection<Map<Integer, Set<IcfgEdge>>> collection = map2.values();
        for (Map<Integer, Set<IcfgEdge>> predicateTransformer2 : collection) {
            n += predicateTransformer2.size();
        }
        this.mErrorLocalizationStatisticsGenerator.reportNumberOfBranches(n);
        PredicateTransformer predicateTransformer = new PredicateTransformer(cfgSmtToolkit.getManagedScript(), (IDomainSpecificOperationProvider)new TermDomainOperationProvider(this.mServices, cfgSmtToolkit.getManagedScript()));
        FaultLocalizationRelevanceChecker faultLocalizationRelevanceChecker = new FaultLocalizationRelevanceChecker(this.mServices, cfgSmtToolkit);
        int n2 = nestedRun.getWord().length() - 1;
        BasicPredicate basicPredicate = this.mPredicateFactory.newPredicate(cfgSmtToolkit.getManagedScript().getScript().term("false", new Term[0]));
        IterativePredicateTransformer iterativePredicateTransformer = new IterativePredicateTransformer((BasicPredicateFactory)this.mPredicateFactory, cfgSmtToolkit.getManagedScript(), cfgSmtToolkit.getModifiableGlobalsTable(), this.mServices, nestedRun.getWord(), iPredicate, null, null, this.mPredicateFactory.not((IPredicate)basicPredicate), this.mSimplificationTechnique, this.mSymbolTable);
        DefaultTransFormulas defaultTransFormulas = new DefaultTransFormulas((Word)nestedRun.getWord(), iPredicate, (IPredicate)basicPredicate, Collections.emptySortedMap(), cfgSmtToolkit.getOldVarsAssignmentCache(), false);
        IterativePredicateTransformer.QuantifierEliminationPostprocessor quantifierEliminationPostprocessor = new IterativePredicateTransformer.QuantifierEliminationPostprocessor(this.mServices, cfgSmtToolkit.getManagedScript(), (BasicPredicateFactory)this.mPredicateFactory, this.mSimplificationTechnique);
        List<IterativePredicateTransformer.QuantifierEliminationPostprocessor> list = Collections.singletonList(quantifierEliminationPostprocessor);
        quantifierEliminationPostprocessor = iterativePredicateTransformer.computeStrongestPostconditionSequence((NestedFormulas)defaultTransFormulas, list);
        this.computeRelevantStatements_FlowSensitive(nestedRun.getWord(), 0, n2, (IPredicate)basicPredicate, (PredicateTransformer<Term, IPredicate, TransFormula>)predicateTransformer, faultLocalizationRelevanceChecker, cfgSmtToolkit, modifiableGlobalsTable, (TracePredicates)quantifierEliminationPostprocessor, map2, nestedRun, iIcfg);
        this.mErrorLocalizationStatisticsGenerator.reportAngelicScore(this.getAngelicScore());
    }

    private NestedRun<L, IPredicate> findPathInCfg(IPredicate iPredicate, IPredicate iPredicate2, Set<IPredicate> set, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton) {
        try {
            return new IsEmpty(new AutomataLibraryServices(this.mServices), iNestedWordAutomaton, Collections.singleton(iPredicate), Collections.singleton(iPredicate2), set).getNestedRun();
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), null);
            throw new ToolchainCanceledException((IRunningTaskStackProvider)automataOperationCanceledException, runningTaskInfo);
        }
    }

    public List<IRelevanceInformation> getRelevanceInformation() {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"- - - - - - - -");
            IRelevanceInformation[] iRelevanceInformationArray = this.mRelevanceOfTrace;
            int n = this.mRelevanceOfTrace.length;
            int n2 = 0;
            while (n2 < n) {
                IRelevanceInformation iRelevanceInformation = iRelevanceInformationArray[n2];
                this.mLogger.debug((Object)(String.valueOf(((RelevanceInformation)iRelevanceInformation).getActions()) + " | " + iRelevanceInformation.getShortString()));
                ++n2;
            }
        }
        return Arrays.asList(this.mRelevanceOfTrace);
    }

    public ErrorLocalizationStatisticsGenerator getStatistics() {
        return this.mErrorLocalizationStatisticsGenerator;
    }

    public Boolean getAngelicStatus() {
        boolean bl = false;
        IRelevanceInformation[] iRelevanceInformationArray = this.mRelevanceOfTrace;
        int n = this.mRelevanceOfTrace.length;
        int n2 = 0;
        while (n2 < n) {
            IRelevanceInformation iRelevanceInformation = iRelevanceInformationArray[n2];
            if (((RelevanceInformation)iRelevanceInformation).getCriterion2UC()) {
                return false;
            }
            bl |= ((RelevanceInformation)iRelevanceInformation).getCriterion2GF();
            ++n2;
        }
        return bl;
    }

    private double getAngelicScore() {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        IRelevanceInformation[] iRelevanceInformationArray = this.mRelevanceOfTrace;
        int n3 = this.mRelevanceOfTrace.length;
        int n4 = 0;
        while (n4 < n3) {
            IRelevanceInformation iRelevanceInformation = iRelevanceInformationArray[n4];
            if (((RelevanceInformation)iRelevanceInformation).getCriterion2UC() || ((RelevanceInformation)iRelevanceInformation).getCriterion1UC()) {
                ++n;
                ++n2;
            } else if (((RelevanceInformation)iRelevanceInformation).getCriterion2GF() || ((RelevanceInformation)iRelevanceInformation).getCriterion1GF()) {
                ++n2;
            }
            ++n4;
        }
        if (n2 != 0) {
            d = (double)n / (double)n2;
        }
        return d;
    }
}

