/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.lib.pea.BoogieBooleanExpressionDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.BooleanDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.EventDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.RangeDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.RelationDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.ZDecision;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class Decision<T extends Decision<T>> {
    public boolean implies(Decision<?> decision, CDD[] cDDArray, CDD[] cDDArray2) {
        int n = 0;
        while (n < cDDArray.length) {
            if (!cDDArray[n].implies(cDDArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public CDD simplify(CDD[] cDDArray) {
        int n = 1;
        while (n < cDDArray.length) {
            if (cDDArray[n] != cDDArray[0]) {
                return CDD.create(this, cDDArray);
            }
            ++n;
        }
        return cDDArray[0];
    }

    public CDD and(Decision<?> decision, CDD[] cDDArray, CDD[] cDDArray2, Map<CDD, Map<CDD, CDD>> map) {
        CDD[] cDDArray3 = new CDD[cDDArray.length];
        int n = 0;
        while (n < cDDArray.length) {
            cDDArray3[n] = cDDArray[n].and(cDDArray2[n], map);
            ++n;
        }
        return this.simplify(cDDArray3);
    }

    public CDD or(Decision<?> decision, CDD[] cDDArray, CDD[] cDDArray2, Map<CDD, Map<CDD, CDD>> map) {
        CDD[] cDDArray3 = new CDD[cDDArray.length];
        int n = 0;
        while (n < cDDArray.length) {
            cDDArray3[n] = cDDArray[n].or(cDDArray2[n], map);
            ++n;
        }
        return this.simplify(cDDArray3);
    }

    public CDD assume(Decision<?> decision, CDD[] cDDArray, CDD[] cDDArray2) {
        CDD[] cDDArray3 = new CDD[cDDArray.length];
        int n = 0;
        while (n < cDDArray.length) {
            cDDArray3[n] = cDDArray[n].assume(cDDArray2[n]);
            ++n;
        }
        return this.simplify(cDDArray3);
    }

    public abstract T prime(Set<String> var1);

    public abstract T unprime(Set<String> var1);

    public abstract String toString(int var1);

    public abstract String toSmtString(int var1);

    public abstract String toTexString(int var1);

    public abstract String toBoogieString(int var1);

    public abstract String toUppaalString(int var1);

    public abstract String toUppaalStringDOM(int var1);

    public abstract String getVar();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public String getSafeVar() {
        return "var_h_" + Math.abs(this.getVar().hashCode());
    }

    public abstract int compareToSimilar(Decision<?> var1);

    public static Comparator<Decision<?>> getComparator() {
        return new DecisionComparator();
    }

    private static final class DecisionComparator
    implements Comparator<Decision<?>> {
        private static final Map<Class<?>, Integer> ORDER = new HashMap();

        static {
            ORDER.put(EventDecision.class, 10);
            ORDER.put(RangeDecision.class, 9);
            ORDER.put(BooleanDecision.class, 8);
            ORDER.put(RelationDecision.class, 7);
            ORDER.put(ZDecision.class, 6);
            ORDER.put(BoogieBooleanExpressionDecision.class, 5);
        }

        private DecisionComparator() {
        }

        @Override
        public int compare(Decision<?> decision, Decision<?> decision2) {
            Class<?> clazz;
            if (decision == null && decision2 == null) {
                return 0;
            }
            if (decision == null) {
                return 1;
            }
            if (decision2 == null) {
                return -1;
            }
            Class<?> clazz2 = decision.getClass();
            if (clazz2 != (clazz = decision2.getClass())) {
                Integer n = ORDER.get(clazz2);
                Integer n2 = ORDER.get(clazz);
                if (n == null || n2 == null) {
                    throw new UnsupportedOperationException("Unknown subclass of Decision: " + String.valueOf(clazz2) + " or " + String.valueOf(clazz));
                }
                return n.compareTo(n2);
            }
            return decision.compareToSimilar(decision2);
        }
    }
}

