/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class CoreUtil {
    private static final String PLATFORM_LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String OS = System.getProperty("os.name");
    public static final boolean OS_IS_WINDOWS = OS.toLowerCase().indexOf("win") >= 0;
    public static final String WORKING_DIRECTORY = System.getProperty("user.dir");
    private static final String PATHEXT = System.getenv("PATHEXT");

    public static String getPlatformLineSeparator() {
        return PLATFORM_LINE_SEPARATOR;
    }

    public static String getIsoUtcTimestamp() {
        Instant instant = Instant.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.of("UTC"));
        return dateTimeFormatter.format(instant.truncatedTo(ChronoUnit.SECONDS)) + "Z";
    }

    public static String getIsoUtcTimestampWithUtcOffset() {
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        return dateTimeFormatter.format(zonedDateTime.truncatedTo(ChronoUnit.SECONDS));
    }

    public static String getUpperToCamelCase(String string) {
        if (string == null) {
            return string;
        }
        if (!string.toUpperCase().equals(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("_");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            stringBuilder.append(Character.toUpperCase(string2.charAt(0)));
            if (string2.length() > 1) {
                stringBuilder.append(string2.substring(1).toLowerCase());
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String readGitVersion(ClassLoader classLoader) {
        Object object;
        Properties properties = new Properties();
        try {
            object = classLoader.getResourceAsStream("version.properties");
            if (object == null) {
                return String.format("%s-%s-m", "?", "?");
            }
            properties.load((InputStream)object);
        }
        catch (IOException iOException) {
            return null;
        }
        object = properties.getProperty("git.branch", "?").replace('/', '.');
        String string = properties.getProperty("git.commit.id", "?").replace('/', '.');
        String string2 = properties.getProperty("git.commit.id.abbrev", "?");
        String string3 = properties.getProperty("git.dirty", "?");
        Object object2 = string.equals(object) ? "?" : object;
        String string4 = "true".equals(string3) ? "%s-%s-m" : "%s-%s";
        return String.format(string4, object2, string2);
    }

    public static File findExecutableBinaryOnPath(String string) {
        Predicate<File> predicate;
        Object object;
        if (OS_IS_WINDOWS) {
            object = new byte[]{77, 90};
            predicate = arg_0 -> CoreUtil.lambda$0((byte[])object, string, arg_0);
        } else {
            object = new byte[]{127, 69, 76, 70};
            predicate = arg_0 -> CoreUtil.lambda$1(string, (byte[])object, arg_0);
        }
        String[] stringArray = System.getenv("PATH").split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray[n2];
            File[] fileArray = new File((String)object).listFiles(file -> file.getName().startsWith(string));
            if (fileArray != null) {
                File[] fileArray2 = fileArray;
                int n3 = fileArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file2 = fileArray2[n4];
                    if (file2.isFile() && file2.canExecute() && predicate.test(file2)) {
                        return file2;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private static boolean hasMagicNumber(File file, byte[] byArray) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                byte[] byArray2 = new byte[byArray.length];
                fileInputStream.read(byArray2);
                return Arrays.equals(byArray2, byArray);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean hasWindowsExecutableExtensionAndName(File file, String string) {
        String string2 = file.getName();
        if (PATHEXT == null) {
            return string.equalsIgnoreCase(string2);
        }
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        String[] stringArray = PATHEXT.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            String string5 = stringArray[n2];
            String string6 = string5.toLowerCase();
            if (string4.endsWith(string6) && (n3 = string4.lastIndexOf(string6)) != -1 && string3.equals(string4.substring(0, n3))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static File writeFile(File file, String string) throws IOException {
        CoreUtil.writeFile((Writer writer) -> {
            Writer writer2 = writer.append(string);
        }, false, file);
        return file;
    }

    public static File writeFile(String string, String string2) throws IOException {
        return CoreUtil.writeFile(string, string2, false);
    }

    public static File writeFile(String string, String[] stringArray) throws IOException {
        return CoreUtil.writeFile(string, stringArray, false);
    }

    public static File appendFile(String string, String string2) throws IOException {
        return CoreUtil.writeFile(string, string2, true);
    }

    public static File appendFile(String string, String[] stringArray) throws IOException {
        return CoreUtil.writeFile(string, stringArray, true);
    }

    private static File writeFile(String string, String[] stringArray, boolean bl) throws IOException {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        File file = CoreUtil.createFile(string);
        IWriterConsumer iWriterConsumer = writer -> {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                writer.append(string);
                writer.append(PLATFORM_LINE_SEPARATOR);
                ++n2;
            }
        };
        CoreUtil.writeFile(iWriterConsumer, bl, file);
        return file;
    }

    private static File writeFile(String string, String string2, boolean bl) throws IOException {
        File file = CoreUtil.createFile(string);
        CoreUtil.writeFile((Writer writer) -> {
            Writer writer2 = writer.append(string2);
        }, bl, file);
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeFile(IWriterConsumer iWriterConsumer, boolean bl, File file) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
            try {
                try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));){
                    iWriterConsumer.consume(bufferedWriter);
                    ((Writer)bufferedWriter).close();
                }
                if (fileOutputStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            fileOutputStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static File createFile(String string) {
        File file;
        File file2 = new File(string);
        if (!file2.isDirectory() && (file = file2.getParentFile()) != null) {
            file.mkdirs();
        }
        return file2;
    }

    public static List<String> readFileLineByLine(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(string)), "UTF8"));){
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                arrayList.add(string2);
                string2 = bufferedReader.readLine();
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public static void readFileLineByLine(String string, Consumer<String> consumer) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(string)), "UTF8"));){
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                consumer.accept(string2);
                string2 = bufferedReader.readLine();
            }
        }
    }

    public static String readFile(String string2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CoreUtil.readFileLineByLine(string2).stream().forEach(string -> {
            StringBuilder stringBuilder2 = stringBuilder.append((String)string).append(PLATFORM_LINE_SEPARATOR);
        });
        return stringBuilder.toString();
    }

    public static String readFile(File file) throws IOException {
        return CoreUtil.readFile(file.getAbsolutePath());
    }

    public static List<String> readFileLineByLine(File file) throws IOException {
        return CoreUtil.readFileLineByLine(file.getAbsolutePath());
    }

    public static String getFileExtension(File file) {
        assert (file != null);
        assert (file.isFile());
        assert (!file.isDirectory());
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static <E> Collection<E> where(Collection<E> collection, Predicate<E> predicate) {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (E e : collection) {
            if (!predicate.test(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public static <T, E> Set<T> selectDistinct(Collection<E> collection, IReduce<T, E> iReduce) {
        HashSet<T> hashSet = new HashSet<T>();
        for (E e : collection) {
            hashSet.add(iReduce.reduce(e));
        }
        return hashSet;
    }

    public static <T, E> Collection<T> select(Collection<E> collection, IReduce<T, E> iReduce) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (E e : collection) {
            arrayList.add(iReduce.reduce(e));
        }
        return arrayList;
    }

    public static <E> Collection<E> flattenMapValuesToCollection(Map<?, E> map) {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (Map.Entry<?, E> entry : map.entrySet()) {
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public static <T, E> T reduce(Set<E> set, IMapReduce<T, E> iMapReduce) {
        Object var2_2 = null;
        for (E e : set) {
            var2_2 = iMapReduce.reduce(var2_2, e);
        }
        return var2_2;
    }

    public static <T, E> T reduce(Collection<E> collection, IMapReduce<T, E> iMapReduce) {
        Object var2_2 = null;
        for (E e : collection) {
            var2_2 = iMapReduce.reduce(var2_2, e);
        }
        return var2_2;
    }

    public static StringBuilder indentMultilineString(String string, String string2, boolean bl) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = System.getProperty("line.separator");
        String[] stringArray2 = stringArray = string.split("\\r?\\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string4 = stringArray2[n2];
            stringBuilder.append(string2).append(string4).append(string3);
            ++n2;
        }
        char c = string.charAt(string.length() - 1);
        if (bl || c != '\n' && c != '\r') {
            stringBuilder.replace(stringBuilder.length() - string3.length(), stringBuilder.length(), "");
        }
        return stringBuilder;
    }

    public static String addIndentation(int n, String string) {
        StringBuilder stringBuilder = new StringBuilder("");
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append("    ");
            ++n2;
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static String addFileSeparator(String string) {
        if (string.endsWith(System.getProperty("file.separator"))) {
            return string;
        }
        return string + System.getProperty("file.separator");
    }

    public static String getCurrentDateTimeAsString() {
        return new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS").format(Calendar.getInstance().getTime());
    }

    public static StringBuilder flatten(String string, String string2) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray2 = stringArray = string.split("\\r?\\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            stringBuilder.append(string3).append(string2);
            ++n2;
        }
        stringBuilder.replace(stringBuilder.length() - string2.length(), stringBuilder.length(), "");
        return stringBuilder;
    }

    public static List<File> flattenDirectories(Collection<File> collection) {
        ArrayDeque<File> arrayDeque = new ArrayDeque<File>();
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayDeque.addAll(collection);
        while (!arrayDeque.isEmpty()) {
            File file = (File)arrayDeque.removeFirst();
            if (file.isFile()) {
                arrayList.add(file);
                continue;
            }
            arrayDeque.addAll(Arrays.asList(file.listFiles()));
        }
        return arrayList;
    }

    public static <E> Collection<E> firstN(Collection<E> collection, int n) {
        ArrayList<E> arrayList = new ArrayList<E>(n);
        int n2 = 1;
        for (E e : collection) {
            arrayList.add(e);
            if (n < ++n2) break;
        }
        return arrayList;
    }

    @SafeVarargs
    public static <T> T[] concatAll(T[] TArray, T[] ... TArray2) {
        T[] TArray3;
        int n = TArray.length;
        T[][] TArray4 = TArray2;
        int n2 = TArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            TArray3 = TArray4[n3];
            n += TArray3.length;
            ++n3;
        }
        TArray3 = Arrays.copyOf(TArray, n);
        n3 = TArray.length;
        T[][] TArray5 = TArray2;
        int n4 = TArray2.length;
        int n5 = 0;
        while (n5 < n4) {
            T[] TArray6 = TArray5[n5];
            System.arraycopy(TArray6, 0, TArray3, n3, TArray6.length);
            n3 += TArray6.length;
            ++n5;
        }
        return TArray3;
    }

    public static String convertStreamToString(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream).useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    public static <T extends Comparable<? super T>> boolean isSorted(Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return true;
        }
        Comparable comparable = (Comparable)iterator.next();
        while (iterator.hasNext()) {
            Comparable comparable2 = (Comparable)iterator.next();
            int n = comparable.compareTo(comparable2);
            if (n > 0) {
                return false;
            }
            comparable = comparable2;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(Iterable<T> iterable, Comparator<T> comparator) {
        Iterator<T> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return true;
        }
        Comparable comparable = (Comparable)iterator.next();
        while (iterator.hasNext()) {
            Comparable comparable2 = (Comparable)iterator.next();
            if (comparator.compare(comparable, comparable2) >= 0) {
                return false;
            }
            comparable = comparable2;
        }
        return true;
    }

    public static <K, V> Map<K, V> constructFilteredMap(Map<K, V> map, Collection<K> collection) {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        for (K k : collection) {
            V v = map.get(k);
            if (v == null) continue;
            hashMap.put(k, v);
        }
        return hashMap;
    }

    public static <E> Set<E> constructHashSet(Iterable<E> iterable) {
        HashSet<E> hashSet = new HashSet<E>();
        for (E e : iterable) {
            hashSet.add(e);
        }
        return hashSet;
    }

    public static String humanReadableByteCount(long l, boolean bl) {
        int n;
        int n2 = n = bl ? 1000 : 1024;
        if (l < (long)n) {
            return l + "B";
        }
        int n3 = (int)(Math.log(l) / Math.log(n));
        String string = (bl ? "kMGTPE" : "KMGTPE").charAt(n3 - 1) + (bl ? "" : "i");
        return String.format("%.1f%sB", (double)l / Math.pow(n, n3), string);
    }

    public static String humanReadableNumber(long l) {
        if (l < 1000L) {
            return Long.toString(l);
        }
        int n = (int)(Math.log(l) / Math.log(1000.0));
        String string = String.valueOf("KMGTPE".charAt(n - 1));
        return String.format("%.1f%s", (double)l / Math.pow(1000.0, n), string);
    }

    public static String join(Collection<?> collection, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) break;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static <T> String join(T[] TArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray2[n2];
            stringBuilder.append(t);
            stringBuilder.append(string);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String humanReadableTime(long l, TimeUnit timeUnit, int n) {
        return CoreUtil.humanReadableTime((double)l, timeUnit, n);
    }

    public static String humanReadableTime(double d, TimeUnit timeUnit, int n) {
        TimeUnit timeUnit2 = CoreUtil.findLargestTargetUnit(d, timeUnit);
        return CoreUtil.toTimeString(d, timeUnit, timeUnit2, n);
    }

    public static String toTimeString(double d, TimeUnit timeUnit, TimeUnit timeUnit2, int n) {
        String string = "%." + n + "f%s";
        return String.format(string, CoreUtil.convertTimeUnit(d, timeUnit, timeUnit2), CoreUtil.getTimeUnitSymbol(timeUnit2));
    }

    public static String toTimeString(double d, TimeUnit timeUnit) {
        return CoreUtil.toTimeString(d, timeUnit, timeUnit, 2);
    }

    public static double convertTimeUnit(double d, TimeUnit timeUnit, TimeUnit timeUnit2) {
        if (timeUnit == timeUnit2) {
            return d;
        }
        if (timeUnit.ordinal() < timeUnit2.ordinal()) {
            return d / (double)timeUnit.convert(1L, timeUnit2);
        }
        return d * (double)timeUnit2.convert(1L, timeUnit);
    }

    public static TimeUnit findLargestTargetUnit(double d, TimeUnit timeUnit) {
        switch (timeUnit) {
            case DAYS: {
                return TimeUnit.DAYS;
            }
            case HOURS: {
                if (d >= 24.0) {
                    return CoreUtil.findLargestTargetUnit(d / 24.0, TimeUnit.DAYS);
                }
                return TimeUnit.HOURS;
            }
            case MINUTES: {
                if (d >= 60.0) {
                    return CoreUtil.findLargestTargetUnit(d / 60.0, TimeUnit.HOURS);
                }
                return TimeUnit.MINUTES;
            }
            case SECONDS: {
                if (d >= 60.0) {
                    return CoreUtil.findLargestTargetUnit(d / 60.0, TimeUnit.MINUTES);
                }
                return TimeUnit.SECONDS;
            }
            case MILLISECONDS: {
                if (d >= 1000.0) {
                    return CoreUtil.findLargestTargetUnit(d / 1000.0, TimeUnit.SECONDS);
                }
                return TimeUnit.MILLISECONDS;
            }
            case MICROSECONDS: {
                if (d >= 1000.0) {
                    return CoreUtil.findLargestTargetUnit(d / 1000.0, TimeUnit.MILLISECONDS);
                }
                return TimeUnit.MICROSECONDS;
            }
            case NANOSECONDS: {
                if (d >= 1000.0) {
                    return CoreUtil.findLargestTargetUnit(d / 1000.0, TimeUnit.NANOSECONDS);
                }
                return TimeUnit.NANOSECONDS;
            }
        }
        throw new UnsupportedOperationException("TimeUnit not yet implemented: " + String.valueOf((Object)timeUnit));
    }

    public static String getTimeUnitSymbol(TimeUnit timeUnit) {
        return switch (timeUnit) {
            case TimeUnit.NANOSECONDS -> "ns";
            case TimeUnit.MICROSECONDS -> "\u00b5s";
            case TimeUnit.MILLISECONDS -> "ms";
            case TimeUnit.SECONDS -> "s";
            case TimeUnit.MINUTES -> "m";
            case TimeUnit.HOURS -> "h";
            case TimeUnit.DAYS -> "d";
            default -> throw new MatchException(null, null);
        };
    }

    public static <E> Collection<E> filter(Collection<?> collection, Class<E> clazz) {
        ArrayList arrayList = new ArrayList();
        for (Object obj : collection) {
            if (!clazz.isAssignableFrom(obj.getClass())) continue;
            arrayList.add(obj);
        }
        return arrayList;
    }

    public static void deleteDirectory(File file) {
        CoreUtil.deleteDirectoryContents(file);
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public static void deleteDirectoryContents(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                if (file2.isDirectory()) {
                    CoreUtil.deleteDirectory(file2);
                } else if (!file2.delete()) {
                    file2.deleteOnExit();
                }
                ++n2;
            }
        }
    }

    public static void deleteDirectoryContentsIf(File file, FileFilter fileFilter) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                boolean bl = fileFilter.accept(file2);
                if (file2.isDirectory()) {
                    if (bl) {
                        CoreUtil.deleteDirectory(file2);
                    } else {
                        CoreUtil.deleteDirectoryContentsIf(file2, fileFilter);
                    }
                } else if (bl) {
                    file2.delete();
                }
                ++n2;
            }
        }
    }

    public static String alphabeticalSequence(int n) {
        return n < 0 ? "" : CoreUtil.alphabeticalSequence(n / 26 - 1) + (char)(65 + n % 26);
    }

    public static String getStackTrace(Throwable throwable) {
        return CoreUtil.getStackTrace("", throwable);
    }

    public static String getStackTrace(String string, Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            stringBuilder.append(string);
            stringBuilder.append(String.format("%s%n", stackTraceElement.toString()));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String repeat(int n, String string) {
        if (n == 0) {
            return "";
        }
        if (n < 0) {
            throw new IllegalArgumentException("n smaller than zero");
        }
        return new String(new char[n]).replace("\u0000", string);
    }

    private static /* synthetic */ boolean lambda$0(byte[] byArray, String string, File file) {
        return CoreUtil.hasMagicNumber(file, byArray) && CoreUtil.hasWindowsExecutableExtensionAndName(file, string);
    }

    private static /* synthetic */ boolean lambda$1(String string, byte[] byArray, File file) {
        return file.getName().equals(string) && CoreUtil.hasMagicNumber(file, byArray);
    }

    @FunctionalInterface
    public static interface IMapReduce<T, K> {
        public T reduce(T var1, K var2);
    }

    @FunctionalInterface
    public static interface IReduce<T, K> {
        public T reduce(K var1);
    }

    @FunctionalInterface
    private static interface IWriterConsumer {
        public void consume(Writer var1) throws IOException;
    }
}

