/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.statistics.Aggregate;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.KeyType;
import de.uni_freiburg.informatik.ultimate.util.statistics.PrettyPrint;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import de.uni_freiburg.informatik.ultimate.util.statistics.TimeTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public abstract class AbstractStatisticsDataProvider
implements IStatisticsDataProvider {
    private final Map<String, Supplier<Object>> mSuppliers = new LinkedHashMap<String, Supplier<Object>>();
    private final Map<String, BinaryOperator<Object>> mAggregators = new HashMap<String, BinaryOperator<Object>>();
    private final Map<String, BiFunction<String, Object, String>> mPrinters = new HashMap<String, BiFunction<String, Object, String>>();
    private final BenchmarkType mBenchmarkType = new BenchmarkType();

    protected final void declare(String string, Supplier<Object> supplier, KeyType keyType) {
        this.declare(string, supplier, keyType::aggregate, keyType::prettyPrint);
    }

    protected final void declareTimeTracker(String string2, TimeTracker timeTracker) {
        this.declare(string2, () -> timeTracker.elapsedTime(TimeUnit.MILLISECONDS), (object, object2) -> (Long)object + (Long)object2, (string, object) -> PrettyPrint.keyColonData(string + " [ms]", object));
    }

    protected final void declareCounter(String string, IntSupplier intSupplier) {
        this.declare(string, intSupplier::getAsInt, KeyType.COUNTER);
    }

    protected final void declare(String string, Supplier<Object> supplier, BinaryOperator<Object> binaryOperator, BiFunction<String, Object, String> biFunction) {
        assert (!this.mSuppliers.containsKey(string));
        assert (supplier != null);
        assert (binaryOperator != null);
        assert (biFunction != null);
        this.mSuppliers.put(string, supplier);
        this.mAggregators.put(string, binaryOperator);
        this.mPrinters.put(string, biFunction);
    }

    protected final void forward(String string, Supplier<IStatisticsDataProvider> supplier) {
        this.declare(string, () -> AbstractStatisticsDataProvider.toStatisticsData((IStatisticsDataProvider)supplier.get()), Aggregate::statisticsDataAggregate, PrettyPrint::keyColonData);
    }

    protected final <T> void forwardAll(String string, Iterable<T> iterable, Function<T, IStatisticsDataProvider> function) {
        this.declare(string, () -> StreamSupport.stream(iterable.spliterator(), false).map(function).map(AbstractStatisticsDataProvider::toStatisticsData).collect(Collectors.toCollection(ArrayList::new)), Aggregate::appendList, PrettyPrint.list(PrettyPrint::keyColonData, Object::toString));
    }

    protected final void include(String string, Supplier<StatisticsData> supplier) {
        this.declare(string, supplier::get, Aggregate::statisticsDataAggregate, PrettyPrint::keyColonData);
    }

    protected final void includeAll(String string, Supplier<Iterable<StatisticsData>> supplier) {
        this.declare(string, () -> StreamSupport.stream(((Iterable)supplier.get()).spliterator(), false).collect(Collectors.toCollection(ArrayList::new)), Aggregate::appendList, PrettyPrint.list(PrettyPrint::keyColonData, Object::toString));
    }

    private static StatisticsData toStatisticsData(IStatisticsDataProvider iStatisticsDataProvider) {
        StatisticsData statisticsData = new StatisticsData();
        statisticsData.aggregateBenchmarkData(iStatisticsDataProvider);
        return statisticsData;
    }

    @Override
    public Object getValue(String string) {
        Supplier<Object> supplier = this.mSuppliers.get(string);
        if (supplier == null) {
            throw new IllegalArgumentException("Unknown key '" + string + "'");
        }
        return supplier.get();
    }

    @Override
    public IStatisticsType getBenchmarkType() {
        return this.mBenchmarkType;
    }

    public String toString() {
        return this.mBenchmarkType.prettyprintBenchmarkData(this);
    }

    private class BenchmarkType
    implements IStatisticsType {
        private BenchmarkType() {
        }

        @Override
        public Collection<String> getKeys() {
            return AbstractStatisticsDataProvider.this.mSuppliers.keySet();
        }

        @Override
        public Object aggregate(String string, Object object, Object object2) {
            BinaryOperator<Object> binaryOperator = AbstractStatisticsDataProvider.this.mAggregators.get(string);
            if (binaryOperator == null) {
                throw new IllegalArgumentException("Unknown key '" + string + "'");
            }
            return binaryOperator.apply(object, object2);
        }

        @Override
        public String prettyprintBenchmarkData(IStatisticsDataProvider iStatisticsDataProvider) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            for (String string2 : this.getKeys()) {
                stringBuilder.append(string);
                Object object = iStatisticsDataProvider.getValue(string2);
                BiFunction<String, Object, String> biFunction = AbstractStatisticsDataProvider.this.mPrinters.get(string2);
                stringBuilder.append(biFunction.apply(string2, object));
                string = ", ";
            }
            return stringBuilder.toString();
        }
    }
}

