/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;

public class IsTotal<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final boolean mResult;
    private final INestedWordAutomaton<LETTER, STATE> mOperand;

    public IsTotal(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        super(automataLibraryServices);
        this.mOperand = iNestedWordAutomaton;
        this.mResult = this.computeIsTotal();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("automaton is " + (this.mResult ? "" : "not ") + "total"));
        }
    }

    private boolean computeIsTotal() {
        for (STATE STATE : this.mOperand.getStates()) {
            if (this.isTotal(STATE)) continue;
            return false;
        }
        return true;
    }

    private boolean isTotal(STATE STATE) {
        Iterable iterable2;
        for (Object LETTER : this.mOperand.getVpAlphabet().getInternalAlphabet()) {
            iterable2 = this.mOperand.internalSuccessors(STATE, LETTER);
            if (iterable2.iterator().hasNext()) continue;
            return false;
        }
        for (Object LETTER : this.mOperand.getVpAlphabet().getCallAlphabet()) {
            iterable2 = this.mOperand.callSuccessors(STATE, LETTER);
            if (iterable2.iterator().hasNext()) continue;
            return false;
        }
        for (Object LETTER : this.mOperand.getVpAlphabet().getReturnAlphabet()) {
            for (Iterable iterable2 : this.mOperand.getStates()) {
                Iterable iterable3 = this.mOperand.returnSuccessors(STATE, iterable2, LETTER);
                if (iterable3.iterator().hasNext()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Boolean getResult() {
        return this.mResult;
    }
}

