/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.arraytheory;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.arraytheory.SMTTheoryOperationProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.arraytheory.SMTTheoryState;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SMTTheoryStateFactoryAndPredicateHelper {
    private final BasicPredicateFactory mBasicPredicateFactory;
    private final CfgSmtToolkit mCsToolkit;
    private final ManagedScript mMgdScript;
    private final SMTTheoryState mTopState;
    private final SMTTheoryState mBottomState;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique = SmtUtils.SimplificationTechnique.SIMPLIFY_QUICK;
    private final SMTTheoryOperationProvider mArrayTheoryOperationProvider;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final BasicPredicate mFalsePredicate;
    private final Map<Term, IPredicate> mTermToPredicate;

    public SMTTheoryStateFactoryAndPredicateHelper(IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, SMTTheoryOperationProvider sMTTheoryOperationProvider) {
        this.mCsToolkit = cfgSmtToolkit;
        this.mMgdScript = cfgSmtToolkit.getManagedScript();
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(this.getClass());
        this.mArrayTheoryOperationProvider = sMTTheoryOperationProvider;
        this.mTermToPredicate = new HashMap<Term, IPredicate>();
        this.mBasicPredicateFactory = new BasicPredicateFactory(iUltimateServiceProvider, cfgSmtToolkit.getManagedScript(), cfgSmtToolkit.getSymbolTable());
        cfgSmtToolkit.getManagedScript().lock((Object)this);
        Term term = cfgSmtToolkit.getManagedScript().term((Object)this, "true", new Term[0]);
        Term term2 = cfgSmtToolkit.getManagedScript().term((Object)this, "false", new Term[0]);
        cfgSmtToolkit.getManagedScript().unlock((Object)this);
        this.mTopState = this.getOrConstructState(term, (ImmutableSet<IProgramVarOrConst>)ImmutableSet.empty());
        this.mFalsePredicate = this.mBasicPredicateFactory.newPredicate(term2);
        this.mBottomState = new SMTTheoryState((IPredicate)this.mFalsePredicate, (ImmutableSet<IProgramVarOrConst>)ImmutableSet.empty(), this);
    }

    public SMTTheoryState getOrConstructState(Term term, ImmutableSet<IProgramVarOrConst> immutableSet) {
        IPredicate iPredicate = this.getOrConstructPredicate(term, (Set<IProgramVarOrConst>)immutableSet);
        return this.getOrConstructState(iPredicate, immutableSet);
    }

    private IPredicate getOrConstructPredicate(Term term, Set<IProgramVarOrConst> set) {
        IPredicate iPredicate = this.mTermToPredicate.get(term);
        if (iPredicate == null) {
            set.stream().filter(iProgramVarOrConst -> iProgramVarOrConst instanceof IProgramVar).map(iProgramVarOrConst -> (IProgramVar)iProgramVarOrConst).collect(Collectors.toSet());
            this.mMgdScript.lock((Object)this);
            this.mMgdScript.push((Object)this, 1);
            TermVarsFuns termVarsFuns = TermVarsFuns.computeTermVarsFuns((Term)term, (ManagedScript)this.mMgdScript, (IIcfgSymbolTable)this.mCsToolkit.getSymbolTable());
            this.mMgdScript.assertTerm((Object)this, termVarsFuns.getClosedFormula());
            Script.LBool lBool = this.mMgdScript.checkSat((Object)this);
            this.mMgdScript.pop((Object)this, 1);
            this.mMgdScript.unlock((Object)this);
            iPredicate = lBool == Script.LBool.UNSAT ? this.mFalsePredicate : this.mBasicPredicateFactory.newPredicate(term);
        }
        return iPredicate;
    }

    public SMTTheoryState getOrConstructState(IPredicate iPredicate, ImmutableSet<IProgramVarOrConst> immutableSet) {
        if (iPredicate == this.mFalsePredicate) {
            return this.mBottomState;
        }
        return new SMTTheoryState(iPredicate, immutableSet, this);
    }

    public SMTTheoryState getTopState() {
        return this.mTopState;
    }

    public SMTTheoryState getBottomState() {
        return this.mBottomState;
    }

    public SMTTheoryState widen(SMTTheoryState sMTTheoryState, SMTTheoryState sMTTheoryState2) {
        return this.disjoinFlat(sMTTheoryState, sMTTheoryState2);
    }

    public SMTTheoryState conjoin(SMTTheoryState sMTTheoryState, SMTTheoryState sMTTheoryState2) {
        if (sMTTheoryState.isBottom()) {
            return sMTTheoryState;
        }
        if (sMTTheoryState2.isBottom()) {
            return sMTTheoryState2;
        }
        IPredicate iPredicate = this.mBasicPredicateFactory.and(this.mSimplificationTechnique, new IPredicate[]{sMTTheoryState.getPredicate(), sMTTheoryState2.getPredicate()});
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        hashSet.addAll((Collection<IProgramVarOrConst>)sMTTheoryState.getVariables());
        hashSet.addAll((Collection<IProgramVarOrConst>)sMTTheoryState2.getVariables());
        return this.getOrConstructState(iPredicate, (ImmutableSet<IProgramVarOrConst>)ImmutableSet.of(hashSet));
    }

    public SMTTheoryState disjoinFlat(SMTTheoryState sMTTheoryState, SMTTheoryState sMTTheoryState2) {
        Term[] termArray;
        Term[] termArray2;
        if (sMTTheoryState.isBottom()) {
            return sMTTheoryState2;
        }
        if (sMTTheoryState2.isBottom()) {
            return sMTTheoryState;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Term[] termArray3 = termArray2 = SmtUtils.getConjuncts((Term)sMTTheoryState.getPredicate().getFormula());
        int n = termArray2.length;
        int n2 = 0;
        while (n2 < n) {
            termArray = termArray3[n2];
            if (sMTTheoryState2.impliesLiteral((Term)termArray)) {
                arrayList.add(termArray);
            }
            ++n2;
        }
        Term[] termArray4 = termArray = SmtUtils.getConjuncts((Term)sMTTheoryState2.getPredicate().getFormula());
        int n3 = termArray.length;
        n = 0;
        while (n < n3) {
            Term term = termArray4[n];
            if (sMTTheoryState.impliesLiteral(term)) {
                arrayList.add(term);
            }
            ++n;
        }
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        hashSet.addAll((Collection<IProgramVarOrConst>)sMTTheoryState.getVariables());
        hashSet.addAll((Collection<IProgramVarOrConst>)sMTTheoryState2.getVariables());
        Term term = SmtUtils.and((Script)this.mCsToolkit.getManagedScript().getScript(), arrayList);
        return this.getOrConstructState(term, (ImmutableSet<IProgramVarOrConst>)ImmutableSet.of(hashSet));
    }

    public IPredicate projectExistentially(Set<TermVariable> set, IPredicate iPredicate) {
        Term term = this.mArrayTheoryOperationProvider.projectExistentially(set, iPredicate.getFormula());
        Term term2 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique, (Term)term);
        return this.mBasicPredicateFactory.newPredicate(term2);
    }

    public boolean implies(SMTTheoryState sMTTheoryState, SMTTheoryState sMTTheoryState2) {
        this.mMgdScript.lock((Object)this);
        this.mMgdScript.push((Object)this, 1);
        this.mMgdScript.assertTerm((Object)this, sMTTheoryState.getPredicate().getClosedFormula());
        this.mMgdScript.assertTerm((Object)this, SmtUtils.not((Script)this.mMgdScript.getScript(), (Term)sMTTheoryState2.getPredicate().getClosedFormula()));
        Script.LBool lBool = this.mMgdScript.checkSat((Object)this);
        this.mMgdScript.pop((Object)this, 1);
        this.mMgdScript.unlock((Object)this);
        assert (lBool != Script.LBool.UNKNOWN);
        return lBool == Script.LBool.UNSAT;
    }

    public boolean impliesLiteral(SMTTheoryState sMTTheoryState, Term term) {
        this.mMgdScript.lock((Object)this);
        this.mMgdScript.push((Object)this, 1);
        this.mMgdScript.assertTerm((Object)this, sMTTheoryState.getPredicate().getClosedFormula());
        TermVarsFuns termVarsFuns = TermVarsFuns.computeTermVarsFuns((Term)term, (ManagedScript)this.mMgdScript, (IIcfgSymbolTable)this.mCsToolkit.getSymbolTable());
        this.mMgdScript.assertTerm((Object)this, SmtUtils.not((Script)this.mMgdScript.getScript(), (Term)termVarsFuns.getClosedFormula()));
        Script.LBool lBool = this.mMgdScript.checkSat((Object)this);
        this.mMgdScript.pop((Object)this, 1);
        this.mMgdScript.unlock((Object)this);
        assert (lBool != Script.LBool.UNKNOWN);
        return lBool == Script.LBool.UNSAT;
    }

    public ManagedScript getManagedScript() {
        return this.mMgdScript;
    }
}

