/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Objects;

public class MultiIndexArrayUpdate
implements ITermProvider {
    private final RelationSymbol mRelationSymbol;
    private final Term mNewArray;
    private final MultiDimensionalNestedStore mMultiDimensionalNestedStore;

    public MultiIndexArrayUpdate(RelationSymbol relationSymbol, Term term, MultiDimensionalNestedStore multiDimensionalNestedStore) {
        this.mRelationSymbol = relationSymbol;
        this.mNewArray = term;
        this.mMultiDimensionalNestedStore = multiDimensionalNestedStore;
    }

    public RelationSymbol getRelationSymbol() {
        return this.mRelationSymbol;
    }

    public Term getNewArray() {
        return this.mNewArray;
    }

    public MultiDimensionalNestedStore getMultiDimensionalNestedStore() {
        return this.mMultiDimensionalNestedStore;
    }

    public MultiIndexArrayUpdate removeOneIndex(int n) {
        return new MultiIndexArrayUpdate(this.getRelationSymbol(), this.getNewArray(), this.getMultiDimensionalNestedStore().removeOneIndex(n));
    }

    public boolean isNondeterministicUpdate() {
        int n = 0;
        while (n < this.mMultiDimensionalNestedStore.getIndices().size()) {
            if (this.isNondeterministicUpdate(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isNondeterministicUpdate(int n) {
        ArrayIndex arrayIndex = this.mMultiDimensionalNestedStore.getIndices().get(n);
        Term term = this.mMultiDimensionalNestedStore.getValues().get(n);
        MultiDimensionalSelect multiDimensionalSelect = MultiDimensionalSelect.of(term);
        return multiDimensionalSelect != null && multiDimensionalSelect.getArray() == this.getNewArray() && multiDimensionalSelect.getIndex().equals(arrayIndex);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mMultiDimensionalNestedStore, this.mNewArray, this.mRelationSymbol});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MultiIndexArrayUpdate multiIndexArrayUpdate = (MultiIndexArrayUpdate)object;
        if (this.mMultiDimensionalNestedStore == null ? multiIndexArrayUpdate.mMultiDimensionalNestedStore != null : !this.mMultiDimensionalNestedStore.equals(multiIndexArrayUpdate.mMultiDimensionalNestedStore)) {
            return false;
        }
        if (this.mNewArray == null ? multiIndexArrayUpdate.mNewArray != null : !this.mNewArray.equals(multiIndexArrayUpdate.mNewArray)) {
            return false;
        }
        return this.mRelationSymbol == multiIndexArrayUpdate.mRelationSymbol;
    }

    public static MultiIndexArrayUpdate of(Script script, Term term) {
        BinaryEqualityRelation binaryEqualityRelation = BinaryEqualityRelation.convert(term);
        if (binaryEqualityRelation == null) {
            return null;
        }
        if (!SmtSortUtils.isArraySort(binaryEqualityRelation.getLhs().getSort())) {
            return null;
        }
        MultiDimensionalNestedStore multiDimensionalNestedStore = MultiDimensionalNestedStore.of(binaryEqualityRelation.getLhs());
        MultiDimensionalNestedStore multiDimensionalNestedStore2 = MultiDimensionalNestedStore.of(binaryEqualityRelation.getRhs());
        if (multiDimensionalNestedStore2 != null && multiDimensionalNestedStore == null) {
            return new MultiIndexArrayUpdate(binaryEqualityRelation.getRelationSymbol(), binaryEqualityRelation.getLhs(), multiDimensionalNestedStore2);
        }
        if (multiDimensionalNestedStore != null && multiDimensionalNestedStore2 == null) {
            return new MultiIndexArrayUpdate(binaryEqualityRelation.getRelationSymbol(), binaryEqualityRelation.getRhs(), multiDimensionalNestedStore);
        }
        return null;
    }

    public String toString() {
        return String.format("(%s %s %s)", new Object[]{this.mRelationSymbol, this.mNewArray, this.mMultiDimensionalNestedStore});
    }

    @Override
    public Term toTerm(Script script) {
        return this.mRelationSymbol.constructTerm(script, this.mNewArray, this.mMultiDimensionalNestedStore.toTerm(script));
    }
}

