/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class AffineFunctionGenerator
implements Serializable {
    private static final long serialVersionUID = 4376363192635730213L;
    private final Term mConstant;
    private final Map<IProgramVar, Term> mCoefficients;

    private static String constName(String string) {
        return string + "c";
    }

    private static String coeffName(String string, IProgramVar iProgramVar) {
        return string + "_" + SmtUtils.removeSmtQuoteCharacters((String)iProgramVar.getGloballyUniqueId());
    }

    private AffineFunctionGenerator(Term term, Map<IProgramVar, Term> map) {
        this.mConstant = term;
        this.mCoefficients = map;
    }

    public AffineFunctionGenerator(Script script, Collection<IProgramVar> collection, String string) {
        this.mConstant = SmtUtils.buildNewConstant((Script)script, (String)AffineFunctionGenerator.constName(string), (String)"Real");
        this.mCoefficients = new LinkedHashMap<IProgramVar, Term>();
        for (IProgramVar iProgramVar : collection) {
            this.mCoefficients.put(iProgramVar, (Term)SmtUtils.buildNewConstant((Script)script, (String)AffineFunctionGenerator.coeffName(string, iProgramVar), (String)"Real"));
        }
    }

    public AffineFunctionGenerator(Script script, Collection<IProgramVar> collection, String string, boolean bl) {
        assert (bl) : "This constructor is called only if the program variables shouldn't have any coefficients whichneed to be determined";
        this.mConstant = SmtUtils.buildNewConstant((Script)script, (String)AffineFunctionGenerator.constName(string), (String)"Real");
        this.mCoefficients = new LinkedHashMap<IProgramVar, Term>();
        for (IProgramVar iProgramVar : collection) {
            this.mCoefficients.put(iProgramVar, SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ONE));
        }
    }

    public LinearInequality generate(Map<IProgramVar, ? extends Term> map) {
        LinearInequality linearInequality = new LinearInequality();
        linearInequality.add(new AffineTerm(this.mConstant, Rational.ONE));
        for (Map.Entry<IProgramVar, ? extends Term> entry : map.entrySet()) {
            if (!this.mCoefficients.containsKey(entry.getKey())) continue;
            linearInequality.add(entry.getValue(), new AffineTerm(this.mCoefficients.get(entry.getKey()), Rational.ONE));
        }
        return linearInequality;
    }

    public LinearInequality generate(Map<IProgramVar, ? extends Term> map, Map<IProgramVar, AffineTerm> map2, Map<Term, AffineTerm> map3) {
        LinearInequality linearInequality = new LinearInequality();
        for (Map.Entry<IProgramVar, ? extends Term> entry : map.entrySet()) {
            linearInequality.add(entry.getValue(), map2.get(entry.getKey()));
        }
        for (Map.Entry<Object, Object> entry : map3.entrySet()) {
            linearInequality.add((Term)entry.getKey(), (AffineTerm)entry.getValue());
        }
        return linearInequality;
    }

    public Term getCoefficient(IProgramVar iProgramVar) {
        return this.mCoefficients.get(iProgramVar);
    }

    public Collection<Term> getCoefficients() {
        ArrayList<Term> arrayList = new ArrayList<Term>(this.mCoefficients.values());
        arrayList.add(this.mConstant);
        return arrayList;
    }

    public Rational getGcd(Map<Term, Rational> map) {
        Rational rational = map.get(this.mConstant);
        for (Map.Entry<IProgramVar, Term> entry : this.mCoefficients.entrySet()) {
            rational = rational.gcd(map.get(entry.getValue()));
        }
        return rational.abs();
    }

    public AffineFunction extractAffineFunction(Map<Term, Rational> map) {
        return this.extractAffineFunction(map, this.getGcd(map));
    }

    public AffineFunction extractAffineFunction(Map<Term, Rational> map, Rational rational) {
        AffineFunction affineFunction = new AffineFunction();
        if (rational.equals((Object)Rational.ZERO)) {
            Rational rational2 = map.get(this.mConstant);
            assert (rational2.equals((Object)Rational.ZERO));
            for (Map.Entry<IProgramVar, Term> entry : this.mCoefficients.entrySet()) {
                rational2 = map.get(entry.getValue());
                assert (rational2.equals((Object)Rational.ZERO));
                affineFunction.put(entry.getKey(), rational2.numerator());
            }
        } else {
            Rational rational3 = map.get(this.mConstant).div(rational);
            assert (rational3.denominator().equals(BigInteger.ONE));
            affineFunction.setConstant(rational3.numerator());
            for (Map.Entry<IProgramVar, Term> entry : this.mCoefficients.entrySet()) {
                rational3 = map.get(entry.getValue()).div(rational);
                assert (rational3.denominator().equals(BigInteger.ONE));
                affineFunction.put(entry.getKey(), rational3.numerator());
            }
        }
        return affineFunction;
    }

    public AffineFunctionGenerator getGeneratorWithNegatedCoefficients(Script script) {
        Term term = script.term("-", new Term[]{this.mConstant});
        HashMap<IProgramVar, Term> hashMap = new HashMap<IProgramVar, Term>(this.mCoefficients.size());
        for (Map.Entry<IProgramVar, Term> entry : this.mCoefficients.entrySet()) {
            hashMap.put(entry.getKey(), script.term("-", new Term[]{entry.getValue()}));
        }
        return new AffineFunctionGenerator(term, hashMap);
    }
}

