/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LogicStatement;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Parameter;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.PolyIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class LogicFunction
extends LogicStatement {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(LogicFunction.class);
    ACSLType type;
    Expression formula;

    public LogicFunction(PolyIdentifier polyIdentifier, ACSLType aCSLType, Expression expression) {
        super(polyIdentifier);
        this.type = aCSLType;
        this.formula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid LogicFunction: " + String.valueOf(this);
    }

    public LogicFunction(PolyIdentifier polyIdentifier, Parameter[] parameterArray, ACSLType aCSLType, Expression expression) {
        super(polyIdentifier, parameterArray);
        this.type = aCSLType;
        this.formula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid LogicFunction: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LogicFunction").append('[');
        stringBuffer.append(this.type);
        stringBuffer.append(',').append(this.formula);
        return stringBuffer.append(']').toString();
    }

    public ACSLType getType() {
        return this.type;
    }

    public Expression getFormula() {
        return this.formula;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.type);
        list.add(this.formula);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((LogicStatement)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            if (this.type != null) {
                this.type.accept(aCSLVisitor);
            }
            if (this.formula != null) {
                this.formula.accept(aCSLVisitor);
            }
            if (this.polyId != null) {
                this.polyId.accept(aCSLVisitor);
            }
            if (this.parameters != null) {
                Parameter[] parameterArray = this.parameters;
                int n = this.parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameter parameter = parameterArray[n2];
                    parameter.accept(aCSLVisitor);
                    ++n2;
                }
            }
        }
    }

    @Override
    public LogicStatement accept(ACSLTransformer aCSLTransformer) {
        LogicStatement logicStatement = aCSLTransformer.transform(this);
        if (logicStatement != this) {
            return logicStatement;
        }
        ACSLType aCSLType = null;
        if (this.type != null) {
            aCSLType = this.type.accept(aCSLTransformer);
        }
        Expression expression = null;
        if (this.formula != null) {
            expression = this.formula.accept(aCSLTransformer);
        }
        PolyIdentifier polyIdentifier = null;
        if (this.polyId != null) {
            polyIdentifier = this.polyId.accept(aCSLTransformer);
        }
        boolean bl = false;
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        if (this.parameters != null) {
            Parameter[] parameterArray = this.parameters;
            int n = this.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                Parameter parameter2 = parameter.accept(aCSLTransformer);
                bl = bl || parameter2 != parameter;
                arrayList.add(parameter2);
                ++n2;
            }
        }
        if (bl || this.type != aCSLType || this.formula != expression || this.polyId != polyIdentifier) {
            return new LogicFunction(polyIdentifier, arrayList.toArray(new Parameter[0]), aCSLType, expression);
        }
        return this;
    }
}

