/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.parser;

import de.uni_freiburg.informatik.ultimate.cdt.parser.CDTParser;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class MultiparseSymbolTable
extends ASTVisitor {
    private final ILogger mLogger;
    private final Map<Pair<String, String>, IASTFunctionDefinition> mFunctionMapping;
    private final Map<Pair<String, String>, IASTDeclarator> mGlobalsMapping;
    private final Map<Pair<String, String>, String> mNamePrefixMapping;
    private final Map<String, List<String>> mIncludeMapping;
    private final String mCdtPProjectHierachyFlag;
    private final boolean mCreateFilebasedPrefixes;

    public MultiparseSymbolTable(ILogger iLogger, String string, boolean bl) {
        this.mCdtPProjectHierachyFlag = string;
        this.shouldVisitDeclarations = true;
        this.shouldVisitTranslationUnit = true;
        this.mLogger = iLogger;
        this.mFunctionMapping = new HashMap<Pair<String, String>, IASTFunctionDefinition>();
        this.mGlobalsMapping = new HashMap<Pair<String, String>, IASTDeclarator>();
        this.mNamePrefixMapping = new HashMap<Pair<String, String>, String>();
        this.mIncludeMapping = new HashMap<String, List<String>>();
        this.mCreateFilebasedPrefixes = bl;
    }

    public int visit(IASTTranslationUnit iASTTranslationUnit) {
        String string2 = this.normalizeCDTFilename(iASTTranslationUnit.getFilePath());
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = iASTTranslationUnit.getAllPreprocessorStatements();
        int n = iASTPreprocessorStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorStatement iASTPreprocessorStatement = iASTPreprocessorStatementArray[n2];
            if (iASTPreprocessorStatement instanceof IASTPreprocessorIncludeStatement) {
                IASTPreprocessorIncludeStatement iASTPreprocessorIncludeStatement = (IASTPreprocessorIncludeStatement)iASTPreprocessorStatement;
                if (iASTPreprocessorIncludeStatement.isSystemInclude()) {
                    if (!iASTPreprocessorIncludeStatement.isResolved()) {
                        this.mLogger.warn((Object)("System include " + String.valueOf(iASTPreprocessorIncludeStatement.getName()) + " could not be resolved by CDT -- only built-in system includes are available."));
                    }
                } else {
                    if (!iASTPreprocessorIncludeStatement.isResolved()) {
                        throw new UnsupportedOperationException("Include " + String.valueOf(iASTPreprocessorIncludeStatement.getName()) + " could not be resolved");
                    }
                    String string3 = this.normalizeCDTFilename(iASTPreprocessorIncludeStatement.getPath());
                    this.mIncludeMapping.computeIfAbsent(string2, string -> new ArrayList()).add(string3);
                }
            }
            ++n2;
        }
        return super.visit(iASTTranslationUnit);
    }

    public int visit(IASTDeclaration iASTDeclaration) {
        if (!(iASTDeclaration.getParent() instanceof IASTTranslationUnit)) {
            return super.visit(iASTDeclaration);
        }
        String string = ((IASTTranslationUnit)iASTDeclaration.getParent()).getFilePath();
        String string2 = this.normalizeCDTFilename(string);
        if (iASTDeclaration instanceof IASTFunctionDefinition) {
            this.visitFunctionDefinition(string2, (IASTFunctionDefinition)iASTDeclaration);
        } else if (iASTDeclaration instanceof IASTSimpleDeclaration) {
            IASTDeclarator iASTDeclarator;
            IASTDeclarator[] iASTDeclaratorArray = ((IASTSimpleDeclaration)iASTDeclaration).getDeclarators();
            int n = iASTDeclaratorArray.length;
            int n2 = 0;
            while (n2 < n) {
                iASTDeclarator = iASTDeclaratorArray[n2];
                if (!(iASTDeclarator instanceof IASTFunctionDeclarator)) {
                    this.visitNonFunctionDeclarator(string2, iASTDeclarator);
                }
                ++n2;
            }
            if (iASTDeclaration.isPartOfTranslationUnitFile()) {
                iASTDeclarator = ((IASTSimpleDeclaration)iASTDeclaration).getDeclSpecifier();
                if (iASTDeclarator instanceof IASTEnumerationSpecifier) {
                    Pair pair = new Pair((Object)string2, (Object)((IASTEnumerationSpecifier)iASTDeclarator).getName().toString());
                    String string3 = this.generatePrefixedIdentifier(string2, ((IASTEnumerationSpecifier)iASTDeclarator).getName().toString());
                    this.mNamePrefixMapping.put((Pair<String, String>)pair, string3);
                } else if (iASTDeclarator instanceof IASTCompositeTypeSpecifier) {
                    Pair pair = new Pair((Object)string2, (Object)((IASTCompositeTypeSpecifier)iASTDeclarator).getName().toString());
                    String string4 = this.generatePrefixedIdentifier(string2, ((IASTCompositeTypeSpecifier)iASTDeclarator).getName().toString());
                    this.mNamePrefixMapping.put((Pair<String, String>)pair, string4);
                }
            }
        }
        return super.visit(iASTDeclaration);
    }

    private void visitNonFunctionDeclarator(String string, IASTDeclarator iASTDeclarator) {
        if (!iASTDeclarator.isPartOfTranslationUnitFile()) {
            return;
        }
        Pair pair = new Pair((Object)string, (Object)iASTDeclarator.getName().toString());
        this.mGlobalsMapping.put((Pair<String, String>)pair, iASTDeclarator);
        this.mNamePrefixMapping.put((Pair<String, String>)pair, this.generatePrefixedIdentifier(string, iASTDeclarator.getName().toString()));
    }

    private void visitFunctionDefinition(String string, IASTFunctionDefinition iASTFunctionDefinition) {
        if (!iASTFunctionDefinition.isPartOfTranslationUnitFile()) {
            return;
        }
        IASTFunctionDeclarator iASTFunctionDeclarator = iASTFunctionDefinition.getDeclarator();
        Pair pair = new Pair((Object)string, (Object)iASTFunctionDeclarator.getName().toString());
        this.mFunctionMapping.put((Pair<String, String>)pair, iASTFunctionDefinition);
        if (!iASTFunctionDeclarator.getName().toString().equals("main")) {
            this.mNamePrefixMapping.put((Pair<String, String>)pair, this.generatePrefixedIdentifier(string, iASTFunctionDeclarator.getName().toString()));
        }
    }

    private String generatePrefixedIdentifier(String string, String string2) {
        if (this.mCreateFilebasedPrefixes) {
            return string2;
        }
        return "__U_MULTI_f" + string.replaceAll("[^a-zA-Z_]", "_") + "__" + string2;
    }

    public Collection<String> getIncludesFor(String string) {
        if (!this.mIncludeMapping.containsKey(string)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection((Collection)this.mIncludeMapping.get(string));
    }

    public void printMappings() {
        String string;
        this.mLogger.info((Object)"Include resolver:");
        for (Map.Entry<String, List<String>> pair : this.mIncludeMapping.entrySet()) {
            this.mLogger.info((Object)("File " + pair.getKey() + " includes: " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)pair.getValue())));
        }
        if (this.mIncludeMapping.isEmpty()) {
            this.mLogger.info((Object)"<empty include resolver>");
        }
        this.mLogger.info((Object)"Function table:");
        for (Pair pair : this.mFunctionMapping.keySet()) {
            string = this.mNamePrefixMapping.get(pair);
            this.mLogger.info((Object)("Function definition of " + string + " ('" + (String)pair.getSecond() + "') in " + (String)pair.getFirst()));
        }
        if (this.mFunctionMapping.isEmpty()) {
            this.mLogger.info((Object)"<empty function table>");
        }
        this.mLogger.info((Object)"Global variable table:");
        for (Pair pair : this.mGlobalsMapping.keySet()) {
            string = this.mNamePrefixMapping.get(pair);
            this.mLogger.info((Object)("Global variable declaration of " + string + " in " + (String)pair.getFirst()));
        }
        if (this.mGlobalsMapping.isEmpty()) {
            this.mLogger.info((Object)"<empty global variable table>");
        }
    }

    public String getNameMappingIfExists(String string, String string2) {
        String string3 = this.normalizeCDTFilename(string);
        Pair pair = new Pair((Object)string3, (Object)string2);
        if (!this.mNamePrefixMapping.containsKey(pair) && this.mIncludeMapping.containsKey(string3)) {
            List<String> list = this.mIncludeMapping.get(string3);
            for (String string4 : list) {
                Pair pair2 = new Pair((Object)string4, (Object)string2);
                if (!this.mNamePrefixMapping.containsKey(pair2)) continue;
                return this.mNamePrefixMapping.get(pair2);
            }
        }
        return this.mNamePrefixMapping.getOrDefault(pair, string2);
    }

    public String normalizeCDTFilename(String string) {
        return CDTParser.normalizeCdtFilename(this.mCdtPProjectHierachyFlag, string);
    }
}

