/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphEdgeLabel;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphNodeLabel;
import de.uni_freiburg.informatik.ultimate.core.lib.models.ModifiableLabeledEdgesMultigraph;

public class CallGraphNode
extends ModifiableLabeledEdgesMultigraph<CallGraphNode, CallGraphEdgeLabel> {
    private static final long serialVersionUID = -937014582193693103L;
    private final String mId;
    private Procedure mProcedureWithSpecification;
    private Procedure mProcedureWithBody;
    private CallGraphNodeLabel mLabel;

    public CallGraphNode(String string) {
        this.mId = string;
    }

    public String getId() {
        return this.mId;
    }

    public void setProcedureWithSpecification(Procedure procedure) {
        assert (procedure == null || procedure.getIdentifier().equals(this.mId));
        assert (procedure == null || procedure.getSpecification() != null);
        this.mProcedureWithSpecification = procedure;
    }

    public void setProcedureWithBody(Procedure procedure) {
        assert (procedure == null || procedure.getIdentifier().equals(this.mId));
        assert (procedure == null || procedure.getBody() != null);
        this.mProcedureWithBody = procedure;
    }

    public void setLabel(CallGraphNodeLabel callGraphNodeLabel) {
        this.mLabel = callGraphNodeLabel;
    }

    public Procedure getProcedureWithSpecification() {
        return this.mProcedureWithSpecification;
    }

    public Procedure getProcedureWithBody() {
        return this.mProcedureWithBody;
    }

    public CallGraphNodeLabel getLabel() {
        return this.mLabel;
    }

    public boolean isImplemented() {
        return this.mProcedureWithBody != null;
    }

    public boolean isCombined() {
        return this.mProcedureWithSpecification == this.mProcedureWithBody;
    }

    public boolean isPolymorphic() {
        return this.mProcedureWithSpecification.getTypeParams().length > 0;
    }

    public boolean hasInlineFlags() {
        for (CallGraphEdgeLabel callGraphEdgeLabel : this.getOutgoingEdgeLabels()) {
            if (!callGraphEdgeLabel.getInlineFlag()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mId);
        stringBuilder.append('{');
        stringBuilder.append(this.isImplemented() ? "impl" : "unimpl");
        stringBuilder.append(',');
        stringBuilder.append((Object)this.mLabel);
        stringBuilder.append('}');
        stringBuilder.append(this.getOutgoingEdgeLabels());
        return stringBuilder.toString();
    }
}

